/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib;

import de.mpc.BaseLib.StopWatch;
import de.mpc.BaseLib.constants.MyConstants;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLQueryCounter {
    private final int SQL_CALL_LIMIT = 3;
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final HashMap<String, Integer> mapName2Counts = new HashMap();
    private final HashMap<String, StopWatch> mapName2Times = new HashMap();

    public void countSQLCall(String name) {
        if (this.mapName2Counts.containsKey(name)) {
            this.mapName2Counts.put(name, this.mapName2Counts.get(name) + 1);
            this.mapName2Times.get(name).reStart();
        } else {
            this.mapName2Counts.put(name, 1);
            StopWatch sw = new StopWatch(name);
            sw.start();
            this.mapName2Times.put(name, sw);
        }
    }

    public void stopTime(String name) {
        if (this.mapName2Times.get(name) != null) {
            this.mapName2Times.get(name).stop();
        } else {
            this.logger.error("name is stopTime does not exist: {}", (Object)name);
        }
    }

    public void printOutAllSQLCalls() {
        this.printOutAllSQLCalls(3);
    }

    private void printOutAllSQLCalls(int limit) {
        this.logger.debug(MyConstants.newline);
        this.logger.debug("Number of SQL calls:");
        this.logger.debug("===================:");
        for (String meth : this.mapName2Counts.keySet()) {
            if (this.mapName2Counts.get(meth) <= limit) continue;
            String strElapsed = this.mapName2Times.get(meth).getUsedTimeAsString();
            this.logger.debug("Method: {}\tCounts: {}\telapsed time: {}", new Object[]{meth, this.mapName2Counts.get(meth), strElapsed});
        }
        this.logger.debug(MyConstants.newline);
    }
}

