/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFile {
    private final String STR_NOT_SPECIFIED = "not specified";
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private Properties props = null;

    public Properties loadProperties(String filepath) {
        if (this.props == null) {
            this.props = new Properties();
        }
        try (FileInputStream propFile = new FileInputStream(filepath);){
            this.props.load(propFile);
        }
        catch (FileNotFoundException fnfexc) {
            fnfexc.printStackTrace(System.err);
        }
        catch (IOException ioexc) {
            ioexc.printStackTrace(System.err);
        }
        return this.props;
    }

    public String readProperty(String propName) {
        String propStr = "";
        if (this.props != null) {
            propStr = this.props.getProperty(propName);
        }
        if (propStr.isEmpty()) {
            propStr = this.STR_NOT_SPECIFIED;
            this.logger.warn("Property {} not specified.", (Object)propName);
        }
        return propStr;
    }
}

