/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib;

import de.mpc.BaseLib.obo.OBOInitialRead;
import de.mpc.BaseLib.obo.OBOModItem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseUnimod
extends OBOInitialRead {
    private final String unimodURLPath = "http://www.unimod.org/obo/unimod.obo";
    private final String UNIMOD_MONO_MASS_LINE = "xref: delta_mono_mass \"";
    private final String UNIMOD_SITE = "_site";
    private final String UNIMOD_SPEC_SITE_SHORT = "xref: spec_";
    private final String UNIMOD_SPEC_SITE_LINE = "xref: spec_X_site ";
    private final String UNIMOD_ID_LINE = "id: UNIMOD:";
    private final String NAME_LINE = "name: ";
    private final String NEW_TERM_LINE = "[Term]";
    private final int MAX_SPEC_SITE = 15;
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private boolean bParsedIn = false;
    private URL oboURL = null;
    private URLConnection urlConn = null;
    private final OBOModItem unimodItem = new OBOModItem();
    private final ArrayList<String> specSitesList = new ArrayList();
    private String termID = "";
    private String name = "";
    private double monoIsotopicDeltaMass = 0.0;

    public ParseUnimod() {
        this.parseInUnimodFileFromInternet();
    }

    private void parseInUnimodFileFromInternet() {
        block23: {
            try {
                this.oboURL = new URL(this.unimodURLPath);
                try {
                    if (this.oboURL == null) break block23;
                    this.urlConn = this.oboURL.openConnection();
                    if (this.urlConn == null) break block23;
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(this.urlConn.getInputStream()));){
                        String line;
                        while ((line = br.readLine()) != null) {
                            String tmpStr;
                            int pos;
                            if (line.equals(this.NEW_TERM_LINE)) {
                                this.addOBOModItemObject();
                                this.resetSomeVariables();
                                continue;
                            }
                            if (line.startsWith(this.NAME_LINE)) {
                                pos = line.lastIndexOf(58);
                                this.name = line.substring(pos + 1).trim();
                                continue;
                            }
                            if (line.startsWith(this.UNIMOD_ID_LINE)) {
                                pos = line.lastIndexOf(58);
                                this.termID = line.substring(pos + 1).trim();
                                continue;
                            }
                            if (line.startsWith(this.UNIMOD_MONO_MASS_LINE)) {
                                pos = line.indexOf(34);
                                tmpStr = line.substring(pos + 1, line.length() - 1);
                                this.monoIsotopicDeltaMass = Double.parseDouble(tmpStr);
                                continue;
                            }
                            if (!line.startsWith(this.UNIMOD_SPEC_SITE_SHORT) || !line.contains(this.UNIMOD_SITE) || !this.startsWithSpecSiteLine(line)) continue;
                            pos = line.indexOf(34);
                            tmpStr = line.substring(pos + 1, line.length() - 1);
                            this.specSitesList.add(tmpStr);
                        }
                        this.addOBOModItemObject();
                        this.bParsedIn = true;
                    }
                }
                catch (ConnectException cexc) {
                    this.logger.error("Could not connect to URL {}", (Object)this.unimodURLPath);
                    cexc.printStackTrace(System.err);
                    ParseUnimod.readOBOFileFromLocalResource("UNIMOD");
                }
                catch (UnknownHostException uhexc) {
                    this.logger.error("Unknown host for  URL {}", (Object)this.unimodURLPath);
                    ParseUnimod.readOBOFileFromLocalResource("UNIMOD");
                }
                catch (IOException ioex) {
                    this.logger.error("Could not open I/O connection to {}", (Object)this.unimodURLPath);
                    ioex.printStackTrace(System.err);
                }
            }
            catch (MalformedURLException mURLex) {
                this.logger.error("URL path {} is not valid.", (Object)this.unimodURLPath);
                mURLex.printStackTrace(System.err);
            }
        }
    }

    private boolean startsWithSpecSiteLine(String line) {
        Integer cnt = 1;
        while (cnt <= this.MAX_SPEC_SITE) {
            String replacedStr = this.UNIMOD_SPEC_SITE_LINE.replaceAll("X", cnt.toString());
            if (line.startsWith(replacedStr)) {
                return true;
            }
            Integer n = cnt;
            Integer n2 = cnt = Integer.valueOf(cnt + 1);
        }
        return false;
    }

    private void addOBOModItemObject() {
        StringBuilder sbSpecSites = new StringBuilder();
        if (!this.termID.isEmpty() && Integer.parseInt(this.termID) > 0) {
            this.unimodItem.addTermID(this.termID);
            this.unimodItem.addMonoisotopicDeltaMass(this.termID, this.monoIsotopicDeltaMass);
            this.unimodItem.addModificationName(this.termID, this.name);
            this.unimodItem.addName2TermID(this.name, this.termID);
            for (String specSite : this.specSitesList) {
                if (specSite.length() != 1) continue;
                this.unimodItem.addSpecSite(this.termID, specSite);
                sbSpecSites.append(specSite);
            }
        }
    }

    private void resetSomeVariables() {
        this.termID = "";
        this.name = "";
        this.monoIsotopicDeltaMass = 0.0;
        this.specSitesList.clear();
    }

    public OBOModItem getUnimodItem() {
        if (!this.bParsedIn) {
            this.parseInUnimodFileFromInternet();
        }
        return this.unimodItem;
    }
}

