/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PICalculator {
    private final double PH_MIN_START = 2.0;
    private final double PH_MAX_START = 12.5;
    private final char Asp = (char)68;
    private final char Glu = (char)69;
    private final char Cys = (char)67;
    private final char Tyr = (char)89;
    private final char His = (char)72;
    private final char Lys = (char)75;
    private final char Arg = (char)82;
    private final char NTerm = (char)42;
    private final char CTerm = (char)35;
    private final double[][] pKTab = new double[][]{{8.2, 3.65, 8.18, 3.9, 4.07, 6.04, 10.54, 12.48, 10.46}, {8.0, 3.1, 8.5, 4.4, 4.4, 6.5, 10.0, 12.0, 10.0}, {8.6, 3.6, 8.5, 3.9, 4.1, 6.5, 10.8, 12.5, 10.1}, {7.7, 3.3, 6.8, 3.5, 4.2, 6.6, 10.5, 12.04, 10.3}, {9.69, 2.34, 8.33, 3.86, 4.25, 6.0, 10.5, 12.4, 10.0}, {11.2, 4.2, 0.0, 4.2, 4.2, 0.0, 11.2, 11.2, 0.0}, {8.0, 3.1, 8.33, 3.68, 4.25, 6.0, 11.5, 11.5, 10.07}, {8.2, 3.2, 9.0, 4.0, 4.5, 6.4, 10.4, 12.0, 10.0}, {9.6, 2.4, 8.3, 3.9, 4.3, 6.0, 10.5, 12.5, 10.1}, {8.43, 3.32, 8.14, 3.71, 4.15, 6.04, 10.67, 12.1, 10.1}};
    private int AspNumber = 0;
    private int GluNumber = 0;
    private int CysNumber = 0;
    private int TyrNumber = 0;
    private int HisNumber = 0;
    private int LysNumber = 0;
    private int ArgNumber = 0;
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private String sequence = "";
    private boolean bUsePatrickios = true;
    private int anzIterations = 0;
    private double pHEpsilon = 0.01;
    private double chargeEpsilon = 1.0E-6;
    private int maxIterations = 25;
    private PKSet standardPKSet = PKSet.Wikipedia;

    public PICalculator() {
    }

    PICalculator(String peptSequence) {
        this.sequence = peptSequence;
        this.setAminoAcidNumbers();
    }

    public double getPHEpsilon() {
        return this.pHEpsilon;
    }

    public double getChargeEpsilon() {
        return this.chargeEpsilon;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public String getSequence() {
        return this.sequence;
    }

    public boolean usePatrickios() {
        return this.bUsePatrickios;
    }

    public PKSet getStandardPKSet() {
        return this.standardPKSet;
    }

    public void setPHEpsilon(double pHEpsilon) {
        this.pHEpsilon = pHEpsilon;
    }

    public void setChargeEpsilon(double chargeEpsilon) {
        this.chargeEpsilon = chargeEpsilon;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
        this.resetAminoAcidNumbers();
        this.anzIterations = 0;
    }

    public void setPatrickiosUsage(boolean usePatrickios) {
        this.bUsePatrickios = usePatrickios;
    }

    public void setStandardPKSet(PKSet pKSet) {
        this.standardPKSet = pKSet;
    }

    private void resetAminoAcidNumbers() {
        this.AspNumber = 0;
        this.GluNumber = 0;
        this.CysNumber = 0;
        this.TyrNumber = 0;
        this.HisNumber = 0;
        this.LysNumber = 0;
        this.ArgNumber = 0;
        this.setAminoAcidNumbers();
    }

    private void setAminoAcidNumbers() {
        for (int i = 0; i < this.sequence.length(); ++i) {
            char aaCode = this.sequence.charAt(i);
            if (aaCode == 'D') {
                ++this.AspNumber;
                continue;
            }
            if (aaCode == 'E') {
                ++this.GluNumber;
                continue;
            }
            if (aaCode == 'C') {
                ++this.CysNumber;
                continue;
            }
            if (aaCode == 'Y') {
                ++this.TyrNumber;
                continue;
            }
            if (aaCode == 'H') {
                ++this.HisNumber;
                continue;
            }
            if (aaCode == 'K') {
                ++this.LysNumber;
                continue;
            }
            if (aaCode != 'R') continue;
            ++this.ArgNumber;
        }
    }

    private double calculateMeanConsensusPI(double pHLow, double pHHigh, double chargeLow, double chargeHigh) {
        double pI = 0.0;
        pI += this.calculatePI(pHLow, pHHigh, chargeLow, chargeHigh, PKSet.DTASelect);
        pI += this.calculatePI(pHLow, pHHigh, chargeLow, chargeHigh, PKSet.EMBOSS);
        pI += this.calculatePI(pHLow, pHHigh, chargeLow, chargeHigh, PKSet.Grimsley);
        pI += this.calculatePI(pHLow, pHHigh, chargeLow, chargeHigh, PKSet.Lehninger);
        pI += this.calculatePI(pHLow, pHHigh, chargeLow, chargeHigh, PKSet.Rodwell);
        pI += this.calculatePI(pHLow, pHHigh, chargeLow, chargeHigh, PKSet.Sillero);
        pI += this.calculatePI(pHLow, pHHigh, chargeLow, chargeHigh, PKSet.Solomon);
        pI += this.calculatePI(pHLow, pHHigh, chargeLow, chargeHigh, PKSet.Wikipedia);
        pI += this.calculatePI(pHLow, pHHigh, chargeLow, chargeHigh, PKSet.CRCHandbook);
        if (this.bUsePatrickios) {
            return (pI += this.calculatePI(pHLow, pHHigh, chargeLow, chargeHigh, PKSet.Patrickios)) / 10.0;
        }
        return pI / 9.0;
    }

    public double calculateConsensusPI(String peptSequence) {
        this.setSequence(peptSequence);
        return this.calculateMeanConsensusPI(2.0, 12.5, 0.0, 0.0);
    }

    public double calculateStandardPI(String peptSequence) {
        this.setSequence(peptSequence);
        if (this.standardPKSet == PKSet.Consensus) {
            return this.calculateConsensusPI(peptSequence);
        }
        return this.calculatePI(2.0, 12.5, 0.0, 0.0, this.standardPKSet);
    }

    private double calculatePI(double pHLow, double pHHigh, double chargeLow, double chargeHigh, PKSet pKSet) {
        double absLowCharge;
        boolean bFlag2;
        assert (!this.sequence.isEmpty());
        assert (pHLow < pHHigh);
        assert (pHLow > 0.0);
        assert (pHHigh < 14.0);
        if (chargeLow == 0.0) {
            this.anzIterations = 0;
            chargeLow = this.getNetChargeAtPHValue(pHLow, pKSet);
        }
        if (chargeHigh == 0.0) {
            chargeHigh = this.getNetChargeAtPHValue(pHHigh, pKSet);
        }
        if (this.anzIterations == 0 && Math.signum(chargeLow) != -Math.signum(chargeHigh)) {
            Object[] paramArray = new Object[]{chargeLow, chargeHigh, this.getSequence()};
            this.logger.trace("Enlarged pH bounds for PI-calculation to 0 - 14:\tchargeLow: {}\tchargeHigh: {}\tsequence: {}\n", paramArray);
            return this.calculatePI(0.0, 14.0, 0.0, 0.0, pKSet);
        }
        ++this.anzIterations;
        double pHMid = (pHLow + pHHigh) / 2.0;
        boolean bFlag1 = Math.abs(pHHigh - pHLow) < this.pHEpsilon;
        boolean bl = bFlag2 = this.anzIterations > this.maxIterations;
        if (Math.abs(chargeLow) < this.chargeEpsilon) {
            return pHLow;
        }
        if (Math.abs(chargeHigh) < this.chargeEpsilon) {
            return pHHigh;
        }
        if (bFlag1 || bFlag2) {
            return pHMid;
        }
        double chargeMid = this.getNetChargeAtPHValue(pHMid, pKSet);
        double absHighCharge = Math.abs(chargeHigh);
        double interpolatedPH = absHighCharge > (absLowCharge = Math.abs(chargeLow)) ? pHLow + absLowCharge / (absLowCharge + absHighCharge) * (pHHigh - pHLow) : pHLow + absLowCharge / (absLowCharge + absHighCharge) * (pHHigh - pHLow);
        double interpolatedCharge = this.getNetChargeAtPHValue(interpolatedPH, pKSet);
        if (Math.signum(interpolatedCharge) == Math.signum(chargeLow)) {
            pHLow = interpolatedPH;
            if (Math.signum(chargeMid) == Math.signum(chargeHigh)) {
                pHHigh = pHMid;
                return this.calculatePI(pHLow, pHHigh, interpolatedCharge, chargeMid, pKSet);
            }
            return this.calculatePI(pHLow, pHHigh, interpolatedCharge, chargeHigh, pKSet);
        }
        pHHigh = interpolatedPH;
        if (Math.signum(chargeMid) == Math.signum(chargeLow)) {
            pHLow = pHMid;
            return this.calculatePI(pHLow, pHHigh, chargeMid, interpolatedCharge, pKSet);
        }
        return this.calculatePI(pHLow, pHHigh, chargeLow, interpolatedCharge, pKSet);
    }

    private double getNetChargeAtPHValue(double pH, PKSet pKSet) {
        double QN_Cys = 0.0;
        double QN_Tyr = 0.0;
        double QP_His = 0.0;
        double QN_CTerm = this.getHendersonHasselbachCharge(-1, this.getPKValueForSet(pKSet, '#'), pH);
        double QN_Asp = this.getHendersonHasselbachCharge(-this.AspNumber, this.getPKValueForSet(pKSet, 'D'), pH);
        double QN_Glu = this.getHendersonHasselbachCharge(-this.GluNumber, this.getPKValueForSet(pKSet, 'E'), pH);
        if (pKSet != PKSet.Patrickios) {
            QN_Cys = this.getHendersonHasselbachCharge(-this.CysNumber, this.getPKValueForSet(pKSet, 'C'), pH);
            QN_Tyr = this.getHendersonHasselbachCharge(-this.TyrNumber, this.getPKValueForSet(pKSet, 'Y'), pH);
            QP_His = this.getHendersonHasselbachCharge(this.HisNumber, this.getPKValueForSet(pKSet, 'H'), pH);
        }
        double QP_NTerm = this.getHendersonHasselbachCharge(1, this.getPKValueForSet(pKSet, '*'), pH);
        double QP_Lys = this.getHendersonHasselbachCharge(this.LysNumber, this.getPKValueForSet(pKSet, 'K'), pH);
        double QP_Arg = this.getHendersonHasselbachCharge(this.ArgNumber, this.getPKValueForSet(pKSet, 'R'), pH);
        if (pKSet != PKSet.Patrickios) {
            return QN_CTerm + QN_Asp + QN_Glu + QN_Cys + QN_Tyr + QP_His + QP_NTerm + QP_Lys + QP_Arg;
        }
        return QN_CTerm + QN_Asp + QN_Glu + QP_NTerm + QP_Lys + QP_Arg;
    }

    private double getHendersonHasselbachCharge(int charge, double pKValue, double pH) {
        if (charge < 0) {
            return (double)charge / (1.0 + Math.pow(10.0, pKValue - pH));
        }
        return (double)charge / (1.0 + Math.pow(10.0, pH - pKValue));
    }

    private double getPKValueForSet(PKSet pKSet, char aaCode) {
        int index1 = this.getIndex1(pKSet);
        int index2 = this.getIndex2(aaCode);
        return this.pKTab[index1][index2];
    }

    private int getIndex1(PKSet pKSet) {
        int index1 = 0;
        if (pKSet == PKSet.Wikipedia) {
            index1 = 0;
        } else if (pKSet == PKSet.DTASelect) {
            index1 = 1;
        } else if (pKSet == PKSet.EMBOSS) {
            index1 = 2;
        } else if (pKSet == PKSet.Grimsley) {
            index1 = 3;
        } else if (pKSet == PKSet.Lehninger) {
            index1 = 4;
        } else if (pKSet == PKSet.Patrickios) {
            index1 = 5;
        } else if (pKSet == PKSet.Rodwell) {
            index1 = 6;
        } else if (pKSet == PKSet.Sillero) {
            index1 = 7;
        } else if (pKSet == PKSet.Solomon) {
            index1 = 8;
        } else if (pKSet == PKSet.CRCHandbook) {
            index1 = 9;
        }
        return index1;
    }

    private int getIndex2(char aaCode) {
        int index2 = 0;
        if (aaCode == '*') {
            index2 = 0;
        } else if (aaCode == '#') {
            index2 = 1;
        } else if (aaCode == 'D') {
            index2 = 3;
        } else if (aaCode == 'E') {
            index2 = 4;
        } else if (aaCode == 'C') {
            index2 = 2;
        } else if (aaCode == 'Y') {
            index2 = 8;
        } else if (aaCode == 'H') {
            index2 = 5;
        } else if (aaCode == 'K') {
            index2 = 7;
        } else if (aaCode == 'R') {
            index2 = 6;
        } else {
            this.logger.error("Unallowed Amino Acid code: {}", (Object)Character.valueOf(aaCode));
        }
        return index2;
    }

    public static enum PKSet {
        EMBOSS,
        DTASelect,
        Grimsley,
        Lehninger,
        Solomon,
        Sillero,
        Rodwell,
        Patrickios,
        Wikipedia,
        CRCHandbook,
        Consensus;

    }
}

