/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib;

import de.mpc.BaseLib.constants.MyConstants;
import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;

public class MyLogger {
    private static final int STD_LINE_LEN = 80;
    private static final int MAX_LINES = 10;
    private static final String STR_PERCENT_FINISHED = "% finished";
    private static Logger myLogger;
    private static boolean bVerbose;
    private static int progressCounter;

    MyLogger() {
        myLogger = null;
    }

    MyLogger(Logger logger) {
        myLogger = logger;
    }

    private static void initLogger(String fullLogFileName) {
        myLogger = Logger.getLogger(MyLogger.class);
        try {
            PatternLayout patternLayout = new PatternLayout();
            patternLayout.setConversionPattern("%d %r [%t] (%F:%L) %-5p %c{1} - %m%n");
            ConsoleAppender consoleAppender = new ConsoleAppender((Layout)patternLayout);
            myLogger.addAppender((Appender)consoleAppender);
            RollingFileAppender fileAppender = new RollingFileAppender((Layout)patternLayout, fullLogFileName, false);
            myLogger.addAppender((Appender)fileAppender);
            myLogger.setLevel(Level.INFO);
        }
        catch (IOException ioex) {
            System.err.println(ioex.getLocalizedMessage());
        }
        myLogger.trace((Object)"MyLogger initialized.");
    }

    public static void writeLogMsg(String msg) {
        if (bVerbose) {
            System.out.println(msg);
        }
    }

    public static void writeProgress(int cnt, int max) {
        if (bVerbose) {
            int modFactor;
            int anzLines = MyLogger.getMinimum(max / 80, 10);
            if (anzLines == 0) {
                anzLines = 1;
            }
            if (progressCounter % (modFactor = max / anzLines) == 0) {
                float ratio = 100.0f * ((float)cnt / (float)max) + 0.5f;
                int percent = (int)ratio;
                System.out.println(MyLogger.getPercentString(percent, cnt, max));
            } else if (modFactor >= 80) {
                if (progressCounter % (modFactor / 80) == 0) {
                    System.out.print(MyConstants.STR_POINT);
                }
            } else {
                System.out.print(MyConstants.STR_POINT);
            }
            ++progressCounter;
        }
    }

    private static int getMinimum(int no1, int no2) {
        if (no1 < no2) {
            return no1;
        }
        return no2;
    }

    public static void writeln() {
        System.out.println("");
    }

    private static String getPercentString(Integer percent, int cnt, int max) {
        String tmpStr = percent.toString();
        StringBuilder sb = new StringBuilder();
        sb.append(tmpStr);
        sb.append('(').append(cnt).append('/').append(max).append(')');
        sb.append(STR_PERCENT_FINISHED);
        return sb.toString();
    }

    public static void setVerbose(boolean bVerboseFlag) {
        bVerbose = bVerboseFlag;
    }

    static {
        bVerbose = true;
        progressCounter = 1;
    }
}

