/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib;

import de.mpc.BaseLib.ProgramExit;
import de.mpc.BaseLib.constants.MyConstants;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyAssert {
    private static final Logger logger = LoggerFactory.getLogger(MyAssert.class);

    private static void fail(String str) {
        new Throwable().printStackTrace(System.err);
        ProgramExit.exitErrorProgram("Assertion failed on " + str);
    }

    private static void myFail(String str) {
        StringWriter sw = new StringWriter();
        new Throwable().printStackTrace(new PrintWriter(sw));
        StringTokenizer st = new StringTokenizer(sw.toString(), MyConstants.newline);
        st.nextToken();
        st.nextToken();
        st.nextToken();
        while (st.hasMoreTokens()) {
            logger.error(" " + st.nextToken().trim().substring(3));
        }
        ProgramExit.exitErrorProgram("Assertion failed on " + str);
    }

    public static void myassert(boolean aBoolean) {
        if (!aBoolean) {
            MyAssert.myFail("Boolean");
        }
    }

    public static void myassert(char aChar) {
        if (aChar == '\u0000') {
            MyAssert.fail("Char");
        }
    }

    public static void myassert(int aInt) {
        if ((long)aInt == 0L) {
            MyAssert.fail("Int");
        }
    }

    public static void myassert(long aLong) {
        if (aLong == 0L) {
            MyAssert.fail("Long");
        }
    }

    public static void myassert(float aFloat) {
        if ((double)aFloat == 0.0) {
            MyAssert.fail("Float");
        }
    }

    public static void myassert(double aDouble) {
        if (aDouble == 0.0) {
            MyAssert.fail("Double");
        }
    }

    public static void myassert(Object anObject) {
        if (anObject == null) {
            MyAssert.fail("Object");
        }
    }
}

