/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib;

import de.mpc.BaseLib.XML.XMLGregorianCalendarConverter;
import de.mpc.BaseLib.constants.MyConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipInputStream;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Helper {
    private static final String STR_XML_DATE_FORMAT = "dd-MM-yyyy'T'HH:mm:ss";
    private static final int BUF_LEN = 80;
    private static final int OFFSET = 0;
    private static final Logger logger = LoggerFactory.getLogger(Helper.class);

    public static void freeMem(boolean bGarbageCollect) {
        if (bGarbageCollect) {
            Runtime r = Runtime.getRuntime();
            r.gc();
        }
    }

    public static String getDatabaseNameCategory(String dbName) {
        String dbNameLower = dbName.toLowerCase();
        if (dbNameLower.contains("sprot")) {
            return "database UniProtKB/Swiss-Prot";
        }
        if (dbNameLower.contains("ipi")) {
            if (dbNameLower.contains("human") || dbNameLower.contains("homo") || dbNameLower.contains("sapiens")) {
                return "database IPI_human";
            }
            if (dbNameLower.contains("mouse")) {
                return "database IPI_mouse";
            }
            if (dbNameLower.contains("rat")) {
                return "database IPI_rat";
            }
            if (dbNameLower.contains("zebrafish")) {
                return "database IPI_zebrafish";
            }
            if (dbNameLower.contains("chicken")) {
                return "database IPI_chicken";
            }
            if (dbNameLower.contains("cow")) {
                return "database IPI_cow";
            }
            if (dbNameLower.contains("arabidopsis")) {
                return "database IPI_arabidopsis";
            }
            logger.trace("Cannot resolve database name category for: {}", (Object)dbName);
            return dbName;
        }
        logger.trace("Cannot resolve database name category for: {}", (Object)dbName);
        return dbName;
    }

    public static String getINListFromIDs(List<Long> idList) {
        StringBuilder strB = new StringBuilder();
        boolean bFirst = true;
        for (long id : idList) {
            if (!bFirst) {
                strB.append(',');
                strB.append(id);
                continue;
            }
            strB.append(id);
            bFirst = false;
        }
        return strB.toString();
    }

    public static boolean isInputFileExistentAndReadable(String fullInpFileName) {
        int pos = fullInpFileName.lastIndexOf(MyConstants.fileSeparator);
        if (pos > -1) {
            String fPath = fullInpFileName.substring(0, pos);
            String fName = fullInpFileName.substring(pos + 1);
            File dir = new File(fPath);
            if (dir.exists()) {
                for (File file : dir.listFiles()) {
                    if (!file.exists() || !file.getName().equals(fName) || !file.canRead() || !file.isFile()) continue;
                    return true;
                }
            } else {
                logger.error("Directory {} does not exist (1)", (Object)dir);
            }
        }
        return false;
    }

    public static boolean isInputFileExistent(String fullInputFileName) {
        boolean found = false;
        int pos = fullInputFileName.lastIndexOf(MyConstants.fileSeparator);
        if (pos > -1) {
            String fPath = fullInputFileName.substring(0, pos);
            String fName = fullInputFileName.substring(pos + 1);
            File dir = new File(fPath);
            if (dir.exists()) {
                for (File file : dir.listFiles()) {
                    if (!file.getName().equals(fName)) continue;
                    found = true;
                    break;
                }
            } else {
                logger.error("Directory {} does not exist (3)", (Object)dir);
            }
        }
        return found;
    }

    public static String getUnzippedSpectrumXml(Blob blob) {
        try {
            String resStr;
            ByteArrayInputStream inStream = new ByteArrayInputStream(blob.getBytes(1L, (int)blob.length()));
            ZipInputStream zipStream = new ZipInputStream(inStream);
            try (ByteArrayOutputStream outStream = new ByteArrayOutputStream(80);){
                while (zipStream.getNextEntry() != null) {
                    int anzBytes;
                    byte[] dataArr = new byte[80];
                    while ((anzBytes = zipStream.read(dataArr, 0, 80)) != -1) {
                        outStream.write(dataArr, 0, anzBytes);
                    }
                }
                resStr = outStream.toString();
                outStream.flush();
            }
            return resStr;
        }
        catch (IOException | SQLException ioexc) {
            ioexc.printStackTrace(System.err);
            return "";
        }
    }

    public static XMLGregorianCalendar getActualDate() {
        SimpleDateFormat dfmt = new SimpleDateFormat(STR_XML_DATE_FORMAT);
        return XMLGregorianCalendarConverter.getXMLGregorianCalendar(dfmt.format(new Date()), STR_XML_DATE_FORMAT);
    }

    public static boolean isAFile(String testStr) {
        File file = new File(testStr);
        if (file.exists()) {
            return file.isFile();
        }
        logger.error("File {} does not exist", (Object)file);
        return false;
    }

    public static Calendar getActualDateAsCalendar() {
        return Helper.getActualDate().toGregorianCalendar();
    }

    public static BigInteger getBigIntFromStr(String str) {
        if (str != null) {
            return new BigInteger(str);
        }
        return null;
    }
}

