/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUID {
    private static final int GUID_SIZE = 36;
    private final int POS_VERSION_BITS = 13;
    private final int POS_VARIANT_BITS = 17;
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private String strGUID = "";

    public GUID(String str) {
        this.setGUID(str);
    }

    public String getGUID() {
        return this.strGUID;
    }

    public char getVersion() {
        return (char)(this.strGUID.charAt(13) & 0xE0);
    }

    public char getTypeVariant() {
        return (char)(this.strGUID.charAt(17) & 0xE0);
    }

    public boolean isStandardTypeVariant() {
        char typeVar = this.getTypeVariant();
        return (typeVar & 0xC0) == 128;
    }

    private void setGUID(String str) {
        if (str != null && !str.isEmpty()) {
            if (GUID.isValid(str)) {
                this.strGUID = str;
            } else {
                this.logger.error("Not a valid GUID: {} of size {}", (Object)str, (Object)str.length());
                Exception exc = new Exception();
                exc.printStackTrace(System.err);
            }
        } else {
            this.strGUID = "";
        }
    }

    public static boolean isValid(String str) {
        if (str.length() == 36) {
            for (int i = 0; i < 36; ++i) {
                if (!(i == 8 || i == 13 || i == 18 || i == 23 ? str.charAt(i) != '-' : !GUID.isHexChar(Character.toUpperCase(str.charAt(i))))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isHexChar(char ch) {
        return Character.isDigit(ch) || ch == 'A' || ch == 'B' || ch == 'C' || ch == 'D' || ch == 'E' || ch == 'F';
    }

    public String toString() {
        return this.strGUID;
    }

    public String asString() {
        StringBuilder strB = new StringBuilder();
        for (char chr : this.strGUID.toCharArray()) {
            if (chr == '-') continue;
            strB.append(chr);
        }
        return strB.toString();
    }

    public static boolean containsGUID(String str) {
        boolean bGUIDFound = false;
        Pattern pattern = Pattern.compile("([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            bGUIDFound = true;
        }
        return bGUIDFound;
    }

    public static boolean isAGUID(String str) {
        boolean bGUIDFound = false;
        Pattern pattern = Pattern.compile("^([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})$");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            bGUIDFound = true;
        }
        return bGUIDFound;
    }
}

