/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class FileTimes {
    private static final int MINUS1601 = -1601;
    private static final String STR_XMLDateFormat = "EEE yyyy-MM-dd hh:mm:ss.SSS aa zz";
    private static final String STR_GMT = "GMT";
    private static final long DIFF_IN_MILLISECONDS_BETWEEN_1601_AND_1970 = 11644473600000L;

    private static long getMillisecondsSince1970(String hundredNanoSecondIntervalsSince1601) {
        String strMilliSecondIntervalsSince1601 = hundredNanoSecondIntervalsSince1601.substring(0, hundredNanoSecondIntervalsSince1601.length() - 4);
        long milliSecondsSince1601 = Long.parseLong(strMilliSecondIntervalsSince1601);
        long milliSecondsSince1970 = milliSecondsSince1601 - 11644473600000L;
        return milliSecondsSince1970;
    }

    private static String display(long milliSecondsSince1970) {
        SimpleDateFormat sdf = new SimpleDateFormat(STR_XMLDateFormat);
        Date actDate = new Date(milliSecondsSince1970);
        Calendar actCalendar = FileTimes.getGMTCalendar();
        actCalendar.setTime(actDate);
        actCalendar.add(1, -1601);
        return sdf.format(actCalendar.getTime());
    }

    private static Calendar getGMTCalendar() {
        return Calendar.getInstance(TimeZone.getTimeZone(STR_GMT));
    }

    private static GregorianCalendar getGMTGregorianCalendar() {
        return (GregorianCalendar)GregorianCalendar.getInstance(TimeZone.getTimeZone(STR_GMT));
    }

    public static String getDisplayString(String hundredNanoSecondIntervalsSince1601) {
        long milliSecondsSince1970 = FileTimes.getMillisecondsSince1970(hundredNanoSecondIntervalsSince1601);
        return FileTimes.display(milliSecondsSince1970);
    }

    public static GregorianCalendar getGregorianCalendar(String hundredNanoSecondIntervalsSince1601) {
        long milliSecondsSince1970 = FileTimes.getMillisecondsSince1970(hundredNanoSecondIntervalsSince1601);
        Date actDate = new Date(milliSecondsSince1970);
        GregorianCalendar actCalendar = FileTimes.getGMTGregorianCalendar();
        actCalendar.setTime(actDate);
        actCalendar.add(1, -1601);
        return actCalendar;
    }

    public static Date getDate(String hundredNanoSecondIntervalsSince1601) {
        long milliSecondsSince1970 = FileTimes.getMillisecondsSince1970(hundredNanoSecondIntervalsSince1601);
        return new Date(milliSecondsSince1970);
    }
}

