/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib.Fasta;

import de.mpc.BaseLib.Fasta.FASTAConstants;
import de.mpc.BaseLib.Fasta.FASTAHeaderInfo;
import de.mpc.BaseLib.Fasta.UniProtTaxonomy;
import de.mpc.BaseLib.Pair;
import de.mpc.BaseLib.TaxonomyReader;
import de.mpc.BaseLib.constants.MyConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyFastaParser {
    private static final Logger logger = LoggerFactory.getLogger(MyFastaParser.class);
    private FASTAHeaderInfo fhi = null;
    private String header = "";
    private TaxonomyReader taxReader;

    public MyFastaParser(TaxonomyReader taxReader) {
        this.taxReader = taxReader;
    }

    public MyFastaParser(String headerLine) {
        this.header = headerLine;
        this.parseFastaHeader(this.header);
    }

    public FASTAHeaderInfo getFastaHeaderInfo() {
        return this.fhi;
    }

    private String extractName(String header, int idPosition) {
        String[] nameArr = header.split("\\|");
        String name = "";
        if (idPosition < nameArr.length) {
            name = header.split("\\|")[idPosition];
        }
        return name.trim();
    }

    private String extractFullName(String header, int idPosition) {
        String[] nameArr = header.split("\\|");
        String name = "";
        if (idPosition < nameArr.length) {
            name = header.split("\\|")[idPosition];
        }
        if (idPosition + 1 < nameArr.length) {
            name = name + MyConstants.STR_PIPE;
            name = name + header.split("\\|")[idPosition + 1];
        }
        return name.trim();
    }

    private boolean handleUniProtOrganismCode(FASTAHeaderInfo fhi, String uniProtTaxCode) {
        switch (uniProtTaxCode) {
            case "HUMAN": 
            case "Homo sapiens": {
                fhi.setOrganismName(UniProtTaxonomy.organismCode2OrganismName.get("HUMAN"));
                fhi.setTaxID(UniProtTaxonomy.organismCode2TaxID.get("HUMAN"));
                break;
            }
            case "BOVIN": {
                fhi.setOrganismName(UniProtTaxonomy.organismCode2OrganismName.get("BOVIN"));
                fhi.setTaxID(UniProtTaxonomy.organismCode2TaxID.get("BOVIN"));
                break;
            }
            case "CHICK": {
                fhi.setOrganismName(UniProtTaxonomy.organismCode2OrganismName.get("CHICK"));
                fhi.setTaxID(UniProtTaxonomy.organismCode2TaxID.get("CHICK"));
                break;
            }
            case "ECOLI": {
                fhi.setOrganismName(UniProtTaxonomy.organismCode2OrganismName.get("ECOLI"));
                fhi.setTaxID(UniProtTaxonomy.organismCode2TaxID.get("ECOLI"));
                break;
            }
            case "HORSE": {
                fhi.setOrganismName(UniProtTaxonomy.organismCode2OrganismName.get("HORSE"));
                fhi.setTaxID(UniProtTaxonomy.organismCode2TaxID.get("HORSE"));
                break;
            }
            case "MAIZE": {
                fhi.setOrganismName(UniProtTaxonomy.organismCode2OrganismName.get("MAIZE"));
                fhi.setTaxID(UniProtTaxonomy.organismCode2TaxID.get("MAIZE"));
                break;
            }
            case "MOUSE": {
                fhi.setOrganismName(UniProtTaxonomy.organismCode2OrganismName.get("MOUSE"));
                fhi.setTaxID(UniProtTaxonomy.organismCode2TaxID.get("MOUSE"));
                break;
            }
            case "PEA": {
                fhi.setOrganismName(UniProtTaxonomy.organismCode2OrganismName.get("PEA"));
                fhi.setTaxID(UniProtTaxonomy.organismCode2TaxID.get("PEA"));
                break;
            }
            case "PIG": {
                fhi.setOrganismName(UniProtTaxonomy.organismCode2OrganismName.get("PIG"));
                fhi.setTaxID(UniProtTaxonomy.organismCode2TaxID.get("PIG"));
                break;
            }
            case "RABBIT": {
                fhi.setOrganismName(UniProtTaxonomy.organismCode2OrganismName.get("RABBIT"));
                fhi.setTaxID(UniProtTaxonomy.organismCode2TaxID.get("RABBIT"));
                break;
            }
            case "RAT": {
                fhi.setOrganismName(UniProtTaxonomy.organismCode2OrganismName.get("RAT"));
                fhi.setTaxID(UniProtTaxonomy.organismCode2TaxID.get("RAT"));
                break;
            }
            case "SHEEP": {
                fhi.setOrganismName(UniProtTaxonomy.organismCode2OrganismName.get("SHEEP"));
                fhi.setTaxID(UniProtTaxonomy.organismCode2TaxID.get("SHEEP"));
                break;
            }
            case "SOYBN": {
                fhi.setOrganismName(UniProtTaxonomy.organismCode2OrganismName.get("SOYBN"));
                fhi.setTaxID(UniProtTaxonomy.organismCode2TaxID.get("SOYBN"));
                break;
            }
            case "TOBAC": {
                fhi.setOrganismName(UniProtTaxonomy.organismCode2OrganismName.get("TOBAC"));
                fhi.setTaxID(UniProtTaxonomy.organismCode2TaxID.get("TOBAC"));
                break;
            }
            case "WHEAT": {
                fhi.setOrganismName(UniProtTaxonomy.organismCode2OrganismName.get("WHEAT"));
                fhi.setTaxID(UniProtTaxonomy.organismCode2TaxID.get("WHEAT"));
                break;
            }
            case "YEAST": {
                fhi.setOrganismName(UniProtTaxonomy.organismCode2OrganismName.get("YEAST"));
                fhi.setTaxID(UniProtTaxonomy.organismCode2TaxID.get("YEAST"));
                break;
            }
            case "XENLA": {
                fhi.setOrganismName(UniProtTaxonomy.organismCode2OrganismName.get("XENLA"));
                fhi.setTaxID(UniProtTaxonomy.organismCode2TaxID.get("XENLA"));
                break;
            }
            case "XENTR": {
                fhi.setOrganismName(UniProtTaxonomy.organismCode2OrganismName.get("XENTR"));
                fhi.setTaxID(UniProtTaxonomy.organismCode2TaxID.get("XENTR"));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public final FASTAHeaderInfo parseFastaHeader(String header) {
        this.fhi = new FASTAHeaderInfo(this.taxReader);
        if (header.startsWith(">bbm")) {
            return this.parseGenInfobackBoneMolType(this.fhi, header);
        }
        if (header.startsWith(">bbs")) {
            return this.parseGenInfobackBoneSeqID(this.fhi, header);
        }
        if (header.startsWith(">dbj")) {
            return this.parseDDBJ(this.fhi, header);
        }
        if (header.startsWith(">emb")) {
            return this.parseEMBL(this.fhi, header);
        }
        if (header.startsWith(">gb")) {
            return this.parseGenBank(this.fhi, header);
        }
        if (header.startsWith(">gi") && !header.startsWith(">gim")) {
            return this.parseGenInfo(this.fhi, header);
        }
        if (header.startsWith(">gim")) {
            return this.parseGenInfoImport(this.fhi, header);
        }
        if (header.startsWith(">gnl")) {
            return this.parseGeneral(this.fhi, header);
        }
        if (header.startsWith(">gpp")) {
            return this.parseGenomePipeline(this.fhi, header);
        }
        if (header.startsWith(">lcl")) {
            return this.parseLocal(this.fhi, header);
        }
        if (header.startsWith(">nat")) {
            return this.parseNamedAnnotationTrack(this.fhi, header);
        }
        if (header.startsWith(">pat")) {
            return this.parsePatents(this.fhi, header);
        }
        if (header.startsWith(">pdb")) {
            return this.parsePDB(this.fhi, header);
        }
        if (header.startsWith(">entry:chain")) {
            return this.parsePDBEntry(this.fhi, header);
        }
        if (header.startsWith(">pgp")) {
            return this.parsePreGrantPatent(this.fhi, header);
        }
        if (header.startsWith(">pir")) {
            return this.parseNBRFPIR(this.fhi, header);
        }
        if (header.startsWith(">prf")) {
            return this.parsePRF(this.fhi, header);
        }
        if (header.startsWith(">ref")) {
            return this.parseNCBIRef(this.fhi, header);
        }
        if (header.startsWith(">sp") || header.startsWith("sp")) {
            return this.parseSwissProt(this.fhi, header);
        }
        if (header.startsWith(">tpd")) {
            return this.parseThirdPartyDDBJ(this.fhi, header);
        }
        if (header.startsWith(">tpe")) {
            return this.parseThirdPartyEMBL(this.fhi, header);
        }
        if (header.startsWith(">tpg")) {
            return this.parseThirdPartyGenBank(this.fhi, header);
        }
        if (header.startsWith(">tr")) {
            return this.parseTrembl(this.fhi, header);
        }
        if (header.contains("SGDID:")) {
            return this.parseSGD(this.fhi, header);
        }
        if (header.startsWith(">IPI:") || header.startsWith("IPI:")) {
            return this.parseIPI(this.fhi, header);
        }
        if (header.startsWith(">MSIPI:")) {
            return this.parseMSIPI(this.fhi, header);
        }
        if (header.startsWith(">UniRef")) {
            return this.parseUniRef(this.fhi, header);
        }
        if (header.startsWith(">CBMS ")) {
            return this.parseMSDB(this.fhi, header);
        }
        if (header.startsWith(">HP")) {
            return this.parseHypotheticalProtein(this.fhi, header);
        }
        if (header.startsWith(">US")) {
            return this.parseUSPatent(this.fhi, header);
        }
        if (header.startsWith(">MES")) {
            return this.parseUniMES(this.fhi, header);
        }
        if (header.startsWith(">UPI")) {
            return this.parseUniParc(this.fhi, header);
        }
        Matcher matcher = FASTAConstants.ACC_ONLY.matcher(header);
        if (matcher.matches()) {
            return this.parseWithoutIdentifier(this.fhi, header);
        }
        matcher = FASTAConstants.CUST_C.matcher(header);
        if (matcher.matches()) {
            return this.parseCustomC(this.fhi, header);
        }
        logger.error("Not yet implemented FASTA header: {}", (Object)header);
        return this.parseHeuristic(this.fhi, header);
    }

    private FASTAHeaderInfo parseGenInfobackBoneMolType(FASTAHeaderInfo fhi, String header) {
        Matcher matcher = FASTAConstants.BBM_HEAD.matcher(header);
        if (matcher.matches()) {
            fhi.setAccession(this.extractName(header, 1));
            return fhi;
        }
        logger.error("Fasta header does not match in parseGenInfobackBoneMolType: {}", (Object)header);
        return fhi;
    }

    private FASTAHeaderInfo parseGenInfobackBoneSeqID(FASTAHeaderInfo fhi, String header) {
        Matcher matcher = FASTAConstants.BBS_HEAD.matcher(header);
        if (matcher.matches()) {
            fhi.setAccession(this.extractName(header, 1));
            return fhi;
        }
        logger.error("Fasta header does not match in parseGenInfobackBoneSeqID: {}", (Object)header);
        return fhi;
    }

    private FASTAHeaderInfo parseDDBJ(FASTAHeaderInfo fhi, String header) {
        Matcher matcher = FASTAConstants.DBJ_HEAD.matcher(header);
        if (matcher.matches()) {
            fhi.setAccession(this.extractName(header, 1));
            fhi.setLocus(this.extractName(header, 2));
            fhi.setDescription(this.extractName(header, 2));
            return fhi;
        }
        logger.error("Fasta header does not match in parseDDBJ: {}", (Object)header);
        return fhi;
    }

    private FASTAHeaderInfo parseEMBL(FASTAHeaderInfo fhi, String header) {
        Matcher matcher = FASTAConstants.EMB_HEAD.matcher(header);
        if (matcher.matches()) {
            fhi.setAccession(this.extractName(header, 1));
            fhi.setLocus(this.extractName(header, 2));
            fhi.setDescription(this.extractName(header, 2));
            return fhi;
        }
        logger.error("Fasta header does not match in parseEMBL: {}", (Object)header);
        return fhi;
    }

    private FASTAHeaderInfo parseGenBank(FASTAHeaderInfo fhi, String header) {
        Matcher matcher = FASTAConstants.GB_HEAD.matcher(header);
        if (matcher.matches()) {
            fhi.setAccession(this.extractName(header, 1));
            fhi.setLocus(this.extractName(header, 2));
            fhi.setDescription(this.extractName(header, 2));
            return fhi;
        }
        logger.error("Fasta header does not match in parseGenBank: {}", (Object)header);
        return fhi;
    }

    private FASTAHeaderInfo parseGenInfo(FASTAHeaderInfo fhi, String header) {
        if (!(header.contains("emb") || header.contains("dbj") || header.contains("gb") || header.contains("pdb") || header.contains("pir") || header.contains("ref") || header.contains("sp"))) {
            Matcher matcher = FASTAConstants.GI_HEAD.matcher(header);
            if (matcher.matches()) {
                fhi.setAccession(this.extractName(header, 1));
                fhi.setGINumber(this.extractName(header, 1));
                return fhi;
            }
            logger.error("Fasta header (GI_HEAD) does not match in parseGenInfo: {}", (Object)header);
        } else {
            Matcher matcher = FASTAConstants.GI_xyz_HEAD.matcher(header);
            if (matcher.matches()) {
                fhi.setAccession(this.extractName(header, 3));
                fhi.setGINumber(this.extractName(header, 1));
                fhi.setDescription(this.extractName(header, 4));
                String name = this.extractName(header, 4);
                int pos1 = name.indexOf(MyConstants.STR_SQUARE_BRACKET_OPEN);
                int pos2 = name.indexOf(MyConstants.STR_SQUARE_BRACKET_CLOSE);
                if (!name.isEmpty() && pos1 > -1 && pos2 > -1 && pos2 > pos1) {
                    String strTemp = name.substring(pos1 + 1, pos2);
                    if (!this.handleUniProtOrganismCode(fhi, strTemp)) {
                        logger.info("Unhandled putative organism in parseGenInfo(): {}", (Object)strTemp);
                    }
                    fhi.setOrganismName(strTemp);
                    fhi.setEntryName(name.substring(0, pos1 - 1).trim());
                } else {
                    fhi.setEntryName(name);
                }
                return fhi;
            }
            logger.error("Fasta header (GI_xyz_HEAD) does not match in parseGenInfo: {}", (Object)header);
        }
        return fhi;
    }

    private FASTAHeaderInfo parseGenInfoImport(FASTAHeaderInfo fhi, String header) {
        Matcher matcher = FASTAConstants.GIM_HEAD.matcher(header);
        if (matcher.matches()) {
            fhi.setAccession(this.extractName(header, 1));
            return fhi;
        }
        logger.error("Fasta header does not match in parseGenInfoImport: {}", (Object)header);
        return fhi;
    }

    private FASTAHeaderInfo parseGeneral(FASTAHeaderInfo fhi, String header) {
        Matcher matcher = FASTAConstants.GNL_HEAD.matcher(header);
        if (matcher.matches()) {
            fhi.setAccession(this.extractName(header, 2));
            String dbStr = this.extractName(header, 1);
            if (dbStr.equals("taxon")) {
                fhi.setTaxID(this.extractName(header, 2));
            }
            fhi.setDatabase(dbStr);
            return fhi;
        }
        logger.error("Fasta header does not match in parseGeneral: {}", (Object)header);
        return fhi;
    }

    private FASTAHeaderInfo parseGenomePipeline(FASTAHeaderInfo fhi, String header) {
        Matcher matcher = FASTAConstants.GPP_HEAD.matcher(header);
        if (matcher.matches()) {
            fhi.setAccession(this.extractName(header, 1));
            fhi.setEntryName(this.extractName(header, 2));
            fhi.setDescription(this.extractName(header, 2));
            return fhi;
        }
        logger.error("Fasta header does not match in parseGenomePipeline: {}", (Object)header);
        return fhi;
    }

    private FASTAHeaderInfo parseLocal(FASTAHeaderInfo fhi, String header) {
        Matcher matcher = FASTAConstants.LCL_HEAD.matcher(header);
        if (matcher.matches()) {
            fhi.setAccession(this.extractName(header, 1));
            return fhi;
        }
        logger.error("Fasta header does not match in parseLocal: {}", (Object)header);
        return fhi;
    }

    private FASTAHeaderInfo parseNamedAnnotationTrack(FASTAHeaderInfo fhi, String header) {
        Matcher matcher = FASTAConstants.NAT_HEAD.matcher(header);
        if (matcher.matches()) {
            fhi.setAccession(this.extractName(header, 1));
            fhi.setEntryName(this.extractName(header, 2));
            fhi.setDescription(this.extractName(header, 2));
            return fhi;
        }
        logger.error("Fasta header does not match in parseNamedAnnotationTrack: {}", (Object)header);
        return fhi;
    }

    private FASTAHeaderInfo parsePatents(FASTAHeaderInfo fhi, String header) {
        Matcher matcher = FASTAConstants.PAT_HEAD.matcher(header);
        if (matcher.matches()) {
            fhi.setAccession(this.extractName(header, 2));
            fhi.setCountry(this.extractName(header, 1));
            fhi.setSequence(this.extractName(header, 3));
            fhi.setDescription(this.extractName(header, 3));
            return fhi;
        }
        logger.error("Fasta header does not match in parsePatents: {}", (Object)header);
        return fhi;
    }

    private FASTAHeaderInfo parsePDB(FASTAHeaderInfo fhi, String header) {
        Matcher matcher = FASTAConstants.PDB_HEAD.matcher(header);
        if (matcher.matches()) {
            fhi.setAccession(this.extractName(header, 1));
            fhi.setChain(this.extractName(header, 2));
            fhi.setDescription(this.extractName(header, 2));
            return fhi;
        }
        logger.error("Fasta header does not match in parsePDB: {}", (Object)header);
        return fhi;
    }

    private FASTAHeaderInfo parsePDBEntry(FASTAHeaderInfo fhi, String header) {
        Matcher matcher = FASTAConstants.PDB_ENTRY_HEAD.matcher(header);
        if (matcher.matches()) {
            fhi.setAccession(this.extractName(header, 1));
            fhi.setSequence(this.extractName(header, 3));
            fhi.setChain(this.extractName(header, 2));
            fhi.setDescription(this.extractName(header, 3));
            return fhi;
        }
        logger.error("Fasta header does not match in parsePDBEntry: {}", (Object)header);
        return fhi;
    }

    private FASTAHeaderInfo parsePreGrantPatent(FASTAHeaderInfo fhi, String header) {
        Matcher matcher = FASTAConstants.PGP_HEAD.matcher(header);
        if (matcher.matches()) {
            fhi.setAccession(this.extractName(header, 2));
            fhi.setCountry(this.extractName(header, 1));
            fhi.setSeqNr(this.extractName(header, 3));
            fhi.setDescription(this.extractName(header, 2));
            return fhi;
        }
        logger.error("Fasta header does not match in parsePreGrantPatent: {}", (Object)header);
        return fhi;
    }

    private FASTAHeaderInfo parseNBRFPIR(FASTAHeaderInfo fhi, String header) {
        Matcher matcher = FASTAConstants.PIR_HEAD.matcher(header);
        if (matcher.matches()) {
            fhi.setAccession(this.extractName(header, 1));
            fhi.setEntryName(this.extractName(header, 2));
            fhi.setDescription(this.extractName(header, 2));
            return fhi;
        }
        logger.error("Fasta header does not match in parseNBRFPIR: {}", (Object)header);
        return fhi;
    }

    private FASTAHeaderInfo parsePRF(FASTAHeaderInfo fhi, String header) {
        Matcher matcher = FASTAConstants.PRF_HEAD.matcher(header);
        if (matcher.matches()) {
            fhi.setAccession(this.extractName(header, 1));
            fhi.setEntryName(this.extractName(header, 2));
            fhi.setDescription(this.extractName(header, 2));
            return fhi;
        }
        logger.error("Fasta header does not match in parsePRF: {}", (Object)header);
        return fhi;
    }

    private FASTAHeaderInfo parseNCBIRef(FASTAHeaderInfo fhi, String header) {
        Matcher matcher = FASTAConstants.REF_HEAD.matcher(header);
        if (matcher.matches()) {
            fhi.setAccession(this.extractName(header, 1));
            fhi.setLocus(this.extractName(header, 2));
            fhi.setDescription(this.extractName(header, 2));
            return fhi;
        }
        logger.error("Fasta header does not match in parseNCBIRef: {}", (Object)header);
        return fhi;
    }

    private FASTAHeaderInfo parseSwissProt(FASTAHeaderInfo fhi, String header) {
        Matcher matcher1 = FASTAConstants.SP_HEAD.matcher(header);
        Matcher matcher2 = FASTAConstants.SP_HEAD2.matcher(header);
        if (matcher1.matches() || matcher2.matches()) {
            fhi.setAccession(this.extractName(header, 1));
            if (matcher1.matches()) {
                fhi.setDescription(this.extractName(header, 2));
            }
            if (matcher2.matches()) {
                fhi.setDescription(this.extractFullName(header, 2));
            }
            String name = this.extractName(header, 2);
            this.handleSwissProtCore(fhi, name);
            return fhi;
        }
        logger.error("Fasta header does not match in parseSwissProt: {}", (Object)header);
        return fhi;
    }

    private void handleSwissProtCore(FASTAHeaderInfo fhi, String name) {
        String restStr;
        fhi.setEntryName(name);
        int pos = name.lastIndexOf(MyConstants.STR_UNDERSCORE);
        if (pos > -1 && !this.handleUniProtOrganismCode(fhi, restStr = name.substring(pos + 1))) {
            this.setOrganismNameAndTaxIDFromStrIfPossible(fhi, restStr);
        }
    }

    private void setOrganismNameAndTaxIDFromStrIfPossible(FASTAHeaderInfo fhi, String str) {
        Pair<Integer, String> taxIDOrgNamePair = this.taxReader.tryToGetOrganismNameFromStr(str);
        if (taxIDOrgNamePair != null) {
            fhi.setOrganismName(taxIDOrgNamePair.getValue());
            fhi.setTaxID(String.valueOf(taxIDOrgNamePair.getKey()));
            if (fhi.getOrganismName().isEmpty()) {
                logger.info("No organism name found in getOrganismNameFromStr(): {}", (Object)str);
            }
        }
    }

    private FASTAHeaderInfo parseThirdPartyDDBJ(FASTAHeaderInfo fhi, String header) {
        Matcher matcher = FASTAConstants.TPD_HEAD.matcher(header);
        if (matcher.matches()) {
            fhi.setAccession(this.extractName(header, 1));
            fhi.setEntryName(this.extractName(header, 2));
            fhi.setDescription(this.extractName(header, 2));
            return fhi;
        }
        logger.error("Fasta header does not match in parseThirdPartyDDBJ: {}", (Object)header);
        return fhi;
    }

    private FASTAHeaderInfo parseThirdPartyEMBL(FASTAHeaderInfo fhi, String header) {
        Matcher matcher = FASTAConstants.TPE_HEAD.matcher(header);
        if (matcher.matches()) {
            fhi.setAccession(this.extractName(header, 1));
            fhi.setEntryName(this.extractName(header, 2));
            fhi.setDescription(this.extractName(header, 2));
            return fhi;
        }
        logger.error("Fasta header does not match in parseThirdPartyEMBL: {}", (Object)header);
        return fhi;
    }

    private FASTAHeaderInfo parseThirdPartyGenBank(FASTAHeaderInfo fhi, String header) {
        Matcher matcher = FASTAConstants.TPG_HEAD.matcher(header);
        if (matcher.matches()) {
            fhi.setAccession(this.extractName(header, 1));
            fhi.setEntryName(this.extractName(header, 2));
            fhi.setDescription(this.extractName(header, 2));
            return fhi;
        }
        logger.error("Fasta header does not match in parseThirdPartyGenBank: {}", (Object)header);
        return fhi;
    }

    private FASTAHeaderInfo parseTrembl(FASTAHeaderInfo fhi, String header) {
        Matcher matcher = FASTAConstants.TR_HEAD.matcher(header);
        if (matcher.matches()) {
            fhi.setAccession(this.extractName(header, 1));
            fhi.setEntryName(this.extractName(header, 2));
            fhi.setDescription(this.extractName(header, 2));
            this.tryToParseMaps(fhi, header);
            return fhi;
        }
        logger.error("Fasta header does not match in parseTrembl: {}", (Object)header);
        return fhi;
    }

    private FASTAHeaderInfo parseSGD(FASTAHeaderInfo fhi, String header) {
        int pos = header.indexOf("SGDID:");
        if (pos > -1) {
            fhi.setAccession(header.substring(pos + 6, pos + 16));
        }
        if ((pos = header.indexOf(MyConstants.STR_BLANK)) > -1) {
            fhi.setEntryName(header.substring(1, pos));
        }
        return fhi;
    }

    private FASTAHeaderInfo parseIPI(FASTAHeaderInfo fhi, String header) {
        int pos1 = header.indexOf(58);
        int pos2 = header.indexOf(124);
        if (pos1 > -1 && pos2 > -1 && pos2 > pos1) {
            fhi.setAccession(header.substring(pos1 + 1, pos2));
        }
        this.tryToParseMaps(fhi, header);
        if (fhi.getDescription().isEmpty() && pos2 > -1 && fhi.getDescription().isEmpty()) {
            fhi.setDescription(header.substring(pos2 + 1));
        }
        return fhi;
    }

    private FASTAHeaderInfo parseMSIPI(FASTAHeaderInfo fhi, String header) {
        fhi.setHashedContent(this.getHashedContent(header));
        return this.parseIPI(fhi, header.substring(3));
    }

    private FASTAHeaderInfo parseUniRef(FASTAHeaderInfo fhi, String header) {
        int pos1 = header.indexOf(95);
        int pos2 = header.indexOf(32);
        if (pos1 > -1 && pos2 > -1 && pos2 > pos1) {
            fhi.setAccession(header.substring(pos1 + 1, pos2));
        }
        if ((pos1 = header.lastIndexOf(124)) > -1) {
            fhi.setDescription(header.substring(pos1 + 1));
        } else {
            fhi.setDescription(header.substring(pos2 + 1));
        }
        this.tryToParseMaps(fhi, header);
        return fhi;
    }

    private FASTAHeaderInfo parseMSDB(FASTAHeaderInfo fhi, String header) {
        return this.parseAccessionAndDescriptionOnly(fhi, header);
    }

    private FASTAHeaderInfo parseHypotheticalProtein(FASTAHeaderInfo fhi, String header) {
        return this.parseAccessionAndDescriptionOnly(fhi, header);
    }

    private FASTAHeaderInfo parseUniMES(FASTAHeaderInfo fhi, String header) {
        return this.parseAccessionAndDescriptionOnly(fhi, header);
    }

    private FASTAHeaderInfo parseUniParc(FASTAHeaderInfo fhi, String header) {
        return this.parseAccessionAndDescriptionOnly(fhi, header);
    }

    private FASTAHeaderInfo parseAccessionAndDescriptionOnly(FASTAHeaderInfo fhi, String header) {
        int pos = header.indexOf(32);
        if (pos > -1) {
            fhi.setAccession(header.substring(1, pos));
            fhi.setDescription(header.substring(pos + 1));
        } else {
            fhi.setAccession(header.substring(1));
        }
        this.tryToParseMaps(fhi, header);
        return fhi;
    }

    private FASTAHeaderInfo parseUSPatent(FASTAHeaderInfo fhi, String header) {
        return this.parseAccessionAndDescriptionOnly(fhi, header);
    }

    private void tryToParseMaps(FASTAHeaderInfo fhi, String header) {
        if (this.fhi.getExtendedParsingFlag()) {
            if (header.contains(MyConstants.STR_EQUAL)) {
                this.parseKeyValueEqualMap(fhi, header, false);
                this.parseKeyValueEqualMap(fhi, header, true);
                this.parseKeyValueEqualMap(fhi, header);
            }
            if (header.contains(MyConstants.STR_COLON)) {
                this.parseKeyValueColonMap(fhi, header);
            }
            this.tryToParseOrganismName(fhi, header);
            this.TryToParseECCode(fhi, header);
            String taxID = fhi.getTaxID();
            if (!taxID.isEmpty() && fhi.getOrganismName().isEmpty()) {
                fhi.setOrganismName(this.taxReader.getOrganismName(taxID));
            }
        }
    }

    private void tryToParseOrganismName(FASTAHeaderInfo fhi, String header) {
        if (!this.getSimpleOrganismNames(fhi, header) && fhi.getOrganismName().isEmpty() && this.getFastaHeaderInfo().getResolveTaxonomyFlag()) {
            this.setOrganismNameAndTaxIDFromStrIfPossible(fhi, header);
        }
    }

    private boolean getSimpleOrganismNames(FASTAHeaderInfo fhi, String header) {
        String upperCaseHeader = header.toUpperCase();
        if (upperCaseHeader.contains("HUMAN") || upperCaseHeader.contains("HOMO SAPIENS")) {
            fhi.setOrganismName("Homo sapiens");
            fhi.setTaxID("9606");
            return true;
        }
        if (upperCaseHeader.contains("MOUSE")) {
            fhi.setOrganismName("Mus musculus");
            fhi.setTaxID("10090");
            return true;
        }
        return false;
    }

    private String getPairedContent(String header, char chr1, char chr2) {
        String restStr;
        int pos2;
        int pos1 = header.indexOf(chr1);
        if (pos1 > -1 && (pos2 = (restStr = header.substring(pos1 + 1)).indexOf(chr2)) > -1 && pos1 + pos2 > pos1) {
            return header.substring(pos1 + 1, pos1 + pos2).trim();
        }
        return "";
    }

    private String getHashedContent(String header) {
        return this.getPairedContent(header, '#', '#');
    }

    private FASTAHeaderInfo parseHeuristic(FASTAHeaderInfo fhi, String header) {
        this.parseAccessionAndDescriptionOnly(fhi, header);
        this.tryToParseMaps(fhi, header);
        return fhi;
    }

    private FASTAHeaderInfo parseCustomC(FASTAHeaderInfo fhi, String header) {
        return this.parseAccessionAndDescriptionOnly(fhi, header);
    }

    private FASTAHeaderInfo parseWithoutIdentifier(FASTAHeaderInfo fhi, String header) {
        fhi.setAccession(this.extractName(header, 0).substring(1));
        fhi.setDescription(this.extractName(header, 1));
        String name = this.extractName(header, 1);
        if (this.getFastaHeaderInfo().getExtendedParsingFlag()) {
            this.handleSwissProtCore(fhi, name);
        }
        return fhi;
    }

    private void parseKeyValueEqualMap(FASTAHeaderInfo fhi, String header) {
        Pattern pattern = FASTAConstants.KEY_VAL_EQUAL_COMPLETE;
        this.matchCompleteEqualString(fhi, header, pattern);
    }

    private void matchCompleteEqualString(FASTAHeaderInfo fhi, String header, Pattern pattern) {
        Matcher matcher = pattern.matcher(header);
        while (matcher.find()) {
            String match = matcher.group(0).trim();
            int pos = match.indexOf(61);
            if (pos <= -1) continue;
            String key = match.substring(0, pos).trim();
            String value = match.substring(pos + 1).trim();
            fhi.getMapEqual().put(key, value);
            if (!key.equals("DE") && !key.equals("descr")) continue;
            fhi.setDescription(value);
        }
    }

    private void parseKeyValueEqualMap(FASTAHeaderInfo fhi, String header, boolean bDoubled) {
        String[] arrStr = new String[]{};
        if (header.contains(MyConstants.STR_PIPE)) {
            arrStr = header.split("\\|");
        }
        Pattern pattern = bDoubled ? FASTAConstants.KEY_VAL_EQUAL_DOUBLE : FASTAConstants.KEY_VAL_EQUAL_SINGLE;
        if (arrStr.length > 0) {
            ArrayList list = new ArrayList();
            Collections.addAll(list, arrStr);
            for (String str : list) {
                this.matchEqualString(fhi, str, bDoubled, pattern);
            }
        } else {
            this.matchEqualString(fhi, header, bDoubled, pattern);
        }
    }

    private void matchEqualString(FASTAHeaderInfo fhi, String header, boolean bDoubled, Pattern pattern) {
        Matcher matcher = pattern.matcher(header);
        while (matcher.find()) {
            String match = matcher.group(0).trim();
            int pos = match.indexOf(61);
            if (pos <= -1) continue;
            String key = match.substring(0, pos).trim();
            String value = match.substring(pos + 1).trim();
            fhi.getMapEqual().put(key, value);
            if (bDoubled) {
                if (!key.equals("OS")) continue;
                fhi.setOrganismName(value);
                this.handleUniProtOrganismCode(fhi, value);
                continue;
            }
            this.handleKeyValuePair(fhi, key, value);
        }
    }

    private void handleKeyValuePair(FASTAHeaderInfo fhi, String key, String value) {
        switch (key) {
            case "OS": {
                if (!fhi.getOrganismName().isEmpty()) break;
                fhi.setOrganismName(value);
                this.handleUniProtOrganismCode(fhi, value);
                break;
            }
            case "DE": 
            case "descr": {
                fhi.setDescription(value);
                break;
            }
            case "AC": 
            case "acc": {
                fhi.setAccession(value);
                break;
            }
            case "Chromosome": {
                fhi.setChromosome(value);
                break;
            }
            case "Tax_Id": {
                fhi.setTaxID(value);
                break;
            }
            case "GN": 
            case "Gene_Symbol": 
            case "Gene": {
                int posDel = this.getDelimiterPos(value);
                if (posDel > -1) {
                    fhi.setGeneSymbol(value.substring(0, posDel));
                    break;
                }
                fhi.setGeneSymbol(value);
                break;
            }
            case "PE": {
                fhi.setProteinExistence(value);
                break;
            }
            case "SV": {
                fhi.setSequenceVersion(value);
                break;
            }
            case "lng": 
            case "len": {
                fhi.setLength(value);
                break;
            }
            case "n": {
                if (value.endsWith(MyConstants.STR_SEMICOLON)) {
                    fhi.setN(value.substring(0, value.length() - 1));
                    break;
                }
                fhi.setN(value);
                break;
            }
            case "Protein": {
                fhi.setProteinName(value);
                break;
            }
            case "Pep": {
                fhi.setSourcePeptide(value);
                break;
            }
            case "RepID": {
                fhi.setRepresentativeMember(value);
                break;
            }
            case "status": {
                fhi.setStatus(value);
                break;
            }
            case "Tax": {
                fhi.setTaxon(value);
                break;
            }
            default: {
                if (key.isEmpty()) break;
                logger.warn("Unhandled key in matchUndoubled(): {}", (Object)key);
            }
        }
    }

    private int getDelimiterPos(String value) {
        int pos1 = value.indexOf(MyConstants.STR_BLANK);
        int pos2 = value.indexOf(MyConstants.STR_SEMICOLON);
        if (pos1 > -1 && (pos1 < pos2 || pos2 == -1)) {
            return pos1;
        }
        if (pos2 > -1 && (pos2 < pos1 || pos1 == -1)) {
            return pos2;
        }
        return -1;
    }

    private void parseKeyValueColonMap(FASTAHeaderInfo fhi, String header) {
        Pattern pattern = FASTAConstants.KEY_VAL_COLON;
        Matcher matcher = pattern.matcher(header);
        while (matcher.find()) {
            String match = matcher.group(0).trim();
            int pos = match.indexOf(58);
            if (pos <= -1) continue;
            String key = match.substring(0, pos).trim();
            String value = match.substring(pos + 1).trim();
            if (!key.isEmpty()) {
                fhi.getMapColon().put(key, value);
                continue;
            }
            if (key.isEmpty()) continue;
            logger.warn("Unhandled key in parseKeyValueColonMap(): {}", (Object)key);
        }
    }

    private void TryToParseECCode(FASTAHeaderInfo fhi, String header) {
        block0: {
            Matcher matcher = FASTAConstants.EC_NUMBER.matcher(header);
            if (!matcher.find()) break block0;
            String ecCode = matcher.group(0).trim();
            fhi.setECCode(ecCode);
        }
    }
}

