/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib.Fasta;

import de.mpc.BaseLib.Fasta.FASTAConstants;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FASTALineParser {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final String fastaString;
    private String identifier;
    private String accession;
    private String description;
    private String organism;

    public FASTALineParser(String fastaStr) {
        this.fastaString = fastaStr;
        this.parse();
    }

    private void parse() {
        if (this.fastaString.startsWith(">gi|")) {
            this.parseNCBI();
        } else if (this.fastaString.startsWith(">MSIPI:")) {
            this.parseMSIPI();
        } else if (this.fastaString.startsWith(">IPI:")) {
            this.parseIPI();
        } else if (this.fastaString.startsWith(">UniRef100_")) {
            this.parseUniRef100();
        } else if (this.fastaString.startsWith(">CBMS")) {
            this.parseMSDB();
        } else if (this.isSwissProtFormat()) {
            this.parseSwissProt();
        } else if (this.fastaString.indexOf(124) > -1) {
            this.parseCustomA();
        } else if (this.fastaString.indexOf(32) > -1) {
            this.parseCustomB();
        } else if (this.fastaString.indexOf(32) > -1) {
            this.parseCustomC();
            this.logger.info("Unknown Fasta string format: " + this.fastaString);
        }
    }

    private boolean isSwissProtFormat() {
        Matcher matcher = FASTAConstants.SWISS_PROT_PATTERN.matcher(this.fastaString);
        if (matcher.find()) {
            this.accession = matcher.group(1);
            this.description = matcher.group(2);
            return true;
        }
        return false;
    }

    private void parseNCBI() {
        String restStr = "";
        int pos = this.fastaString.lastIndexOf("||");
        if (pos > -1) {
            restStr = this.fastaString.substring(pos + 1);
        } else {
            pos = this.fastaString.lastIndexOf(124);
            if (pos > -1) {
                restStr = this.fastaString.substring(pos + 1).trim();
            }
        }
        pos = restStr.indexOf(91);
        if (pos > -1) {
            this.description = restStr.substring(0, pos).trim();
        }
    }

    private void parseMSIPI() {
        int pos1 = this.fastaString.indexOf("Gene_Symbol=");
        int pos2 = this.fastaString.indexOf("lng=");
        if (pos1 > -1 && pos2 > -1 && pos2 > pos1) {
            int len = "Gene_Symbol=".length();
            this.description = this.fastaString.substring(pos1 + len, pos2 - pos1 - len);
        }
    }

    private void parseIPI() {
        int pos = this.fastaString.lastIndexOf(59);
        if (pos > -1) {
            this.description = this.fastaString.substring(pos + 1);
        }
    }

    private void parseUniRef100() {
        int pos1 = this.fastaString.indexOf(58);
        int pos2 = this.fastaString.indexOf(59);
        if (pos1 > -1 && pos2 > -1 && pos2 > pos1) {
            this.description = this.fastaString.substring(pos1 + 1, pos2 - pos1 - 1);
        }
    }

    private void parseMSDB() {
        int pos = this.fastaString.indexOf(45);
        int len = ">CBMS ".length();
        if (pos > -1) {
            this.description = this.fastaString.substring(len, pos - len);
        }
    }

    private void parseSwissProt() {
        int pos;
        if (this.description.isEmpty() && (pos = this.fastaString.indexOf(124)) > -1) {
            this.description = this.fastaString.substring(pos + 1);
        }
    }

    private void parseCustomA() {
        int pos = this.fastaString.lastIndexOf(124);
        if (pos > -1) {
            this.description = this.fastaString.substring(pos + 1);
        }
    }

    private void parseCustomB() {
        int pos1 = this.fastaString.lastIndexOf(32);
        int pos2 = this.fastaString.lastIndexOf(123);
        if (pos1 > -1 && pos2 > -1 && pos2 > pos1) {
            this.description = this.fastaString.substring(pos1 + 1, pos2 - pos1 - 1);
        } else {
            boolean bRetVal = this.handleTranscript(this.fastaString);
            if (!bRetVal) {
                this.logger.trace("Unhandled case in custom parsing B: {}", (Object)this.fastaString);
            }
        }
    }

    private boolean handleTranscript(String str) {
        int pos = str.lastIndexOf(58);
        if (pos > -1) {
            this.description = str.substring(pos + 1);
            return true;
        }
        return false;
    }

    private void parseCustomC() {
        this.description = "";
    }

    private String matchXY() {
        String match = "";
        if (this.fastaString.contains("")) {
            Pattern pattern = Pattern.compile("^([0-9].[0-9]{0,1})");
            Matcher matcher = pattern.matcher(this.fastaString);
            while (matcher.find()) {
                match = matcher.group(0);
            }
        }
        return match;
    }

    public String getDescription() {
        return this.description;
    }
}

