/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib.Fasta;

import de.mpc.BaseLib.Fasta.FASTAHeaderInfo;
import de.mpc.BaseLib.TaxonomyReader;
import de.mpc.BaseLib.constants.MyConstants;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FASTALine {
    private final String STR_BLANK_UNDERSCORE_BLANK = " _ ";
    private final String STR_BLANK_BLANK = "  ";
    private static final Pattern PAT_KEY_VAL_COLON = Pattern.compile("([a-zA-Z0-9_])+:(([a-zA-Z0-9,.])+([ ;]{1}|$))+");
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final FASTAHeaderInfo fastaHeader;
    private String lastScannedStr;

    public FASTALine(TaxonomyReader taxReader) {
        this.fastaHeader = new FASTAHeaderInfo(taxReader);
        this.resetMembers();
    }

    public FASTALine(String headerLine, TaxonomyReader taxReader) {
        this.fastaHeader = new FASTAHeaderInfo(taxReader);
        this.resetMembers();
        this.scanHeaderLine(headerLine);
    }

    private void resetMembers() {
        this.lastScannedStr = "";
        this.fastaHeader.resetMembers();
    }

    private boolean scanHeaderLine(String headerLine) {
        this.fastaHeader.setFastaLine(headerLine);
        if (headerLine.equals(this.lastScannedStr)) {
            return true;
        }
        this.resetMembers();
        if (headerLine.startsWith(MyConstants.STR_SEMICOLON)) {
            return false;
        }
        if (headerLine.startsWith(MyConstants.STR_GREATER)) {
            int pos;
            int posVLine = headerLine.indexOf(124);
            if (posVLine > -1) {
                String dbID = headerLine.substring(1, posVLine).trim();
                this.fastaHeader.setUniProtKBID(dbID);
                this.fastaHeader.setUniProtIDDescr(this.cvtUniProtKBIDToLongIDStr(this.fastaHeader.getUniProtKBID()));
                if (dbID.equals("gi") || dbID.equals("sh")) {
                    int pos2;
                    String restStr;
                    String tmpStr = this.getAccessionFromRestStr(headerLine.substring(posVLine + 1));
                    if ((posVLine = tmpStr.indexOf(124)) > -1) {
                        this.fastaHeader.setSecondaryID(tmpStr.substring(0, posVLine).trim());
                    }
                    if ((posVLine = (restStr = tmpStr.substring(posVLine + 1).trim()).indexOf(124)) > -1) {
                        this.fastaHeader.setSecondaryAccession(restStr.substring(0, posVLine).trim());
                    }
                    if ((pos2 = (tmpStr = restStr.substring(posVLine + 1).trim()).indexOf("RecName: ")) > -1) {
                        this.handleParsingRuleC(tmpStr, pos2);
                        this.handleRecNameCase(tmpStr);
                    } else {
                        this.getProteinAndOrganismNameFromSimpleFASTALine(tmpStr);
                    }
                    return this.finishParsing(headerLine);
                }
                if (dbID.equals("tr") || dbID.equals("sp")) {
                    String tmpStr = this.getAccessionFromRestStr(headerLine.substring(posVLine + 1));
                    int posBlank = tmpStr.indexOf(32);
                    if (posBlank > -1) {
                        this.fastaHeader.setEntryName(tmpStr.substring(0, posBlank).trim());
                    }
                    String restStr = tmpStr.substring(posBlank);
                    this.scanSmallHeaderLine(restStr);
                    return this.finishParsing(headerLine);
                }
                if (dbID.startsWith("IPI:")) {
                    int posBlank = headerLine.indexOf(32);
                    if (posBlank > -1) {
                        String pairStr = headerLine.substring(1, posBlank);
                        this.parseDbAccPairMap(pairStr);
                    }
                    this.handleTaxIDAndGeneSymbol(headerLine.substring(posBlank + 1));
                    int posVPipe = headerLine.lastIndexOf(124);
                    if (posVPipe > -1) {
                        this.fastaHeader.setDescription(headerLine.substring(posVPipe + 1));
                    }
                    return this.finishParsing(headerLine);
                }
                if (dbID.contains("SWISS-PROT")) {
                    int posLastColon = dbID.lastIndexOf(58);
                    this.fastaHeader.setAccession(dbID.substring(posLastColon + 1));
                    this.fastaHeader.setDescription(headerLine.substring(posVLine + 1));
                    return this.finishParsing(headerLine);
                }
                this.logger.error("Unhandled dbID in FASTA headerLine: {}\tdbID: {}", (Object)headerLine, (Object)dbID);
                return false;
            }
            this.handleParsingRuleC(headerLine, -1);
            String acc = this.fastaHeader.getAccession();
            if ((acc == null || acc.isEmpty()) && (pos = headerLine.indexOf(32)) > -1) {
                this.fastaHeader.setAccession(headerLine.substring(1, pos).trim());
            }
            return this.finishParsing(headerLine);
        }
        if (!headerLine.contains(MyConstants.STR_GREATER) && headerLine.indexOf(124) < 0) {
            if (headerLine.startsWith("Tax_Id=")) {
                this.handleTaxIDAndGeneSymbol(headerLine);
            } else {
                int pos;
                String retStr = this.scanSmallHeaderLine(headerLine);
                this.fastaHeader.setAccession(this.getAccessionForSmallHeaderLine(retStr));
                if (this.fastaHeader.getAccession().isEmpty() && (pos = headerLine.indexOf(32)) > -1) {
                    this.fastaHeader.setAccession(headerLine.substring(0, pos));
                }
            }
            return true;
        }
        int posGI = headerLine.indexOf("gi");
        int posDBJ = headerLine.indexOf("dbj");
        int posEMB = headerLine.indexOf("emb");
        int posGB = headerLine.indexOf("gb");
        int posPDB = headerLine.indexOf("pdb");
        int posPIR = headerLine.indexOf("pir");
        int posREF = headerLine.indexOf("ref");
        int posSP = headerLine.indexOf("sp");
        if (posGI > -1) {
            return this.checkTwoProteinDBIDs(headerLine, posGI, posDBJ) || this.checkTwoProteinDBIDs(headerLine, posGI, posEMB) || this.checkTwoProteinDBIDs(headerLine, posGI, posGB) || this.checkTwoProteinDBIDs(headerLine, posGI, posPDB) || this.checkTwoProteinDBIDs(headerLine, posGI, posPIR) || this.checkTwoProteinDBIDs(headerLine, posGI, posREF) || this.checkTwoProteinDBIDs(headerLine, posGI, posSP);
        }
        this.getProteinAndOrganismNameFromSimpleFASTALine(headerLine);
        this.logger.error("Maybe not a FASTA header line: {}", (Object)headerLine);
        return true;
    }

    private boolean finishParsing(String headerLine) {
        this.lastScannedStr = headerLine;
        if (this.fastaHeader.getDescription() == null) {
            this.fastaHeader.setDescription(this.getFullDescription(headerLine));
        }
        return true;
    }

    private String getFullDescription(String headerLine) {
        int pos = headerLine.lastIndexOf(MyConstants.STR_PIPE);
        if (pos > -1) {
            return headerLine.substring(pos + 1);
        }
        return "";
    }

    private void getProteinAndOrganismNameFromSimpleFASTALine(String str) {
        int posOpen = str.lastIndexOf(91);
        int posClose = str.lastIndexOf(93);
        if (posOpen > -1 && posClose > -1 && posClose > posOpen && str.endsWith(MyConstants.STR_SQUARE_BRACKET_CLOSE)) {
            String strTemp = str.substring(0, posOpen).trim();
            if (strTemp.startsWith("protein ")) {
                this.fastaHeader.setProteinName(strTemp.substring(8));
            } else {
                this.fastaHeader.setProteinName(strTemp);
            }
            this.fastaHeader.setOrganismName(str.substring(posOpen + 1, posClose).trim());
        } else {
            this.fastaHeader.setProteinName(str);
            this.fastaHeader.setOrganismName(this.tryToGetOrganismName(str));
        }
    }

    private boolean checkTwoProteinDBIDs(String headerLine, int posGI, int posSecondID) {
        if (posSecondID > -1 && posSecondID > posGI) {
            this.fastaHeader.setAccession(headerLine.substring(posGI + 3, posSecondID));
            this.getProteinAndOrganismNameFromStartString(headerLine, posGI);
            return true;
        }
        return false;
    }

    private void getProteinAndOrganismNameFromStartString(String headerLine, int posGI) {
        String startStr = headerLine.substring(0, posGI);
        int posOpen = startStr.indexOf(123);
        int posClose = startStr.indexOf(125);
        if (posOpen > -1 && posClose > -1 && posClose > posOpen) {
            this.fastaHeader.setProteinName(startStr.substring(0, posOpen));
            this.fastaHeader.setOrganismName(startStr.substring(posOpen + 1, posClose));
        }
    }

    private String getAccessionFromRestStr(String restStr) {
        int pos = restStr.indexOf(124);
        if (pos > -1) {
            this.fastaHeader.setAccession(restStr.substring(0, pos).trim());
        }
        assert (this.fastaHeader.getAccession().length() >= 6 || this.fastaHeader.getAccession().length() <= 9);
        return restStr.substring(pos + 1);
    }

    private void parseDbAccPairMap(String str) {
        Pattern pattern = Pattern.compile("[a-zA-Z-_]+:[a-zA-Z0-9\\.-;_]+[|]?");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            String match = matcher.group(0);
            int pos = match.indexOf(58);
            if (pos <= -1) continue;
            String key = match.substring(0, pos).trim();
            String value = match.substring(pos + 1).trim();
            if (value.endsWith(MyConstants.STR_VLINE)) {
                value = value.substring(0, value.length() - 1);
            }
            this.fastaHeader.getDBAccPairMap().put(key, value);
        }
    }

    private void handleTaxIDAndGeneSymbol(String str) {
        int posTaxID = str.indexOf("Tax_Id=");
        int posGeneSymbol = str.indexOf("Gene_Symbol=");
        if (posTaxID > -1 && posGeneSymbol > -1) {
            String strRest;
            int posBlank;
            this.fastaHeader.setTaxID(str.substring(posTaxID + "Tax_Id=".length(), posGeneSymbol));
            if (posGeneSymbol > -1 && (posBlank = (strRest = str.substring(posGeneSymbol + "Gene_Symbol=".length())).indexOf(32)) > -1) {
                this.fastaHeader.setGeneSymbol(strRest.substring(0, posBlank));
                this.fastaHeader.setProteinName(strRest.substring(posBlank + 1));
            }
        }
    }

    private String tryToGetOrganismName(String str) {
        if (str.indexOf("human") > -1 || str.indexOf("Human") > -1 || str.indexOf("HUMAN") > -1) {
            return "HUMAN";
        }
        if (str.indexOf("bovin") > -1 || str.indexOf("Bovin") > -1 || str.indexOf("BOVIN") > -1) {
            return "BOVIN";
        }
        if (str.indexOf("murin") > -1 || str.indexOf("Murin") > -1 || str.indexOf("MURIN") > -1) {
            return "MURIN";
        }
        this.logger.trace("headerLine contains no organism name: {}", (Object)str);
        return null;
    }

    private void handleParsingRuleC(String str, int posRecName) {
        boolean bRetVal = this.handleProteinUnderscoreOrganismName(str, posRecName);
        if (!bRetVal) {
            int pos = str.indexOf(123);
            if (pos > -1) {
                this.fastaHeader.setProteinName(str.substring(0, pos).trim());
                this.fastaHeader.setOrganismName(str.substring(pos + 1));
            } else {
                bRetVal = this.handleTranscript(str);
                if (!(bRetVal || (bRetVal = this.handleBeginningPipe(str)) || (bRetVal = this.tryToGetDescription(str)) || (bRetVal = this.handleDBBlankUnderscoreBlankProteinNameBlankUnderscoreBlank(str)) || (bRetVal = this.handleDBUnderscoreProteinUnderscoreOrganismName(str)) || (bRetVal = this.handleDoubleBlank(str)))) {
                    this.logger.error("Unhandled case in parsing Rule C: {}", (Object)str);
                }
            }
        }
    }

    private boolean handleDoubleBlank(String str) {
        String[] strArr = str.split(this.STR_BLANK_BLANK);
        if (strArr.length >= 2) {
            this.fastaHeader.setProteinName(strArr[1]);
            return true;
        }
        strArr = str.split(MyConstants.STR_BLANK);
        if (strArr.length >= 2) {
            this.fastaHeader.setProteinName(strArr[1]);
            return true;
        }
        this.logger.debug("str: {}", (Object)str);
        return false;
    }

    private boolean handleDBBlankUnderscoreBlankProteinNameBlankUnderscoreBlank(String str) {
        String[] strArr = str.split(this.STR_BLANK_UNDERSCORE_BLANK);
        if (strArr.length >= 2) {
            this.fastaHeader.setProteinName(strArr[1]);
            return true;
        }
        return false;
    }

    private boolean handleDBUnderscoreProteinUnderscoreOrganismName(String str) {
        String[] strArr = str.split(MyConstants.STR_UNDERSCORE);
        if (strArr.length >= 3) {
            this.fastaHeader.setProteinName(strArr[1]);
            this.fastaHeader.setOrganismName(strArr[2]);
            return true;
        }
        return false;
    }

    private boolean handleProteinUnderscoreOrganismName(String str, int posRecName) {
        int pos = str.indexOf(95);
        if (pos > -1) {
            this.fastaHeader.setProteinName(str.substring(0, pos));
            if (posRecName > -1) {
                this.fastaHeader.setOrganismName(str.substring(pos + 1, posRecName).trim());
                return true;
            }
        }
        return false;
    }

    private boolean handleTranscript(String str) {
        int pos = str.lastIndexOf(58);
        if (pos > -1) {
            this.fastaHeader.setProteinName(str.substring(pos + 1));
            return true;
        }
        return false;
    }

    private boolean handleBeginningPipe(String str) {
        int pos2;
        int posMin;
        int posPipe = str.indexOf(124);
        int pos1 = str.indexOf("\\DE=");
        int n = posMin = pos1 < (pos2 = str.indexOf(91)) ? pos1 : pos2;
        if (posPipe > -1 && posMin > posPipe) {
            this.fastaHeader.setProteinName(str.substring(posPipe + 1, posMin).trim());
            this.fastaHeader.setAccession(this.tryToGetAccession(str));
            return true;
        }
        return false;
    }

    private String tryToGetAccession(String str) {
        int posPipe = str.indexOf(124);
        int posAcc = str.indexOf("\\AC=");
        if (posPipe > -1 && posAcc > -1 && posAcc < posPipe) {
            return str.substring(posPipe + 4, posAcc);
        }
        return "";
    }

    private boolean tryToGetDescription(String str) {
        int pos = str.lastIndexOf(91);
        int posDesc = str.indexOf("\\DE=");
        if (posDesc > -1 && pos > -1 && posDesc < pos) {
            this.fastaHeader.setProteinName(str.substring(posDesc + 1, pos).trim());
            return true;
        }
        return false;
    }

    private void handleRecNameCase(String tmpStr) {
        int posFlags = tmpStr.indexOf("Flags: ");
        int posAltName = tmpStr.indexOf("AltName: ");
        int posRecName = tmpStr.indexOf("RecName: ");
        String strAltName = "";
        String strRecName = "";
        if (posFlags > -1) {
            if (posAltName > -1) {
                strAltName = tmpStr.substring(posAltName + "AltName: ".length(), posFlags);
                if (posRecName > -1) {
                    strRecName = tmpStr.substring(posRecName + "RecName: ".length(), posAltName);
                }
            } else if (posRecName > -1) {
                strRecName = tmpStr.substring(posRecName + "RecName: ".length(), posFlags);
            }
        } else if (posAltName > -1) {
            strAltName = tmpStr.substring(posAltName + "AltName: ".length());
            if (posRecName > -1) {
                strRecName = tmpStr.substring(posRecName + "RecName: ".length(), posAltName);
            }
        } else if (posRecName > -1) {
            strRecName = tmpStr.substring(posRecName + "RecName: ".length());
        }
        this.handleProteinUnderscoreOrganismName(tmpStr, posRecName);
        if (!strRecName.isEmpty()) {
            this.fastaHeader.setProteinName(this.getFullName(strRecName));
        } else if (!strAltName.isEmpty()) {
            this.fastaHeader.setProteinName(this.getFullName(strAltName));
        }
    }

    private String getFullName(String str) {
        int posFullEQ = str.indexOf("Full=");
        int posShortEQ = str.indexOf("Short=");
        String tmpStr = "";
        if (posFullEQ > -1) {
            tmpStr = posShortEQ > -1 ? str.substring(posFullEQ + "Full=".length(), posShortEQ).trim() : str.substring(posFullEQ + "Full=".length()).trim();
        }
        if (tmpStr.endsWith(MyConstants.STR_SEMICOLON)) {
            return tmpStr.substring(0, tmpStr.length() - 1);
        }
        return tmpStr;
    }

    private String scanSmallHeaderLine(String restStr) {
        String tmpStr = "";
        int pos = restStr.indexOf("OS");
        if (pos > -1) {
            this.fastaHeader.setProteinName(restStr.substring(0, pos).trim());
            tmpStr = restStr.substring(pos);
            if (tmpStr.indexOf(61) > -1) {
                this.parseKeyValueEqualMap(tmpStr);
            }
            if (tmpStr.indexOf(58) > -1) {
                this.parseKeyValueColonMap(tmpStr);
            }
            this.fastaHeader.setOrganismName(this.fastaHeader.getMapEqual().get("OS"));
        }
        return tmpStr;
    }

    private String getAccessionForSmallHeaderLine(String str) {
        String retStr = "";
        int pos1 = str.indexOf(91);
        int pos2 = str.indexOf(93);
        if (pos1 > -1 && pos2 > -1 && pos2 > pos1) {
            retStr = str.substring(pos1 + 1, pos2);
        }
        return retStr;
    }

    private void parseKeyValueEqualMap(String str) {
        Pattern pattern = Pattern.compile("([a-zA-Z0-9])+=(([a-zA-Z0-9])+([ ]{1}|$))+");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            String match = matcher.group(0).trim();
            int pos = match.indexOf(61);
            if (pos <= -1) continue;
            String key = match.substring(0, pos).trim();
            String value = match.substring(pos + 1).trim();
            this.fastaHeader.getMapEqual().put(key, value);
            switch (key) {
                case "OS": {
                    this.fastaHeader.setOrganismName(value);
                    break;
                }
                case "DE=": 
                case "descr=": {
                    this.fastaHeader.setDescription(value);
                    break;
                }
                case "AC=": 
                case "acc=": {
                    this.fastaHeader.setAccession(value);
                    break;
                }
                case "Tax_Id=": {
                    this.fastaHeader.setTaxID(value);
                    break;
                }
                case "GN=": 
                case "Gene_Symbol=": {
                    this.fastaHeader.setGeneSymbol(value);
                }
            }
        }
    }

    private void parseKeyValueColonMap(String str) {
        Matcher matcher = PAT_KEY_VAL_COLON.matcher(str);
        while (matcher.find()) {
            String match = matcher.group(0).trim();
            int pos = match.indexOf(58);
            if (pos <= -1) continue;
            String key = match.substring(0, pos).trim();
            String value = match.substring(pos + 1).trim();
            this.fastaHeader.getMapColon().put(key, value);
        }
    }

    public String getID(String headerLine) {
        if (this.scanHeaderLine(headerLine)) {
            return this.fastaHeader.getUniProtKBID();
        }
        return "";
    }

    public String getLongID(String headerLine) {
        String id = this.getID(headerLine);
        String longIDStr = this.cvtUniProtKBIDToLongIDStr(id);
        this.fastaHeader.setUniProtIDDescr(longIDStr);
        return longIDStr;
    }

    private String cvtUniProtKBIDToLongIDStr(String UniProtKBID) {
        if (UniProtKBID.equals("gi")) {
            return "GenBank | EMBL | DDBJ";
        }
        if (UniProtKBID.equals("gnl")) {
            return "General database identifier";
        }
        if (UniProtKBID.equals("bbs")) {
            return "GenInfo BackBone SeqId";
        }
        if (UniProtKBID.equals("bbm")) {
            return "GenInfo BackBone MolType";
        }
        if (UniProtKBID.equals("ddbj")) {
            return "DNA DataBase of Japan";
        }
        if (UniProtKBID.equals("emb")) {
            return "EMBL";
        }
        if (UniProtKBID.equals("entry:chain")) {
            return "Brookhaven Protein Data Bank (2)";
        }
        if (UniProtKBID.equals("gb")) {
            return "GenBank";
        }
        if (UniProtKBID.equals("gi")) {
            return "GenInfo Integrated Database";
        }
        if (UniProtKBID.equals("gim")) {
            return "GenInfo Import ID";
        }
        if (UniProtKBID.equals("gnl")) {
            return "General database Reference";
        }
        if (UniProtKBID.equals("gpp")) {
            return "Genome Pipeline";
        }
        if (UniProtKBID.equals("lcl")) {
            return "Local Sequence Identifier";
        }
        if (UniProtKBID.equals("nat")) {
            return "Named Annotation Track";
        }
        if (UniProtKBID.equals("pat")) {
            return "Patents";
        }
        if (UniProtKBID.equals("pdb")) {
            return "Brookhaven Protein Data Bank (1)";
        }
        if (UniProtKBID.equals("pgp")) {
            return "Pre-Grant Patent";
        }
        if (UniProtKBID.equals("pir")) {
            return "NBRF PIR";
        }
        if (UniProtKBID.equals("prf")) {
            return "Protein Research Foundation";
        }
        if (UniProtKBID.equals("ref")) {
            return "NCBI Reference Sequence";
        }
        if (UniProtKBID.equals("sh")) {
            return "shuffled sequence";
        }
        if (UniProtKBID.equals("sp")) {
            return "Swiss-Prot";
        }
        if (UniProtKBID.equals("tpd")) {
            return "Third-Party DDBJ";
        }
        if (UniProtKBID.equals("tpe")) {
            return "Third-Party EMBL";
        }
        if (UniProtKBID.equals("tpg")) {
            return "Third-Party GenBank";
        }
        if (UniProtKBID.equals("tr")) {
            return "TrEMBL";
        }
        if (UniProtKBID.startsWith("IPI")) {
            return "International Protein Index";
        }
        if (UniProtKBID.equals("")) {
            return "";
        }
        this.logger.error("Unknown FASTA UniProt-ID: {}", (Object)this.fastaHeader.getUniProtKBID());
        return "";
    }

    public String getAccessionFromHeaderLine(String headerLine) {
        if (this.scanHeaderLine(headerLine)) {
            return this.fastaHeader.getAccession();
        }
        return "";
    }

    public String getShortAccession(String headerLine) {
        if (this.scanHeaderLine(headerLine)) {
            int pos = this.fastaHeader.getAccession().indexOf("_HUMAN");
            if (pos > -1) {
                return this.fastaHeader.getAccession().substring(0, pos);
            }
            return this.fastaHeader.getAccession();
        }
        return "";
    }

    public String getEntryName(String headerLine) {
        if (this.scanHeaderLine(headerLine)) {
            return this.fastaHeader.getEntryName();
        }
        return "";
    }

    public String getProteinName(String headerLine) {
        if (this.scanHeaderLine(headerLine)) {
            return this.fastaHeader.getProteinName();
        }
        return "";
    }

    public FASTAHeaderInfo getFASTAHeaderInfo(String headerLine) {
        if (this.scanHeaderLine(headerLine)) {
            return this.fastaHeader;
        }
        return null;
    }

    public FASTAHeaderInfo getFASTAHeaderInfo() {
        if (this.lastScannedStr.length() > 0) {
            return this.fastaHeader;
        }
        return null;
    }
}

