/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib.Fasta;

import de.mpc.BaseLib.TaxonomyReader;
import de.mpc.BaseLib.constants.MyConstants;
import java.util.HashMap;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FASTAHeaderInfo {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private String fastaLine;
    private final TaxonomyReader taxReader;
    private String UniProtKBID;
    private String secondaryID;
    private String UniProtIDDescr;
    private String description;
    private String accession;
    private String secondaryAccession;
    private String giNumber;
    private String entryName;
    private String locus;
    private String proteinName;
    private String organismName;
    private String taxID;
    private String geneSymbol;
    private String database;
    private String chromosome;
    private String country;
    private String sequence;
    private String seqNr;
    private String chain;
    private String ecCode;
    private String strain;
    private String hashedContent;
    private String sourcePeptide;
    private String representativeMember;
    private String status;
    private String taxon;
    private int length;
    private int N;
    private int proteinExistence;
    private int sequenceVersion;
    private boolean bResolveTaxonomy = false;
    private boolean bDoExtendedParsing = false;
    private final HashMap<String, String> mapEqual = new HashMap();
    private final HashMap<String, String> mapColon = new HashMap();
    private final HashMap<String, String> dbAccPairMap = new HashMap();

    public FASTAHeaderInfo(TaxonomyReader taxReader) {
        this.taxReader = taxReader;
        this.resetMembers();
    }

    public final void resetMembers() {
        this.UniProtKBID = "";
        this.secondaryID = "";
        this.UniProtIDDescr = "";
        this.accession = "";
        this.secondaryAccession = "";
        this.giNumber = "";
        this.entryName = "";
        this.locus = "";
        this.proteinName = "";
        this.organismName = "";
        this.taxID = "";
        this.geneSymbol = "";
        this.database = "";
        this.chromosome = "";
        this.country = "";
        this.sequence = "";
        this.seqNr = "";
        this.chain = "";
        this.ecCode = "";
        this.strain = "";
        this.hashedContent = "";
        this.sourcePeptide = "";
        this.representativeMember = "";
        this.status = "";
        this.taxon = "";
        this.length = -1;
        this.N = -1;
        this.proteinExistence = -1;
        this.sequenceVersion = -1;
        this.mapEqual.clear();
        this.mapColon.clear();
        this.dbAccPairMap.clear();
    }

    public boolean getResolveTaxonomyFlag() {
        return this.bResolveTaxonomy;
    }

    public void setResolveTaxonomyFlag(boolean flag) {
        this.bResolveTaxonomy = flag;
    }

    public boolean getExtendedParsingFlag() {
        return this.bDoExtendedParsing;
    }

    public void setExtendedParsingFlag(boolean flag) {
        this.bDoExtendedParsing = flag;
    }

    public final String getLongDescription() {
        StringBuilder strB = new StringBuilder();
        strB.append(this.entryName);
        strB.append(this.proteinName);
        this.addToStrEqualBuilder(strB, "AC=");
        this.addToStrEqualBuilder(strB, "DE=");
        this.addToStrEqualBuilder(strB, "GN=");
        this.addToStrEqualBuilder(strB, "OS");
        this.addToStrEqualBuilder(strB, "PE=");
        this.addToStrEqualBuilder(strB, "SV=");
        this.addToStrEqualBuilder(strB, "acc=");
        this.addToStrEqualBuilder(strB, "Chromosome=");
        this.addToStrEqualBuilder(strB, "descr=");
        this.addToStrEqualBuilder(strB, "len=");
        this.addToStrEqualBuilder(strB, "lng=");
        this.addToStrEqualBuilder(strB, "MASS=");
        this.addToStrEqualBuilder(strB, "n=");
        this.addToStrEqualBuilder(strB, "Gene=");
        this.addToStrEqualBuilder(strB, "Gene_Symbol=");
        this.addToStrEqualBuilder(strB, "Pep=");
        this.addToStrEqualBuilder(strB, "Protein=");
        this.addToStrEqualBuilder(strB, "REP_ID=");
        this.addToStrEqualBuilder(strB, "status=");
        this.addToStrEqualBuilder(strB, "Tax=");
        this.addToStrEqualBuilder(strB, "Tax_Id=");
        this.addToStrColonBuilder(strB, "Cluster:");
        this.addToStrColonBuilder(strB, "ENSEMBL:");
        this.addToStrColonBuilder(strB, "H-INV:");
        this.addToStrColonBuilder(strB, "IPI:");
        this.addToStrColonBuilder(strB, "MSIPI:");
        this.addToStrColonBuilder(strB, "REFSE:");
        this.addToStrColonBuilder(strB, "REFSEQ:");
        this.addToStrColonBuilder(strB, "Rep:");
        this.addToStrColonBuilder(strB, "SGDID:");
        this.addToStrColonBuilder(strB, "SWISS-PROT:");
        this.addToStrColonBuilder(strB, "TREMBL:");
        this.addToStrColonBuilder(strB, "VEGA:");
        return strB.toString();
    }

    private void addToStrEqualBuilder(StringBuilder strB, String keyStr) {
        if (this.mapEqual.containsKey(keyStr)) {
            strB.append(MyConstants.STR_BLANK).append(keyStr);
            strB.append(this.mapEqual.get(keyStr));
        }
    }

    private void addToStrColonBuilder(StringBuilder strB, String keyStr) {
        if (this.mapColon.containsKey(keyStr)) {
            strB.append(MyConstants.STR_BLANK).append(keyStr);
            strB.append(this.mapColon.get(keyStr));
        }
    }

    public String getFastaLine() {
        return this.fastaLine;
    }

    public String getUniProtKBID() {
        return this.UniProtKBID;
    }

    public String getSecondaryID() {
        return this.secondaryID;
    }

    public String getUniProtIDDescr() {
        return this.UniProtIDDescr;
    }

    public String getDescription() {
        if (this.description != null && !this.description.equals("")) {
            return this.description;
        }
        if (this.mapEqual.containsKey("descr")) {
            return this.mapEqual.get("descr");
        }
        if (this.mapEqual.containsKey("DE")) {
            return this.mapEqual.get("DE");
        }
        return "";
    }

    public String getAccession() {
        Iterator<String> i$;
        if (!this.accession.equals("")) {
            return this.accession;
        }
        if (this.mapEqual.containsKey("AC")) {
            return this.mapEqual.get("AC");
        }
        if (this.mapEqual.containsKey("acc")) {
            return this.mapEqual.get("acc");
        }
        if (this.dbAccPairMap.size() > 0 && (i$ = this.dbAccPairMap.keySet().iterator()).hasNext()) {
            String key = i$.next();
            return this.dbAccPairMap.get(key);
        }
        this.logger.trace("No accession found in getAccession() of FASTAHeaderInfo for fastaLine: {}", (Object)this.fastaLine);
        return "";
    }

    public String getSecondaryAccession() {
        return this.secondaryAccession;
    }

    public String getOrganismName() {
        if (this.organismName != null && !this.organismName.equals("")) {
            return this.organismName;
        }
        if (this.mapEqual.containsKey("OS")) {
            return this.mapEqual.get("OS");
        }
        if (!this.getTaxID().isEmpty()) {
            return this.taxReader.getOrganismName(String.valueOf(this.getTaxID()));
        }
        return "";
    }

    public String getGINumber() {
        return this.giNumber;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public String getLocus() {
        return this.locus;
    }

    public String getTaxID() {
        return this.taxID;
    }

    public String getProteinName() {
        return this.proteinName;
    }

    public String getGeneSymbol() {
        return this.geneSymbol;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getChromosome() {
        return this.chromosome;
    }

    public String getCountry() {
        return this.country;
    }

    public String getSequence() {
        return this.sequence;
    }

    public String getSeqNr() {
        return this.seqNr;
    }

    public String getChain() {
        return this.chain;
    }

    public String getECCode() {
        return this.ecCode;
    }

    public String getStrain() {
        return this.strain;
    }

    public String getHashedContent() {
        return this.hashedContent;
    }

    public String getSourcePeptide() {
        return this.sourcePeptide;
    }

    public String getRepresentativeMember() {
        return this.representativeMember;
    }

    public String getStatus() {
        return this.status;
    }

    public String getTaxon() {
        return this.taxon;
    }

    public int getLength() {
        return this.length;
    }

    public int getN() {
        return this.N;
    }

    public int getProteinExistence() {
        return this.proteinExistence;
    }

    public int getSequenceVersion() {
        return this.sequenceVersion;
    }

    public HashMap<String, String> getMapEqual() {
        return this.mapEqual;
    }

    public HashMap<String, String> getMapColon() {
        return this.mapEqual;
    }

    public HashMap<String, String> getDBAccPairMap() {
        return this.dbAccPairMap;
    }

    public void setFastaLine(String fastLine) {
        this.fastaLine = fastLine;
    }

    public void setUniProtKBID(String uniProtID) {
        this.UniProtKBID = uniProtID;
    }

    public void setSecondaryID(String secondaryID) {
        this.secondaryID = secondaryID;
    }

    public void setUniProtIDDescr(String uniProtIDDescr) {
        this.UniProtIDDescr = uniProtIDDescr;
    }

    public void setDescription(String desc) {
        this.description = desc.trim();
    }

    public void setAccession(String acc) {
        this.accession = acc;
    }

    public void setSecondaryAccession(String acc) {
        this.secondaryAccession = acc;
    }

    public void setOrganismName(String organism) {
        this.organismName = organism;
        if (this.taxReader != null) {
            this.taxID = String.valueOf(this.taxReader.getTaxID(this.organismName));
        }
    }

    public void setGINumber(String giNumber) {
        this.giNumber = giNumber;
    }

    public void setEntryName(String entry) {
        this.entryName = entry;
    }

    public void setLocus(String locus) {
        this.locus = locus;
    }

    public void setTaxID(String taxID) {
        this.taxID = taxID;
    }

    public void setProteinName(String proteinName) {
        this.proteinName = proteinName;
    }

    public void setGeneSymbol(String geneSymbol) {
        this.geneSymbol = geneSymbol;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setChromosome(String chromosome) {
        this.chromosome = chromosome;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public void setSeqNr(String seqNr) {
        this.seqNr = seqNr;
    }

    public void setChain(String chain) {
        this.chain = chain;
    }

    public void setECCode(String ecCode) {
        this.ecCode = ecCode;
    }

    public void setStrain(String strain) {
        this.strain = strain;
    }

    public void setHashedContent(String content) {
        this.hashedContent = content;
    }

    public void setSourcePeptide(String peptide) {
        this.sourcePeptide = peptide;
    }

    public void setRepresentativeMember(String repMember) {
        this.representativeMember = repMember;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setTaxon(String taxon) {
        this.taxon = taxon;
    }

    public void setLength(String strLen) {
        this.length = Integer.valueOf(strLen);
    }

    public void setN(String strN) {
        this.N = Integer.valueOf(strN);
        this.mapEqual.put("n", strN);
    }

    public void setProteinExistence(String strPE) {
        this.proteinExistence = Integer.valueOf(strPE);
    }

    public void setSequenceVersion(String strSV) {
        this.sequenceVersion = Integer.valueOf(strSV);
    }

    public float getMass() {
        if (this.mapEqual.containsKey("MASS=")) {
            return Float.parseFloat(this.mapEqual.get("MASS="));
        }
        return 0.0f;
    }

    public String getDescription(String headerLine) {
        String descr = this.getValueForKeyFromMap(headerLine, "DE=");
        if (descr.isEmpty()) {
            descr = this.getValueForKeyFromMap(headerLine, "descr=");
        }
        return descr;
    }

    public String getAccession(String headerLine) {
        String acc = this.getValueForKeyFromMap(headerLine, "AC=");
        if (acc.isEmpty()) {
            acc = this.getValueForKeyFromMap(headerLine, "acc=");
        }
        return acc;
    }

    public String getOrganismName(String headerLine) {
        if (this.taxReader != null) {
            return this.getValueForKeyFromMap(headerLine, "OS");
        }
        return "";
    }

    public String getGeneName(String headerLine) {
        String geneName = this.getValueForKeyFromMap(headerLine, "GN=");
        if (geneName.isEmpty()) {
            geneName = this.getValueForKeyFromMap(headerLine, "Gene_Symbol=");
        }
        return geneName;
    }

    public int getLength(String headerLine) {
        String geneName = this.getValueForKeyFromMap(headerLine, "len=");
        if (geneName.isEmpty()) {
            geneName = this.getValueForKeyFromMap(headerLine, "lng=");
        }
        return Integer.parseInt(geneName);
    }

    public float getMass(String headerLine) {
        return Float.parseFloat(this.getValueForKeyFromMap(headerLine, "MASS="));
    }

    public int getN(String headerLine) {
        return Integer.parseInt(this.getValueForKeyFromMap(headerLine, "n"));
    }

    public String getTaxID(String headerLine) {
        return this.getValueForKeyFromMap(headerLine, "Tax_Id=");
    }

    public String getProteinExistence(String headerLine) {
        return this.getValueForKeyFromMap(headerLine, "PE=");
    }

    public String getSequenceVersion(String headerLine) {
        return this.getValueForKeyFromMap(headerLine, "SV=");
    }

    private String getValueForKeyFromMap(String headerLine, String token) {
        if (this.getMapEqual().containsKey(token)) {
            return this.getMapEqual().get(token);
        }
        if (this.getMapColon().containsKey(token)) {
            return this.getMapColon().get(token);
        }
        return this.getValueForKeyFromHeader(headerLine, token);
    }

    private String getValueForKeyFromHeader(String headerLine, String key) {
        int pos2 = -1;
        int pos1 = headerLine.indexOf(key);
        if (pos1 <= -1 || pos1 + key.length() > headerLine.length()) {
            return "";
        }
        String restStr = headerLine.substring(pos1 + key.length());
        if (key.indexOf(61) > -1) {
            pos2 = restStr.indexOf(61);
        } else if (key.indexOf(58) > -1) {
            pos2 = restStr.indexOf(58);
        }
        String retStr = pos2 > -1 ? restStr.substring(0, pos2 - 2).trim() : restStr.trim();
        return retStr;
    }
}

