/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib.DB;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SQLSERVER_VERSION {
    UNKNOWN(-1),
    UNSUPPORTED(0),
    SQLSERVER2005(8),
    SQLSERVER2008(9),
    SQLSERVER2012(10);

    private final int version;
    private final Logger logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());

    private SQLSERVER_VERSION(int version) {
        this.version = version;
    }

    public static SQLSERVER_VERSION valueOf(int version) {
        switch (version) {
            case 8: {
                return SQLSERVER2005;
            }
            case 9: {
                return SQLSERVER2008;
            }
            case 10: {
                return SQLSERVER2012;
            }
        }
        return UNSUPPORTED;
    }

    public String toString() {
        switch (this.version) {
            case 8: {
                return "SQLServer 2005";
            }
            case 9: {
                return "SQLServer 2008";
            }
            case 10: {
                return "SQLServer 2012";
            }
        }
        this.logger.error("Unknown SQL Server version: " + this.version);
        return "";
    }
}

