/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib;

import de.mpc.BaseLib.BaseCVHelper;
import de.mpc.BaseLib.ParseUnimod;
import de.mpc.BaseLib.obo.OBOInitialRead;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CVQuery {
    protected static final String STR_UNIMOD = "UNIMOD:";
    protected static final Logger logger = LoggerFactory.getLogger(CVQuery.class);
    protected static final ParseUnimod parseUnimod = new ParseUnimod();

    public static String getUniqueOLSKey(String queryName, String ontology) {
        if (BaseCVHelper.isInitiallyReadOntology(ontology)) {
            return OBOInitialRead.getIDFromCVTerm(queryName, ontology);
        }
        return null;
    }

    public static String getOLSKey(String queryName) {
        String key = CVQuery.getUniqueOLSKey(queryName, "MS");
        if (key == null) {
            key = CVQuery.getUniqueOLSKey(queryName, "UNIMOD");
        }
        if (key == null) {
            key = CVQuery.getUniqueOLSKey(queryName, "UO");
        }
        return key;
    }

    public static String getOLSTerm(String queryName) {
        String term = CVQuery.getUniqueOLSTerm(queryName, "MS");
        if (term == null) {
            term = CVQuery.getUniqueOLSTerm(queryName, "UNIMOD");
        }
        if (term == null) {
            term = CVQuery.getUniqueOLSTerm(queryName, "UO");
        }
        return term;
    }

    public static String getBTOTerm(String queryName) {
        return CVQuery.getUniqueOLSTerm(queryName, "BTO");
    }

    public static String getMSTerm(String queryName) {
        return CVQuery.getUniqueOLSTerm(queryName, "MS");
    }

    public static String getUNIMODTerm(String queryName) {
        return parseUnimod.getUnimodItem().mapName2TermID(queryName);
    }

    public static String getUOTerm(String queryName) {
        return CVQuery.getUniqueOLSTerm(queryName, "UO");
    }

    public static String getUniqueOLSTerm(String queryKey, String ontology) {
        if (BaseCVHelper.isInitiallyReadOntology(ontology)) {
            return OBOInitialRead.getIDFromCVTerm(queryKey, ontology);
        }
        return null;
    }

    public static String getBrendaAccession(String term) {
        return CVQuery.getUniqueOLSKey(term, "BTO");
    }

    public static String getPSIMSAccession(String term) {
        return CVQuery.getUniqueOLSKey(term, "MS");
    }

    public static String getUniModAccession(String name) {
        return STR_UNIMOD + parseUnimod.getUnimodItem().mapName2TermID(name);
    }

    public static String getUnitAccession(String term) {
        return CVQuery.getUniqueOLSKey(term, "UO");
    }

    public static boolean hasCVTermAValue(String term, String ontology) {
        return OBOInitialRead.hasCVTermAValue(term, ontology);
    }

    public static boolean isValidTerm(String termStr, String ontologyID) {
        return !CVQuery.getUniqueOLSKey(termStr, ontologyID).isEmpty();
    }
}

