/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseCVHelper {
    public static final String ONT_BTO = "BTO";
    public static final String ONT_CHEBI = "CHEBI";
    public static final String ONT_CL = "CL";
    public static final String ONT_GO = "GO";
    public static final String ONT_NEWT = "NEWT";
    public static final String ONT_OBI = "OBI";
    public static final String ONT_PATO = "PATO";
    public static final String ONT_PSI_MOD = "MOD";
    public static final String ONT_PSI_MS = "MS";
    public static final String ONT_UNIMOD = "UNIMOD";
    public static final String ONT_UNIT = "UO";
    private static final String VERS_CHEBI = "119";
    private static final String VERS_GO = "17452";
    private static final String VERS_OBI = "80";
    private static final String VERS_PSI_MOD = "1.013.0";
    private static final String VERS_PSI_MS = "3.68.0";
    private static final String VERS_UNKNOWN = "";
    private static final String VERS_BTO = "09:04:2014 14:03";
    private static final String VERS_CL = "releases/2014-07-08";
    private static final String VERS_NEWT = "";
    private static final String VERS_PATO = "09:04:2014 12:42";
    private static final String VERS_UNIMOD = "2014:06:04 16:11";
    private static final String VERS_UNIT = "09:04:2014 13:37";
    protected static final Logger logger = LoggerFactory.getLogger(BaseCVHelper.class);
    private static final String[] ontIDs4InitialRead = new String[]{"UNIMOD", "MOD", "MS", "UO"};
    private static String versCHEBI = "119";
    private static final String versCL = "releases/2014-07-08";
    private static final String versGO = "17452";
    private static final String versOBI = "80";
    private static String versPSI_MOD = "1.013.0";
    private static String versPSI_MS = "3.68.0";
    private static final String versBTO = "09:04:2014 14:03";
    private static final String versNEWT = "";
    private static final String versPATO = "09:04:2014 12:42";
    private static final String versUNIMOD = "2014:06:04 16:11";
    private static final String versUNIT = "09:04:2014 13:37";

    public static String getOntologyURI(String ontID) {
        switch (ontID) {
            case "BTO": {
                return "http://www.brenda-enzymes.org/ontology/tissue/tree/update/update_files/BrendaTissueOBO";
            }
            case "CHEBI": {
                return "http://obo.cvs.sourceforge.net/obo/obo/ontology/chemical/chebi.obo";
            }
            case "CL": {
                return "http://cell-ontology.googlecode.com/svn/trunk/src/ontology/cl.obo";
            }
            case "GO": {
                return "http://obo.cvs.sourceforge.net/obo/obo/ontology/genomic-proteomic/gene_ontology.obo";
            }
            case "NEWT": {
                return "http://www.ebi.ac.uk/newt/display";
            }
            case "OBI": {
                return "http://obi.svn.sourceforge.net/svnroot/obi/releases/2010-10-26/merged/merged-obi-comments.owl";
            }
            case "PATO": {
                return "http://pato.googlecode.com/svn/trunk/quality.obo";
            }
            case "MOD": {
                return "http://psidev.cvs.sourceforge.net/psidev/psi/mod/data/PSI-MOD.obo";
            }
            case "MS": {
                return "http://psidev.cvs.sourceforge.net/viewvc/psidev/psi/psi-ms/mzML/controlledVocabulary/psi-ms.obo";
            }
            case "UNIMOD": {
                return "http://www.unimod.org/obo/unimod.obo";
            }
            case "UO": {
                return "http://unit-ontology.googlecode.com/svn/trunk/unit.obo";
            }
        }
        logger.error("CVHelper(getOntologyURI) - ontID: " + ontID + " nicht definiert.");
        return "";
    }

    public static String getOntologyFullName(String ontID) {
        switch (ontID) {
            case "BTO": {
                return "BRENDA tissue / enzyme source";
            }
            case "CHEBI": {
                return "Chemical Entities of Biological Interest";
            }
            case "CL": {
                return "Cell Type";
            }
            case "GO": {
                return "Gene Ontology";
            }
            case "NEWT": {
                return "NEWT UniProt Taxonomy Database";
            }
            case "OBI": {
                return "Ontology for Biomedical Investigations";
            }
            case "PATO": {
                return "Phenotypic qualities (properties)";
            }
            case "MOD": {
                return "Protein Modifications (PSI-MOD)";
            }
            case "MS": {
                return "Mass Spectrometry CV (PSI-MS)";
            }
            case "UNIMOD": {
                return "UNIMOD CV for modifications";
            }
            case "UO": {
                return "Unit Ontology";
            }
        }
        logger.error("CVHelper(getOntologyFullName) - ontID: " + ontID + " nicht definiert.");
        return "";
    }

    public static String getOntologyVersion(String ontID) {
        switch (ontID) {
            case "BTO": {
                return "09:04:2014 14:03";
            }
            case "CHEBI": {
                return versCHEBI;
            }
            case "CL": {
                return "releases/2014-07-08";
            }
            case "GO": {
                return "17452";
            }
            case "NEWT": {
                return "";
            }
            case "OBI": {
                return "80";
            }
            case "PATO": {
                return "09:04:2014 12:42";
            }
            case "MOD": {
                return versPSI_MOD;
            }
            case "MS": {
                return versPSI_MS;
            }
            case "UNIMOD": {
                return "2014:06:04 16:11";
            }
            case "UO": {
                return "09:04:2014 13:37";
            }
        }
        logger.error("CVHelper(getOntologyVersion) - ontID: " + ontID + " nicht definiert.");
        return "1.0";
    }

    public static void setVersion(String ontID, String version) {
        switch (ontID) {
            case "CHEBI": {
                versCHEBI = version;
                break;
            }
            case "MOD": {
                versPSI_MOD = version;
                break;
            }
            case "MS": {
                versPSI_MS = version;
                break;
            }
            default: {
                logger.error("CVHelper(setVersion) for ontID: " + ontID + " not yet implemented.");
            }
        }
    }

    public static String[] getOntologyIDsForInitialRead() {
        return ontIDs4InitialRead;
    }

    public static boolean isInitiallyReadOntology(String ontID) {
        for (String id : ontIDs4InitialRead) {
            if (!id.equals(ontID)) continue;
            return true;
        }
        return false;
    }
}

