/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib;

import de.mpc.BaseLib.SystemProps;
import de.mpc.BaseLib.constants.MyConstants;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveUnpacker {
    private static final int BUF_SIZE = 1024;
    private static final String STR_DOES_NOT_EXIST = " does not exist";
    private static final String STR_COULD_NOT_CREATE_DIR = "Could not create directory: ";
    private static final String STR_EXT_ZIP = ".zip";
    private static final String STR_PREFIX_ARC = "arc";
    private static final String STR_C_TMP = SystemProps.getTemporaryFilesPath();
    private static final String TAXONOMY_FILE_PATH_IN = STR_C_TMP + "names.dmp";
    private static final String TAXONOMY_FILE_PATH_OUT = STR_C_TMP + "taxonomy_ID_names.dmp";
    private static final String TAXONOMY_FILE_URL = "ftp://ftp.ncbi.nlm.nih.gov/pub/taxonomy/taxdmp.zip";
    private static final Logger logger = LoggerFactory.getLogger(ArchiveUnpacker.class);

    public static void readAndUnzipTaxIDFileFromInternet() {
        try {
            BufferedWriter buffWriter;
            URL url = new URL(TAXONOMY_FILE_URL);
            ArchiveUnpacker.unpackArchiveFromURL(url, "names.dmp");
            try (BufferedReader buffReader = new BufferedReader(new FileReader(TAXONOMY_FILE_PATH_IN));){
                String line;
                buffWriter = new BufferedWriter(new FileWriter(TAXONOMY_FILE_PATH_OUT));
                while ((line = buffReader.readLine()) != null) {
                    String[] splitter = line.split(MyConstants.STR_TAB);
                    buffWriter.write(splitter[0] + MyConstants.STR_TAB + splitter[2] + MyConstants.newline);
                }
            }
            buffWriter.close();
        }
        catch (MalformedURLException malfexc) {
            malfexc.printStackTrace(System.err);
            System.err.println("Please check the URL for the taxonomy ID file: ftp://ftp.ncbi.nlm.nih.gov/pub/taxonomy/taxdmp.zip");
        }
        catch (IOException ioexc) {
            ioexc.printStackTrace(System.err);
            System.err.println("Can't read taxonomy ID file from the Internet: ftp://ftp.ncbi.nlm.nih.gov/pub/taxonomy/taxdmp.zip");
        }
    }

    private static File unpackArchiveFromURL(URL url, File targetDir, String targetFileName) {
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        try {
            BufferedInputStream in = new BufferedInputStream(url.openStream(), 1024);
            File zipFile = File.createTempFile(STR_PREFIX_ARC, STR_EXT_ZIP, targetDir);
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(zipFile));){
                ArchiveUnpacker.copyInputStream(in, out);
            }
            File retFile = ArchiveUnpacker.unpackArchiveFromFile(zipFile, targetDir, targetFileName);
            zipFile.delete();
            return retFile;
        }
        catch (IOException ioex) {
            ioex.printStackTrace(System.err);
            return null;
        }
    }

    private static File unpackArchiveFromURL(URL url) {
        return ArchiveUnpacker.unpackArchiveFromURL(url, new File(STR_C_TMP), "");
    }

    private static File unpackArchiveFromURL(URL url, String targetFileName) {
        return ArchiveUnpacker.unpackArchiveFromURL(url, new File(STR_C_TMP), targetFileName);
    }

    private static File unpackArchiveFromFile(File fileToUnpack, File targetDir, String targetFileName) {
        if (!fileToUnpack.exists()) {
            logger.error(fileToUnpack.getAbsolutePath() + STR_DOES_NOT_EXIST);
        }
        if (!ArchiveUnpacker.buildTmpDirectory(targetDir)) {
            logger.error(STR_COULD_NOT_CREATE_DIR + targetDir);
        }
        try (ZipFile zipFile = new ZipFile(fileToUnpack);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (targetFileName.isEmpty() || !targetFileName.equals(entry.getName())) continue;
                File tmpFile = new File(targetDir, File.separator + entry.getName());
                if (!ArchiveUnpacker.buildTmpDirectory(tmpFile.getParentFile())) {
                    logger.error(STR_COULD_NOT_CREATE_DIR + tmpFile.getParentFile());
                }
                if (!entry.isDirectory()) {
                    ArchiveUnpacker.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(tmpFile)));
                    continue;
                }
                if (ArchiveUnpacker.buildTmpDirectory(tmpFile)) continue;
                logger.error(STR_COULD_NOT_CREATE_DIR + tmpFile);
            }
        }
        catch (IOException ioex) {
            ioex.printStackTrace(System.err);
        }
        return fileToUnpack;
    }

    private static File unpackArchiveFromFile(File file) {
        return ArchiveUnpacker.unpackArchiveFromFile(file, new File(STR_C_TMP), "");
    }

    private static void copyInputStream(InputStream in, OutputStream out) {
        byte[] buffer = new byte[1024];
        try {
            int len = in.read(buffer);
            while (len >= 0) {
                out.write(buffer, 0, len);
                len = in.read(buffer);
            }
            in.close();
            out.close();
        }
        catch (IOException ioex) {
            ioex.printStackTrace(System.err);
        }
    }

    private static boolean buildTmpDirectory(File file) {
        return file.exists() || file.mkdirs();
    }
}

