/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib;

import java.util.HashMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AACodes {
    private static final double AVG_MASS_H = 1.008;
    private static final double AVG_MASS_O = 15.994;
    private static final double AVG_MASS_H2O = 18.009999999999998;
    private static final double MASS_PROTON = 1.007276;
    private static final double MI_MASS_H = 1.007825;
    private static final double MI_MASS_O = 15.994915;
    private static final double MI_MASS_H2O = 18.010565;
    private static final Logger logger = LoggerFactory.getLogger(AACodes.class);
    private static HashMap<String, String> map1to3;
    private static HashMap<String, String> map3to1;
    private static HashMap<String, String> map1toMonoisotopicMass;
    private static HashMap<String, String> map1toAverageMass;

    public AACodes() {
        this.initMaps();
    }

    private void initMaps() {
    }

    public static TreeSet<String> getAllOneLetterCodes() {
        TreeSet<String> aaSet = new TreeSet<String>();
        aaSet.add("A");
        aaSet.add("R");
        aaSet.add("N");
        aaSet.add("D");
        aaSet.add("C");
        aaSet.add("Q");
        aaSet.add("E");
        aaSet.add("G");
        aaSet.add("H");
        aaSet.add("J");
        aaSet.add("L");
        aaSet.add("I");
        aaSet.add("K");
        aaSet.add("M");
        aaSet.add("F");
        aaSet.add("P");
        aaSet.add("O");
        aaSet.add("U");
        aaSet.add("S");
        aaSet.add("T");
        aaSet.add("W");
        aaSet.add("Y");
        aaSet.add("V");
        aaSet.add("B");
        aaSet.add("Z");
        return aaSet;
    }

    public static String getOneLetterCode(String threeLetterCode) {
        switch (threeLetterCode) {
            case "Ala": {
                return "A";
            }
            case "Arg": {
                return "R";
            }
            case "Asn": {
                return "N";
            }
            case "Asp": {
                return "D";
            }
            case "Cys": {
                return "C";
            }
            case "Gln": {
                return "Q";
            }
            case "Glu": {
                return "E";
            }
            case "Gly": {
                return "G";
            }
            case "His": {
                return "H";
            }
            case "Xle": {
                return "J";
            }
            case "Leu": {
                return "L";
            }
            case "Ile": {
                return "I";
            }
            case "Lys": {
                return "K";
            }
            case "Met": {
                return "M";
            }
            case "Phe": {
                return "F";
            }
            case "Pro": {
                return "P";
            }
            case "Pyl": {
                return "O";
            }
            case "Sec": {
                return "U";
            }
            case "Ser": {
                return "S";
            }
            case "Thr": {
                return "T";
            }
            case "Trp": {
                return "W";
            }
            case "Tyr": {
                return "Y";
            }
            case "Val": {
                return "V";
            }
            case "Asx": {
                return "B";
            }
            case "Glx": {
                return "Z";
            }
            case "Xaa": {
                return "X";
            }
        }
        return "";
    }

    public static String getThreeLetterCode(String oneLetterCode) {
        String tmpStr;
        switch (tmpStr = oneLetterCode.toUpperCase()) {
            case "A": {
                return "Ala";
            }
            case "R": {
                return "Arg";
            }
            case "N": {
                return "Asn";
            }
            case "D": {
                return "Asp";
            }
            case "C": {
                return "Cys";
            }
            case "Q": {
                return "Gln";
            }
            case "E": {
                return "Glu";
            }
            case "G": {
                return "Gly";
            }
            case "H": {
                return "His";
            }
            case "J": {
                return "Xle";
            }
            case "L": {
                return "Leu";
            }
            case "I": {
                return "Ile";
            }
            case "K": {
                return "Lys";
            }
            case "M": {
                return "Met";
            }
            case "F": {
                return "Phe";
            }
            case "P": {
                return "Pro";
            }
            case "O": {
                return "Pyl";
            }
            case "U": {
                return "Sec";
            }
            case "S": {
                return "Ser";
            }
            case "T": {
                return "Thr";
            }
            case "W": {
                return "Trp";
            }
            case "Y": {
                return "Tyr";
            }
            case "V": {
                return "Val";
            }
            case "B": {
                return "Asx";
            }
            case "Z": {
                return "Glx";
            }
            case "X": {
                return "Xaa";
            }
        }
        logger.error("getThreeLetterCode() - Unknown oneLetterCode: " + oneLetterCode);
        return "";
    }

    public static double getMonoisotopicMass(char oneLetterCode) {
        return AACodes.getMonoisotopicMass(String.valueOf(oneLetterCode));
    }

    public static double getMonoisotopicMass(String oneLetterCode) {
        String tmpStr;
        switch (tmpStr = oneLetterCode.toUpperCase()) {
            case "A": {
                return 71.03712;
            }
            case "R": {
                return 156.10112;
            }
            case "N": {
                return 114.04293;
            }
            case "D": {
                return 115.02695;
            }
            case "C": {
                return 103.00919;
            }
            case "Q": {
                return 128.05858;
            }
            case "E": {
                return 129.0426;
            }
            case "G": {
                return 57.02147;
            }
            case "H": {
                return 137.05891;
            }
            case "J": {
                return 113.08407;
            }
            case "L": {
                return 113.08407;
            }
            case "I": {
                return 113.08407;
            }
            case "K": {
                return 128.09497;
            }
            case "M": {
                return 131.0405;
            }
            case "F": {
                return 147.06842;
            }
            case "P": {
                return 97.05277;
            }
            case "O": {
                return 237.14772;
            }
            case "U": {
                return 150.9531;
            }
            case "S": {
                return 87.03203;
            }
            case "T": {
                return 101.04768;
            }
            case "W": {
                return 186.07932;
            }
            case "Y": {
                return 163.06332;
            }
            case "V": {
                return 99.06842;
            }
            case "B": {
                return 114.53494;
            }
            case "Z": {
                return 128.55058;
            }
        }
        logger.error("getMonoisotopicMass() - Unknown oneLetterCode: " + oneLetterCode);
        return 0.0;
    }

    public static double getAverageMass(char oneLetterCode) {
        return AACodes.getAverageMass(String.valueOf(oneLetterCode));
    }

    public static double getAverageMass(String oneLetterCode) {
        String tmpStr;
        switch (tmpStr = oneLetterCode.toUpperCase()) {
            case "A": {
                return 71.0787;
            }
            case "R": {
                return 156.188;
            }
            case "N": {
                return 114.1039;
            }
            case "D": {
                return 115.0885;
            }
            case "C": {
                return 103.145;
            }
            case "Q": {
                return 128.13091;
            }
            case "E": {
                return 129.1156;
            }
            case "G": {
                return 57.0517;
            }
            case "H": {
                return 137.1414;
            }
            case "J": {
                return 113.1598;
            }
            case "L": {
                return 113.1598;
            }
            case "I": {
                return 113.1598;
            }
            case "K": {
                return 128.1745;
            }
            case "M": {
                return 131.1994;
            }
            case "F": {
                return 147.1772;
            }
            case "P": {
                return 97.1168;
            }
            case "O": {
                return 237.29874;
            }
            case "U": {
                return 150.0369;
            }
            case "S": {
                return 87.078;
            }
            case "T": {
                return 101.1051;
            }
            case "W": {
                return 186.2141;
            }
            case "Y": {
                return 163.17661;
            }
            case "V": {
                return 99.1328;
            }
            case "B": {
                return 114.5962;
            }
            case "Z": {
                return 128.62326;
            }
        }
        logger.error("getAverageMass() - Unknown oneLetterCode: " + oneLetterCode);
        return 0.0;
    }

    public static double calculateMZRatioFromSequence(String sequence, int charge, ScanPolarity scanPolarity, boolean bUseAverageMasses) {
        double massSum = 0.0;
        for (int i = 0; i < sequence.length(); ++i) {
            if (bUseAverageMasses) {
                massSum += AACodes.getAverageMass(sequence.substring(i, i + 1));
                continue;
            }
            massSum += AACodes.getMonoisotopicMass(sequence.substring(i, i + 1));
        }
        massSum = bUseAverageMasses ? (massSum += 18.009999999999998) : (massSum += 36.02113);
        massSum = scanPolarity == ScanPolarity.PositiveMode ? (massSum += 1.007276) : (massSum -= 1.007276);
        return massSum /= (double)charge;
    }

    public static enum ScanPolarity {
        PositiveMode,
        NegativeMode;

    }
}

