/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.protXML.PD;

import de.mpc.BaseLib.constants.MyConstants;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PD_SearchSummary
implements Serializable {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    protected String namespace;
    protected HashMap<String, String> paramsMap = null;
    protected HashMap<String, String> PDNodePrefixMap = null;
    private final ArrayList<String> fullFileNamesList = new ArrayList();

    public PD_SearchSummary() {
        this.paramsMap = new HashMap();
        this.PDNodePrefixMap = new HashMap();
        this.initPDNodePrefixMap();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void addToFullFileNamesList(String fileName) {
        this.fullFileNamesList.add(fileName);
    }

    public ArrayList<String> getFullFileNamesList() {
        return this.fullFileNamesList;
    }

    private void initPDNodePrefixMap() {
        this.PDNodePrefixMap.put("Mascot", "Mascot:");
        this.PDNodePrefixMap.put("Noise Peak Filter", "Noise Peak Filter:");
        this.PDNodePrefixMap.put("Non-Fragment Filter", "Non-Fragment Filter:");
        this.PDNodePrefixMap.put("Peptide Validator", "Peptide Validator:");
        this.PDNodePrefixMap.put("Percolator", "Percolator:");
        this.PDNodePrefixMap.put("Reporter Ions Quantitizer", "Reporter Ions Quantitizer:");
        this.PDNodePrefixMap.put("Scan Event Filter", "Scan Event Filter:");
        this.PDNodePrefixMap.put("SEQUEST", "SEQUEST:");
        this.PDNodePrefixMap.put("Spectrum Exporter", "Spectrum Exporter:");
        this.PDNodePrefixMap.put("Spectrum Files", "Spectrum Files:");
        this.PDNodePrefixMap.put("Spectrum Grouper", "Spectrum Grouper:");
        this.PDNodePrefixMap.put("Spectrum Properties Filter", "Spectrum Properties Filter:");
        this.PDNodePrefixMap.put("Spectrum Score Filter", "Spectrum Score Filter:");
        this.PDNodePrefixMap.put("Spectrum Selector", "Spectrum Selector:");
        this.PDNodePrefixMap.put("SRF File Selector", "SRF File Selector:");
        this.PDNodePrefixMap.put("Xtract", "Xtract:");
        this.PDNodePrefixMap.put("ZCore", "ZCore:");
    }

    public HashMap<String, String> getParamsMap() {
        return this.paramsMap;
    }

    public void addToParamsMap(String key, String value) {
        if (this.paramsMap.containsKey(key)) {
            this.logger.error("ERROR: " + key + " already contained in paramsMap.");
        } else {
            this.paramsMap.put(key, value);
        }
    }

    public void clearParamsMap() {
        if (this.paramsMap != null) {
            this.paramsMap.clear();
        }
    }

    public HashMap<String, String> getPDNodePrefixMap() {
        return this.PDNodePrefixMap;
    }

    public void addToPDNodePrefixMap(String key, String value) {
        if (this.PDNodePrefixMap.containsKey(key)) {
            this.logger.error("ERROR: " + key + " already contained in PDNodePrefixMap.");
        } else {
            this.PDNodePrefixMap.put(key, value);
        }
    }

    public void clearPDNodePrefixMap() {
        if (this.PDNodePrefixMap != null) {
            this.PDNodePrefixMap.clear();
        }
    }

    public boolean isProteomeDiscovererNodeString(String nodeStrToTest) {
        if (this.PDNodePrefixMap.containsKey(nodeStrToTest)) {
            return true;
        }
        this.logger.error("ERROR: " + nodeStrToTest + " is not a valid Proteome Discoverer node.");
        return false;
    }

    public boolean isInvalidPDKey(String keyStr) {
        if (keyStr.isEmpty() || keyStr.startsWith(MyConstants.STR_HYPHEN)) {
            return true;
        }
        Pattern pattern = Pattern.compile("^[0-9]+[.]{1}[0-9]*[ ]{1}");
        Matcher matcher = pattern.matcher(keyStr);
        if (matcher.find()) {
            return !keyStr.endsWith(". Static Modification") && !keyStr.endsWith(". Dynamic Modification");
        }
        return false;
    }

    public String getPDNodePrefixString(String keyStr) {
        if (this.PDNodePrefixMap.containsKey(keyStr)) {
            return this.PDNodePrefixMap.get(keyStr);
        }
        this.logger.error("Is not a valid PDNodePrefixStr: " + keyStr);
        return "";
    }
}

