/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD.XML;

import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.Params.PDProgramParameters;
import de.mpc.PD.XML.AZippedData;
import de.mpc.PD.XML.SpectrumPeak;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class XMLSpectra
extends AZippedData {
    private final String STR_START_PEAK = "<Peak ";

    public XMLSpectra(PDProgramParameters pp) {
        super(pp);
    }

    public ArrayList<SpectrumPeak> getMSPeaks(int uniqueSpectrumID) {
        String xmlStr = this.unzipSpectraXML(uniqueSpectrumID);
        String xmlSubStr = xmlStr.substring(xmlStr.indexOf("<Peak ", xmlStr.indexOf("<IsotopeClusterPeakCentroids")), xmlStr.lastIndexOf("</IsotopeClusterPeakCentroids"));
        String[] splitter = xmlSubStr.split(MyConstants.newline);
        ArrayList<SpectrumPeak> peakList = new ArrayList<SpectrumPeak>();
        String[] stringArray = splitter;
        int n = splitter.length;
        int n2 = 0;
        while (n2 < n) {
            String split = stringArray[n2];
            if (split.trim().startsWith("<Peak ")) {
                peakList.add(new SpectrumPeak(split));
            }
            ++n2;
        }
        return peakList;
    }

    public ArrayList<SpectrumPeak> getMSMSPeaks(int uniqueSpectrumID) {
        String[] splitter;
        ArrayList<SpectrumPeak> peakList = new ArrayList<SpectrumPeak>();
        String xmlStr = this.unzipSpectraXML(uniqueSpectrumID);
        String xmlSubStr = xmlStr.substring(xmlStr.indexOf("<Peak ", xmlStr.indexOf("<PeakCentroids")), xmlStr.lastIndexOf("</PeakCentroids"));
        String[] stringArray = splitter = xmlSubStr.split(MyConstants.newline);
        int n = splitter.length;
        int n2 = 0;
        while (n2 < n) {
            String split = stringArray[n2];
            if (split.trim().startsWith("<Peak ")) {
                peakList.add(new SpectrumPeak(split));
            }
            ++n2;
        }
        return peakList;
    }

    public SpectrumPeak getFragmentedMSPeak(int uniqueSpectrumID) {
        String xmlStr = this.unzipSpectraXML(uniqueSpectrumID);
        String xmlSubStr = xmlStr.substring(xmlStr.indexOf("<MonoisotopicPeakCentroids"), xmlStr.lastIndexOf("</MonoisotopicPeakCentroids"));
        String[] splitter = xmlSubStr.split(MyConstants.newline);
        SpectrumPeak peak = null;
        String[] stringArray = splitter;
        int n = splitter.length;
        int n2 = 0;
        while (n2 < n) {
            String split = stringArray[n2];
            if (split.trim().startsWith("<Peak ")) {
                peak = new SpectrumPeak(split);
            }
            ++n2;
        }
        return peak;
    }

    public String unzipSpectraXML(int uniqueSpectrumID) {
        return this.unzipZippedData(this.retrieveZippedSpectrumXML(uniqueSpectrumID));
    }

    private byte[] retrieveZippedSpectrumXML(int uniqueSpectrumID) {
        StringBuilder strB = new StringBuilder();
        strB.append("SELECT Spectrum FROM Spectra").append(MyConstants.newline);
        strB.append("WHERE UniqueSpectrumID = ").append(uniqueSpectrumID);
        String sqlStr = strB.toString();
        if (this.pp.isUsingSQLite4Java()) {
            try {
                SQLiteStatement sqlSt = this.pp.getSQLiteAccess().dbConn.prepare(sqlStr);
                try {
                    this.zippedData = (byte[])sqlSt.columnValue(0);
                }
                finally {
                    sqlSt.dispose();
                }
            }
            catch (SQLiteException sqliteex) {
                this.pp.getSQLiteAccess().handleSQLite4JavaError(sqliteex);
                sqliteex.printStackTrace(System.err);
            }
        } else if (this.pp.isUsingJDBC()) {
            try {
                Statement st = this.pp.getJDBCAccess().dbConn.createStatement();
                ResultSet rSet = st.executeQuery(sqlStr);
                try {
                    this.zippedData = rSet.getBytes(1);
                }
                finally {
                    st.close();
                }
            }
            catch (SQLException sex) {
                this.pp.getJDBCAccess().handleJDBCError(sex);
                sex.printStackTrace(System.err);
            }
        }
        return this.zippedData;
    }
}

