/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD.XML;

import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.Params.PDProgramParameters;
import de.mpc.PD.XML.AZippedData;
import de.mpc.PD.XML.ChromatogramPeak;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class XMLChromatogram
extends AZippedData {
    private final String STR_STR_PT = "<Pt ";

    public XMLChromatogram(PDProgramParameters pp) {
        super(pp);
    }

    public ArrayList<ChromatogramPeak> getChromatogramPeaks(int fileID, int traceType) {
        String[] splitter;
        ArrayList<ChromatogramPeak> peakList = new ArrayList<ChromatogramPeak>();
        String chromatogramXML = this.unzipChromatogramXML(fileID, traceType);
        String[] stringArray = splitter = chromatogramXML.split(MyConstants.newline);
        int n = splitter.length;
        int n2 = 0;
        while (n2 < n) {
            String split = stringArray[n2];
            if (split.trim().startsWith("<Pt ")) {
                peakList.add(new ChromatogramPeak(split));
            }
            ++n2;
        }
        return peakList;
    }

    public String unzipChromatogramXML(int fileID, int traceType) {
        return this.unzipZippedData(this.retrieveZippedChromatogramXML(fileID, traceType));
    }

    private byte[] retrieveZippedChromatogramXML(int fileID, int traceType) {
        StringBuilder strB = new StringBuilder();
        strB.append("SELECT Chromatogram FROM Chromatograms").append(MyConstants.newline);
        strB.append("WHERE FileID = ").append(fileID).append(MyConstants.newline);
        strB.append("AND TraceType = ").append(traceType);
        String sqlStr = strB.toString();
        if (this.pp.isUsingSQLite4Java()) {
            try {
                SQLiteStatement sqlSt = this.pp.getSQLiteAccess().dbConn.prepare(sqlStr);
                try {
                    this.zippedData = (byte[])sqlSt.columnValue(0);
                }
                finally {
                    sqlSt.dispose();
                }
            }
            catch (SQLiteException sqliteex) {
                this.pp.getSQLiteAccess().handleSQLite4JavaError(sqliteex);
                sqliteex.printStackTrace(System.err);
            }
        } else if (this.pp.isUsingJDBC()) {
            try {
                Statement st = this.pp.getJDBCAccess().dbConn.createStatement();
                ResultSet rSet = st.executeQuery(sqlStr);
                try {
                    this.zippedData = rSet.getBytes(1);
                }
                finally {
                    st.close();
                }
            }
            catch (SQLException sex) {
                this.pp.getJDBCAccess().handleJDBCError(sex);
                sex.printStackTrace(System.err);
            }
        }
        return this.zippedData;
    }
}

