/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD.XML;

import de.mpc.BaseLib.constants.MyConstants;

public class SpectrumPeak {
    private final int DREI = 3;
    private float mass;
    private float intensity;
    private float charge;
    private float resolution;
    private float signalToNoise;

    public SpectrumPeak(float mass, float intensity, float charge, float resolution, float signalToNoise) {
        this.mass = mass;
        this.intensity = intensity;
        this.charge = charge;
        this.resolution = resolution;
        this.signalToNoise = signalToNoise;
    }

    public SpectrumPeak(String xmlLine) {
        String[] splitter;
        String[] stringArray = splitter = xmlLine.trim().split(MyConstants.STR_BLANK);
        int n = splitter.length;
        int n2 = 0;
        while (n2 < n) {
            String split = stringArray[n2];
            if (split.startsWith("X=\"")) {
                this.mass = Float.valueOf(split.substring(3, split.lastIndexOf(MyConstants.STR_ANF_ZEICHEN))).floatValue();
            } else if (split.startsWith("Y=\"")) {
                this.intensity = Float.valueOf(split.substring(3, split.lastIndexOf(MyConstants.STR_ANF_ZEICHEN))).floatValue();
            } else if (split.startsWith("Z=\"")) {
                this.charge = Float.valueOf(split.substring(3, split.lastIndexOf(MyConstants.STR_ANF_ZEICHEN))).floatValue();
            } else if (split.startsWith("R=\"")) {
                this.resolution = Float.valueOf(split.substring(3, split.lastIndexOf(MyConstants.STR_ANF_ZEICHEN))).floatValue();
            } else if (split.startsWith("SN=\"")) {
                this.signalToNoise = Float.valueOf(split.substring(4, split.lastIndexOf(MyConstants.STR_ANF_ZEICHEN))).floatValue();
            }
            ++n2;
        }
    }

    public float getMass() {
        return this.mass;
    }

    public float getIntensity() {
        return this.intensity;
    }

    public float getCharge() {
        return this.charge;
    }

    public float getResolution() {
        return this.resolution;
    }

    public float getSNRatio() {
        return this.signalToNoise;
    }
}

