/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD.XML;

import de.mpc.BaseLib.XML.BaseSaxParser;
import de.mpc.BaseLib.XML.XMLHandlerBase;
import de.mpc.PD.Spectrum.ActivationEnergiesType;
import de.mpc.PD.Spectrum.HeaderType;
import de.mpc.PD.Spectrum.IsotopeClusterProfilePointsType;
import de.mpc.PD.Spectrum.MassSpectrumType;
import de.mpc.PD.Spectrum.PeakCentroidsType;
import de.mpc.PD.Spectrum.PeakType;
import de.mpc.PD.Spectrum.PrecursorInfoType;
import de.mpc.PD.Spectrum.ProfilePointsType;
import de.mpc.PD.Spectrum.ScanEventType;
import de.mpc.PD.Spectrum.SpectrumIdentifierType;
import de.mpc.PD.Spectrum.SpectrumIdentifiersType;
import de.mpc.PD.XML.SpectrumSaxParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SpectrumHandler
extends XMLHandlerBase {
    private final Logger logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
    private boolean bMassSpectrum = false;
    private boolean bHeader = false;
    private boolean bScanEvent = false;
    private boolean bPrecursorInfo = false;
    private boolean bPeakCentroids = false;
    private boolean bMonoisotopicPeakCentroids = false;
    private boolean bMeasuredMonoisotopicPeakCentroids = false;
    private boolean bIsotopeClusterPeakCentroids = false;
    private boolean bProfilePoints = false;
    private boolean bIsotopeClusterProfilePoints = false;
    private boolean bPeak = false;
    private boolean bSpectrumIdentifiers = false;
    private boolean bSpectrumIdentifier = false;
    private boolean bActivationEnergies = false;
    private boolean bSpectrumHeader = false;
    private boolean bSpectrumID = false;
    private boolean bInstrumentName = false;
    private boolean bDataType = false;
    private boolean bLowPosition = false;
    private boolean bHighPosition = false;
    private boolean bBasePeakPosition = false;
    private boolean bBasePeakIntensity = false;
    private boolean bTotalIntensity = false;
    private boolean bActivationTypes = false;
    private boolean bIonizationSource = false;
    private boolean bIsMultiplexed = false;
    private boolean bIsolationMass = false;
    private boolean bIsolationWidth = false;
    private boolean bMassAnalyzer = false;
    private boolean bMSOrder = false;
    private boolean bPolarity = false;
    private boolean bScanRate = false;
    private boolean bScanType = false;
    public MassSpectrumType massSpectrum = null;
    private HeaderType header = null;
    private ScanEventType scanEvent = null;
    private PrecursorInfoType precursorInfo = null;
    private PeakCentroidsType peakCentroids = null;
    private PeakCentroidsType monoIsotopicPeakCentroids = null;
    private PeakCentroidsType measuredMonoIsotopicPeakCentroids = null;
    private PeakCentroidsType isotopeClusterPeakCentroids = null;
    private ProfilePointsType profilePoints = null;
    private IsotopeClusterProfilePointsType isotopeClusterProfilePoints = null;
    private PeakType peak = null;
    private SpectrumIdentifiersType spectrumIdentifiers = null;
    private SpectrumIdentifierType spectrumIdentifier = null;
    private ActivationEnergiesType activationEnergies = null;
    private Double doubleVal = null;
    private HeaderType spectrumHeader = null;

    public SpectrumHandler(SpectrumSaxParser parser) {
        super((BaseSaxParser)parser);
    }

    public void startDocument() throws SAXException {
        this.printTraceStr("startDocument (Spectrum)");
    }

    public void endDocument() throws SAXException {
        this.printTraceStr("endDocument (Spectrum)");
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("MassSpectrum")) {
            if (this.massSpectrum == null) {
                this.massSpectrum = new MassSpectrumType();
            }
            if (atts != null) {
                this.setMassSpectrumAttributes(atts);
            }
            this.bMassSpectrum = true;
        } else if (qName.equals("Header")) {
            if (this.header == null) {
                this.header = new HeaderType();
            }
            this.bHeader = true;
        } else if (qName.equals("SpectrumHeader")) {
            this.spectrumHeader = new HeaderType();
            this.bSpectrumHeader = true;
        } else if (qName.equals("ScanEvent")) {
            if (this.scanEvent == null) {
                this.scanEvent = new ScanEventType();
            }
            this.bScanEvent = true;
        } else if (qName.equals("PrecursorInfo")) {
            if (this.precursorInfo == null) {
                this.precursorInfo = new PrecursorInfoType();
            }
            if (atts != null) {
                this.setPrecursorInfoAttributes(atts);
            }
            this.bPrecursorInfo = true;
        } else if (qName.equals("Peak")) {
            if (this.peak == null) {
                this.peak = new PeakType();
            }
            if (atts != null) {
                this.setPeakAttributes(atts, this.peak);
            }
            this.bPeak = true;
        } else if (qName.equals("PeakCentroids")) {
            if (this.peakCentroids == null) {
                this.peakCentroids = new PeakCentroidsType();
            }
            this.bPeakCentroids = true;
        } else if (qName.equals("ProfilePoints")) {
            if (this.profilePoints == null) {
                this.profilePoints = new ProfilePointsType();
            }
            this.bProfilePoints = true;
        } else if (qName.equals("SpectrumIdentifiers")) {
            if (this.spectrumIdentifiers == null) {
                this.spectrumIdentifiers = new SpectrumIdentifiersType();
            }
            this.bSpectrumIdentifiers = true;
        } else if (qName.equals("SpectrumIdentifier")) {
            if (this.spectrumIdentifier == null) {
                this.spectrumIdentifier = new SpectrumIdentifierType();
            }
            if (atts != null) {
                this.setSpectrumIdentifierAttributes(atts);
            }
            this.bSpectrumIdentifier = true;
        } else if (qName.equals("ActivationEnergies")) {
            if (this.activationEnergies == null) {
                this.activationEnergies = new ActivationEnergiesType();
            }
            this.bActivationEnergies = true;
        } else if (qName.equals("double")) {
            this.doubleVal = 0.0;
        } else if (qName.equals("MonoisotopicPeakCentroids")) {
            if (this.monoIsotopicPeakCentroids == null) {
                this.monoIsotopicPeakCentroids = new PeakCentroidsType();
            }
            this.bMonoisotopicPeakCentroids = true;
        } else if (qName.equals("MeasuredMonoisotopicPeakCentroids")) {
            if (this.measuredMonoIsotopicPeakCentroids == null) {
                this.measuredMonoIsotopicPeakCentroids = new PeakCentroidsType();
            }
            this.bMeasuredMonoisotopicPeakCentroids = true;
        } else if (qName.equals("IsotopeClusterPeakCentroids")) {
            if (this.isotopeClusterPeakCentroids == null) {
                this.isotopeClusterPeakCentroids = new PeakCentroidsType();
            }
            this.bIsotopeClusterPeakCentroids = true;
        } else if (qName.equals("IsotopeClusterProfilePoints")) {
            if (this.isotopeClusterProfilePoints == null) {
                this.isotopeClusterProfilePoints = new IsotopeClusterProfilePointsType();
            }
            this.bIsotopeClusterProfilePoints = true;
        } else if (!this.setHeaderRespSpectrumHeaderFields(qName, true) && !this.setScanEventFields(qName, true)) {
            this.logger.error("************ UNHANDLED START ELEMENT    : " + qName);
        }
        this.lastActivated = qName;
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (qName.equals("MassSpectrum")) {
            this.checkForEmptyLists();
            ((SpectrumSaxParser)this.parser).setMassSpectrum(this.massSpectrum);
            this.bMassSpectrum = false;
        } else if (qName.equals("Header")) {
            this.massSpectrum.setHeader(this.header);
            this.header = null;
            this.bHeader = false;
        } else if (qName.equals("SpectrumHeader")) {
            this.precursorInfo.setSpectrumHeader(this.spectrumHeader);
            this.spectrumHeader = null;
            this.bSpectrumHeader = false;
        } else if (qName.equals("ScanEvent")) {
            if (this.bHeader) {
                if (this.bPrecursorInfo) {
                    this.precursorInfo.setScanEvent(this.scanEvent);
                } else {
                    this.massSpectrum.setScanEvent(this.scanEvent);
                }
            }
            this.scanEvent = null;
            this.bScanEvent = false;
        } else if (qName.equals("PrecursorInfo")) {
            this.massSpectrum.setPrecursorInfo(this.precursorInfo);
            this.precursorInfo = null;
            this.bPrecursorInfo = false;
        } else if (qName.equals("Peak")) {
            if (this.bPeakCentroids) {
                this.peakCentroids.getPeak().add(this.peak);
            } else if (this.bMonoisotopicPeakCentroids) {
                this.monoIsotopicPeakCentroids.getPeak().add(this.peak);
            } else if (this.bMeasuredMonoisotopicPeakCentroids) {
                this.measuredMonoIsotopicPeakCentroids.getPeak().add(this.peak);
            } else if (this.bIsotopeClusterPeakCentroids) {
                this.isotopeClusterPeakCentroids.getPeak().add(this.peak);
            }
            this.peak = null;
            this.bPeak = false;
        } else if (qName.equals("PeakCentroids")) {
            this.addPeakListToPeakCentroids();
            this.massSpectrum.setPeakCentroids(this.peakCentroids);
            this.peakCentroids = null;
            this.bPeakCentroids = false;
        } else if (qName.equals("ProfilePoints")) {
            this.massSpectrum.setProfilePoints(this.profilePoints);
            this.profilePoints = null;
            this.bProfilePoints = false;
        } else if (qName.equals("SpectrumIdentifiers")) {
            if (this.bHeader) {
                this.header.setSpectrumIdentifiers(this.spectrumIdentifiers);
            } else if (this.bSpectrumHeader) {
                this.spectrumHeader.setSpectrumIdentifiers(this.spectrumIdentifiers);
            }
            this.spectrumIdentifiers = null;
            this.bSpectrumIdentifiers = false;
        } else if (qName.equals("SpectrumIdentifier")) {
            this.spectrumIdentifiers.setSpectrumIdentifier(this.spectrumIdentifier);
            this.spectrumIdentifier = null;
            this.bSpectrumIdentifier = false;
        } else if (qName.equals("ActivationEnergies")) {
            this.scanEvent.setActivationEnergies(this.activationEnergies);
            this.activationEnergies = null;
            this.bActivationEnergies = false;
        } else if (qName.equals("double")) {
            this.activationEnergies.setDouble(this.doubleVal);
            this.doubleVal = null;
        } else if (qName.equals("MonoisotopicPeakCentroids")) {
            this.addPeakListToMonoisotopicPeakCentroids();
            this.precursorInfo.setMonoisotopicPeakCentroids(this.monoIsotopicPeakCentroids);
            this.monoIsotopicPeakCentroids = null;
            this.bMonoisotopicPeakCentroids = false;
        } else if (qName.equals("MeasuredMonoisotopicPeakCentroids")) {
            this.addPeakListToMeasuredMonoisotopicPeakCentroids();
            this.precursorInfo.setMeasuredMonoisotopicPeakCentroids(this.measuredMonoIsotopicPeakCentroids);
            this.measuredMonoIsotopicPeakCentroids = null;
            this.bMeasuredMonoisotopicPeakCentroids = false;
        } else if (qName.equals("IsotopeClusterPeakCentroids")) {
            this.addPeakListToIsotopeClusterPeakCentroids();
            this.precursorInfo.setIsotopeClusterPeakCentroids(this.isotopeClusterPeakCentroids);
            this.isotopeClusterPeakCentroids = null;
            this.bIsotopeClusterPeakCentroids = false;
        } else if (qName.equals("IsotopeClusterProfilePoints")) {
            this.precursorInfo.setIsotopeClusterProfilePoints(this.isotopeClusterProfilePoints);
            this.isotopeClusterProfilePoints = null;
            this.bIsotopeClusterProfilePoints = false;
        } else if (!this.setHeaderRespSpectrumHeaderFields(qName, false) && !this.setScanEventFields(qName, false)) {
            this.logger.error("************ UNHANDLED END ELEMENT    : " + qName);
        }
        this.lastActivated = "";
    }

    private boolean setHeaderRespSpectrumHeaderFields(String qName, boolean bFlag) {
        switch (qName) {
            case "SpectrumID": {
                this.bSpectrumID = bFlag;
                break;
            }
            case "InstrumentName": {
                this.bInstrumentName = bFlag;
                break;
            }
            case "DataType": {
                this.bDataType = bFlag;
                break;
            }
            case "LowPosition": {
                this.bLowPosition = bFlag;
                break;
            }
            case "HighPosition": {
                this.bHighPosition = bFlag;
                break;
            }
            case "BasePeakPosition": {
                this.bBasePeakPosition = bFlag;
                break;
            }
            case "BasePeakIntensity": {
                this.bBasePeakIntensity = bFlag;
                break;
            }
            case "TotalIntensity": {
                this.bTotalIntensity = bFlag;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private boolean setScanEventFields(String qName, boolean bFlag) {
        switch (qName) {
            case "ActivationTypes": {
                this.bActivationTypes = bFlag;
                break;
            }
            case "IonizationSource": {
                this.bIonizationSource = bFlag;
                break;
            }
            case "IsMultiplexed": {
                this.bIsMultiplexed = bFlag;
                break;
            }
            case "IsolationMass": {
                this.bIsolationMass = bFlag;
                break;
            }
            case "IsolationWidth": {
                this.bIsolationWidth = bFlag;
                break;
            }
            case "MassAnalyzer": {
                this.bMassAnalyzer = bFlag;
                break;
            }
            case "MSOrder": {
                this.bMSOrder = bFlag;
                break;
            }
            case "Polarity": {
                this.bPolarity = bFlag;
                break;
            }
            case "ScanRate": {
                this.bScanRate = bFlag;
                break;
            }
            case "ScanType": {
                this.bScanType = bFlag;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String tmpStr = new String(ch, start, length).trim();
        if (!tmpStr.isEmpty()) {
            if (this.bMassSpectrum && this.lastActivated.equals("MassSpectrum")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"MassSpectrum\"): ");
            } else if (this.bHeader && this.lastActivated.equals("Header")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"Header\"): ");
            } else if (this.bSpectrumHeader && this.lastActivated.equals("SpectrumHeader")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"SpectrumHeader\"): ");
            } else if (this.bScanEvent && this.lastActivated.equals("ScanEvent")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"ScanEvent\"): ");
            } else if (this.bPrecursorInfo && this.lastActivated.equals("PrecursorInfo")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"PrecursorInfo\"): ");
            } else if (this.bPeak && this.lastActivated.equals("Peak")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"Peak\"): ");
            } else if (this.bPeakCentroids && this.lastActivated.equals("PeakCentroids")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"PeakCentroids\"): ");
            } else if (this.bProfilePoints && this.lastActivated.equals("ProfilePoints")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"ProfilePoints\"): ");
            } else if (this.bSpectrumIdentifiers && this.lastActivated.equals("SpectrumIdentifiers")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"SpectrumIdentifiers\"): ");
            } else if (this.bSpectrumIdentifier && this.lastActivated.equals("SpectrumIdentifier")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"SpectrumIdentifier\"): ");
            } else if (this.bActivationEnergies && this.lastActivated.equals("ActivationEnergies")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"ActivationEnergies\"): ");
            } else if (this.bActivationEnergies && this.lastActivated.equals("double")) {
                this.doubleVal = Double.valueOf(tmpStr);
            } else if (this.bMonoisotopicPeakCentroids && this.lastActivated.equals("MonoisotopicPeakCentroids")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"MonoisotopicPeakCentroids\"): ");
            } else if (this.bMeasuredMonoisotopicPeakCentroids && this.lastActivated.equals("MeasuredMonoisotopicPeakCentroids")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"MeasuredMonoisotopicPeakCentroids\"): ");
            } else if (this.bIsotopeClusterPeakCentroids && this.lastActivated.equals("IsotopeClusterPeakCentroids")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"IsotopeClusterPeakCentroids\"): ");
            } else if (this.bIsotopeClusterPeakCentroids && this.lastActivated.equals("IsotopeClusterProfilePoints")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"IsotopeClusterProfilePoints\"): ");
            } else if (this.bSpectrumID && this.lastActivated.equals("SpectrumID")) {
                if (this.bHeader) {
                    this.header.setSpectrumID(tmpStr);
                } else if (this.bSpectrumHeader) {
                    this.spectrumHeader.setSpectrumID(tmpStr);
                }
            } else if (this.bInstrumentName && this.lastActivated.equals("InstrumentName")) {
                if (this.bHeader) {
                    this.header.setInstrumentName(tmpStr);
                } else if (this.bSpectrumHeader) {
                    this.spectrumHeader.setInstrumentName(tmpStr);
                }
            } else if (this.bDataType && this.lastActivated.equals("DataType")) {
                if (this.bHeader) {
                    this.header.setDataType(tmpStr);
                } else if (this.bSpectrumHeader) {
                    this.spectrumHeader.setDataType(tmpStr);
                }
            } else if (this.bLowPosition && this.lastActivated.equals("LowPosition")) {
                if (this.bHeader) {
                    this.header.setLowPosition(tmpStr);
                } else if (this.bSpectrumHeader) {
                    this.spectrumHeader.setLowPosition(tmpStr);
                }
            } else if (this.bHighPosition && this.lastActivated.equals("HighPosition")) {
                if (this.bHeader) {
                    this.header.setHighPosition(tmpStr);
                } else if (this.bSpectrumHeader) {
                    this.spectrumHeader.setHighPosition(tmpStr);
                }
            } else if (this.bBasePeakPosition && this.lastActivated.equals("BasePeakPosition")) {
                if (this.bHeader) {
                    this.header.setBasePeakPosition(tmpStr);
                } else if (this.bSpectrumHeader) {
                    this.spectrumHeader.setBasePeakPosition(tmpStr);
                }
            } else if (this.bBasePeakIntensity && this.lastActivated.equals("BasePeakIntensity")) {
                if (this.bHeader) {
                    this.header.setBasePeakIntensity(tmpStr);
                } else if (this.bSpectrumHeader) {
                    this.spectrumHeader.setBasePeakIntensity(tmpStr);
                }
            } else if (this.bTotalIntensity && this.lastActivated.equals("TotalIntensity")) {
                if (this.bHeader) {
                    this.header.setTotalIntensity(tmpStr);
                } else if (this.bSpectrumHeader) {
                    this.spectrumHeader.setTotalIntensity(tmpStr);
                }
            } else if (this.bActivationTypes && this.lastActivated.equals("ActivationTypes")) {
                if (this.bScanEvent) {
                    this.scanEvent.setActivationTypes(tmpStr);
                }
            } else if (this.bIonizationSource && this.lastActivated.equals("IonizationSource")) {
                if (this.bScanEvent) {
                    this.scanEvent.setIonizationSource(tmpStr);
                }
            } else if (this.bIsMultiplexed && this.lastActivated.equals("IsMultiplexed")) {
                if (this.bScanEvent) {
                    this.scanEvent.setIsMultiplexed(tmpStr);
                }
            } else if (this.bIsolationMass && this.lastActivated.equals("IsolationMass")) {
                if (this.bScanEvent) {
                    this.scanEvent.setIsolationMass(tmpStr);
                }
            } else if (this.bIsolationWidth && this.lastActivated.equals("IsolationWidth")) {
                if (this.bScanEvent) {
                    this.scanEvent.setIsolationWidth(tmpStr);
                }
            } else if (this.bMassAnalyzer && this.lastActivated.equals("MassAnalyzer")) {
                if (this.bScanEvent) {
                    this.scanEvent.setMassAnalyzer(tmpStr);
                }
            } else if (this.bMSOrder && this.lastActivated.equals("MSOrder")) {
                if (this.bScanEvent) {
                    this.scanEvent.setMSOrder(tmpStr);
                }
            } else if (this.bPolarity && this.lastActivated.equals("Polarity")) {
                if (this.bScanEvent) {
                    this.scanEvent.setPolarity(tmpStr);
                }
            } else if (this.bScanRate && this.lastActivated.equals("ScanRate")) {
                if (this.bScanEvent) {
                    this.scanEvent.setScanRate(tmpStr);
                }
            } else if (this.bScanType && this.lastActivated.equals("ScanType")) {
                if (this.bScanEvent) {
                    this.scanEvent.setScanType(tmpStr);
                }
            } else if (tmpStr.length() > 0) {
                this.logger.error("############ start characters(" + length + "): " + tmpStr);
            }
        }
    }

    private void setMassSpectrumAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr = atts.getQName(i);
            if (!tmpStr.equals("xsi:schemaLocation")) {
                this.logger.error("++++++++++++ Unknown attribute in MassSpectrum: " + tmpStr);
            }
            ++i;
        }
    }

    private void setPrecursorInfoAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "SpectrumNumber": {
                    this.precursorInfo.setSpectrumNumber(Integer.valueOf(atts.getValue(i)));
                    break;
                }
                case "Charge": {
                    this.precursorInfo.setCharge(Integer.valueOf(atts.getValue(i)));
                    break;
                }
                case "SinglyChargedMass": {
                    this.precursorInfo.setSinglyChargedMass(Float.valueOf(atts.getValue(i)).floatValue());
                    break;
                }
                case "PrecursorMassOrigin": {
                    this.precursorInfo.setPrecursorMassOrigin(atts.getValue(i));
                    break;
                }
                case "Intensity": {
                    this.precursorInfo.setIntensity(Float.valueOf(atts.getValue(i)).floatValue());
                    break;
                }
                case "Resolution": {
                    this.precursorInfo.setResolution(Integer.valueOf(atts.getValue(i)));
                    break;
                }
                case "SignalToNoise": {
                    this.precursorInfo.setSignalToNoise(Float.valueOf(atts.getValue(i)).floatValue());
                    break;
                }
                case "InstrumentDeterminedCharge": {
                    this.precursorInfo.setInstrumentDeterminedCharge(Integer.valueOf(atts.getValue(i)));
                    break;
                }
                case "InstrumentDeterminedMonoisotopicMass": {
                    this.precursorInfo.setInstrumentDeterminedMonoisotopicMass(Float.valueOf(atts.getValue(i)).floatValue());
                    break;
                }
                case "PercentIsolationInterference": {
                    this.precursorInfo.setPercentIsolationInterference(Float.valueOf(atts.getValue(i)).floatValue());
                    break;
                }
                case "IonInjectTime": {
                    this.precursorInfo.setIonInjectTime(Integer.valueOf(atts.getValue(i)));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in PrecursorInfo: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setSpectrumIdentifierAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "FileID": {
                    this.spectrumIdentifier.setFileID(atts.getValue(i));
                    break;
                }
                case "ScanNumber": {
                    this.spectrumIdentifier.setScanNumber(atts.getValue(i));
                    break;
                }
                case "MasterScanNumber": {
                    this.spectrumIdentifier.setMasterScanNumber(atts.getValue(i));
                    break;
                }
                case "RetentionTime": {
                    this.spectrumIdentifier.setRetentionTime(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in SpectrumIdentifier: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setPeakAttributes(Attributes atts, PeakType peak) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "X": {
                    peak.setX(atts.getValue(i));
                    break;
                }
                case "Y": {
                    peak.setY(atts.getValue(i));
                    break;
                }
                case "Z": {
                    peak.setZ(atts.getValue(i));
                    break;
                }
                case "R": {
                    peak.setR(atts.getValue(i));
                    break;
                }
                case "SN": {
                    peak.setSN(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in Peak: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void addPeakListToPeakCentroids() {
    }

    private void addPeakListToMonoisotopicPeakCentroids() {
    }

    private void addPeakListToMeasuredMonoisotopicPeakCentroids() {
    }

    private void addPeakListToIsotopeClusterPeakCentroids() {
    }

    protected final void checkForEmptyLists() {
    }
}

