/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD.XML;

import de.mpc.BaseLib.GUID;
import de.mpc.BaseLib.XML.BaseSaxParser;
import de.mpc.BaseLib.XML.XMLHandlerBase;
import de.mpc.PD.FilterInfoSet.FilterInfoSetXmlType;
import de.mpc.PD.FilterInfoSet.FilterInfoType;
import de.mpc.PD.FilterInfoSet.ParameterType;
import de.mpc.PD.XML.ResultFilterSetSaxParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ResultFilterSetHandler
extends XMLHandlerBase {
    private final Logger logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
    private boolean bFilterInfoSetXml = false;
    private boolean bFilterInfo = false;
    private boolean bParameter = false;
    public FilterInfoSetXmlType filterInfoSetXml = null;
    public FilterInfoType filterInfo = null;
    public ParameterType parameter = null;
    private ArrayList<FilterInfoType> filterInfoList = null;
    private ArrayList<ParameterType> parameterList = null;

    public ResultFilterSetHandler(ResultFilterSetSaxParser parser) {
        super((BaseSaxParser)parser);
    }

    public void startDocument() throws SAXException {
        this.printTraceStr("startDocument (ResultFilterSet)");
    }

    public void endDocument() throws SAXException {
        this.printTraceStr("endDocument (ResultFilterSet)");
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        switch (qName) {
            case "FilterInfoSetXml": {
                if (this.filterInfoSetXml == null) {
                    this.filterInfoSetXml = new FilterInfoSetXmlType();
                }
                if (atts != null) {
                    this.setFilterInfoSetXmlAttributes(atts);
                }
                this.bFilterInfoSetXml = true;
                break;
            }
            case "FilterInfo": {
                if (this.filterInfo == null) {
                    this.filterInfo = new FilterInfoType();
                }
                if (this.filterInfoList == null) {
                    this.filterInfoList = new ArrayList();
                }
                if (atts != null) {
                    this.setFilterInfoAttributes(atts);
                }
                this.bFilterInfo = true;
                break;
            }
            case "Parameter": {
                if (this.parameter == null) {
                    this.parameter = new ParameterType();
                }
                if (this.parameterList == null) {
                    this.parameterList = new ArrayList();
                }
                if (atts != null) {
                    this.setParameterAttributes(atts);
                }
                this.bParameter = true;
                break;
            }
            default: {
                this.logger.error("************ UNHANDLED START ELEMENT    : " + qName);
            }
        }
        this.lastActivated = qName;
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        switch (qName) {
            case "FilterInfoSetXml": {
                this.addFilterInfoListToFilterInfoSetXml();
                this.checkForEmptyLists();
                ((ResultFilterSetSaxParser)this.parser).setFilterInfoSet(this.filterInfoSetXml);
                this.bFilterInfoSetXml = false;
                break;
            }
            case "FilterInfo": {
                this.addParameterListToFilterInfo();
                this.filterInfoList.add(this.filterInfo);
                this.filterInfo = null;
                this.bFilterInfo = false;
                break;
            }
            case "Parameter": {
                this.parameterList.add(this.parameter);
                this.parameter = null;
                this.bParameter = false;
                break;
            }
            default: {
                this.logger.error("************ UNHANDLED END ELEMENT    : " + qName);
            }
        }
        this.lastActivated = "";
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String tmpStr = new String(ch, start, length).trim();
        if (!tmpStr.isEmpty()) {
            if (this.bFilterInfoSetXml && this.lastActivated.equals("FilterInfoSetXml")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"FilterInfoSetXml\"): ");
            } else if (this.bFilterInfo && this.lastActivated.equals("FilterInfo")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"FilterInfo\"): ");
            } else if (this.bParameter && this.lastActivated.equals("Parameter")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"Parameter\"): ");
            } else {
                this.logger.error("############ start characters(" + length + "): " + tmpStr);
            }
        }
    }

    private void setFilterInfoSetXmlAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr = atts.getQName(i);
            if (tmpStr.equals("FilterSetName")) {
                this.filterInfoSetXml.setFilterSetName(atts.getValue(i));
            } else if (!tmpStr.equals("xsi:schemaLocation")) {
                this.logger.error("++++++++++++ Unknown attribute in FilterInfoSetXml: " + tmpStr);
            }
            ++i;
        }
    }

    private void setFilterInfoAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "FilterName": {
                    this.filterInfo.setFilterName(atts.getValue(i));
                    break;
                }
                case "Description": {
                    this.filterInfo.setDescription(atts.getValue(i));
                    break;
                }
                case "Guid": {
                    this.filterInfo.setGuid(new GUID(atts.getValue(i)).toString());
                    break;
                }
                case "ApplyableNodes": {
                    this.filterInfo.setApplyableNodes(atts.getValue(i));
                    break;
                }
                case "IsActive": {
                    this.filterInfo.setIsActive(Boolean.parseBoolean(atts.getValue(i)));
                    break;
                }
                case "IsApplied": {
                    this.filterInfo.setIsApplied(Boolean.parseBoolean(atts.getValue(i)));
                    break;
                }
                case "FilterKind": {
                    this.filterInfo.setFilterKind(atts.getValue(i));
                    break;
                }
                case "IsConfidenceFilter": {
                    this.filterInfo.setIsConfidenceFilter(Boolean.parseBoolean(atts.getValue(i)));
                    break;
                }
                case "ConfidenceLevel": {
                    this.filterInfo.setConfidenceLevel(atts.getValue(i));
                    break;
                }
                case "ProcessingNodeNumber": {
                    this.filterInfo.setProcessingNodeNumber(Integer.parseInt(atts.getValue(i)));
                    break;
                }
                case "Version": {
                    this.filterInfo.setVersion(Integer.parseInt(atts.getValue(i)));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in FilterInfo: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setParameterAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "ParameterName": {
                    this.parameter.setParameterName(atts.getValue(i));
                    break;
                }
                case "ParameterDisplayName": {
                    this.parameter.setParameterDisplayName(atts.getValue(i));
                    break;
                }
                case "ParameterValue": {
                    this.parameter.setParameterValue(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in Parameter: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void addFilterInfoListToFilterInfoSetXml() {
        if (this.filterInfoList != null) {
            for (FilterInfoType filterInf : this.filterInfoList) {
                this.filterInfoSetXml.getFilterInfo().add(filterInf);
            }
            this.filterInfoList.clear();
            this.filterInfoList = null;
        }
    }

    private void addParameterListToFilterInfo() {
        if (this.parameterList != null) {
            for (ParameterType param : this.parameterList) {
                this.filterInfo.getParameter().add(param);
            }
            this.parameterList.clear();
            this.parameterList = null;
        }
    }

    protected final void checkForEmptyLists() {
        if (this.filterInfoList != null) {
            this.logger.error("NOT ALL filter info's saved");
        }
        if (this.parameterList != null) {
            this.logger.error("NOT ALL parameter's saved");
        }
    }

    public HashMap<String, String> getResultFilterParams(String level) {
        HashMap<String, String> nameValueMap = new HashMap<String, String>();
        for (FilterInfoType filterInf : this.filterInfoList) {
            if (!filterInf.getConfidenceLevel().startsWith(level)) continue;
            List<ParameterType> paramList = filterInf.getParameter();
            for (ParameterType param : paramList) {
                nameValueMap.put(param.getParameterName(), param.getParameterValue());
            }
        }
        return nameValueMap;
    }
}

