/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD.XML;

import de.mpc.BaseLib.XML.BaseSaxParser;
import de.mpc.PD.XML.ProtXMLHandler;
import de.mpc.protXML.ProteinSummary;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ProtXMLSaxParser
extends BaseSaxParser {
    public ProtXMLHandler protXMLHandler = null;

    public ProtXMLSaxParser(String protXMLInputFileName) {
        super(protXMLInputFileName);
        this.initSaxParser(protXMLInputFileName);
    }

    private void initSaxParser(String protXMLInputFileName) {
        this.protXMLHandler = new ProtXMLHandler(this);
        try {
            this.saxParser.parse(new File(protXMLInputFileName), (DefaultHandler)((Object)this.protXMLHandler));
        }
        catch (IOException | SAXException sex) {
            sex.printStackTrace(System.err);
        }
    }

    public void setExplicitHandleSearchSummary(boolean flag) {
        this.protXMLHandler.setHandleSearchSummary(flag);
    }

    public void setProteinSummary(ProteinSummary proteinSummary) {
        this.protXMLHandler.proteinSummary = proteinSummary;
    }

    public ProteinSummary getProteinSummary() {
        return this.protXMLHandler.proteinSummary;
    }

    public ArrayList getUsedProcessingNodes() {
        return this.protXMLHandler.getUsedProcessingNodes();
    }

    public ArrayList<ProtXMLHandler.SearchMachines> getUsedSearchMachines() {
        ArrayList<ProtXMLHandler.SearchMachines> searchMachines = new ArrayList<ProtXMLHandler.SearchMachines>();
        ProtXMLHandler.SearchMachines[] searchMachinesArray = ProtXMLHandler.SearchMachines.values();
        int n = searchMachinesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProtXMLHandler.SearchMachines sm = searchMachinesArray[n2];
            if (this.protXMLHandler.getUsedSearchMachines().contains((Object)sm)) {
                searchMachines.add(sm);
            }
            ++n2;
        }
        return searchMachines;
    }

    private ProteinSummary.ProteinGroup.Protein.AnalysisResult getAnalysisResultOfProtein(ProteinSummary.ProteinGroup.Protein protein, String analysis, BigInteger id) {
        List<ProteinSummary.ProteinGroup.Protein.AnalysisResult> analysisResultList = protein.getAnalysisResult();
        for (ProteinSummary.ProteinGroup.Protein.AnalysisResult analysisRes : analysisResultList) {
            if (!analysisRes.getAnalysis().equals(analysis) || analysisRes.getId() != id) continue;
            return analysisRes;
        }
        return null;
    }

    private ProteinSummary.ProteinGroup.Protein getProteinOfProteinGroup(ProteinSummary.ProteinGroup proteinGroup, String groupSiblingId) {
        List<ProteinSummary.ProteinGroup.Protein> proteinList = proteinGroup.getProtein();
        for (ProteinSummary.ProteinGroup.Protein prot : proteinList) {
            if (!prot.getGroupSiblingId().equals(groupSiblingId)) continue;
            return prot;
        }
        return null;
    }

    public ProteinSummary.ProteinGroup getProteinGroup(String groupNumber) {
        if (this.protXMLHandler.proteinSummary != null) {
            List<ProteinSummary.ProteinGroup> proteinGroupList = this.protXMLHandler.proteinSummary.getProteinGroup();
            for (ProteinSummary.ProteinGroup proteinGrp : proteinGroupList) {
                if (!proteinGrp.getGroupNumber().equals(groupNumber)) continue;
                return proteinGrp;
            }
        }
        return null;
    }
}

