/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD.XML;

import de.mpc.BaseLib.CVQuery;
import de.mpc.BaseLib.XML.BaseSaxParser;
import de.mpc.BaseLib.XML.XMLGregorianCalendarConverter;
import de.mpc.BaseLib.XML.XMLHandlerBase;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.BaseLib.obo.OBOInitialRead;
import de.mpc.PD.XML.ProtXMLSaxParser;
import de.mpc.protXML.ASAPProtAnalysisSummary;
import de.mpc.protXML.ASAPPvalueAnalysisSummary;
import de.mpc.protXML.ASAPRatio;
import de.mpc.protXML.ASAPRatioPvalue;
import de.mpc.protXML.LibraResult;
import de.mpc.protXML.LibraSummary;
import de.mpc.protXML.NameValueType;
import de.mpc.protXML.PD.PD_Empty;
import de.mpc.protXML.PD.PD_Parameter;
import de.mpc.protXML.PD.PD_ProcessingNodeSummary;
import de.mpc.protXML.PD.PD_SearchSummary;
import de.mpc.protXML.ProteinSummary;
import de.mpc.protXML.ProteinprophetDetails;
import de.mpc.protXML.XPressAnalysisSummary;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ProtXMLHandler<T, TL>
extends XMLHandlerBase {
    private final String STR_DATE_FORMAT = "yyyy-MM-dd";
    private final String STR_FILENAMES = "File Name(s)";
    private final String STR_PIPELINE_TREENODE_STARTSEQUENCE = "|-(";
    private final String STR_PREFIX_PROTEOME_DISCOVERER = "ProteomeDiscoverer:";
    private final String STR_PROCESSING_NODE_ = "Processing node ";
    private final Logger logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
    private String SearchMachineForParameters;
    private String currentProcessingNodeName;
    private boolean bHandleSearchSummary = true;
    private boolean bProtein_summary = false;
    private boolean bProtein_summary_header = false;
    private boolean bProgram_details = false;
    private boolean bAnalysis_summary = false;
    private boolean bDataset_derivation = false;
    private boolean bData_filter = false;
    private boolean bProtein_group = false;
    private boolean bProtein = false;
    private boolean bParameter = false;
    private boolean bProteinNameValueType = false;
    private boolean bIndistinguishableProteinNameValueType = false;
    private boolean bAnalysis_result = false;
    private boolean bAnnotation = false;
    private boolean bIndistinguishable_protein = false;
    private boolean bPeptide = false;
    private boolean bModification_info = false;
    private boolean bMod_aminoacid_mass = false;
    private boolean bPeptide_parent_protein = false;
    private boolean bIndistinguishable_peptide = false;
    private boolean bLibra_summary = false;
    private boolean bFragment_masses = false;
    private boolean bIsotopic_contributions = false;
    private boolean bContributing_channel = false;
    private boolean bAffected_channel = false;
    private boolean bLibra_result = false;
    private boolean bIntensity = false;
    private boolean bASAP_prot_analysis_summary = false;
    private boolean bASAP_pvalue_analysis_summary = false;
    private boolean bASAPRatio_pvalue = false;
    private boolean bASAPRatio = false;
    private boolean bASAP_Seq = false;
    private boolean bASAP_Peak = false;
    private boolean bASAP_Dta = false;
    private boolean bXPress_analysis_summary = false;
    private boolean bProteinprophet_details = false;
    private boolean bNsp_information = false;
    private boolean bNi_information = false;
    private boolean bProtein_summary_data_filter = false;
    private boolean bNsp_distribution = false;
    private boolean bNi_distribution = false;
    private boolean bPD_ProcessingNodeSummary = false;
    private boolean bPD_SearchSummary = false;
    private boolean bPD_Parameter = false;
    private boolean bPD_Empty = false;
    public ProteinSummary proteinSummary = null;
    private ProteinSummary.ProteinSummaryHeader proteinSummaryHeader = null;
    private ProteinSummary.ProteinSummaryHeader.ProgramDetails programDetails = null;
    private ProteinSummary.AnalysisSummary analysisSummary = null;
    private ProteinSummary.DatasetDerivation.DataFilter dataFilter = null;
    private ProteinSummary.DatasetDerivation datasetDerivation = null;
    private ProteinSummary.ProteinGroup proteinGroup = null;
    private ProteinSummary.ProteinGroup.Protein protein = null;
    private ProteinSummary.ProteinGroup.Protein.Peptide.Parameter peptideParameter = null;
    private NameValueType proteinNameValueType = null;
    private NameValueType indistinguishableProteinNameValueType = null;
    private ProteinSummary.ProteinGroup.Protein.AnalysisResult analysisResult = null;
    private ProteinSummary.ProteinGroup.Protein.Annotation annotation;
    private ProteinSummary.ProteinGroup.Protein.IndistinguishableProtein.Annotation annotationIP;
    private ProteinSummary.ProteinGroup.Protein.IndistinguishableProtein indistinguishableProtein = null;
    private ProteinSummary.ProteinGroup.Protein.Peptide peptide = null;
    private ProteinSummary.ProteinGroup.Protein.Peptide.ModificationInfo modificationInfo = null;
    private ProteinSummary.ProteinGroup.Protein.Peptide.IndistinguishablePeptide.ModificationInfo modificationInfoIP = null;
    private ProteinSummary.ProteinGroup.Protein.Peptide.ModificationInfo.ModAminoacidMass modAminoacidMass = null;
    private ProteinSummary.ProteinGroup.Protein.Peptide.IndistinguishablePeptide.ModificationInfo.ModAminoacidMass modAminoacidMassIP = null;
    private ProteinSummary.ProteinGroup.Protein.Peptide.PeptideParentProtein peptideParentProtein = null;
    private ProteinSummary.ProteinGroup.Protein.Peptide.IndistinguishablePeptide indistinguishablePeptide = null;
    public LibraSummary libraSummary = null;
    private LibraSummary.FragmentMasses fragmentMasses = null;
    private LibraSummary.IsotopicContributions isotopicContributions = null;
    private LibraSummary.IsotopicContributions.ContributingChannel contributingChannel = null;
    private LibraSummary.IsotopicContributions.ContributingChannel.AffectedChannel affectedChannel = null;
    public LibraResult libraResult = null;
    private LibraResult.Intensity intensity = null;
    public ASAPProtAnalysisSummary asapProtAnalysisSummary = null;
    public ASAPPvalueAnalysisSummary asapPvalueAnalysisSummary = null;
    public ASAPRatioPvalue asapRatioPvalue = null;
    public ASAPRatio asapRatio = null;
    private ASAPRatio.ASAPSeq asapSeq = null;
    private ASAPRatio.ASAPSeq.ASAPPeak asapPeak = null;
    private ASAPRatio.ASAPSeq.ASAPPeak.ASAPDta asapDta = null;
    public XPressAnalysisSummary xpressAnalysisSummary = null;
    public ProteinprophetDetails proteinprophetDetails = null;
    private ProteinprophetDetails.NspInformation nspInformation = null;
    private ProteinprophetDetails.NiInformation niInformation = null;
    private ProteinprophetDetails.ProteinSummaryDataFilter proteinSummaryDataFilter = null;
    private ProteinprophetDetails.NspInformation.NspDistribution nspDistribution = null;
    private ProteinprophetDetails.NiInformation.NiDistribution niDistribution = null;
    private PD_ProcessingNodeSummary PD_processingNodeSummary = null;
    public PD_SearchSummary PD_searchSummary = null;
    private PD_Parameter PD_parameter = null;
    private PD_Empty PD_empty = null;
    private ArrayList<ProteinSummary.AnalysisSummary> analysisSummaryList = null;
    private ArrayList<ProteinSummary.DatasetDerivation.DataFilter> dataFilterList = null;
    private ArrayList<ProteinSummary.ProteinGroup> proteinGroupList = null;
    private ArrayList<ProteinSummary.ProteinGroup.Protein> proteinList = null;
    private ArrayList<ProteinSummary.ProteinGroup.Protein.Peptide.Parameter> peptideParameterList = null;
    private ArrayList<NameValueType> proteinNameValueTypeList = null;
    private ArrayList<NameValueType> indistinguishableProteinNameValueTypeList = null;
    private ArrayList<ProteinSummary.ProteinGroup.Protein.AnalysisResult> analysisResultList = null;
    private ArrayList<ProteinSummary.ProteinGroup.Protein.IndistinguishableProtein> indistinguishableProteinList = null;
    private ArrayList<ProteinSummary.ProteinGroup.Protein.Peptide> peptideList = null;
    private ArrayList<ProteinSummary.ProteinGroup.Protein.Peptide.ModificationInfo> modificationInfoList = null;
    private ArrayList<ProteinSummary.ProteinGroup.Protein.Peptide.IndistinguishablePeptide.ModificationInfo> modificationInfoIPList = null;
    private ArrayList<ProteinSummary.ProteinGroup.Protein.Peptide.ModificationInfo.ModAminoacidMass> modAminoacidMassList = null;
    private ArrayList<ProteinSummary.ProteinGroup.Protein.Peptide.IndistinguishablePeptide.ModificationInfo.ModAminoacidMass> modAminoacidMassIPList = null;
    private ArrayList<ProteinSummary.ProteinGroup.Protein.Peptide.PeptideParentProtein> peptideParentProteinList = null;
    private ArrayList<ProteinSummary.ProteinGroup.Protein.Peptide.IndistinguishablePeptide> indistinguishablePeptideList = null;
    private ArrayList<LibraSummary.FragmentMasses> fragmentMassesList = null;
    private ArrayList<LibraSummary.IsotopicContributions.ContributingChannel> contributingChannelList = null;
    private ArrayList<LibraSummary.IsotopicContributions.ContributingChannel.AffectedChannel> affectedChannelList = null;
    private ArrayList<LibraResult.Intensity> intensityList = null;
    private ArrayList<ASAPRatio.ASAPSeq> asapSeqList;
    private ArrayList<ASAPRatio.ASAPSeq.ASAPPeak> asapPeakList;
    private ArrayList<ASAPRatio.ASAPSeq.ASAPPeak.ASAPDta> asapDtaList;
    private ArrayList<ProteinprophetDetails.ProteinSummaryDataFilter> proteinSummaryDataFilterList;
    private ArrayList<ProteinprophetDetails.NspInformation.NspDistribution> nspDistributionList;
    private ArrayList<ProteinprophetDetails.NiInformation.NiDistribution> niDistributionList;
    public ArrayList<PD_Parameter> PD_parameterList = null;
    private final ArrayList<ProcessingNodes> usedProcessingNodes = new ArrayList();

    public ProtXMLHandler(ProtXMLSaxParser parser) {
        super((BaseSaxParser)parser);
    }

    public void setHandleSearchSummary(boolean flag) {
        this.bHandleSearchSummary = flag;
    }

    public ArrayList<ProcessingNodes> getUsedProcessingNodes() {
        return this.usedProcessingNodes;
    }

    public ArrayList getUsedSearchMachines() {
        ArrayList<SearchMachines> smNodes = new ArrayList<SearchMachines>();
        if (this.usedProcessingNodes.contains((Object)ProcessingNodes.SEQUEST)) {
            smNodes.add(SearchMachines.SEQUEST);
        }
        if (this.usedProcessingNodes.contains((Object)ProcessingNodes.Mascot)) {
            smNodes.add(SearchMachines.Mascot);
        }
        if (this.usedProcessingNodes.contains((Object)ProcessingNodes.ZCore)) {
            smNodes.add(SearchMachines.ZCore);
        }
        if (this.usedProcessingNodes.contains((Object)ProcessingNodes.AmandaPeptideIdentifier)) {
            smNodes.add(SearchMachines.Amanda);
        }
        if (this.usedProcessingNodes.contains((Object)ProcessingNodes.SequestHT)) {
            smNodes.add(SearchMachines.SEQUEST_HT);
        }
        return smNodes;
    }

    public void startDocument() throws SAXException {
        this.printTraceStr("startDocument (protXML)");
    }

    public void endDocument() throws SAXException {
        this.printTraceStr("endDocument (protXML)");
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        switch (qName) {
            case "protein_summary": {
                if (this.proteinSummary == null) {
                    this.proteinSummary = new ProteinSummary();
                }
                if (atts != null) {
                    this.setProteinSummaryAttributes(atts);
                }
                this.bProtein_summary = true;
                break;
            }
            case "protein_summary_header": {
                if (this.proteinSummaryHeader == null) {
                    this.proteinSummaryHeader = new ProteinSummary.ProteinSummaryHeader();
                }
                if (atts != null) {
                    this.setProteinSummaryHeaderAttributes(atts);
                }
                this.bProtein_summary_header = true;
                break;
            }
            case "program_details": {
                if (this.programDetails == null) {
                    this.programDetails = new ProteinSummary.ProteinSummaryHeader.ProgramDetails();
                }
                if (atts != null) {
                    this.setProgramDetailsAttributes(atts);
                }
                this.bProgram_details = true;
                break;
            }
            case "analysis_summary": {
                if (this.analysisSummary == null) {
                    this.analysisSummary = new ProteinSummary.AnalysisSummary();
                }
                if (this.analysisSummaryList == null) {
                    this.analysisSummaryList = new ArrayList();
                }
                if (atts != null) {
                    this.setAnalysisSummaryAttributes(atts);
                }
                this.bAnalysis_summary = true;
                break;
            }
            case "dataset_derivation": {
                if (this.datasetDerivation == null) {
                    this.datasetDerivation = new ProteinSummary.DatasetDerivation();
                }
                if (atts != null) {
                    this.setDatasetDerivationAttributes(atts);
                }
                this.bDataset_derivation = true;
                break;
            }
            case "data_filter": {
                if (this.dataFilter == null) {
                    this.dataFilter = new ProteinSummary.DatasetDerivation.DataFilter();
                }
                if (this.dataFilterList == null) {
                    this.dataFilterList = new ArrayList();
                }
                if (atts != null) {
                    this.setDataFilterAttributes(atts);
                }
                this.bData_filter = true;
                break;
            }
            case "protein_group": {
                if (this.proteinGroup == null) {
                    this.proteinGroup = new ProteinSummary.ProteinGroup();
                }
                if (this.proteinGroupList == null) {
                    this.proteinGroupList = new ArrayList();
                }
                if (atts != null) {
                    this.setProteinGroupAttributes(atts);
                }
                this.bProtein_group = true;
                break;
            }
            case "protein": {
                if (this.protein == null) {
                    this.protein = new ProteinSummary.ProteinGroup.Protein();
                }
                if (this.proteinList == null) {
                    this.proteinList = new ArrayList();
                }
                if (atts != null) {
                    this.setProteinAttributes(atts);
                }
                this.bProtein = true;
                break;
            }
            case "parameter": {
                if (this.bPeptide) {
                    if (this.peptideParameter == null) {
                        this.peptideParameter = new ProteinSummary.ProteinGroup.Protein.Peptide.Parameter();
                    }
                    if (this.peptideParameterList == null) {
                        this.peptideParameterList = new ArrayList();
                    }
                    if (atts != null) {
                        this.setParameterAttributes(this.peptideParameter, atts);
                    }
                    this.bParameter = true;
                    break;
                }
                if (this.bIndistinguishable_protein) {
                    if (this.indistinguishableProteinNameValueType == null) {
                        this.indistinguishableProteinNameValueType = new NameValueType();
                    }
                    if (this.indistinguishableProteinNameValueTypeList == null) {
                        this.indistinguishableProteinNameValueTypeList = new ArrayList();
                    }
                    if (atts != null) {
                        this.setNameValueTypeAttributes(this.indistinguishableProteinNameValueType, atts);
                    }
                    this.bIndistinguishableProteinNameValueType = true;
                    break;
                }
                if (this.bProtein) {
                    if (this.proteinNameValueType == null) {
                        this.proteinNameValueType = new NameValueType();
                    }
                    if (this.proteinNameValueTypeList == null) {
                        this.proteinNameValueTypeList = new ArrayList();
                    }
                    if (atts != null) {
                        this.setNameValueTypeAttributes(this.proteinNameValueType, atts);
                    }
                    this.bProteinNameValueType = true;
                    break;
                }
                this.logger.error("Parameter at unexpected position");
                break;
            }
            case "analysis_result": {
                if (this.analysisResult == null) {
                    this.analysisResult = new ProteinSummary.ProteinGroup.Protein.AnalysisResult();
                }
                if (this.analysisResultList == null) {
                    this.analysisResultList = new ArrayList();
                }
                if (atts != null) {
                    this.setAnalysisResultAttributes(atts);
                }
                this.bAnalysis_result = true;
                break;
            }
            case "annotation": {
                if (this.bIndistinguishable_protein) {
                    if (this.annotation == null) {
                        this.annotation = new ProteinSummary.ProteinGroup.Protein.Annotation();
                    }
                    if (atts != null) {
                        this.setAnnotationAttributes(atts);
                    }
                } else {
                    if (this.annotationIP == null) {
                        this.annotationIP = new ProteinSummary.ProteinGroup.Protein.IndistinguishableProtein.Annotation();
                    }
                    if (atts != null) {
                        this.setAnnotationIPAttributes(atts);
                    }
                }
                this.bAnnotation = true;
                break;
            }
            case "indistinguishable_protein": {
                if (this.indistinguishableProtein == null) {
                    this.indistinguishableProtein = new ProteinSummary.ProteinGroup.Protein.IndistinguishableProtein();
                }
                if (this.indistinguishableProteinList == null) {
                    this.indistinguishableProteinList = new ArrayList();
                }
                if (atts != null) {
                    this.setIndistinguishableProteinAttributes(atts);
                }
                this.bIndistinguishable_protein = true;
                break;
            }
            case "peptide": {
                if (this.peptide == null) {
                    this.peptide = new ProteinSummary.ProteinGroup.Protein.Peptide();
                }
                if (this.peptideList == null) {
                    this.peptideList = new ArrayList();
                }
                if (atts != null) {
                    this.setPeptideAttributes(atts);
                }
                this.bPeptide = true;
                break;
            }
            case "modification_info": {
                if (this.bIndistinguishable_peptide) {
                    if (this.modificationInfoIP == null) {
                        this.modificationInfoIP = new ProteinSummary.ProteinGroup.Protein.Peptide.IndistinguishablePeptide.ModificationInfo();
                    }
                    if (this.modificationInfoIPList == null) {
                        this.modificationInfoIPList = new ArrayList();
                    }
                    if (atts != null) {
                        this.setModificationInfoIPAttributes(atts);
                    }
                } else {
                    if (this.modificationInfo == null) {
                        this.modificationInfo = new ProteinSummary.ProteinGroup.Protein.Peptide.ModificationInfo();
                    }
                    if (this.modificationInfoList == null) {
                        this.modificationInfoList = new ArrayList();
                    }
                    if (atts != null) {
                        this.setModificationInfoAttributes(atts);
                    }
                }
                this.bModification_info = true;
                break;
            }
            case "mod_aminoacid_mass": {
                if (this.bIndistinguishable_peptide) {
                    if (this.modAminoacidMassIP == null) {
                        this.modAminoacidMassIP = new ProteinSummary.ProteinGroup.Protein.Peptide.IndistinguishablePeptide.ModificationInfo.ModAminoacidMass();
                    }
                    if (this.modAminoacidMassIPList == null) {
                        this.modAminoacidMassIPList = new ArrayList();
                    }
                    if (atts != null) {
                        this.setModAminoacidMassIPAttributes(atts);
                    }
                } else {
                    if (this.modAminoacidMass == null) {
                        this.modAminoacidMass = new ProteinSummary.ProteinGroup.Protein.Peptide.ModificationInfo.ModAminoacidMass();
                    }
                    if (this.modAminoacidMassList == null) {
                        this.modAminoacidMassList = new ArrayList();
                    }
                    if (atts != null) {
                        this.setModAminoacidMassAttributes(atts);
                    }
                }
                this.bMod_aminoacid_mass = true;
                break;
            }
            case "peptide_parent_protein": {
                if (this.peptideParentProtein == null) {
                    this.peptideParentProtein = new ProteinSummary.ProteinGroup.Protein.Peptide.PeptideParentProtein();
                }
                if (this.peptideParentProteinList == null) {
                    this.peptideParentProteinList = new ArrayList();
                }
                if (atts != null) {
                    this.setPeptideParentProteinAttributes(atts);
                }
                this.bPeptide_parent_protein = true;
                break;
            }
            case "indistinguishable_peptide": {
                if (this.indistinguishablePeptide == null) {
                    this.indistinguishablePeptide = new ProteinSummary.ProteinGroup.Protein.Peptide.IndistinguishablePeptide();
                }
                if (this.indistinguishablePeptideList == null) {
                    this.indistinguishablePeptideList = new ArrayList();
                }
                if (atts != null) {
                    this.setIndistinguishablePeptideAttributes(atts);
                }
                this.bIndistinguishable_peptide = true;
                break;
            }
            case "Empty": {
                if (this.PD_empty == null) {
                    this.PD_empty = new PD_Empty();
                }
                if (atts != null) {
                    this.setPD_EmptyAttributes(this.PD_empty, atts);
                }
                this.bPD_Empty = true;
                break;
            }
            case "ProcessingNodeSummary": {
                if (this.PD_processingNodeSummary == null) {
                    this.PD_processingNodeSummary = new PD_ProcessingNodeSummary();
                }
                if (atts != null) {
                    this.setPD_ProcessingNodeAttributes(this.PD_processingNodeSummary, atts);
                }
                this.bPD_ProcessingNodeSummary = true;
                break;
            }
            case "SearchSummary": {
                if (this.bHandleSearchSummary) {
                    if (this.PD_searchSummary == null) {
                        this.PD_searchSummary = new PD_SearchSummary();
                    }
                    if (atts != null) {
                        this.setPD_SearchSummaryAttributes(this.PD_searchSummary, atts);
                    }
                }
                this.bPD_SearchSummary = true;
                break;
            }
            case "Parameter": {
                if (this.PD_parameter == null) {
                    this.PD_parameter = new PD_Parameter();
                }
                if (this.PD_parameterList == null) {
                    this.PD_parameterList = new ArrayList();
                }
                if (atts != null) {
                    this.setPD_ParameterAttributes(this.PD_parameter, atts);
                }
                this.bPD_Parameter = true;
                break;
            }
            case "libra_summary": {
                if (this.libraSummary == null) {
                    this.libraSummary = new LibraSummary();
                }
                if (atts != null) {
                    this.setLibraSummaryAttributes(atts);
                }
                this.bLibra_summary = true;
                break;
            }
            case "fragment_masses": {
                if (this.fragmentMasses == null) {
                    this.fragmentMasses = new LibraSummary.FragmentMasses();
                }
                if (this.fragmentMassesList == null) {
                    this.fragmentMassesList = new ArrayList();
                }
                if (atts != null) {
                    this.setFragmentMassesAttributes(atts);
                }
                this.bFragment_masses = true;
                break;
            }
            case "isotopic_contributions": {
                if (this.isotopicContributions == null) {
                    this.isotopicContributions = new LibraSummary.IsotopicContributions();
                }
                if (atts != null) {
                    this.setIsotopicContributionsAttributes(atts);
                }
                this.bIsotopic_contributions = true;
                break;
            }
            case "contributing_channel": {
                if (this.contributingChannel == null) {
                    this.contributingChannel = new LibraSummary.IsotopicContributions.ContributingChannel();
                }
                if (this.contributingChannelList == null) {
                    this.contributingChannelList = new ArrayList();
                }
                if (atts != null) {
                    this.setContributingChannelAttributes(atts);
                }
                this.bContributing_channel = true;
                break;
            }
            case "affected_channel": {
                if (this.affectedChannel == null) {
                    this.affectedChannel = new LibraSummary.IsotopicContributions.ContributingChannel.AffectedChannel();
                }
                if (this.affectedChannelList == null) {
                    this.affectedChannelList = new ArrayList();
                }
                if (atts != null) {
                    this.setAffectedChannelAttributes(atts);
                }
                this.bAffected_channel = true;
                break;
            }
            case "libra_result": {
                if (this.libraResult == null) {
                    this.libraResult = new LibraResult();
                }
                if (atts != null) {
                    this.setLibraResultAttributes(atts);
                }
                this.bLibra_result = true;
                break;
            }
            case "intensity": {
                if (this.intensity == null) {
                    this.intensity = new LibraResult.Intensity();
                }
                if (this.intensityList == null) {
                    this.intensityList = new ArrayList();
                }
                if (atts != null) {
                    this.setIntensityAttributes(atts);
                }
                this.bIntensity = true;
                break;
            }
            case "ASAP_prot_analysis_summary": {
                if (this.asapProtAnalysisSummary == null) {
                    this.asapProtAnalysisSummary = new ASAPProtAnalysisSummary();
                }
                if (atts != null) {
                    this.setASAPProtAnalysisSummaryAttributes(atts);
                }
                this.bASAP_prot_analysis_summary = true;
                break;
            }
            case "ASAP_pvalue_analysis_summary": {
                if (this.asapPvalueAnalysisSummary == null) {
                    this.asapPvalueAnalysisSummary = new ASAPPvalueAnalysisSummary();
                }
                if (atts != null) {
                    this.setASAPPvalueAnalysisSummaryAttributes(atts);
                }
                this.bASAP_pvalue_analysis_summary = true;
                break;
            }
            case "ASAPRatio_pvalue": {
                if (this.asapRatioPvalue == null) {
                    this.asapRatioPvalue = new ASAPRatioPvalue();
                }
                if (atts != null) {
                    this.setASAPRatioPvalueAttributes(atts);
                }
                this.bASAP_pvalue_analysis_summary = true;
                break;
            }
            case "ASAPRatio": {
                if (this.asapRatio == null) {
                    this.asapRatio = new ASAPRatio();
                }
                if (atts != null) {
                    this.setASAPRatioAttributes(atts);
                }
                this.bASAPRatio = true;
                break;
            }
            case "ASAP_Seq": {
                if (this.asapSeq == null) {
                    this.asapSeq = new ASAPRatio.ASAPSeq();
                }
                if (this.asapSeqList == null) {
                    this.asapSeqList = new ArrayList();
                }
                if (atts != null) {
                    this.setASAPSeqAttributes(atts);
                }
                this.bASAP_Seq = true;
                break;
            }
            case "ASAP_Peak": {
                if (this.asapPeak == null) {
                    this.asapPeak = new ASAPRatio.ASAPSeq.ASAPPeak();
                }
                if (this.asapPeakList == null) {
                    this.asapPeakList = new ArrayList();
                }
                if (atts != null) {
                    this.setASAPPeakAttributes(atts);
                }
                this.bASAP_Peak = true;
                break;
            }
            case "ASAP_Dta": {
                if (this.asapDta == null) {
                    this.asapDta = new ASAPRatio.ASAPSeq.ASAPPeak.ASAPDta();
                }
                if (this.asapDtaList == null) {
                    this.asapDtaList = new ArrayList();
                }
                if (atts != null) {
                    this.setASAPDtaAttributes(atts);
                }
                this.bASAP_Dta = true;
                break;
            }
            case "XPress_analysis_summary": {
                if (this.xpressAnalysisSummary == null) {
                    this.xpressAnalysisSummary = new XPressAnalysisSummary();
                }
                if (atts != null) {
                    this.setXPressAnalysisSummaryAttributes(atts);
                }
                this.bXPress_analysis_summary = true;
                break;
            }
            case "Proteinprophet_details": {
                if (this.proteinprophetDetails == null) {
                    this.proteinprophetDetails = new ProteinprophetDetails();
                }
                if (atts != null) {
                    this.setProteinprophetDetailsAttributes(atts);
                }
                this.bProteinprophet_details = true;
                break;
            }
            case "Nsp_information": {
                if (this.nspInformation == null) {
                    this.nspInformation = new ProteinprophetDetails.NspInformation();
                }
                if (atts != null) {
                    this.setNspInformationAttributes(atts);
                }
                this.bNsp_information = true;
                break;
            }
            case "Ni_information": {
                if (this.niInformation == null) {
                    this.niInformation = new ProteinprophetDetails.NiInformation();
                }
                if (atts != null) {
                    this.setNiInformationAttributes(atts);
                }
                this.bNi_information = true;
                break;
            }
            case "Protein_summary_data_filter": {
                if (this.proteinSummaryDataFilter == null) {
                    this.proteinSummaryDataFilter = new ProteinprophetDetails.ProteinSummaryDataFilter();
                }
                if (this.proteinSummaryDataFilterList == null) {
                    this.proteinSummaryDataFilterList = new ArrayList();
                }
                if (atts != null) {
                    this.setProteinSummaryDataFilterAttributes(atts);
                }
                this.bProtein_summary_data_filter = true;
                break;
            }
            case "Nsp_distribution": {
                if (this.nspDistribution == null) {
                    this.nspDistribution = new ProteinprophetDetails.NspInformation.NspDistribution();
                }
                if (this.nspDistributionList == null) {
                    this.nspDistributionList = new ArrayList();
                }
                if (atts != null) {
                    this.setNspDistributionAttributes(atts);
                }
                this.bNsp_distribution = true;
                break;
            }
            case "Ni_distribution": {
                if (this.niDistribution == null) {
                    this.niDistribution = new ProteinprophetDetails.NiInformation.NiDistribution();
                }
                if (this.niDistributionList == null) {
                    this.niDistributionList = new ArrayList();
                }
                if (atts != null) {
                    this.setNiDistributionAttributes(atts);
                }
                this.bNi_distribution = true;
                break;
            }
            default: {
                this.logger.error("************ UNHANDLED START ELEMENT    : " + qName);
            }
        }
        this.lastActivated = qName;
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        switch (qName) {
            case "protein_summary": {
                this.addAnalysisSummaryListToProteinSummary();
                this.addProteinGroupListToProteinSummary();
                this.checkForEmptyLists();
                ((ProtXMLSaxParser)this.parser).setProteinSummary(this.proteinSummary);
                this.bProtein_summary = false;
                break;
            }
            case "protein_summary_header": {
                this.proteinSummary.setProteinSummaryHeader(this.proteinSummaryHeader);
                this.proteinSummaryHeader = null;
                this.bProtein_summary_header = false;
                break;
            }
            case "program_details": {
                this.proteinSummaryHeader.setProgramDetails(this.programDetails);
                this.programDetails = null;
                this.bProgram_details = false;
                break;
            }
            case "analysis_summary": {
                this.analysisSummaryList.add(this.analysisSummary);
                this.analysisSummary = null;
                this.bAnalysis_summary = false;
                break;
            }
            case "dataset_derivation": {
                this.addDataFilterListToDatasetDerivation();
                this.proteinSummary.setDatasetDerivation(this.datasetDerivation);
                this.datasetDerivation = null;
                this.bDataset_derivation = false;
                break;
            }
            case "data_filter": {
                this.dataFilterList.add(this.dataFilter);
                this.dataFilter = null;
                this.bData_filter = false;
                break;
            }
            case "protein_group": {
                this.addProteinListToProteinGroup();
                this.proteinGroupList.add(this.proteinGroup);
                this.proteinGroup = null;
                this.bProtein_group = false;
                break;
            }
            case "protein": {
                this.addNameValueTypeListToProtein();
                this.addAnalysisResultListToProtein();
                this.addIndistinguishableProteinListToProtein();
                this.addPeptideListToProtein();
                this.proteinList.add(this.protein);
                this.protein = null;
                this.bProtein = false;
                break;
            }
            case "parameter": {
                if (this.bPeptide) {
                    this.peptideParameterList.add(this.peptideParameter);
                    this.peptideParameter = null;
                    this.bParameter = false;
                    break;
                }
                if (this.bIndistinguishable_protein) {
                    this.indistinguishableProteinNameValueTypeList.add(this.indistinguishableProteinNameValueType);
                    this.indistinguishableProteinNameValueType = null;
                    this.bIndistinguishableProteinNameValueType = false;
                    break;
                }
                if (this.bProtein) {
                    this.proteinNameValueTypeList.add(this.proteinNameValueType);
                    this.proteinNameValueType = null;
                    this.bProteinNameValueType = false;
                    break;
                }
                this.logger.error("Parameter at unexpected position");
                break;
            }
            case "analysis_result": {
                this.analysisResultList.add(this.analysisResult);
                this.analysisResult = null;
                this.bAnalysis_result = false;
                break;
            }
            case "annotation": {
                if (this.bIndistinguishable_protein) {
                    this.indistinguishableProtein.setAnnotation(this.annotationIP);
                    this.annotationIP = null;
                } else {
                    this.protein.setAnnotation(this.annotation);
                    this.annotation = null;
                }
                this.bAnnotation = false;
                break;
            }
            case "indistinguishable_protein": {
                this.addNameValueTypeListToIndistinguishableProtein();
                this.indistinguishableProteinList.add(this.indistinguishableProtein);
                this.indistinguishableProtein = null;
                this.bIndistinguishable_protein = false;
                break;
            }
            case "peptide": {
                this.addParameterListToPeptide();
                this.addModificationInfoListToPeptide();
                this.addPeptideParentProteinListToPeptide();
                this.addIndistinguishablePeptideListToPeptide();
                this.peptideList.add(this.peptide);
                this.peptide = null;
                this.bPeptide = false;
                break;
            }
            case "modification_info": {
                if (this.bIndistinguishable_peptide) {
                    this.addModAminoAcidMassIPListToModificationInfoIP();
                    this.modificationInfoIPList.add(this.modificationInfoIP);
                    this.modificationInfoIP = null;
                } else {
                    this.addModAminoAcidMassListToModificationInfo();
                    this.modificationInfoList.add(this.modificationInfo);
                    this.modificationInfo = null;
                }
                this.bModification_info = false;
                break;
            }
            case "mod_aminoacid_mass": {
                if (this.bIndistinguishable_peptide) {
                    this.modAminoacidMassIPList.add(this.modAminoacidMassIP);
                    this.modAminoacidMassIP = null;
                } else {
                    this.modAminoacidMassList.add(this.modAminoacidMass);
                    this.modAminoacidMass = null;
                }
                this.bMod_aminoacid_mass = false;
                break;
            }
            case "peptide_parent_protein": {
                this.peptideParentProteinList.add(this.peptideParentProtein);
                this.peptideParentProtein = null;
                this.bPeptide_parent_protein = false;
                break;
            }
            case "indistinguishable_peptide": {
                if (this.bIndistinguishable_peptide) {
                    this.addModificationInfoIPListToIndistinguishablePeptide();
                    this.indistinguishablePeptideList.add(this.indistinguishablePeptide);
                } else {
                    this.addModificationInfoListToPeptide();
                    this.peptideList.add(this.peptide);
                }
                this.indistinguishablePeptide = null;
                this.bIndistinguishable_peptide = false;
                break;
            }
            case "Empty": {
                this.analysisResult.setAny(this.PD_empty);
                this.PD_empty = null;
                this.bPD_Empty = false;
                break;
            }
            case "ProcessingNodeSummary": {
                this.PD_processingNodeSummary.setParameterList(this.PD_parameterList);
                this.analysisSummary.setAny(this.PD_processingNodeSummary);
                this.PD_parameterList.clear();
                this.PD_parameterList = null;
                this.PD_processingNodeSummary = null;
                this.bPD_ProcessingNodeSummary = false;
                break;
            }
            case "SearchSummary": {
                if (this.bHandleSearchSummary) {
                    this.programDetails.setAny(this.PD_searchSummary);
                }
                this.bPD_SearchSummary = false;
                break;
            }
            case "Parameter": {
                this.PD_parameterList.add(this.PD_parameter);
                this.PD_parameter = null;
                this.bPD_Parameter = false;
                break;
            }
            case "libra_summary": {
                this.addFragmentMassesListToLibraSummary();
                this.libraSummary = null;
                this.bLibra_summary = false;
                break;
            }
            case "fragment_masses": {
                this.fragmentMasses = null;
                this.bFragment_masses = false;
                break;
            }
            case "isotopic_contributions": {
                this.addContributingChannelListToIsotopicContributions();
                this.libraSummary.setIsotopicContributions(this.isotopicContributions);
                this.isotopicContributions = null;
                this.bIsotopic_contributions = false;
                break;
            }
            case "contributing_channel": {
                this.addAffectedChannelListToContributingChannel();
                this.contributingChannel = null;
                this.bContributing_channel = false;
                break;
            }
            case "affected_channel": {
                this.affectedChannel = null;
                this.bAffected_channel = false;
                break;
            }
            case "libra_result": {
                this.addIntensityListToLibraResult();
                this.libraResult = null;
                this.bLibra_result = false;
                break;
            }
            case "Intensity": {
                this.intensity = null;
                this.bIntensity = false;
                break;
            }
            case "ASAP_prot_analysis_summary": {
                this.asapProtAnalysisSummary = null;
                this.bASAP_prot_analysis_summary = false;
                break;
            }
            case "ASAP_pvalue_analysis_summary": {
                this.asapPvalueAnalysisSummary = null;
                this.bASAP_pvalue_analysis_summary = false;
                break;
            }
            case "ASAPRatio_pvalue": {
                this.asapRatioPvalue = null;
                this.bASAPRatio_pvalue = false;
                break;
            }
            case "ASAPRatio": {
                this.addASAPSeqListToASAPRatio();
                this.asapRatio = null;
                this.bASAPRatio = false;
                break;
            }
            case "ASAP_Seq": {
                this.addASAPPeakListToASAPSeq();
                this.asapSeq = null;
                this.bASAP_Seq = false;
                break;
            }
            case "ASAP_Peak": {
                this.addASAPDtaListToASAPPeak();
                this.asapPeak = null;
                this.bASAP_Peak = false;
                break;
            }
            case "ASAP_Dta": {
                this.asapDta = null;
                this.bIntensity = false;
                break;
            }
            case "XPress_analysis_summary": {
                this.xpressAnalysisSummary = null;
                this.bXPress_analysis_summary = false;
                break;
            }
            case "proteinprophet_details": {
                this.addProteinSummaryDataFilterListToProteinprophetDetails();
                this.proteinprophetDetails = null;
                this.bProteinprophet_details = false;
                break;
            }
            case "nsp_information": {
                this.addNspDistributionListToNspInformation();
                this.proteinprophetDetails.setNspInformation(this.nspInformation);
                this.nspInformation = null;
                this.bNsp_information = false;
                break;
            }
            case "ni_information": {
                this.addNiDistributionListToNiInformation();
                this.proteinprophetDetails.setNiInformation(this.niInformation);
                this.niInformation = null;
                this.bNi_information = false;
                break;
            }
            case "protein_summary_data_filter": {
                this.proteinSummaryDataFilter = null;
                this.bProtein_summary_data_filter = false;
                break;
            }
            case "nsp_distribution": {
                this.nspDistribution = null;
                this.bNsp_distribution = false;
                break;
            }
            case "ni_distribution": {
                this.niDistribution = null;
                this.bNi_distribution = false;
                break;
            }
            default: {
                this.logger.error("************ UNHANDLED END ELEMENT    : " + qName);
            }
        }
        this.lastActivated = "";
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String tmpStr = new String(ch, start, length).trim();
        if (this.bProtein_summary && this.lastActivated.equals("protein_summary")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"protein_summary\"): ");
        } else if (this.bProtein_summary_header && this.lastActivated.equals("protein_summary_header")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"protein_summary_header\"): ");
        } else if (this.bProgram_details && this.lastActivated.equals("program_details")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"program_details\"): ");
        } else if (this.bAnalysis_summary && this.lastActivated.equals("analysis_summary")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"analysis_summary\"): ");
        } else if (this.bDataset_derivation && this.lastActivated.equals("dataset_derivation")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"dataset_derivation\"): ");
        } else if (this.bData_filter && this.lastActivated.equals("data_filter")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"data_filter\"): ");
        } else if (this.bProtein_group && this.lastActivated.equals("protein_group")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"protein_group\"): ");
        } else if (this.bProtein && this.lastActivated.equals("protein")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"protein\"): ");
        } else if (this.bParameter && this.lastActivated.equals("parameter")) {
            if (this.bPeptide) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"parameter\"): ");
            } else {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"parameter\")(AS NameValueType): ");
            }
        } else if (this.bAnalysis_result && this.lastActivated.equals("analysis_result")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"analysis_result\"): ");
        } else if (this.bAnnotation && this.lastActivated.equals("annotation")) {
            if (this.bIndistinguishable_protein) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"annotation\"): ");
            } else {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"annotation(IP)\"): ");
            }
        } else if (this.bIndistinguishable_protein && this.lastActivated.equals("indistinguishable_protein")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"indistinguishable_protein\"): ");
        } else if (this.bPeptide && this.lastActivated.equals("peptide")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"peptide\"): ");
        } else if (this.bModification_info && this.lastActivated.equals("modification_info")) {
            if (this.bPeptide) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"modification_info\"): ");
            } else {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"modification_info(IP)\"): ");
            }
        } else if (this.bMod_aminoacid_mass && this.lastActivated.equals("mod_aminoacid_mass")) {
            if (this.bPeptide) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"mod_aminoacid_mass\"): ");
            } else {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"mod_aminoacid_mass(IP)\"): ");
            }
        } else if (this.bPeptide_parent_protein && this.lastActivated.equals("peptide_parent_protein")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"peptide_parent_protein\"): ");
        } else if (this.bIndistinguishable_peptide && this.lastActivated.equals("indistinguishable_peptide")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"indistinguishable_peptide\"): ");
        } else if (this.bPD_ProcessingNodeSummary && this.lastActivated.equals("ProcessingNodeSummary")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"PD_ProcessingNodeSummary\"): ");
        } else if (this.bPD_SearchSummary && this.lastActivated.equals("SearchSummary")) {
            if (this.bHandleSearchSummary) {
                int pos = tmpStr.indexOf(10);
                if (pos > -1) {
                    String tmpStr1 = tmpStr.substring(0, pos);
                    this.handleSearchSummaryParameters(tmpStr1);
                    String tmpStr2 = tmpStr.substring(pos + 1);
                    this.handleSearchSummaryParameters(tmpStr2);
                } else {
                    this.handleSearchSummaryParameters(tmpStr);
                }
            }
        } else if (this.bPD_Parameter && this.lastActivated.equals("Parameter")) {
            this.PD_parameter.setValue(tmpStr);
            this.bPD_Parameter = false;
        } else if (this.bLibra_summary && this.lastActivated.equals("libra_summary")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"libra_summary\"): ");
        } else if (this.bFragment_masses && this.lastActivated.equals("fragment_masses")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"fragment_masses\"): ");
        } else if (this.bIsotopic_contributions && this.lastActivated.equals("isotopic_contributions")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"isotopic_contributions\"): ");
        } else if (this.bContributing_channel && this.lastActivated.equals("contributing_channel")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"contributing_channel\"): ");
        } else if (this.bAffected_channel && this.lastActivated.equals("affected_channel")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"affected_channel\"): ");
        } else if (this.bLibra_result && this.lastActivated.equals("libra_result")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"libra_result\"): ");
        } else if (this.bIntensity && this.lastActivated.equals("intensity")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"intensity\"): ");
        } else if (this.bXPress_analysis_summary && this.lastActivated.equals("XPress_analysis_summary")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"XPress_analysis_summary\"): ");
        } else if (this.bProteinprophet_details && this.lastActivated.equals("proteinprophet_details")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"proteinprophet_details\"): ");
        } else if (this.bNsp_information && this.lastActivated.equals("nsp_information")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"nsp_information\"): ");
        } else if (this.bNi_information && this.lastActivated.equals("ni_Information")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"ni_Information\"): ");
        } else if (this.bProtein_summary_data_filter && this.lastActivated.equals("protein_summary_data_filter")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"protein_summary_data_filter\"): ");
        } else if (this.bNsp_distribution && this.lastActivated.equals("nsp_distribution")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"nsp_distribution\"): ");
        } else if (this.bNi_distribution && this.lastActivated.equals("ni_distribution")) {
            this.checkIfCharactersAreEmpty(tmpStr, "characters(\"ni_distribution\"): ");
        } else if (tmpStr.length() > 0) {
            this.logger.error("############ start characters(" + length + "): " + tmpStr);
        }
    }

    private void handleSearchSummaryParameters(String tmpStr) {
        String[] ssStrs;
        String ss_str = tmpStr;
        String[] stringArray = ssStrs = ss_str.split(MyConstants.newline);
        int n = ssStrs.length;
        int n2 = 0;
        while (n2 < n) {
            String ssStr = stringArray[n2];
            if (this.checkForMeaningfulContent(ssStr) && this.isNotAllWhiteSpace(ssStr)) {
                String retStr = this.removeEqualsAndHyphens(ssStr);
                if (this.checkForMeaningfulContent(retStr)) {
                    if (retStr.indexOf(58) >= 0) {
                        String valueStr;
                        String keyStr;
                        if (this.isAFileName(retStr)) {
                            keyStr = "File Name(s)";
                            valueStr = retStr.trim();
                        } else {
                            keyStr = this.getKeyFromStr(retStr).trim();
                            valueStr = this.getValueFromStr(retStr).trim();
                        }
                        if (!this.isAFileName(keyStr) && !this.isAFileName(valueStr)) {
                            if (!this.PD_searchSummary.isInvalidPDKey(keyStr)) {
                                if (!valueStr.isEmpty() && keyStr.startsWith("Processing node ")) {
                                    if (this.PD_searchSummary.isProteomeDiscovererNodeString(valueStr)) {
                                        this.SearchMachineForParameters = this.PD_searchSummary.getPDNodePrefixString(valueStr);
                                        this.setProcessingNode();
                                    } else {
                                        this.logger.error("Unrecognized Proteome Discoverer Node Type: " + valueStr);
                                        this.SearchMachineForParameters = "";
                                    }
                                }
                                if (!valueStr.isEmpty()) {
                                    String translatedKeyStr = this.translatePDParameterNameToCVName(keyStr);
                                    String validKeyStr = this.tryToGetValidOntologyTerm(translatedKeyStr, valueStr);
                                    if (!validKeyStr.isEmpty()) {
                                        if (!this.PD_searchSummary.getParamsMap().containsKey(validKeyStr)) {
                                            this.PD_searchSummary.addToParamsMap(validKeyStr, valueStr);
                                            this.logger.trace("INFO: Added(key + value): " + validKeyStr + "\t" + valueStr + MyConstants.newline);
                                        } else {
                                            this.logger.trace("Key " + validKeyStr + " already contained in paramsMap of PD_searchSummary");
                                        }
                                    } else if (!keyStr.startsWith("Processing node ")) {
                                        this.logger.info("INFO: Not used - keyStr:" + translatedKeyStr + "\tvalueStr: " + valueStr);
                                    }
                                }
                            } else {
                                this.logger.trace("INFO: Not a valid PD key: " + keyStr);
                            }
                        } else {
                            if (this.isAFileName(keyStr)) {
                                this.PD_searchSummary.addToFullFileNamesList(keyStr);
                            }
                            if (this.isAFileName(valueStr)) {
                                this.PD_searchSummary.addToFullFileNamesList(valueStr);
                            }
                        }
                    } else {
                        this.PD_searchSummary.addToParamsMap(retStr, "");
                        this.logger.debug("INFO: Added (only key): " + retStr);
                    }
                } else {
                    this.logger.error("INFO: characters(\"PD_SearchSummary\") NOT MEANINGFUL 2: retStr" + retStr);
                }
            } else if (this.isNotAllWhiteSpace(ssStr)) {
                this.logger.trace("INFO: characters(\"PD_SearchSummary\") NOT MEANINGFUL 1: " + ssStr);
            }
            ++n2;
        }
    }

    public String translatePDParameterNameToCVName(String parName) {
        String retStr = parName;
        if (parName.endsWith("S/N Threshold")) {
            retStr = parName.replace("S/N Threshold", "SN Threshold");
        } else if (parName.endsWith("Target FDR (Relaxed)")) {
            retStr = parName.replace("Target FDR (Relaxed)", "Target FDR Relaxed");
        } else if (parName.endsWith("Target FDR (Strict)")) {
            retStr = parName.replace("Target FDR (Strict)", "Target FDR Strict");
        } else if (parName.endsWith("Max. identical Modifications Per Peptide")) {
            retStr = parName.replace("Max. identical Modifications Per Peptide", "Max Identical Modifications Per Peptide");
        } else if (parName.endsWith("Max. Modifications Per Peptide")) {
            retStr = parName.replace("Max. Modifications Per Peptide", "Max Modifications Per Peptide");
        } else if (parName.endsWith("Max. Precursor Mass")) {
            retStr = parName.replace("Max. Precursor Mass", "Max Precursor Mass");
        } else if (parName.endsWith("Min. Precursor Mass")) {
            retStr = parName.replace("Min. Precursor Mass", "Min Precursor Mass");
        } else if (parName.endsWith("Max. MGF File Size [MB]")) {
            retStr = parName.replace("Max. MGF File Size [MB]", "Max MGF File Size");
        } else if (parName.endsWith("Time interval between attempts to submit a search [sec]")) {
            retStr = parName.replace("Time interval between attempts to submit a search [sec]", "Time interval between attempts to submit a search");
        } else if (parName.endsWith("Peptide Cut Off Score")) {
            retStr = parName.replace("Peptide Cut Off Score", "Peptide CutOff Score");
        } else if (parName.endsWith("S/N Threshold (FTonly)")) {
            retStr = parName.replace("S/N Threshold (FTonly)", "SN Threshold FTonly");
        } else if (parName.endsWith("Top N")) {
            retStr = parName.replace("Top N", "Sequest:TopNumber");
        } else if (parName.endsWith("Please Don't Touch this")) {
            retStr = parName.replace("Please Don't Touch this", "Please Do not Touch this");
        }
        return retStr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String tryToGetValidOntologyTerm(String keyStr, String valueStr) {
        if (this.isUserParamKeyStr(keyStr)) {
            return keyStr;
        }
        if (!keyStr.startsWith("Processing node ")) {
            if (this.isValidMSOntologyTerm(keyStr)) return keyStr;
            this.logger.trace(String.valueOf(MyConstants.newline) + keyStr + " is not valid(1)");
            String tmpKeyStr = String.valueOf("ProteomeDiscoverer:") + keyStr;
            if (this.isValidMSOntologyTerm(tmpKeyStr)) return tmpKeyStr;
            this.logger.trace(String.valueOf(tmpKeyStr) + " is not valid(2)");
            if (this.SearchMachineForParameters.isEmpty()) return "";
            tmpKeyStr = String.valueOf("ProteomeDiscoverer:") + this.SearchMachineForParameters + keyStr;
            if (this.isValidMSOntologyTerm(tmpKeyStr)) return tmpKeyStr;
            this.logger.trace(String.valueOf(tmpKeyStr) + " is not valid(3)");
            return "";
        } else {
            this.currentProcessingNodeName = valueStr;
        }
        return "";
    }

    private boolean isUserParamKeyStr(String keyStr) {
        return keyStr.equals("Calculate Probability Scores") || keyStr.equals("File name(s)") || keyStr.equals("File Name(s)") || keyStr.equals("First Scan") || keyStr.equals("Last Scan") || keyStr.equals("Peptide Without Protein Cut Off Score") || keyStr.equals("Peptide Without Protein Score Cut Off") || keyStr.equals("Peptide Without Protein XCorr Threshold") || keyStr.equals("Quantification method") || keyStr.equals("RT tolerance of isotope pattern multiplets") || keyStr.equals("Search date") || keyStr.equals("Search description") || keyStr.equals("Search name") || keyStr.equals("Single-Peak/Missing channels allowed") || keyStr.equals("Spectrum Confidence") || keyStr.equals("Use Fragment Mass Tolerance of Search Node") || keyStr.equals("Validation based on");
    }

    private boolean isValidMSOntologyTerm(String termStr) {
        return OBOInitialRead.isValidTerm((String)termStr, (String)"MS") || CVQuery.isValidTerm((String)termStr, (String)"MS");
    }

    private boolean isAFileName(String testStr) {
        String tmpStr = testStr.trim();
        return tmpStr.indexOf(":\\") == 1 && tmpStr.indexOf(46) > 0;
    }

    private void setProcessingNode() {
        String tmpStr;
        switch (tmpStr = this.SearchMachineForParameters.substring(0, this.SearchMachineForParameters.length() - 1)) {
            case "Mascot": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.Mascot)) break;
                this.usedProcessingNodes.add(ProcessingNodes.Mascot);
                this.logger.debug("Search machine found: " + tmpStr);
                break;
            }
            case "SEQUEST": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.SEQUEST)) break;
                this.usedProcessingNodes.add(ProcessingNodes.SEQUEST);
                this.logger.debug("Search machine found: " + tmpStr);
                break;
            }
            case "ZCore": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.ZCore)) break;
                this.usedProcessingNodes.add(ProcessingNodes.ZCore);
                this.logger.debug("Search machine found: " + tmpStr);
                break;
            }
            case "Sequest HT": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.SequestHT)) break;
                this.usedProcessingNodes.add(ProcessingNodes.SequestHT);
                this.logger.debug("Search machine found: " + tmpStr);
                break;
            }
            case "Annotation": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.Annotation)) break;
                this.usedProcessingNodes.add(ProcessingNodes.Annotation);
                this.logger.debug("Annotation processing node found: " + tmpStr);
                break;
            }
            case "AmandaPeptideIdentifier": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.AmandaPeptideIdentifier)) break;
                this.usedProcessingNodes.add(ProcessingNodes.AmandaPeptideIdentifier);
                this.logger.debug("Annotation processing node found: " + tmpStr);
                break;
            }
            case "ETD Spectrum Charger": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.ETDSpectrumCharger)) break;
                this.usedProcessingNodes.add(ProcessingNodes.ETDSpectrumCharger);
                this.logger.debug("Spectrum processing node found: " + tmpStr);
                break;
            }
            case "Event Detector": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.EventDetector)) break;
                this.usedProcessingNodes.add(ProcessingNodes.EventDetector);
                this.logger.debug("Spectrum and feature retrieval processing node found: " + tmpStr);
                break;
            }
            case "Fixed Value PSM Validator Node": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.FixedValuePsmValidatorNode)) break;
                this.usedProcessingNodes.add(ProcessingNodes.FixedValuePsmValidatorNode);
                this.logger.debug("Spectrum and feature retrieval processing node found: " + tmpStr);
                break;
            }
            case "Ise Node": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.IseNode)) break;
                this.usedProcessingNodes.add(ProcessingNodes.IseNode);
                this.logger.debug("Spectrum and feature retrieval processing node found: " + tmpStr);
                break;
            }
            case "MSPepSearch": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.MSPepSearch)) break;
                this.usedProcessingNodes.add(ProcessingNodes.MSPepSearch);
                this.logger.debug("Spectrum and feature retrieval processing node found: " + tmpStr);
                break;
            }
            case "Noise Peak Filter": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.NoisePeakFilter)) break;
                this.usedProcessingNodes.add(ProcessingNodes.NoisePeakFilter);
                this.logger.debug("Spectrum processing node found: " + tmpStr);
                break;
            }
            case "Non-Fragment Filter": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.NonFragmentFilter)) break;
                this.usedProcessingNodes.add(ProcessingNodes.NonFragmentFilter);
                this.logger.debug("Spectrum processing node found: " + tmpStr);
                break;
            }
            case "Peptide Validator": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.PeptideValidator)) break;
                this.usedProcessingNodes.add(ProcessingNodes.PeptideValidator);
                this.logger.debug("Peptide validation processing node found: " + tmpStr);
                break;
            }
            case "Percolator": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.Percolator)) break;
                this.usedProcessingNodes.add(ProcessingNodes.Percolator);
                this.logger.debug("Protein validation processing node found: " + tmpStr);
                break;
            }
            case "phosphoRS 3.0": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.PhosphoRS3_0)) break;
                this.usedProcessingNodes.add(ProcessingNodes.PhosphoRS3_0);
                this.logger.debug("Protein validation processing node found: " + tmpStr);
                break;
            }
            case "Precursor Ions Area Detector": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.PrecursorIonsAreaDetector)) break;
                this.usedProcessingNodes.add(ProcessingNodes.PrecursorIonsAreaDetector);
                this.logger.debug("Quantification processing node found: " + tmpStr);
                break;
            }
            case "Precursor Ions Quantifier": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.PrecursorIonsQuantifier)) break;
                this.usedProcessingNodes.add(ProcessingNodes.PrecursorIonsQuantifier);
                this.logger.debug("Quantification processing node found: " + tmpStr);
                break;
            }
            case "PTM Site Scorer": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.PTMSiteScorer)) break;
                this.usedProcessingNodes.add(ProcessingNodes.PTMSiteScorer);
                this.logger.debug("Quantification processing node found: " + tmpStr);
                break;
            }
            case "Re-Annotation": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.ReAnnotation)) break;
                this.usedProcessingNodes.add(ProcessingNodes.ReAnnotation);
                this.logger.debug("Annotation processing node found: " + tmpStr);
                break;
            }
            case "Reporter Ions Quantifier": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.ReporterIonQuantifier)) break;
                this.usedProcessingNodes.add(ProcessingNodes.ReporterIonQuantifier);
                this.logger.debug("Quantification processing node found: " + tmpStr);
                break;
            }
            case "Scan Event Filter": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.ScanEventFilter)) break;
                this.usedProcessingNodes.add(ProcessingNodes.ScanEventFilter);
                this.logger.debug("Spectrum filter processing node found: " + tmpStr);
                break;
            }
            case "Spectra ST": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.SpectraST)) break;
                this.usedProcessingNodes.add(ProcessingNodes.SpectraST);
                this.logger.debug("Spectrum filter processing node found: " + tmpStr);
                break;
            }
            case "Spectrum Confidence Filter": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.SpectrumConfidenceFilter)) break;
                this.usedProcessingNodes.add(ProcessingNodes.SpectrumConfidenceFilter);
                this.logger.debug("Spectrum filter processing node found: " + tmpStr);
                break;
            }
            case "Spectrum Exporter": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.SpectrumExporter)) break;
                this.usedProcessingNodes.add(ProcessingNodes.SpectrumExporter);
                this.logger.debug("Processing node found: " + tmpStr);
                break;
            }
            case "Spectrum Files": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.SpectrumFiles)) break;
                this.usedProcessingNodes.add(ProcessingNodes.SpectrumFiles);
                this.logger.debug("Data input processing node found: " + tmpStr);
                break;
            }
            case "Spectrum Grouper": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.SpectrumGrouper)) break;
                this.usedProcessingNodes.add(ProcessingNodes.SpectrumGrouper);
                this.logger.debug("Spectrum processing node found: " + tmpStr);
                break;
            }
            case "Spectrum Normalizer": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.SpectrumNormalizer)) break;
                this.usedProcessingNodes.add(ProcessingNodes.SpectrumNormalizer);
                this.logger.debug("Spectrum processing node found: " + tmpStr);
                break;
            }
            case "Spectrum Properties Filter": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.SpectrumPropertiesFilter)) break;
                this.usedProcessingNodes.add(ProcessingNodes.SpectrumPropertiesFilter);
                this.logger.debug("Spectrum filter processing node found: " + tmpStr);
                break;
            }
            case "Spectrum Score Filter": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.SpectrumScoreFilter)) break;
                this.usedProcessingNodes.add(ProcessingNodes.SpectrumScoreFilter);
                this.logger.debug("Processing node found: " + tmpStr);
                break;
            }
            case "Spectrum Selector": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.SpectrumSelector)) break;
                this.usedProcessingNodes.add(ProcessingNodes.SpectrumSelector);
                this.logger.debug("Spectrum and feature retrieval processing node found: " + tmpStr);
                break;
            }
            case "SRF File Selector": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.SRFFileSelector)) break;
                this.usedProcessingNodes.add(ProcessingNodes.SRFFileSelector);
                this.logger.debug("Data input processing node found: " + tmpStr);
                break;
            }
            case "Target Decoy PSM Validator": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.TargetDecoyPSMValidator)) break;
                this.usedProcessingNodes.add(ProcessingNodes.TargetDecoyPSMValidator);
                this.logger.debug("Data input processing node found: " + tmpStr);
                break;
            }
            case "Top N Peaks Filter": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.TopNPeaksFilter)) break;
                this.usedProcessingNodes.add(ProcessingNodes.TopNPeaksFilter);
                this.logger.debug("Spectrum processing node found: " + tmpStr);
                break;
            }
            case "Xtract": {
                if (this.usedProcessingNodes.contains((Object)ProcessingNodes.Xtract)) break;
                this.usedProcessingNodes.add(ProcessingNodes.Xtract);
                this.logger.debug("Processing node found: " + tmpStr);
                break;
            }
            default: {
                this.logger.error("Unhandled Proteome Discoverer processing node infos found: " + tmpStr);
            }
        }
    }

    private void setProteinSummaryAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr = atts.getQName(i);
            if (tmpStr.equals("summary_xml")) {
                this.proteinSummary.setSummaryXml(atts.getValue(i));
            } else {
                this.logger.error("++++++++++++ Unknown attribute in protein_summary: " + tmpStr);
            }
            ++i;
        }
    }

    private void setProteinSummaryHeaderAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "reference_database": {
                    this.proteinSummaryHeader.setReferenceDatabase(atts.getValue(i));
                    break;
                }
                case "win-cyg_reference_database": {
                    this.proteinSummaryHeader.setWinCygReferenceDatabase(atts.getValue(i));
                    break;
                }
                case "residue_substitution_list": {
                    this.proteinSummaryHeader.setResidueSubstitutionList(atts.getValue(i));
                    break;
                }
                case "organism": {
                    this.proteinSummaryHeader.setOrganism(atts.getValue(i));
                    break;
                }
                case "source_files": {
                    this.proteinSummaryHeader.setSourceFiles(atts.getValue(i));
                    break;
                }
                case "source_files_alt": {
                    this.proteinSummaryHeader.setSourceFilesAlt(atts.getValue(i));
                    break;
                }
                case "win-cyg_source_files": {
                    this.proteinSummaryHeader.setWinCygSourceFiles(atts.getValue(i));
                    break;
                }
                case "source_file_xtn": {
                    this.proteinSummaryHeader.setSourceFileXtn(atts.getValue(i));
                    break;
                }
                case "min_peptide_probability": {
                    this.proteinSummaryHeader.setMinPeptideProbability(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "min_peptide_weight": {
                    this.proteinSummaryHeader.setMinPeptideWeight(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "num_predicted_correct_prots": {
                    this.proteinSummaryHeader.setNumPredictedCorrectProts(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "num_input_1_spectra": {
                    this.proteinSummaryHeader.setNumInput1Spectra(this.getBigIntFromStr(atts.getValue(i)));
                    break;
                }
                case "num_input_2_spectra": {
                    this.proteinSummaryHeader.setNumInput2Spectra(this.getBigIntFromStr(atts.getValue(i)));
                    break;
                }
                case "num_input_3_spectra": {
                    this.proteinSummaryHeader.setNumInput3Spectra(this.getBigIntFromStr(atts.getValue(i)));
                    break;
                }
                case "num_input_4_spectra": {
                    this.proteinSummaryHeader.setNumInput4Spectra(this.getBigIntFromStr(atts.getValue(i)));
                    break;
                }
                case "num_input_5_spectra": {
                    this.proteinSummaryHeader.setNumInput5Spectra(this.getBigIntFromStr(atts.getValue(i)));
                    break;
                }
                case "initial_min_peptide_prob": {
                    this.proteinSummaryHeader.setInitialMinPeptideProb(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "total_no_spectrum_ids": {
                    this.proteinSummaryHeader.setTotalNoSpectrumIds(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "sample_enzyme": {
                    this.proteinSummaryHeader.setSampleEnzyme(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in protein_summary_header: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setProgramDetailsAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "analysis": {
                    this.programDetails.setAnalysis(atts.getValue(i));
                    break;
                }
                case "time": {
                    this.programDetails.setTime(XMLGregorianCalendarConverter.getXMLGregorianCalendar((String)atts.getValue(i), (String)"yyyy-MM-dd"));
                    break;
                }
                case "version": {
                    this.programDetails.setVersion(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in program_details: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setAnalysisSummaryAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "analysis": {
                    this.analysisSummary.setAnalysis(atts.getValue(i));
                    break;
                }
                case "time": {
                    this.analysisSummary.setTime(XMLGregorianCalendarConverter.getXMLGregorianCalendar((String)atts.getValue(i), (String)"yyyy-MM-dd"));
                    break;
                }
                case "id": {
                    try {
                        this.analysisSummary.setId(this.getBigIntFromStr(atts.getValue(i)));
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace(System.err);
                    }
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in analysis_summary: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setDatasetDerivationAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr = atts.getQName(i);
            if (tmpStr.equals("generation_no")) {
                this.datasetDerivation.setGenerationNo(atts.getValue(i));
            } else {
                this.logger.error("++++++++++++ Unknown attribute in dataset_derivation: " + tmpStr);
            }
            ++i;
        }
    }

    private void setDataFilterAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "number": {
                    this.dataFilter.setNumber(atts.getValue(i));
                    break;
                }
                case "parent_file": {
                    this.dataFilter.setParentFile(atts.getValue(i));
                    break;
                }
                case "windows_parent": {
                    this.dataFilter.setWindowsParent(atts.getValue(i));
                    break;
                }
                case "description": {
                    this.dataFilter.setDescription(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in data_filter: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setProteinGroupAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "group_number": {
                    this.proteinGroup.setGroupNumber(atts.getValue(i));
                    break;
                }
                case "pseudo_name": {
                    this.proteinGroup.setPseudoName(atts.getValue(i));
                    break;
                }
                case "probability": {
                    this.proteinGroup.setProbability(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in protein_group: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setProteinAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "protein_name": {
                    this.protein.setProteinName(atts.getValue(i));
                    break;
                }
                case "probability": {
                    this.protein.setProbability(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "percent_coverage": {
                    this.protein.setPercentCoverage(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "n_indistinguishable_proteins": {
                    this.protein.setNIndistinguishableProteins(this.getBigIntFromStr(atts.getValue(i)));
                    break;
                }
                case "unique_stripped_peptides": {
                    this.protein.setUniqueStrippedPeptides(atts.getValue(i));
                    break;
                }
                case "group_sibling_id": {
                    this.protein.setGroupSiblingId(atts.getValue(i));
                    break;
                }
                case "total_number_peptides": {
                    this.protein.setTotalNumberPeptides(this.getBigIntFromStr(atts.getValue(i)));
                    break;
                }
                case "subsuming_protein_entry": {
                    this.protein.setSubsumingProteinEntry(atts.getValue(i));
                    break;
                }
                case "pct_spectrum_ids": {
                    this.protein.setPctSpectrumIds(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in protein: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setParameterAttributes(ProteinSummary.ProteinGroup.Protein.Peptide.Parameter parameter, Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "name": {
                    parameter.setName(atts.getValue(i));
                    break;
                }
                case "value": {
                    parameter.setValue(atts.getValue(i));
                    break;
                }
                case "type": {
                    parameter.setType(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in parameter: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setNameValueTypeAttributes(NameValueType nameValueType, Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "name": {
                    nameValueType.setName(atts.getValue(i));
                    break;
                }
                case "value": {
                    nameValueType.setValue(atts.getValue(i));
                    break;
                }
                case "type": {
                    nameValueType.setType(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in nameValueType: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setAnalysisResultAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "analysis": {
                    this.analysisResult.setAnalysis(atts.getValue(i));
                    break;
                }
                case "id": {
                    this.analysisResult.setId(this.getBigIntFromStr(atts.getValue(i)));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in analysis_result: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setAnnotationAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "protein_description": {
                    this.annotation.setProteinDescription(atts.getValue(i));
                    break;
                }
                case "ipi_name": {
                    this.annotation.setIpiName(atts.getValue(i));
                    break;
                }
                case "refseq_name": {
                    this.annotation.setRefseqName(atts.getValue(i));
                    break;
                }
                case "swissprot_name": {
                    this.annotation.setSwissprotName(atts.getValue(i));
                    break;
                }
                case "ensembl_name": {
                    this.annotation.setEnsemblName(atts.getValue(i));
                    break;
                }
                case "trembl_name": {
                    this.annotation.setTremblName(atts.getValue(i));
                    break;
                }
                case "locus_link_name": {
                    this.annotation.setLocusLinkName(atts.getValue(i));
                    break;
                }
                case "flybase": {
                    this.annotation.setFlybase(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in annotation: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setAnnotationIPAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "protein_description": {
                    this.annotationIP.setProteinDescription(atts.getValue(i));
                    break;
                }
                case "ipi_name": {
                    this.annotationIP.setIpiName(atts.getValue(i));
                    break;
                }
                case "refseq_name": {
                    this.annotationIP.setRefseqName(atts.getValue(i));
                    break;
                }
                case "swissprot_name": {
                    this.annotationIP.setSwissprotName(atts.getValue(i));
                    break;
                }
                case "ensembl_name": {
                    this.annotationIP.setEnsemblName(atts.getValue(i));
                    break;
                }
                case "trembl_name": {
                    this.annotationIP.setTremblName(atts.getValue(i));
                    break;
                }
                case "locus_link_name": {
                    this.annotationIP.setLocusLinkName(atts.getValue(i));
                    break;
                }
                case "flybase": {
                    this.annotationIP.setFlybase(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in annotation(IP): " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setIndistinguishableProteinAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr = atts.getQName(i);
            if (tmpStr.equals("protein_name")) {
                this.indistinguishableProtein.setProteinName(atts.getValue(i));
            } else {
                this.logger.error("++++++++++++ Unknown attribute in indistinguishable_protein: " + tmpStr);
            }
            ++i;
        }
    }

    private void setPeptideAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "peptide_sequence": {
                    this.peptide.setPeptideSequence(atts.getValue(i));
                    break;
                }
                case "charge": {
                    this.peptide.setCharge(this.getBigIntFromStr(atts.getValue(i)));
                    break;
                }
                case "initial_probability": {
                    this.peptide.setInitialProbability(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "nsp_adjusted_probability": {
                    this.peptide.setNspAdjustedProbability(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "ni_adjusted_probability": {
                    this.peptide.setNiAdjustedProbability(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "exp_sibling_ion_instances": {
                    this.peptide.setExpSiblingIonInstances(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "exp_sibling_ion_bin": {
                    this.peptide.setExpSiblingIonBin(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "exp_tot_instances": {
                    this.peptide.setExpTotInstances(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "peptide_group_designator": {
                    this.peptide.setPeptideGroupDesignator(atts.getValue(i));
                    break;
                }
                case "weight": {
                    this.peptide.setWeight(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "is_nondegenerate_evidence": {
                    this.peptide.setIsNondegenerateEvidence(atts.getValue(i));
                    break;
                }
                case "n_enzymatic_termini": {
                    this.peptide.setNEnzymaticTermini(this.getBigIntFromStr(atts.getValue(i)));
                    break;
                }
                case "n_sibling_peptides": {
                    this.peptide.setNSiblingPeptides(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "n_sibling_peptides_bin": {
                    this.peptide.setNSiblingPeptidesBin(this.getBigIntFromStr(atts.getValue(i)));
                    break;
                }
                case "n_instances": {
                    this.peptide.setNInstances(this.getBigIntFromStr(atts.getValue(i)));
                    break;
                }
                case "calc_neutral_pep_mass": {
                    this.peptide.setCalcNeutralPepMass(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "is_contributing_evidence": {
                    this.peptide.setIsContributingEvidence(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in peptide: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setModificationInfoAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "mod_nterm_mass": {
                    this.modificationInfo.setModNtermMass(atts.getValue(i));
                    break;
                }
                case "mod_cterm_mass": {
                    this.modificationInfo.setModCtermMass(atts.getValue(i));
                    break;
                }
                case "modified_peptide": {
                    this.modificationInfo.setModifiedPeptide(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in modification_info: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setModificationInfoIPAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "mod_nterm_mass": {
                    this.modificationInfoIP.setModNtermMass(atts.getValue(i));
                    break;
                }
                case "mod_cterm_mass": {
                    this.modificationInfoIP.setModCtermMass(atts.getValue(i));
                    break;
                }
                case "modified_peptide": {
                    this.modificationInfoIP.setModifiedPeptide(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in modification_info(IP): " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setModAminoacidMassAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "position": {
                    this.modAminoacidMass.setPosition(atts.getValue(i));
                    break;
                }
                case "mass": {
                    this.modAminoacidMass.setMass(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in mod_aminoacid_mass: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setModAminoacidMassIPAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "position": {
                    this.modAminoacidMassIP.setPosition(atts.getValue(i));
                    break;
                }
                case "mass": {
                    this.modAminoacidMassIP.setMass(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in mod_aminoacid_mass(IP): " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setPeptideParentProteinAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr = atts.getQName(i);
            if (tmpStr.equals("protein_name")) {
                this.peptideParentProtein.setProteinName(atts.getValue(i));
            } else {
                this.logger.error("++++++++++++ Unknown attribute in peptide_parent_protein: " + tmpStr);
            }
            ++i;
        }
    }

    private void setIndistinguishablePeptideAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr = atts.getQName(i);
            if (tmpStr.equals("peptide_sequence")) {
                this.indistinguishablePeptide.setPeptideSequence(atts.getValue(i));
            } else {
                this.logger.error("++++++++++++ Unknown attribute in indistinguishable_peptide: " + tmpStr);
            }
            ++i;
        }
    }

    private void setLibraSummaryAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "mass_tolerance": {
                    this.libraSummary.setMassTolerance(Float.parseFloat(atts.getValue(i)));
                    break;
                }
                case "centroiding_preference": {
                    this.libraSummary.setCentroidingPreference(Integer.parseInt(atts.getValue(i)));
                    break;
                }
                case "normalization": {
                    this.libraSummary.setNormalization(Integer.parseInt(atts.getValue(i)));
                    break;
                }
                case "output_type": {
                    this.libraSummary.setOutputType(Integer.parseInt(atts.getValue(i)));
                    break;
                }
                case "channel_code": {
                    this.libraSummary.setChannelCode(atts.getValue(i));
                    break;
                }
                case "min_pep_prob": {
                    this.libraSummary.setMinPepProb(Float.parseFloat(atts.getValue(i)));
                    break;
                }
                case "min_pep_wt": {
                    this.libraSummary.setMinPepWt(Float.parseFloat(atts.getValue(i)));
                    break;
                }
                case "min_prot_prob": {
                    this.libraSummary.setMinProtProb(Float.parseFloat(atts.getValue(i)));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in libra_summary: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setFragmentMassesAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "channel": {
                    this.fragmentMasses.setChannel(Long.parseLong(atts.getValue(i)));
                    break;
                }
                case "mz": {
                    this.fragmentMasses.setMz(Float.parseFloat(atts.getValue(i)));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in fragment_masses: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setIsotopicContributionsAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr = atts.getQName(i);
            this.logger.error("++++++++++++ Unknown attribute in isotopic_contributions): " + tmpStr);
            ++i;
        }
    }

    private void setContributingChannelAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr = atts.getQName(i);
            if (tmpStr.equals("channel")) {
                this.contributingChannel.setChannel(Long.parseLong(atts.getValue(i)));
            } else {
                this.logger.error("++++++++++++ Unknown attribute in contributing_channel: " + tmpStr);
            }
            ++i;
        }
    }

    private void setAffectedChannelAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "channel": {
                    this.affectedChannel.setChannel(Long.parseLong(atts.getValue(i)));
                    break;
                }
                case "correction": {
                    this.affectedChannel.setCorrection(Float.parseFloat(atts.getValue(i)));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in affected_channel: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setLibraResultAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr = atts.getQName(i);
            if (tmpStr.equals("number")) {
                this.libraResult.setNumber(this.getBigIntFromStr(atts.getValue(i)));
            } else {
                this.logger.error("++++++++++++ Unknown attribute in libra_result: " + tmpStr);
            }
            ++i;
        }
    }

    private void setIntensityAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "mz": {
                    this.intensity.setMz(Float.parseFloat(atts.getValue(i)));
                    break;
                }
                case "ratio": {
                    this.intensity.setRatio(Float.parseFloat(atts.getValue(i)));
                    break;
                }
                case "error": {
                    this.intensity.setError(Float.parseFloat(atts.getValue(i)));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in intensity: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setASAPProtAnalysisSummaryAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "version": {
                    this.asapProtAnalysisSummary.setVersion(atts.getValue(i));
                    break;
                }
                case "bin_ref_files": {
                    this.asapProtAnalysisSummary.setBinaryRefFiles(atts.getValue(i));
                    break;
                }
                case "min_peptide_probability": {
                    this.asapProtAnalysisSummary.setMinPeptideProbability(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "min_peptide_weight": {
                    this.asapProtAnalysisSummary.setMinPeptideWeight(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "min_protein_probability": {
                    this.asapProtAnalysisSummary.setMinProteinProbability(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "reference_isotope": {
                    this.asapProtAnalysisSummary.setReferenceIsotope(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in ASAP_prot_analysis_summary: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setASAPPvalueAnalysisSummaryAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "asapratio_id": {
                    this.asapPvalueAnalysisSummary.setAsapProtId(this.getBigIntFromStr(atts.getValue(i)));
                    break;
                }
                case "background_ratio_mean": {
                    this.asapPvalueAnalysisSummary.setBackgroundRatioMean(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "background_ratio_stdev": {
                    this.asapPvalueAnalysisSummary.setBackgroundRatioStdev(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "background_fitting_error": {
                    this.asapPvalueAnalysisSummary.setBackgroundFittingError(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "analysis_distribution_file": {
                    this.asapPvalueAnalysisSummary.setAnalysisDistributionFile(atts.getValue(i));
                    break;
                }
                case "full_analysis_distr_file": {
                    this.asapPvalueAnalysisSummary.setFullAnalysisDistrFile(atts.getValue(i));
                    break;
                }
                case "asap_prot_id": {
                    this.asapPvalueAnalysisSummary.setAsapProtId(this.getBigIntFromStr(atts.getValue(i)));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in ASAP_pvalue_analysis_summary: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setASAPRatioPvalueAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "adj_ratio_mean": {
                    this.asapRatioPvalue.setAdjRatioMean(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "adj_ratio_standard_dev": {
                    this.asapRatioPvalue.setAdjRatioStandardDev(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "heavy2light_ratio_mean": {
                    this.asapRatioPvalue.setHeavy2LightAdjRatioMean(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "heavy2light_ratio_standard_dev": {
                    this.asapRatioPvalue.setHeavy2LightAdjRatioStandardDev(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "pvalue": {
                    this.asapRatioPvalue.setPvalue(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "decimal_pvalue": {
                    this.asapRatioPvalue.setDecimalPvalue(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in ASAPRatio_pvalue: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setASAPRatioAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "ratio_mean": {
                    this.asapRatio.setRatioMean(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "ratio_standard_dev": {
                    this.asapRatio.setRatioStandardDev(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "ratio_number_peptides": {
                    this.asapRatio.setRatioNumberPeptides(this.getBigIntFromStr(atts.getValue(i)));
                    break;
                }
                case "heavy2light_ratio_mean": {
                    this.asapRatio.setHeavy2LightRatioMean(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "heavy2light_ratio_standard_dev": {
                    this.asapRatio.setHeavy2LightRatioStandardDev(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "description": {
                    this.asapRatio.setDescription(atts.getValue(i));
                    break;
                }
                case "status": {
                    this.asapRatio.setStatus(atts.getValue(i));
                    break;
                }
                case "peptide_ins": {
                    this.asapRatio.setPeptideInds(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in ASAPRatio: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setASAPSeqAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "status": {
                    this.asapSeq.setStatus(atts.getValue(i));
                    break;
                }
                case "include": {
                    this.asapSeq.setInclude(atts.getValue(i));
                    break;
                }
                case "datanum": {
                    this.asapSeq.setDatanum(this.getBigIntFromStr(atts.getValue(i)));
                    break;
                }
                case "ratio_mean": {
                    this.asapSeq.setRatioMean(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "ratio_standard_dev": {
                    this.asapSeq.setRatioStandardDev(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "heavy2light_ratio_mean": {
                    this.asapSeq.setHeavy2LightRatioMean(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "heavy2light_ratio_standard_dev": {
                    this.asapSeq.setHeavy2LightRatioStandardDev(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "weight": {
                    this.asapSeq.setWeight(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "light_sequence": {
                    this.asapSeq.setLightSequence(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in ASAP_Seq: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setASAPPeakAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "status": {
                    this.asapPeak.setStatus(atts.getValue(i));
                    break;
                }
                case "include": {
                    this.asapPeak.setInclude(atts.getValue(i));
                    break;
                }
                case "datanum": {
                    this.asapPeak.setDatanum(this.getBigIntFromStr(atts.getValue(i)));
                    break;
                }
                case "ratio_mean": {
                    this.asapPeak.setRatioMean(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "ratio_standard_dev": {
                    this.asapPeak.setRatioStandardDev(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "heavy2light_ratio_mean": {
                    this.asapPeak.setHeavy2LightRatioMean(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "heavy2light_ratio_standard_dev": {
                    this.asapPeak.setHeavy2LightRatioStandardDev(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "weight": {
                    this.asapPeak.setWeight(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "peptide_binary_ind": {
                    this.asapPeak.setPeptideBinaryInd(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in ASAP_Peak: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setASAPDtaAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "peptide_index": {
                    this.asapDta.setPeptideIndex(atts.getValue(i));
                    break;
                }
                case "include": {
                    this.asapDta.setInclude(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in ASAP_Dta: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setXPressAnalysisSummaryAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "min_peptide_probability": {
                    this.xpressAnalysisSummary.setMinPeptideProbability(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "min_peptide_weight": {
                    this.xpressAnalysisSummary.setMinPeptideWeight(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "min_protein_probability": {
                    this.xpressAnalysisSummary.setMinProteinProbability(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "reference_isotope": {
                    this.xpressAnalysisSummary.setReferenceIsotope(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in XPress_analysis_summary: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setProteinprophetDetailsAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "occam_flag": {
                    this.proteinprophetDetails.setOccamFlag(atts.getValue(i));
                    break;
                }
                case "groups_flag": {
                    this.proteinprophetDetails.setGroupsFlag(atts.getValue(i));
                    break;
                }
                case "degen_flag": {
                    this.proteinprophetDetails.setDegenFlag(atts.getValue(i));
                    break;
                }
                case "nsp_flag": {
                    this.proteinprophetDetails.setNspFlag(atts.getValue(i));
                    break;
                }
                case "initial_peptide_wt_iters": {
                    this.proteinprophetDetails.setInitialPeptideWtIters(atts.getValue(i));
                    break;
                }
                case "nsp_distribution_iters": {
                    this.proteinprophetDetails.setNspDistributionIters(atts.getValue(i));
                    break;
                }
                case "final_peptide_wt_iters": {
                    this.proteinprophetDetails.setFinalPeptideWtIters(atts.getValue(i));
                    break;
                }
                case "run_options": {
                    this.proteinprophetDetails.setRunOptions(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in proteinprophet_details: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setNspInformationAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr = atts.getQName(i);
            if (tmpStr.equals("neighboring_bin_smoothing")) {
                this.nspInformation.setNeighboringBinSmoothing(atts.getValue(i));
            } else {
                this.logger.error("++++++++++++ Unknown attribute in nsp_information: " + tmpStr);
            }
            ++i;
        }
    }

    private void setNiInformationAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr = atts.getQName(i);
            this.logger.error("++++++++++++ Unknown attribute in ni_information: " + tmpStr);
            ++i;
        }
    }

    private void setProteinSummaryDataFilterAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "min_probability": {
                    this.proteinSummaryDataFilter.setMinProbability(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "sensitivity": {
                    this.proteinSummaryDataFilter.setSensitivity(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "false_positive_error_rate": {
                    this.proteinSummaryDataFilter.setFalsePositiveErrorRate(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "predicted_num_correct": {
                    this.proteinSummaryDataFilter.setPredictedNumCorrect(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "predicted_num_incorrect": {
                    this.proteinSummaryDataFilter.setPredictedNumIncorrect(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in protein_summary_data_filter: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setNspDistributionAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "bin_no": {
                    this.nspDistribution.setBinNo(this.getBigIntFromStr(atts.getValue(i)));
                    break;
                }
                case "nsp_lower_bound_incl": {
                    this.nspDistribution.setNspLowerBoundIncl(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "nsp_upper_bound_excl": {
                    this.nspDistribution.setNspUpperBoundExcl(atts.getValue(i));
                    break;
                }
                case "nsp_lower_bound_excl": {
                    this.nspDistribution.setNspLowerBoundExcl(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "nsp_upper_bound_incl": {
                    this.nspDistribution.setNspUpperBoundIncl(atts.getValue(i));
                    break;
                }
                case "pos_freq": {
                    this.nspDistribution.setPosFreq(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "neg_freq": {
                    this.nspDistribution.setNegFreq(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "pos_to_neg_ratio": {
                    this.nspDistribution.setPosToNegRatio(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "alt_pos_to_neg_ratio": {
                    this.nspDistribution.setAltPosToNegRatio(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in nsp_distribution: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setNiDistributionAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "bin_no": {
                    this.niDistribution.setBinNo(this.getBigIntFromStr(atts.getValue(i)));
                    break;
                }
                case "ni_lower_bound_incl": {
                    this.niDistribution.setNiLowerBoundIncl(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "ni_upper_bound_excl": {
                    this.niDistribution.setNiUpperBoundExcl(atts.getValue(i));
                    break;
                }
                case "ni_lower_bound_excl": {
                    this.niDistribution.setNiLowerBoundExcl(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "ni_upper_bound_incl": {
                    this.niDistribution.setNiUpperBoundIncl(atts.getValue(i));
                    break;
                }
                case "pos_freq": {
                    this.niDistribution.setPosFreq(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "neg_freq": {
                    this.niDistribution.setNegFreq(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "pos_to_neg_ratio": {
                    this.niDistribution.setPosToNegRatio(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "alt_pos_to_neg_ratio": {
                    this.niDistribution.setAltPosToNegRatio(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in ni_distribution: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setPD_EmptyAttributes(PD_Empty empty, Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr = atts.getQName(i);
            if (tmpStr.equals("xmlns")) {
                empty.setNamespace(atts.getValue(i));
            } else {
                this.logger.error("++++++++++++ Unknown attribute in PD_Empty object: " + tmpStr);
            }
            ++i;
        }
    }

    private void setPD_ProcessingNodeAttributes(PD_ProcessingNodeSummary processingNodeSummary, Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr = atts.getQName(i);
            if (tmpStr.equals("xmlns")) {
                processingNodeSummary.setNamespace(atts.getValue(i));
            } else {
                this.logger.error("++++++++++++ Unknown attribute in PD_ProcessingNodeSummary object: " + tmpStr);
            }
            ++i;
        }
    }

    private void setPD_SearchSummaryAttributes(PD_SearchSummary searchSummary, Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr = atts.getQName(i);
            if (tmpStr.equals("xmlns")) {
                searchSummary.setNamespace(atts.getValue(i));
            } else {
                this.logger.error("++++++++++++ Unknown attribute in PD_SearchSummary object: " + tmpStr);
            }
            ++i;
        }
    }

    private void setPD_ParameterAttributes(PD_Parameter parameter, Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr = atts.getQName(i);
            if (tmpStr.equals("name")) {
                parameter.setName(atts.getValue(i));
            } else {
                this.logger.error("++++++++++++ Unknown attribute in PD_Parameter object: " + tmpStr);
            }
            ++i;
        }
    }

    private void addProteinGroupListToProteinSummary() {
        for (ProteinSummary.ProteinGroup protGrp : this.proteinGroupList) {
            this.proteinSummary.getProteinGroup().add(protGrp);
        }
        this.proteinGroupList = super.resetList(this.proteinGroupList);
    }

    private void addAnalysisSummaryListToProteinSummary() {
        if (this.analysisSummaryList != null) {
            for (ProteinSummary.AnalysisSummary analysisSum : this.analysisSummaryList) {
                this.proteinSummary.getAnalysisSummary().add(analysisSum);
            }
            this.analysisSummaryList = super.resetList(this.analysisSummaryList);
        }
    }

    private void addDataFilterListToDatasetDerivation() {
        if (this.dataFilterList != null) {
            for (ProteinSummary.DatasetDerivation.DataFilter dataFilt : this.dataFilterList) {
                this.datasetDerivation.getDataFilter().add(dataFilt);
            }
            this.dataFilterList = super.resetList(this.dataFilterList);
        }
    }

    private void addProteinListToProteinGroup() {
        for (ProteinSummary.ProteinGroup.Protein prot : this.proteinList) {
            this.proteinGroup.getProtein().add(prot);
        }
        this.proteinList = super.resetList(this.proteinList);
    }

    private void addNameValueTypeListToProtein() {
        if (this.proteinNameValueTypeList != null) {
            for (NameValueType protNameValueType : this.proteinNameValueTypeList) {
                this.protein.getParameter().add(protNameValueType);
            }
            this.proteinNameValueTypeList = super.resetList(this.proteinNameValueTypeList);
        }
    }

    private void addAnalysisResultListToProtein() {
        if (this.analysisResultList != null) {
            for (ProteinSummary.ProteinGroup.Protein.AnalysisResult analysisRes : this.analysisResultList) {
                this.protein.getAnalysisResult().add(analysisRes);
            }
            this.analysisResultList = super.resetList(this.analysisResultList);
        }
    }

    private void addIndistinguishableProteinListToProtein() {
        if (this.indistinguishableProteinList != null) {
            for (ProteinSummary.ProteinGroup.Protein.IndistinguishableProtein indistinguishableProt : this.indistinguishableProteinList) {
                this.protein.getIndistinguishableProtein().add(indistinguishableProt);
            }
            this.indistinguishableProteinList = super.resetList(this.indistinguishableProteinList);
        }
    }

    private void addPeptideListToProtein() {
        for (ProteinSummary.ProteinGroup.Protein.Peptide pept : this.peptideList) {
            this.protein.getPeptide().add(pept);
        }
        this.peptideList = super.resetList(this.peptideList);
    }

    private void addNameValueTypeListToIndistinguishableProtein() {
        if (this.indistinguishableProteinNameValueTypeList != null) {
            for (NameValueType indistinguishableProtNameValueType : this.indistinguishableProteinNameValueTypeList) {
                this.indistinguishableProtein.getParameter().add(indistinguishableProtNameValueType);
            }
            this.indistinguishableProteinNameValueTypeList = super.resetList(this.indistinguishableProteinNameValueTypeList);
        }
    }

    private void addParameterListToPeptide() {
        if (this.peptideParameterList != null) {
            for (ProteinSummary.ProteinGroup.Protein.Peptide.Parameter peptParam : this.peptideParameterList) {
                this.peptide.getParameter().add(peptParam);
            }
            this.peptideParameterList = super.resetList(this.peptideParameterList);
        }
    }

    private void addPeptideParentProteinListToPeptide() {
        if (this.peptideParentProteinList != null) {
            for (ProteinSummary.ProteinGroup.Protein.Peptide.PeptideParentProtein peptParentProt : this.peptideParentProteinList) {
                this.peptide.getPeptideParentProtein().add(peptParentProt);
            }
            this.peptideParentProteinList = super.resetList(this.peptideParentProteinList);
        }
    }

    private void addIndistinguishablePeptideListToPeptide() {
        if (this.indistinguishablePeptideList != null) {
            for (ProteinSummary.ProteinGroup.Protein.Peptide.IndistinguishablePeptide indistinguishablePept : this.indistinguishablePeptideList) {
                this.peptide.getIndistinguishablePeptide().add(indistinguishablePept);
            }
            this.indistinguishablePeptideList = super.resetList(this.indistinguishablePeptideList);
        }
    }

    private void addModificationInfoListToPeptide() {
        if (this.modificationInfoList != null) {
            for (ProteinSummary.ProteinGroup.Protein.Peptide.ModificationInfo modInfo : this.modificationInfoList) {
                this.peptide.getModificationInfo().add(modInfo);
            }
            this.modificationInfoList = super.resetList(this.modificationInfoList);
        }
    }

    private void addModificationInfoIPListToIndistinguishablePeptide() {
        if (this.modificationInfoIPList != null) {
            for (ProteinSummary.ProteinGroup.Protein.Peptide.IndistinguishablePeptide.ModificationInfo modInfoIP : this.modificationInfoIPList) {
                this.indistinguishablePeptide.getModificationInfo().add(modInfoIP);
            }
            this.modificationInfoIPList = super.resetList(this.modificationInfoIPList);
        }
    }

    private void addModAminoAcidMassListToModificationInfo() {
        if (this.modAminoacidMassList != null) {
            for (ProteinSummary.ProteinGroup.Protein.Peptide.ModificationInfo.ModAminoacidMass modAAMass : this.modAminoacidMassList) {
                this.modificationInfo.getModAminoacidMass().add(modAAMass);
            }
            this.modAminoacidMassList = super.resetList(this.modAminoacidMassList);
        }
    }

    private void addModAminoAcidMassIPListToModificationInfoIP() {
        if (this.modAminoacidMassIPList != null) {
            for (ProteinSummary.ProteinGroup.Protein.Peptide.IndistinguishablePeptide.ModificationInfo.ModAminoacidMass modAAMassIP : this.modAminoacidMassIPList) {
                this.modificationInfoIP.getModAminoacidMass().add(modAAMassIP);
            }
            this.modAminoacidMassIPList = super.resetList(this.modAminoacidMassIPList);
        }
    }

    private void addFragmentMassesListToLibraSummary() {
        if (this.fragmentMassesList != null) {
            for (LibraSummary.FragmentMasses fragMasses : this.fragmentMassesList) {
                this.libraSummary.getFragmentMasses().add(fragMasses);
            }
            this.fragmentMassesList = super.resetList(this.fragmentMassesList);
        }
    }

    private void addContributingChannelListToIsotopicContributions() {
        if (this.contributingChannelList != null) {
            for (LibraSummary.IsotopicContributions.ContributingChannel contribChannel : this.contributingChannelList) {
                this.isotopicContributions.getContributingChannel().add(contribChannel);
            }
            this.contributingChannelList = super.resetList(this.contributingChannelList);
        }
    }

    private void addAffectedChannelListToContributingChannel() {
        if (this.affectedChannelList != null) {
            for (LibraSummary.IsotopicContributions.ContributingChannel.AffectedChannel affectChannel : this.affectedChannelList) {
                this.contributingChannel.getAffectedChannel().add(affectChannel);
            }
            this.affectedChannelList = super.resetList(this.affectedChannelList);
        }
    }

    private void addIntensityListToLibraResult() {
        if (this.intensityList != null) {
            for (LibraResult.Intensity intens : this.intensityList) {
                this.libraResult.getIntensity().add(intens);
            }
            this.intensityList = super.resetList(this.intensityList);
        }
    }

    private void addASAPSeqListToASAPRatio() {
        if (this.asapSeqList != null) {
            for (ASAPRatio.ASAPSeq asapSequ : this.asapSeqList) {
                this.asapRatio.getASAPSeq().add(asapSequ);
            }
            this.asapSeqList = super.resetList(this.asapSeqList);
        }
    }

    private void addASAPPeakListToASAPSeq() {
        if (this.asapPeakList != null) {
            for (ASAPRatio.ASAPSeq.ASAPPeak asapPeak1 : this.asapPeakList) {
                this.asapSeq.getASAPPeak().add(asapPeak1);
            }
            this.asapPeakList = super.resetList(this.asapPeakList);
        }
    }

    private void addASAPDtaListToASAPPeak() {
        if (this.asapDtaList != null) {
            for (ASAPRatio.ASAPSeq.ASAPPeak.ASAPDta asapDta1 : this.asapDtaList) {
                this.asapPeak.getASAPDta().add(asapDta1);
            }
            this.asapDtaList = super.resetList(this.asapDtaList);
        }
    }

    private void addProteinSummaryDataFilterListToProteinprophetDetails() {
        if (this.proteinSummaryDataFilterList != null) {
            for (ProteinprophetDetails.ProteinSummaryDataFilter protSummaryDataFilter : this.proteinSummaryDataFilterList) {
                this.proteinprophetDetails.getProteinSummaryDataFilter().add(protSummaryDataFilter);
            }
            this.proteinSummaryDataFilterList = super.resetList(this.proteinSummaryDataFilterList);
        }
    }

    private void addNspDistributionListToNspInformation() {
        if (this.nspDistributionList != null) {
            for (ProteinprophetDetails.NspInformation.NspDistribution nspDistrib : this.nspDistributionList) {
                this.nspInformation.getNspDistribution().add(nspDistrib);
            }
            this.nspDistributionList = super.resetList(this.nspDistributionList);
        }
    }

    private void addNiDistributionListToNiInformation() {
        if (this.niDistributionList != null) {
            for (ProteinprophetDetails.NiInformation.NiDistribution niDistrib : this.niDistributionList) {
                this.niInformation.getNiDistribution().add(niDistrib);
            }
            this.niDistributionList = super.resetList(this.niDistributionList);
        }
    }

    protected final void checkForEmptyLists() {
        if (this.analysisSummaryList != null) {
            this.logger.error("NOT ALL AnalysisSummary's saved");
        }
        if (this.dataFilterList != null) {
            this.logger.error("NOT ALL DataFilter's saved");
        }
        if (this.proteinGroupList != null) {
            this.logger.error("NOT ALL ProteinGroup's saved");
        }
        if (this.proteinList != null) {
            this.logger.error("NOT ALL Protein's saved");
        }
        if (this.peptideParameterList != null) {
            this.logger.error("NOT ALL Parameter's saved");
        }
        if (this.analysisResultList != null) {
            this.logger.error("NOT ALL AnalysisResult's saved");
        }
        if (this.indistinguishableProteinList != null) {
            this.logger.error("NOT ALL IndistinguishableProtein's saved");
        }
        if (this.peptideList != null) {
            this.logger.error("NOT ALL Peptide's saved");
        }
        if (this.modificationInfoList != null) {
            this.logger.error("NOT ALL ModificationInfo's saved");
        }
        if (this.modAminoacidMassList != null) {
            this.logger.error("NOT ALL ModAminoacidMass's saved");
        }
        if (this.peptideParentProteinList != null) {
            this.logger.error("NOT ALL ParentProtein's saved");
        }
        if (this.indistinguishablePeptideList != null) {
            this.logger.error("NOT ALL IndistinguishablePeptide's saved");
        }
        if (this.PD_parameterList != null) {
            this.logger.error("NOT ALL PD_Parameter's saved");
        }
    }

    private boolean checkForMeaningfulContent(String str) {
        if (str.length() == 0 || str.contains("|-(")) {
            return false;
        }
        String trimmedStr = str.trim();
        char ch = trimmedStr.charAt(0);
        if (trimmedStr.startsWith("|-(")) {
            return false;
        }
        int i = 1;
        while (i < trimmedStr.length()) {
            if (trimmedStr.charAt(i) != ch) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String removeEqualsAndHyphens(String str) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch != '=' && ch != '-') {
                sb.append(ch);
            }
            ++i;
        }
        String retStr = sb.toString();
        if (retStr.charAt(0) == '\n') {
            return retStr.substring(1);
        }
        return retStr;
    }

    public static enum ProcessingNodes {
        Mascot("Mascot"),
        SEQUEST("SequestNode"),
        SequestHT(""),
        ZCore(""),
        Annotation(""),
        AmandaPeptideIdentifier("AmandaPeptideIdentifier"),
        ETDSpectrumCharger(""),
        EventDetector("EventDetectorNode"),
        FixedValuePsmValidatorNode(""),
        IseNode("IseNode"),
        MSPepSearch(""),
        NoisePeakFilter(""),
        NonFragmentFilter(""),
        PeptideValidator("PeptideValidatorNode"),
        Percolator("PercolatorNode"),
        PhosphoRS3_0(""),
        PrecursorIonsAreaDetector("PrecursorIonsAreaDetectionNode"),
        PrecursorIonsQuantifier(""),
        PTMSiteScorer("PTMSiteScorerNode"),
        ReAnnotation(""),
        ReporterIonQuantifier(""),
        ScanEventFilter("ScanEventFilterNode"),
        SpectraST(""),
        SpectrumConfidenceFilter(""),
        SpectrumExporter("SpectrumExportNode"),
        SpectrumFiles("SpectrumFilesNode"),
        SpectrumGrouper(""),
        SpectrumNormalizer(""),
        SpectrumPropertiesFilter(""),
        SpectrumScoreFilter(""),
        SpectrumSelector("SpectrumSelectorNode"),
        SRFFileSelector(""),
        TargetDecoyPSMValidator(""),
        TopNPeaksFilter(""),
        Xtract(""),
        Unknown("Unknown");

        private final String processingNode;

        private ProcessingNodes(String nodeName) {
            this.processingNode = nodeName;
        }

        public String getProcessingNode() {
            return this.processingNode;
        }

        public static ProcessingNodes fromValue(String val) {
            return ProcessingNodes.valueOf(val);
        }
    }

    public static enum SearchMachines {
        Amanda("Amanda", "MS Amanda"),
        Mascot("Mas", "Mascot"),
        SEQUEST("SEQ", "SEQUEST"),
        SEQUEST_HT("SEQ HT", "Sequest HT"),
        ZCore("ZCo", "ZCore");

        private final String smShortStr;
        private final String smLongStr;

        private SearchMachines(String shortStr, String longStr) {
            this.smShortStr = shortStr;
            this.smLongStr = longStr;
        }

        public String getShortSMString() {
            return this.smShortStr;
        }

        public String getLongSMString() {
            return this.smLongStr;
        }

        public boolean isMascot() {
            return this.smShortStr.equals("Mas");
        }

        public boolean isSequest() {
            return this.smShortStr.equals("SEQ");
        }

        public boolean isSequestHT() {
            return this.smShortStr.equals("SEQ HT");
        }

        public boolean isZCore() {
            return this.smShortStr.equals("ZCo");
        }

        public boolean isMSAmanda() {
            return this.smShortStr.equals("AMANDA");
        }
    }
}

