/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD.XML;

import de.mpc.BaseLib.XML.BaseSaxParser;
import de.mpc.BaseLib.XML.XMLHandlerBase;
import de.mpc.PD.PDWorkflow.MethodPart;
import de.mpc.PD.PDWorkflow.Modification;
import de.mpc.PD.PDWorkflow.PDWorkflowType;
import de.mpc.PD.PDWorkflow.ParameterType;
import de.mpc.PD.PDWorkflow.ProcessingMethodType;
import de.mpc.PD.PDWorkflow.ProcessingNodeInterfaceType;
import de.mpc.PD.PDWorkflow.ProcessingNodeInterfacesType;
import de.mpc.PD.PDWorkflow.ProcessingNodeParameterType;
import de.mpc.PD.PDWorkflow.ProcessingNodeParametersType;
import de.mpc.PD.PDWorkflow.WorkflowNodeType;
import de.mpc.PD.PDWorkflow.WorkflowTreeType;
import de.mpc.PD.XML.PDWorkflowSaxParser;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PDWorkflowHandler
extends XMLHandlerBase {
    private final Logger logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
    private boolean bPDWorkflow = false;
    private boolean bWorkflowTree = false;
    private boolean bWorkflowNode = false;
    private boolean bProcessingNodeInterfaces = false;
    private boolean bProcessingNodeInterface = false;
    private boolean bProcessingNodeParameters = false;
    private boolean bProcessingNodeParameter = false;
    private boolean bModification = false;
    private boolean bProcessingMethod = false;
    private boolean bMethodPart = false;
    private boolean bParameter = false;
    public PDWorkflowType pdWorkflow = null;
    public WorkflowTreeType workflowTree = null;
    public WorkflowNodeType workflowNode = null;
    public ProcessingNodeInterfacesType pnInterfaces = null;
    public ProcessingNodeInterfaceType pnInterface = null;
    public ProcessingNodeParametersType pnParameters = null;
    public ProcessingNodeParameterType pnParameter = null;
    public Modification modification = null;
    public ProcessingMethodType processingMethod = null;
    public MethodPart methodPart = null;
    public ParameterType parameter = null;
    private ArrayList<WorkflowNodeType> workflowNodeList = null;
    private ArrayList<ProcessingNodeInterfaceType> pnInterfaceList = null;
    private ArrayList<ProcessingNodeParameterType> pnParameterList = null;
    private ArrayList<MethodPart> methodPartList = null;
    private ArrayList<ParameterType> parameterList = null;
    private final Stack<MethodPart> methodPartStack = new Stack();
    private final Stack<ArrayList<MethodPart>> methodPartListStack = new Stack();
    private String lastMethodPartParent;

    public PDWorkflowHandler(PDWorkflowSaxParser parser) {
        super((BaseSaxParser)parser);
    }

    public void startDocument() throws SAXException {
        this.printTraceStr("startDocument (PDWorkflow)");
    }

    public void endDocument() throws SAXException {
        this.printTraceStr("endDocument (PDWorkflow)");
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        switch (qName) {
            case "Workflow": {
                if (this.pdWorkflow == null) {
                    this.pdWorkflow = new PDWorkflowType();
                }
                if (atts != null) {
                    this.setPDWorkflowAttributes(atts);
                }
                this.bPDWorkflow = true;
                break;
            }
            case "WorkflowTree": {
                if (this.workflowTree == null) {
                    this.workflowTree = new WorkflowTreeType();
                }
                if (atts != null) {
                    this.setWorkflowTreeAttributes(atts);
                }
                this.bWorkflowTree = true;
                break;
            }
            case "WorkflowNode": {
                if (this.workflowNode == null) {
                    this.workflowNode = new WorkflowNodeType();
                }
                if (this.workflowNodeList == null) {
                    this.workflowNodeList = new ArrayList();
                }
                if (atts != null) {
                    this.setWorkflowNodeAttributes(atts);
                }
                this.bWorkflowNode = true;
                break;
            }
            case "ProcessingNodeInterfaces": {
                if (this.pnInterfaces == null) {
                    this.pnInterfaces = new ProcessingNodeInterfacesType();
                }
                this.bProcessingNodeInterfaces = true;
                break;
            }
            case "ProcessingNodeInterface": {
                if (this.pnInterface == null) {
                    this.pnInterface = new ProcessingNodeInterfaceType();
                }
                if (this.pnInterfaceList == null) {
                    this.pnInterfaceList = new ArrayList();
                }
                if (atts != null) {
                    this.setProcessingNodeInterfaceAttributes(atts);
                }
                this.bProcessingNodeInterface = true;
                break;
            }
            case "ProcessingNodeParameters": {
                if (this.pnParameters == null) {
                    this.pnParameters = new ProcessingNodeParametersType();
                }
                this.bProcessingNodeParameters = true;
                break;
            }
            case "ProcessingNodeParameter": {
                if (this.pnParameter == null) {
                    this.pnParameter = new ProcessingNodeParameterType();
                }
                if (this.pnParameterList == null) {
                    this.pnParameterList = new ArrayList();
                }
                if (atts != null) {
                    this.setProcessingNodeParameterAttributes(atts);
                }
                this.bProcessingNodeParameter = true;
                break;
            }
            case "Modification": {
                if (this.modification == null) {
                    this.modification = new Modification();
                }
                if (atts != null) {
                    this.setModificationAttributes(atts);
                }
                this.bModification = true;
                break;
            }
            case "ProcessingMethod": {
                if (this.processingMethod == null) {
                    this.processingMethod = new ProcessingMethodType();
                }
                if (atts != null) {
                    this.setProcessingMethodAttributes(atts);
                }
                this.bProcessingMethod = true;
                this.lastMethodPartParent = "ProcessingMethod";
                break;
            }
            case "MethodPart": {
                if (this.methodPart == null) {
                    this.methodPart = new MethodPart();
                    this.methodPartStack.push(this.methodPart);
                }
                if (this.methodPartList == null) {
                    this.methodPartList = new ArrayList();
                    this.methodPartListStack.push(this.methodPartList);
                }
                if (atts != null) {
                    this.setMethodPartAttributes(atts);
                }
                this.bMethodPart = true;
                this.lastMethodPartParent = "MethodPart";
                break;
            }
            case "Parameter": {
                if (this.parameter == null) {
                    this.parameter = new ParameterType();
                }
                if (this.parameterList == null) {
                    this.parameterList = new ArrayList();
                }
                if (atts != null) {
                    this.setParameterAttributes(atts);
                }
                this.bParameter = true;
                break;
            }
            default: {
                this.logger.error("************ UNHANDLED START ELEMENT    : " + qName);
            }
        }
        this.lastActivated = qName;
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        switch (qName) {
            case "Workflow": {
                this.checkForEmptyLists();
                ((PDWorkflowSaxParser)this.parser).setPDWorkflow(this.pdWorkflow);
                this.bPDWorkflow = false;
                break;
            }
            case "WorkflowTree": {
                this.addWorkflowNodeListToWorkflowTree();
                this.pdWorkflow.setWorkflowTree(this.workflowTree);
                this.workflowTree = null;
                this.bWorkflowTree = false;
                break;
            }
            case "WorkflowNode": {
                this.workflowNodeList.add(this.workflowNode);
                this.workflowNode = null;
                this.bWorkflowNode = false;
                break;
            }
            case "ProcessingNodeInterfaces": {
                this.addProcessingNodeInterfaceListToProcessingNodeInterfaces();
                this.workflowNode.setProcessingNodeInterfaces(this.pnInterfaces);
                this.pnInterfaces = null;
                this.bProcessingNodeInterfaces = false;
                break;
            }
            case "ProcessingNodeInterface": {
                this.pnInterfaceList.add(this.pnInterface);
                this.pnInterface = null;
                this.bProcessingNodeInterface = false;
                break;
            }
            case "ProcessingNodeParameters": {
                this.addProcessingNodeParameterListToProcessingNodeParameters();
                this.workflowNode.setProcessingNodeParameters(this.pnParameters);
                this.pnParameters = null;
                this.bProcessingNodeParameters = false;
                break;
            }
            case "ProcessingNodeParameter": {
                this.pnParameterList.add(this.pnParameter);
                this.pnParameter = null;
                this.bProcessingNodeParameter = false;
                break;
            }
            case "Modification": {
                if (!this.bParameter) {
                    // empty if block
                }
                this.modification = null;
                this.bModification = false;
                break;
            }
            case "ProcessingMethod": {
                if (this.lastMethodPartParent.equals("ProcessingMethod")) {
                    this.addMethodPartListToProcessingMethod();
                }
                this.processingMethod = null;
                this.bProcessingMethod = false;
                break;
            }
            case "MethodPart": {
                this.addParameterListToMethodPart();
                if (this.lastMethodPartParent.equals("MethodPart")) {
                    this.addMethodPartListToMethodPart();
                }
                try {
                    this.methodPartList = this.methodPartListStack.pop();
                    this.methodPartList.add(this.methodPart);
                    this.methodPart = this.methodPartStack.pop();
                }
                catch (EmptyStackException esex) {
                    this.methodPart = null;
                }
                this.bMethodPart = false;
                break;
            }
            case "Parameter": {
                this.parameterList.add(this.parameter);
                this.parameter = null;
                this.bParameter = false;
                break;
            }
            default: {
                this.logger.error("************ UNHANDLED END ELEMENT    : " + qName);
            }
        }
        this.lastActivated = "";
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String tmpStr = new String(ch, start, length).trim();
        if (!tmpStr.isEmpty()) {
            if (this.bPDWorkflow && this.lastActivated.equals("Workflow")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"Workflow\"): ");
            } else if (this.bWorkflowTree && this.lastActivated.equals("WorkflowTree")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"WorkflowTree\"): ");
            } else if (this.bWorkflowNode && this.lastActivated.equals("WorkflowNode")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"WorkflowNode\"): ");
            } else if (this.bProcessingNodeInterfaces && this.lastActivated.equals("ProcessingNodeInterfaces")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"ProcessingNodeInterfaces\"): ");
            } else if (this.bProcessingNodeInterface && this.lastActivated.equals("ProcessingNodeInterface")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"ProcessingNodeInterface\"): ");
            } else if (this.bProcessingNodeParameters && this.lastActivated.equals("ProcessingNodeParameters")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"ProcessingNodeParameters\"): ");
            } else if (this.bProcessingNodeParameter && this.lastActivated.equals("ProcessingNodeParameter")) {
                this.pnParameter.getContent().add(tmpStr);
            } else if (this.bModification && this.lastActivated.equals("Modification")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"Modification\"): ");
            } else if (this.bProcessingMethod && this.lastActivated.equals("ProcessingMethod")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"ProcessingMethod\"): ");
            } else if (this.bMethodPart && this.lastActivated.equals("MethodPart")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"MethodPart\"): ");
            } else if (this.bParameter && this.lastActivated.equals("Parameter")) {
                this.parameter.getContent().add(tmpStr);
            } else {
                this.logger.error("############ start characters(" + length + "): " + tmpStr);
            }
        }
    }

    private void setPDWorkflowAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr = atts.getQName(i);
            if (tmpStr.equals("ContinueJob")) {
                this.pdWorkflow.setContinueJob(atts.getValue(i));
            } else if (tmpStr.equals("WaitForEarlierJobs")) {
                this.pdWorkflow.setWaitForEarlierJobs(atts.getValue(i));
            } else if (tmpStr.equals("CreatedFromUser")) {
                this.pdWorkflow.setCreatedFromUser(atts.getValue(i));
            } else if (tmpStr.equals("CreationDate")) {
                this.pdWorkflow.setCreationDate(atts.getValue(i));
            } else if (tmpStr.equals("Description")) {
                this.pdWorkflow.setDescription(atts.getValue(i));
            } else if (tmpStr.equals("Name")) {
                this.pdWorkflow.setName(atts.getValue(i));
            } else if (!tmpStr.equals("xsi:schemaLocation")) {
                this.logger.error("++++++++++++ Unknown attribute in PWWorkflow: " + tmpStr);
            }
            ++i;
        }
    }

    private void setWorkflowTreeAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr = atts.getQName(i);
            if (tmpStr.equals("MergeSimilarIdentificationResults")) {
                this.workflowTree.setMergeSimilarIdentificationResults(atts.getValue(i));
            } else {
                this.logger.error("++++++++++++ Unknown attribute in WorkflowTree: " + tmpStr);
            }
            ++i;
        }
    }

    private void setWorkflowNodeAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "Description": {
                    this.workflowNode.setDescription(atts.getValue(i));
                    break;
                }
                case "Comment": {
                    this.workflowNode.setComment(atts.getValue(i));
                    break;
                }
                case "ProteinIdentificationGroupID": {
                    this.workflowNode.setProteinIdentificationGroupID(Integer.parseInt(atts.getValue(i)));
                    break;
                }
                case "ParentProcessingNodeNumber": {
                    this.workflowNode.setParentProcessingNodeNumber(Integer.parseInt(atts.getValue(i)));
                    break;
                }
                case "Category": {
                    this.workflowNode.setCategory(atts.getValue(i));
                    break;
                }
                case "Guid": {
                    this.workflowNode.setGuid(atts.getValue(i));
                    break;
                }
                case "MinorVersion": {
                    this.workflowNode.setMinorVersion(Integer.parseInt(atts.getValue(i)));
                    break;
                }
                case "MainVersion": {
                    this.workflowNode.setMainVersion(Integer.parseInt(atts.getValue(i)));
                    break;
                }
                case "FriendlyName": {
                    this.workflowNode.setFriendlyName(atts.getValue(i));
                    break;
                }
                case "ProcessingNodeName": {
                    this.workflowNode.setProcessingNodeName(atts.getValue(i));
                    break;
                }
                case "ProcessingNodeNumber": {
                    this.workflowNode.setProcessingNodeNumber(Integer.parseInt(atts.getValue(i)));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in WorkflowNode: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setProcessingNodeInterfaceAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "Name": {
                    this.pnInterface.setName(atts.getValue(i));
                    break;
                }
                case "Kind": {
                    this.pnInterface.setKind(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in ProcessingNodeInterface: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setProcessingNodeParameterAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "Name": {
                    this.pnParameter.setName(atts.getValue(i));
                    break;
                }
                case "Category": {
                    this.pnParameter.setCategory(atts.getValue(i));
                    break;
                }
                case "FriendlyName": {
                    this.pnParameter.setFriendlyName(atts.getValue(i));
                    break;
                }
                case "IsValueSet": {
                    this.pnParameter.setIsValueSet(atts.getValue(i));
                    break;
                }
                case "IsAdvanced": {
                    this.pnParameter.setIsAdvanced(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in ProcessingNodeParameter: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setModificationAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "Name": {
                    this.modification.setName(atts.getValue(i));
                    break;
                }
                case "PositionType": {
                    this.modification.setPositionType(atts.getValue(i));
                    break;
                }
                case "Substitution": {
                    this.modification.setSubstitution(atts.getValue(i));
                    break;
                }
                case "LeavingGroup": {
                    this.modification.setLeavingGroup(atts.getValue(i));
                    break;
                }
                case "IsSubstitution": {
                    this.modification.setIsSubstitution(atts.getValue(i));
                    break;
                }
                case "DeltaAverageMass": {
                    this.modification.setDeltaAverageMass(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "DeltaMass": {
                    this.modification.setDeltaMass(Double.parseDouble(atts.getValue(i)));
                    break;
                }
                case "UnimodAccession": {
                    this.modification.setUnimodAccession(Integer.parseInt(atts.getValue(i)));
                    break;
                }
                case "ID": {
                    this.modification.setID(Integer.parseInt(atts.getValue(i)));
                    break;
                }
                case "Abbreviation": {
                    this.modification.setAbbreviation(atts.getValue(i));
                    break;
                }
                case "Version": {
                    this.modification.setVersion(atts.getValue(i));
                    break;
                }
                case "AminoAcids": {
                    this.modification.setAminoAcids(atts.getValue(i));
                    break;
                }
                case "Terminus": {
                    this.modification.setTerminus(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in Modification: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setProcessingMethodAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "description": {
                    this.processingMethod.setDescription(atts.getValue(i));
                    break;
                }
                case "name": {
                    this.processingMethod.setName(atts.getValue(i));
                    break;
                }
                case "version": {
                    this.processingMethod.setVersion(Integer.parseInt(atts.getValue(i)));
                    break;
                }
                case "minorVersion": {
                    this.processingMethod.setMajorVersion(Integer.parseInt(atts.getValue(i)));
                    break;
                }
                case "majorVersion": {
                    this.processingMethod.setMajorVersion(Integer.parseInt(atts.getValue(i)));
                    break;
                }
                case "isActive": {
                    this.processingMethod.setIsActive(atts.getValue(i));
                    break;
                }
                case "class": {
                    this.processingMethod.setClazz(atts.getValue(i));
                    break;
                }
                case "selected": {
                    this.processingMethod.setSelected(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in ProcessingMethod: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setMethodPartAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "name": {
                    this.methodPart.setName(atts.getValue(i));
                    break;
                }
                case "version": {
                    this.methodPart.setVersion(Integer.parseInt(atts.getValue(i)));
                    break;
                }
                case "selected": {
                    this.methodPart.setSelected(atts.getValue(i));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in MethodPart: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void setParameterAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr = atts.getQName(i);
            if (tmpStr.equals("name")) {
                this.methodPart.setName(atts.getValue(i));
            } else {
                this.logger.error("++++++++++++ Unknown attribute in Parameter: " + tmpStr);
            }
            ++i;
        }
    }

    private void addWorkflowNodeListToWorkflowTree() {
        if (this.workflowNodeList != null) {
            for (WorkflowNodeType wfNode : this.workflowNodeList) {
                this.workflowTree.getWorkflowNode().add(wfNode);
            }
            this.workflowNodeList.clear();
            this.workflowNodeList = null;
        }
    }

    private void addProcessingNodeInterfaceListToProcessingNodeInterfaces() {
        if (this.pnInterfaceList != null) {
            for (ProcessingNodeInterfaceType pnInterf : this.pnInterfaceList) {
                this.pnInterfaces.getProcessingNodeInterface().add(pnInterf);
            }
            this.pnInterfaceList.clear();
            this.pnInterfaceList = null;
        }
    }

    private void addProcessingNodeParameterListToProcessingNodeParameters() {
        if (this.pnParameterList != null) {
            for (ProcessingNodeParameterType pnParam : this.pnParameterList) {
                this.pnParameters.getProcessingNodeParameter().add(pnParam);
            }
            this.pnParameterList.clear();
            this.pnParameterList = null;
        }
    }

    private void addMethodPartListToProcessingMethod() {
        if (this.methodPartList != null) {
            for (MethodPart methPart : this.methodPartList) {
                this.processingMethod.getMethodPart().add(methPart);
            }
            this.methodPartList.clear();
            this.methodPartList = null;
        }
    }

    private void addMethodPartListToMethodPart() {
        if (this.methodPartList != null) {
            for (MethodPart methPart : this.methodPartList) {
                this.methodPart.getMethodPart().add(methPart);
            }
            this.methodPartList.clear();
            this.methodPartList = null;
        }
    }

    private void addParameterListToMethodPart() {
        if (this.parameterList != null) {
            for (ParameterType param : this.parameterList) {
                this.methodPart.getParameter().add(param);
            }
            this.parameterList.clear();
            this.parameterList = null;
        }
    }

    protected final void checkForEmptyLists() {
        if (this.workflowNodeList != null) {
            this.logger.error("NOT ALL workflow nodes saved");
        }
        if (this.pnInterfaceList != null) {
            this.logger.error("NOT ALL processing node interfaces saved");
        }
        if (this.pnParameterList != null) {
            this.logger.error("NOT ALL processing node parameters saved");
        }
        if (this.methodPartList != null) {
            this.logger.error("NOT ALL method parts saved");
        }
        if (this.parameterList != null) {
            this.logger.error("NOT ALL parameters saved");
        }
    }
}

