/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD.XML;

import de.mpc.BaseLib.GUID;
import de.mpc.BaseLib.XML.BaseSaxParser;
import de.mpc.BaseLib.XML.XMLHandlerBase;
import de.mpc.PD.FDRSettings.FalseDiscoveryRateCalculatorType;
import de.mpc.PD.FDRSettings.FalseDiscoveryRateSettingsType;
import de.mpc.PD.FDRSettings.FalseDiscoveryRateType;
import de.mpc.PD.FDRSettings.ParameterType;
import de.mpc.PD.FDRSettings.ParametersType;
import de.mpc.PD.XML.FDRSettingsSaxParser;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FDRSettingsHandler
extends XMLHandlerBase {
    private final Logger logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
    private boolean bFDRSettings = false;
    private boolean bFDR = false;
    private boolean bFDRCalculator = false;
    private boolean bParameters = false;
    private boolean bParameter = false;
    private boolean bHasDecoySearch = false;
    private boolean bTrueCount = false;
    private boolean bFalseCount = false;
    private boolean bTarget = false;
    private boolean bGuid = false;
    private boolean bVersion = false;
    public FalseDiscoveryRateSettingsType fdrSettings = null;
    public FalseDiscoveryRateType fdr = null;
    public FalseDiscoveryRateCalculatorType fdrCalculator = null;
    public ParametersType parameters = null;
    public ParameterType parameter = null;
    public boolean hasDecoySearch;
    public int trueCount;
    public int falseCount;
    public float target;
    public GUID guid = null;
    public String version;
    private ArrayList<FalseDiscoveryRateType> fdrList = null;
    private ArrayList<ParametersType> parametersList = null;
    private ArrayList<ParameterType> parameterList = null;

    public FDRSettingsHandler(FDRSettingsSaxParser parser) {
        super((BaseSaxParser)parser);
    }

    public void startDocument() throws SAXException {
        this.printTraceStr("startDocument (FDRSettings)");
    }

    public void endDocument() throws SAXException {
        this.printTraceStr("endDocument (FDRSettings)");
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        switch (qName) {
            case "FalseDiscoveryRateSettings": {
                if (this.fdrSettings == null) {
                    this.fdrSettings = new FalseDiscoveryRateSettingsType();
                }
                if (atts != null) {
                    this.setFDRSettingsAttributes(atts);
                }
                this.bFDRSettings = true;
                break;
            }
            case "FalseDiscoveryRate": {
                if (this.fdr == null) {
                    this.fdr = new FalseDiscoveryRateType();
                }
                if (this.fdrList == null) {
                    this.fdrList = new ArrayList();
                }
                if (atts != null) {
                    this.setFDRAttributes(atts);
                }
                this.bFDR = true;
                break;
            }
            case "FalseDiscoveryRateCalculator": {
                if (this.fdrCalculator == null) {
                    this.fdrCalculator = new FalseDiscoveryRateCalculatorType();
                }
                if (atts != null) {
                    this.setFDRCalculatorAttributes(atts);
                }
                this.bFDRCalculator = true;
                break;
            }
            case "Parameters": {
                if (this.parameters == null) {
                    this.parameters = new ParametersType();
                }
                if (this.parametersList == null) {
                    this.parametersList = new ArrayList();
                }
                if (atts != null) {
                    this.setParametersAttributes(atts);
                }
                this.bParameters = true;
                break;
            }
            case "Parameter": {
                if (this.parameter == null) {
                    this.parameter = new ParameterType();
                }
                if (this.parameterList == null) {
                    this.parameterList = new ArrayList();
                }
                if (atts != null) {
                    this.setParameterAttributes(atts);
                }
                this.bParameter = true;
                break;
            }
            case "HasDecoySearch": {
                this.bHasDecoySearch = true;
                break;
            }
            case "TrueCount": {
                this.bTrueCount = true;
                break;
            }
            case "FalseCount": {
                this.bFalseCount = true;
                break;
            }
            case "Target": {
                this.bTarget = true;
                break;
            }
            case "Guid": {
                this.bGuid = true;
                break;
            }
            case "Version": {
                this.bVersion = true;
                break;
            }
            default: {
                this.logger.error("************ UNHANDLED START ELEMENT    : " + qName);
            }
        }
        this.lastActivated = qName;
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        switch (qName) {
            case "FalseDiscoveryRateSettings": {
                this.addFDRListToFDRSettings();
                this.checkForEmptyLists();
                ((FDRSettingsSaxParser)this.parser).setFDRSettings(this.fdrSettings);
                this.bFDRSettings = false;
                break;
            }
            case "FalseDiscoveryRate": {
                this.fdrList.add(this.fdr);
                this.fdr = null;
                this.bFDR = false;
                break;
            }
            case "FalseDiscoveryRateCalculator": {
                this.addParametersListToFDRCalculator();
                this.fdrSettings.setFalseDiscoveryRateCalculator(this.fdrCalculator);
                this.fdrCalculator = null;
                this.bFDRCalculator = false;
                break;
            }
            case "Parameters": {
                this.addParameterListToParameters();
                this.parametersList.add(this.parameters);
                this.parameters = null;
                this.bParameters = false;
                break;
            }
            case "Parameter": {
                this.parameterList.add(this.parameter);
                this.parameter = null;
                this.bParameter = false;
                break;
            }
            case "HasDecoySearch": {
                this.bHasDecoySearch = false;
                break;
            }
            case "TrueCount": {
                this.bTrueCount = false;
                break;
            }
            case "FalseCount": {
                this.bFalseCount = false;
                break;
            }
            case "Target": {
                this.bTarget = false;
                break;
            }
            case "Guid": {
                this.bGuid = false;
                break;
            }
            case "Version": {
                this.bVersion = false;
                break;
            }
            default: {
                this.logger.error("************ UNHANDLED END ELEMENT    : " + qName);
            }
        }
        this.lastActivated = "";
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String tmpStr = new String(ch, start, length).trim();
        if (!tmpStr.isEmpty()) {
            if (this.bFDRSettings && this.lastActivated.equals("FalseDiscoveryRateSettings")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"FalseDiscoveryRateSettings\"): ");
            } else if (this.bFDR && this.lastActivated.equals("FalseDiscoveryRate")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"FalseDiscoveryRate\"): ");
            } else if (this.bFDRCalculator && this.lastActivated.equals("FalseDiscoveryRateCalculator")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"FalseDiscoveryRateCalculator\"): ");
            } else if (this.bParameters && this.lastActivated.equals("Parameters")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"Parameters\"): ");
            } else if (this.bParameter && this.lastActivated.equals("Parameter")) {
                this.parameter.setValue(Float.valueOf(tmpStr).floatValue());
            } else if (this.bHasDecoySearch && this.lastActivated.equals("HasDecoySearch")) {
                this.hasDecoySearch = Boolean.valueOf(tmpStr);
            } else if (this.bTrueCount && this.lastActivated.equals("TrueCount")) {
                this.trueCount = Integer.valueOf(tmpStr);
            } else if (this.bFalseCount && this.lastActivated.equals("FalseCount")) {
                this.falseCount = Integer.valueOf(tmpStr);
            } else if (this.bTarget && this.lastActivated.equals("Target")) {
                this.target = Float.valueOf(tmpStr).floatValue();
            } else if (this.bGuid && this.lastActivated.equals("Guid")) {
                this.guid = new GUID(tmpStr);
            } else if (this.bVersion && this.lastActivated.equals("Version")) {
                this.version = tmpStr;
            } else {
                this.logger.error("############ start characters(" + length + "): " + tmpStr);
            }
        }
    }

    private void setFDRSettingsAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr = atts.getQName(i);
            if (!tmpStr.equals("xsi:schemaLocation")) {
                this.logger.error("++++++++++++ Unknown attribute in FDRSettings: " + tmpStr);
            }
            ++i;
        }
    }

    private void setFDRAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr = atts.getQName(i);
            if (tmpStr.equals("Level")) {
                this.fdr.setLevel(atts.getValue(i));
            } else {
                this.logger.error("++++++++++++ Unknown attribute in FDR: " + tmpStr);
            }
            ++i;
        }
    }

    private void setFDRCalculatorAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr = atts.getQName(i);
            this.logger.error("++++++++++++ Unknown attribute in FDRCalculator: " + tmpStr);
            ++i;
        }
    }

    private void setParametersAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr = atts.getQName(i);
            if (tmpStr.equals("Level")) {
                this.parameters.setLevel(atts.getValue(i));
            } else {
                this.logger.error("++++++++++++ Unknown attribute in Parameters: " + tmpStr);
            }
            ++i;
        }
    }

    private void setParameterAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr = atts.getQName(i);
            if (tmpStr.equals("Name")) {
                this.parameter.setName(atts.getValue(i));
            } else {
                this.logger.error("++++++++++++ Unknown attribute in Parameter: " + tmpStr);
            }
            ++i;
        }
    }

    private void addFDRListToFDRSettings() {
        if (this.fdrList != null) {
            for (FalseDiscoveryRateType fdrRate : this.fdrList) {
                this.fdrSettings.getFalseDiscoveryRate().add(fdrRate);
            }
            this.fdrList.clear();
            this.fdrList = null;
        }
    }

    private void addParametersListToFDRCalculator() {
        if (this.parametersList != null) {
            int i = 0;
            while (i < this.fdrList.size()) {
                this.fdrCalculator.getParameters().add(this.parametersList.get(i));
                ++i;
            }
            this.parametersList.clear();
            this.parametersList = null;
        }
    }

    private void addParameterListToParameters() {
        if (this.parameterList != null) {
            int i = 0;
            while (i < this.fdrList.size()) {
                this.parameters.getParameter().add(this.parameterList.get(i));
                ++i;
            }
            this.parameterList.clear();
            this.parameterList = null;
        }
    }

    protected final void checkForEmptyLists() {
        if (this.fdrList != null) {
            this.logger.error("NOT ALL FDR's saved");
        }
        if (this.parametersList != null) {
            this.logger.error("NOT ALL parameters saved");
        }
        if (this.parameterList != null) {
            this.logger.error("NOT ALL parameter's saved");
        }
    }

    public boolean hasDecoySearch() {
        return this.bHasDecoySearch;
    }

    public String getFDRCalculatorGUID() {
        return this.fdrCalculator.getGuid();
    }

    public String getFDRCalculatorVersion() {
        return this.fdrCalculator.getVersion();
    }

    public float getMinScoreAtChargeState(String level, int chargeState) {
        List<ParametersType> paramsTypeList = this.fdrCalculator.getParameters();
        for (ParametersType paramsType : paramsTypeList) {
            if (!paramsType.getLevel().equals(level)) continue;
            List<ParameterType> paramTypeList = paramsType.getParameter();
            for (ParameterType paramType : paramTypeList) {
                if (!paramType.getName().endsWith(String.valueOf(chargeState))) continue;
                return paramType.getValue();
            }
        }
        return 0.0f;
    }

    public BigInteger getTrueCount(String level) {
        for (FalseDiscoveryRateType fdrType : this.fdrList) {
            if (!fdrType.getLevel().equals(level)) continue;
            return fdrType.getTrueCount();
        }
        return BigInteger.valueOf(0L);
    }

    public BigInteger getFalseCount(String level) {
        for (FalseDiscoveryRateType fdrType : this.fdrList) {
            if (!fdrType.getLevel().equals(level)) continue;
            return fdrType.getFalseCount();
        }
        return BigInteger.valueOf(0L);
    }

    public float getTargetValue(String level) {
        for (FalseDiscoveryRateType fdrType : this.fdrList) {
            if (!fdrType.getLevel().equals(level)) continue;
            return fdrType.getTarget();
        }
        return 0.0f;
    }
}

