/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD.XML;

import de.mpc.BaseLib.constants.MyConstants;

public class ChromatogramPeak {
    private final int DREI = 3;
    private float retentionTime;
    private float intensity;
    private int scanNumber;

    public ChromatogramPeak(float retentionTime, float intensity, int scanNumber) {
        this.retentionTime = retentionTime;
        this.intensity = intensity;
        this.scanNumber = scanNumber;
    }

    public ChromatogramPeak(String xmlLine) {
        String[] splitter;
        String[] stringArray = splitter = xmlLine.trim().split(MyConstants.STR_BLANK);
        int n = splitter.length;
        int n2 = 0;
        while (n2 < n) {
            String split = stringArray[n2];
            if (split.startsWith("T=\"")) {
                this.retentionTime = Float.valueOf(split.substring(3, split.lastIndexOf(MyConstants.STR_ANF_ZEICHEN))).floatValue();
            } else if (split.startsWith("Y=\"")) {
                this.intensity = Float.valueOf(split.substring(3, split.lastIndexOf(MyConstants.STR_ANF_ZEICHEN))).floatValue();
            } else if (split.startsWith("Scan=\"")) {
                this.scanNumber = Integer.valueOf(split.substring(6, split.lastIndexOf(MyConstants.STR_ANF_ZEICHEN)));
            }
            ++n2;
        }
    }

    public float getRetentioTime() {
        return this.retentionTime;
    }

    public float getIntensity() {
        return this.intensity;
    }

    public int getScanNumber() {
        return this.scanNumber;
    }
}

