/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD.XML;

import de.mpc.BaseLib.XML.BaseSaxParser;
import de.mpc.BaseLib.XML.XMLHandlerBase;
import de.mpc.PD.Chromatogram.ChromatogramType;
import de.mpc.PD.Chromatogram.PointsType;
import de.mpc.PD.Chromatogram.PtType;
import de.mpc.PD.Chromatograms;
import de.mpc.PD.XML.ChromatogramSaxParser;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ChromatogramHandler
extends XMLHandlerBase {
    private final Logger logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
    private boolean bChromatogram = false;
    private boolean bTraceType = false;
    private boolean bPoints = false;
    private boolean bPt = false;
    public ChromatogramType chromatogram = null;
    private Chromatograms.TraceType traceType = null;
    private PointsType points = null;
    private PtType pt = null;
    private ArrayList<PtType> ptList = null;

    public ChromatogramHandler(ChromatogramSaxParser parser) {
        super((BaseSaxParser)parser);
    }

    public void startDocument() throws SAXException {
        this.printTraceStr("startDocument (Chromatogram)");
    }

    public void endDocument() throws SAXException {
        this.printTraceStr("endDocument (Chromatogram)");
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        switch (qName) {
            case "Chromatogram": {
                if (this.chromatogram == null) {
                    this.chromatogram = new ChromatogramType();
                }
                this.bChromatogram = true;
                break;
            }
            case "Points": {
                if (this.points == null) {
                    this.points = new PointsType();
                }
                if (this.ptList == null) {
                    this.ptList = new ArrayList();
                }
                this.bPoints = true;
                break;
            }
            case "Pt": {
                if (this.pt == null) {
                    this.pt = new PtType();
                }
                if (atts != null) {
                    this.setPtAttributes(atts);
                }
                this.bPt = true;
                break;
            }
            case "TraceType": {
                this.bTraceType = true;
                break;
            }
            default: {
                this.logger.error("************ UNHANDLED START ELEMENT    : " + qName);
            }
        }
        this.lastActivated = qName;
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        switch (qName) {
            case "Chromatogram": {
                this.checkForEmptyLists();
                ((ChromatogramSaxParser)this.parser).setChromatogram(this.chromatogram);
                this.bChromatogram = false;
                break;
            }
            case "Points": {
                this.addPtListToPoints();
                this.chromatogram.setPoints(this.points);
                this.points = null;
                this.bPoints = false;
                break;
            }
            case "Pt": {
                this.ptList.add(this.pt);
                this.pt = null;
                this.bPt = false;
                break;
            }
            case "TraceType": {
                this.chromatogram.setTraceType(String.valueOf((Object)this.traceType));
                this.bTraceType = false;
                break;
            }
            default: {
                this.logger.error("************ UNHANDLED END ELEMENT    : " + qName);
            }
        }
        this.lastActivated = "";
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String tmpStr = new String(ch, start, length).trim();
        if (!tmpStr.isEmpty()) {
            if (this.bChromatogram && this.lastActivated.equals("Chromatogram")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"Chromatogram\"): ");
            } else if (this.bTraceType && this.lastActivated.equals("TraceType")) {
                if (tmpStr.equals("TicTrace")) {
                    this.traceType = Chromatograms.TraceType.TIC;
                } else {
                    this.logger.warn("TraceType {} not handled in characters()", (Object)tmpStr);
                }
            } else if (this.bPoints && this.lastActivated.equals("Points")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"Points\"): ");
            } else if (this.bPt && this.lastActivated.equals("Pt")) {
                this.checkIfCharactersAreEmpty(tmpStr, "characters(\"Pt\"): ");
            } else if (tmpStr.length() > 0) {
                this.logger.error("############ start characters(" + length + "): " + tmpStr);
            }
        }
    }

    private void setPtAttributes(Attributes atts) {
        int i = 0;
        while (i < atts.getLength()) {
            String tmpStr;
            switch (tmpStr = atts.getQName(i)) {
                case "T": {
                    this.pt.setT(Float.valueOf(atts.getValue(i)).floatValue());
                    break;
                }
                case "Y": {
                    this.chromatogram.setTraceType(atts.getValue(i));
                    break;
                }
                case "Scan": {
                    this.pt.setScan(Integer.valueOf(atts.getValue(i)));
                    break;
                }
                default: {
                    this.logger.error("++++++++++++ Unknown attribute in Pt: " + tmpStr);
                }
            }
            ++i;
        }
    }

    private void addPtListToPoints() {
        if (this.ptList != null) {
            for (PtType filterInf : this.ptList) {
                this.points.getPt().add(filterInf);
            }
            this.ptList.clear();
            this.ptList = null;
        }
    }

    protected final void checkForEmptyLists() {
        if (this.ptList != null) {
            this.logger.error("NOT ALL Pt's saved");
        }
    }
}

