/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.FileTimes;
import de.mpc.BaseLib.Helper;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.IPNNable;
import de.mpc.PD.PDBaseClassSinglePrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.ProcessingNodes;
import de.mpc.PD.SMsFromPNN;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.GregorianCalendar;

public class WorkflowMessages
extends PDBaseClassSinglePrimaryKey
implements IPNNable {
    private long messageID = -1L;
    private long processingNodeID;
    private long processingNodeNumber;
    private BigInteger time = null;
    private int messageKind;
    private String message;
    private ProcessingNodes processingNode = null;
    private final ArrayList<ProcessingNodes> processingNodesList = new ArrayList();
    private final String searchMachine;

    public WorkflowMessages(AProgramParameters pp, long messageID) {
        super(pp);
        this.messageID = messageID;
        this.initFromDB();
        this.searchMachine = SMsFromPNN.retrieveSearchMachineForProcessingNodeNumber(pp, this.processingNodeNumber);
    }

    private void initFromDB() {
        this.sb.append("select ProcessingNodeID, ProcessingNodeNumber, Time, MessageKind, Message").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where MessageID = ?");
        this.initAndProcessPrepared(this.messageID);
    }

    private void loadForeignKeyObjects() {
        if (this.processingNodeNumber > -1L && this.processingNode == null) {
            this.processingNode = this.requestProcessingNode(this.processingNodeNumber);
        }
        if (this.processingNodeNumber > -1L) {
            this.requestProcessingNodesList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private ProcessingNodes requestProcessingNode(long processingNodeNumber) {
        return new ProcessingNodes(this.getPP(), processingNodeNumber);
    }

    private void requestProcessingNodesList() {
        for (Object obj : ProcessingNodes.getObjectIDList(this.getPP(), ProcessingNodes.class)) {
            this.processingNodesList.add(new ProcessingNodes(this.getPP(), (Long)obj));
        }
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.processingNodeID = this.sql4javaSt.columnLong(this.colIndex++);
                this.processingNodeNumber = this.sql4javaSt.columnLong(this.colIndex++);
                this.time = Helper.getBigIntFromStr((String)this.sql4javaSt.columnString(this.colIndex++));
                this.messageKind = this.sql4javaSt.columnInt(this.colIndex++);
                this.message = this.sql4javaSt.columnString(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.processingNodeID = this.rs.getLong(this.colIndex++);
                this.processingNodeNumber = this.rs.getLong(this.colIndex++);
                this.time = Helper.getBigIntFromStr((String)this.rs.getString(this.colIndex++));
                this.messageKind = this.rs.getInt(this.colIndex++);
                this.message = this.rs.getString(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public long getMessageID() {
        return this.messageID;
    }

    public long getProcessingNodeID() {
        return this.processingNodeID;
    }

    public BigInteger getTime() {
        return this.time;
    }

    public int getMessageKind() {
        return this.messageKind;
    }

    public String getMessage() {
        return this.message;
    }

    public GregorianCalendar getFileTimeAsCalendar() {
        return FileTimes.getGregorianCalendar((String)this.time.toString());
    }

    public ArrayList<ProcessingNodes> getProcessingNodesList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNodesList;
    }

    @Override
    public long getProcessingNodeNumber() {
        return this.processingNodeNumber;
    }

    @Override
    public ProcessingNodes getProcessingNode() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNode;
    }

    @Override
    public String getSearchMachine() {
        return this.searchMachine;
    }
}

