/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.PDBaseClass;
import de.mpc.PD.PD_GUID;
import de.mpc.PD.Params.AProgramParameters;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class WorkflowInfo
extends PDBaseClass {
    private long workflowState = -1L;
    private String workflowName;
    private String workflowDescription;
    private Date workflowStartDate = null;
    private String workflowTemplate;
    private String user;
    private PD_GUID workflowGUID = null;
    private PD_GUID machineGUID = null;
    private String machineName;
    private boolean mergeSimilarIdentificationResults;
    private boolean isValid;
    private int version;

    public WorkflowInfo(AProgramParameters pp, long workflowState) {
        super(pp);
        this.workflowState = workflowState;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select WorkflowName, WorkflowDescription, WorkflowStartDate, WorkflowTemplate, User, WorkflowGUID, MachineGUID, MachineName, MergeSimilarIdentificationResults, IsValid, Version").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where WorkflowState = ?");
        this.initAndProcessPrepared(this.workflowState);
    }

    private void loadGUIDObjects() {
        if (this.workflowGUID != null) assert (this.isNotNull((Object)this.workflowGUID));
        if (this.machineGUID != null) assert (this.isNotNull((Object)this.machineGUID));
        this.bGUIDObjectsLoaded = true;
    }

    @Override
    protected final void setAllMembers() {
        if (this.getPP().isUsingSQLite4Java()) {
            this.colIndex = 0;
            try {
                this.workflowName = this.sql4javaSt.columnString(this.colIndex++);
                this.workflowDescription = this.sql4javaSt.columnString(this.colIndex++);
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                this.workflowStartDate = df.parse(this.sql4javaSt.columnString(this.colIndex++));
                this.workflowTemplate = this.sql4javaSt.columnString(this.colIndex++);
                this.user = this.sql4javaSt.columnString(this.colIndex++);
                this.workflowGUID = new PD_GUID(this.sql4javaSt.columnString(this.colIndex++));
                this.machineGUID = new PD_GUID(this.sql4javaSt.columnString(this.colIndex++));
                this.machineName = this.sql4javaSt.columnString(this.colIndex++);
                this.mergeSimilarIdentificationResults = this.sql4javaSt.columnInt(this.colIndex++) == 1;
                this.isValid = this.sql4javaSt.columnInt(this.colIndex++) == 1;
                this.version = this.sql4javaSt.columnInt(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
            catch (ParseException pex) {
                pex.printStackTrace(System.err);
            }
        } else {
            this.colIndex = 1;
            try {
                this.workflowName = this.rs.getString(this.colIndex++);
                this.workflowDescription = this.rs.getString(this.colIndex++);
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                this.workflowStartDate = df.parse(this.rs.getString(this.colIndex++));
                this.workflowTemplate = this.rs.getString(this.colIndex++);
                this.user = this.rs.getString(this.colIndex++);
                this.workflowGUID = new PD_GUID(this.rs.getString(this.colIndex++));
                this.machineGUID = new PD_GUID(this.rs.getString(this.colIndex++));
                this.machineName = this.rs.getString(this.colIndex++);
                this.mergeSimilarIdentificationResults = this.rs.getInt(this.colIndex++) == 1;
                this.isValid = this.rs.getInt(this.colIndex++) == 1;
                this.version = this.rs.getInt(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
            catch (ParseException pex) {
                pex.printStackTrace(System.err);
            }
        }
    }

    public long getWorkflowState() {
        return this.workflowState;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public String getWorkflowDescription() {
        return this.workflowDescription;
    }

    public Date getWorkflowStartDate() {
        return this.workflowStartDate;
    }

    public String getWorkflowTemplate() {
        return this.workflowTemplate;
    }

    public String getUser() {
        return this.user;
    }

    public PD_GUID getWorkflowGUID() {
        return this.workflowGUID;
    }

    public PD_GUID getMachinewGUID() {
        return this.machineGUID;
    }

    public String getMachineName() {
        return this.machineName;
    }

    public boolean isMergeSimilarIdentificationResults() {
        return this.mergeSimilarIdentificationResults;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public int getVersion() {
        return this.version;
    }
}

