/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.PDBaseClassSinglePrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import java.sql.SQLException;

public class TaxonomyNodes
extends PDBaseClassSinglePrimaryKey {
    private long taxonomyID = -1L;
    private long parentTaxonomyID;
    private int taxonomyRank;
    private int leftNodeIndex;
    private int rightNodeIndex;
    private TaxonomyNodes parentTaxonomy = null;

    public TaxonomyNodes(AProgramParameters pp, long taxonomyID) {
        super(pp);
        this.taxonomyID = taxonomyID;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select ParentTaxonomyID, TaxonomyRank, LeftNodeIndex, RightNodeIndex").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where TaxonomyID = ?");
        this.initAndProcessPrepared(this.taxonomyID);
    }

    private void loadForeignKeyObjects() {
        if (this.parentTaxonomyID > -1L && this.parentTaxonomy == null) {
            this.parentTaxonomy = this.requestParentTaxonomy(this.parentTaxonomyID);
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private TaxonomyNodes requestParentTaxonomy(long parentTaxID) {
        return new TaxonomyNodes(this.getPP(), parentTaxID);
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.parentTaxonomyID = this.sql4javaSt.columnLong(this.colIndex++);
                this.taxonomyRank = this.sql4javaSt.columnInt(this.colIndex++);
                this.leftNodeIndex = this.sql4javaSt.columnInt(this.colIndex++);
                this.rightNodeIndex = this.sql4javaSt.columnInt(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.parentTaxonomyID = this.rs.getLong(this.colIndex++);
                this.taxonomyRank = this.rs.getInt(this.colIndex++);
                this.leftNodeIndex = this.rs.getInt(this.colIndex++);
                this.rightNodeIndex = this.rs.getInt(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public long getTaxonomyID() {
        return this.taxonomyID;
    }

    public long getParentTaxonomyID() {
        return this.parentTaxonomyID;
    }

    public int getTaxonomyRank() {
        return this.taxonomyRank;
    }

    public int getLeftNodeIndex() {
        return this.leftNodeIndex;
    }

    public int getRightNodeIndex() {
        return this.rightNodeIndex;
    }

    public TaxonomyNodes getParentTaxonomy() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.parentTaxonomy;
    }
}

