/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.PDBaseClassTripledUniqueKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.TaxonomyNodes;

public class TaxonomyNames
extends PDBaseClassTripledUniqueKey {
    private long taxonomyID = -1L;
    private long nameCategory = -1L;
    private final String name;
    private TaxonomyNodes taxonomyNode = null;

    public TaxonomyNames(AProgramParameters pp, long taxonomyID, long nameCategory, String name) {
        super(pp);
        this.taxonomyID = taxonomyID;
        this.nameCategory = nameCategory;
        this.name = name;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select *").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where Name = ? and TaxonomyID = ? and NameCategory");
        this.initAndProcessPrepared(this.name, this.taxonomyID, this.nameCategory);
    }

    private void loadForeignKeyObjects() {
        if (this.taxonomyID > -1L && this.taxonomyNode == null) {
            this.taxonomyNode = this.requestTaxonomyNode(this.taxonomyID);
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private TaxonomyNodes requestTaxonomyNode(long taxID) {
        return new TaxonomyNodes(this.getPP(), taxID);
    }

    public long getTaxonomyID() {
        return this.taxonomyID;
    }

    public long getNameCategory() {
        return this.nameCategory;
    }

    public String getName() {
        return this.name;
    }

    public TaxonomyNodes getTaxonomyNode() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.taxonomyNode;
    }
}

