/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.IPNNable;
import de.mpc.PD.PDBaseClassPairedPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.ProcessingNodes;
import de.mpc.PD.SMsFromPNN;
import de.mpc.PD.SpectrumHeaders;
import java.sql.SQLException;
import java.util.ArrayList;

public class SpectrumScores
extends PDBaseClassPairedPrimaryKey
implements IPNNable {
    private long processingNodeNumber = -1L;
    private long spectrumID = -1L;
    private double score;
    private SpectrumHeaders spectrumHeader = null;
    private ProcessingNodes processingNode = null;
    private final ArrayList<SpectrumHeaders> spectrumHeadersList = new ArrayList();
    private final ArrayList<ProcessingNodes> processingNodesList = new ArrayList();
    private final String searchMachine;

    public SpectrumScores(AProgramParameters pp, long processingNodeNo, long spectrumID) {
        super(pp);
        this.processingNodeNumber = processingNodeNo;
        this.spectrumID = spectrumID;
        this.initFromDB();
        this.searchMachine = SMsFromPNN.retrieveSearchMachineForProcessingNodeNumber(pp, this.processingNodeNumber);
    }

    private void initFromDB() {
        this.sb.append("select Score").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where ProcessingNodeNumber = ? and SpectrumID = ?");
        this.initAndProcessPrepared(this.getProcessingNodeNumber(), this.spectrumID);
    }

    private void loadForeignKeyObjects() {
        if (this.spectrumID > -1L && this.spectrumHeader == null) {
            this.spectrumHeader = this.requestSpectrumHeader(this.spectrumID);
        }
        if (this.processingNodeNumber > -1L && this.processingNode == null) {
            this.processingNode = this.requestProcessingNode(this.processingNodeNumber);
        }
        if (this.spectrumID > -1L) {
            this.requestSpectrumHeadersList();
        }
        if (this.processingNodeNumber > -1L) {
            this.requestProcessingNodesList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private SpectrumHeaders requestSpectrumHeader(long spectID) {
        return new SpectrumHeaders(this.getPP(), spectID);
    }

    private ProcessingNodes requestProcessingNode(long processingNodeNumber) {
        return new ProcessingNodes(this.getPP(), processingNodeNumber);
    }

    private void requestSpectrumHeadersList() {
        for (Object obj : SpectrumHeaders.getObjectIDList(this.getPP(), SpectrumHeaders.class)) {
            this.spectrumHeadersList.add(new SpectrumHeaders(this.getPP(), (Long)obj));
        }
    }

    private void requestProcessingNodesList() {
        for (Object obj : ProcessingNodes.getObjectIDList(this.getPP(), ProcessingNodes.class)) {
            this.processingNodesList.add(new ProcessingNodes(this.getPP(), (Long)obj));
        }
    }

    @Override
    protected final void setAllMembers() {
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.score = this.sql4javaSt.columnDouble(0);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.score = this.rs.getDouble(1);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public long getSpectrumID() {
        return this.spectrumID;
    }

    public double getScore() {
        return this.score;
    }

    public SpectrumHeaders getSpectrumHeader() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.spectrumHeader;
    }

    public ArrayList<SpectrumHeaders> getSpectrumHeadersList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.spectrumHeadersList;
    }

    public ArrayList<ProcessingNodes> getProcessingNodesList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNodesList;
    }

    @Override
    public long getProcessingNodeNumber() {
        return this.processingNodeNumber;
    }

    @Override
    public ProcessingNodes getProcessingNode() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNode;
    }

    @Override
    public String getSearchMachine() {
        return this.searchMachine;
    }
}

