/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.CustomDataFields;
import de.mpc.PD.IMZable;
import de.mpc.PD.IPNNable;
import de.mpc.PD.MassPeaks;
import de.mpc.PD.PDBaseClassSinglePrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.ProcessingNodes;
import de.mpc.PD.QuanResults;
import de.mpc.PD.SMsFromPNN;
import de.mpc.PD.ScanEvents;
import de.mpc.PD.Spectra;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class SpectrumHeaders
extends PDBaseClassSinglePrimaryKey
implements IPNNable,
IMZable {
    private long spectrumID = -1L;
    private long creatingProcessingNodeNumber = -1L;
    private long massPeakID;
    private long scanEventID;
    private int lastScan;
    private int firstScan;
    private double retentionTime;
    private boolean hidden;
    private String scanNumbers;
    private short charge;
    private double mass;
    private long uniqueSpectrumID;
    private MassPeaks massPeak = null;
    private ScanEvents scanEvent = null;
    private Spectra uniqueSpectra = null;
    private ProcessingNodes creatingProcessingNode = null;
    private final ArrayList<ScanEvents> scanEventsList = new ArrayList();
    private final ArrayList<ProcessingNodes> creatingProcessingNodesList = new ArrayList();
    private final HashMap<Long, QuanResults> quanResultsMap = new HashMap();
    private boolean bFilledQuanResultsMap = false;
    private final HashMap<Long, ProcessingNodes> sendingProcessingNodesMap = new HashMap();
    private boolean bFilledSendingProcessingNodesMap = false;
    private final HashMap<Long, ProcessingNodes> reporterIonQuanResultsProcessingNodesMap = new HashMap();
    private boolean bFilledReporterIonQuanResultsProcessingNodesMap = false;
    private final HashMap<Long, CustomDataFields> customDataMap = new HashMap();
    private boolean bFilledCustomDataMap = false;
    private final String searchMachine;

    public SpectrumHeaders(AProgramParameters pp, long spectrumID) {
        super(pp);
        this.spectrumID = spectrumID;
        this.initFromDB();
        this.searchMachine = SMsFromPNN.retrieveSearchMachineForProcessingNodeNumber(pp, this.creatingProcessingNodeNumber);
    }

    private void initFromDB() {
        this.sb.append("select MassPeakID, ScanEventID, LastScan, FirstScan, RetentionTime, Hidden, ScanNumbers, Charge, Mass, CreatingProcessingNodeNumber, UniqueSpectrumID").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where SpectrumID = ?");
        this.initAndProcessPrepared(this.spectrumID);
    }

    private void loadForeignKeyObjects() {
        if (this.massPeakID > -1L && this.massPeak == null) {
            this.massPeak = this.requestMassPeak(this.massPeakID);
        }
        if (this.scanEventID > -1L && this.scanEvent == null) {
            this.scanEvent = this.requestScanEvent(this.scanEventID);
        }
        if (this.uniqueSpectrumID > -1L && this.uniqueSpectra == null) {
            this.uniqueSpectra = this.requestSpectra(this.uniqueSpectrumID);
        }
        if (this.creatingProcessingNodeNumber > -1L && this.creatingProcessingNode == null) {
            this.creatingProcessingNode = this.requestCreatingProcessingNode(this.creatingProcessingNodeNumber);
        }
        if (this.scanEventID > -1L) {
            this.requestScanEventsList();
        }
        if (this.creatingProcessingNodeNumber > -1L) {
            this.requestCreatingProcessingNodesListList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private ProcessingNodes requestCreatingProcessingNode(long processingNodeNumber) {
        return new ProcessingNodes(this.getPP(), processingNodeNumber);
    }

    private MassPeaks requestMassPeak(long massPeakID) {
        return new MassPeaks(this.getPP(), massPeakID);
    }

    private ScanEvents requestScanEvent(long scanEvtID) {
        return new ScanEvents(this.getPP(), scanEvtID);
    }

    private Spectra requestSpectra(long spectID) {
        return new Spectra(this.getPP(), spectID);
    }

    private void requestScanEventsList() {
        for (Object obj : ScanEvents.getObjectIDList(this.getPP(), ScanEvents.class)) {
            this.scanEventsList.add(new ScanEvents(this.getPP(), (Long)obj));
        }
    }

    private void requestCreatingProcessingNodesListList() {
        for (Object obj : ProcessingNodes.getObjectIDList(this.getPP(), ProcessingNodes.class)) {
            this.creatingProcessingNodesList.add(new ProcessingNodes(this.getPP(), (Long)obj));
        }
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.massPeakID = this.sql4javaSt.columnLong(this.colIndex++);
                this.scanEventID = this.sql4javaSt.columnLong(this.colIndex++);
                this.lastScan = this.sql4javaSt.columnInt(this.colIndex++);
                this.firstScan = this.sql4javaSt.columnInt(this.colIndex++);
                this.retentionTime = this.sql4javaSt.columnDouble(this.colIndex++);
                this.hidden = this.sql4javaSt.columnInt(this.colIndex++) == 1;
                this.scanNumbers = this.sql4javaSt.columnString(this.colIndex++);
                this.charge = (short)this.sql4javaSt.columnInt(this.colIndex++);
                this.mass = this.sql4javaSt.columnDouble(this.colIndex++);
                this.creatingProcessingNodeNumber = this.sql4javaSt.columnLong(this.colIndex++);
                this.uniqueSpectrumID = this.sql4javaSt.columnLong(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.massPeakID = this.rs.getLong(this.colIndex++);
                this.scanEventID = this.rs.getLong(this.colIndex++);
                this.lastScan = this.rs.getInt(this.colIndex++);
                this.firstScan = this.rs.getInt(this.colIndex++);
                this.retentionTime = this.rs.getDouble(this.colIndex++);
                this.hidden = this.rs.getInt(this.colIndex++) == 1;
                this.scanNumbers = this.rs.getString(this.colIndex++);
                this.charge = this.rs.getShort(this.colIndex++);
                this.mass = this.rs.getDouble(this.colIndex++);
                this.creatingProcessingNodeNumber = this.rs.getLong(this.colIndex++);
                this.uniqueSpectrumID = this.rs.getLong(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    @Override
    public long getID() {
        return this.spectrumID;
    }

    public long getSpectrumID() {
        return this.spectrumID;
    }

    public long getMassPeakID() {
        return this.massPeakID;
    }

    public long getScanEventID() {
        return this.scanEventID;
    }

    public int getLastScan() {
        return this.lastScan;
    }

    public int getFirstScan() {
        return this.firstScan;
    }

    public double getRetentionTime() {
        return this.retentionTime;
    }

    public boolean getHidden() {
        return this.hidden;
    }

    public String getScanNumbers() {
        return this.scanNumbers;
    }

    public short getCharge() {
        return this.charge;
    }

    public double getMass() {
        return this.mass;
    }

    public long getCreatingProcessingNodeNumber() {
        return this.creatingProcessingNodeNumber;
    }

    public long getUniqueSpectrumID() {
        return this.uniqueSpectrumID;
    }

    @Override
    public float getMz() {
        if (this.charge != 0) {
            return (float)(this.mass / (double)this.charge);
        }
        return Float.POSITIVE_INFINITY;
    }

    public MassPeaks getMassPeak() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.massPeak;
    }

    public ScanEvents getScanEvent() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.scanEvent;
    }

    public Spectra getSpectra() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.uniqueSpectra;
    }

    public ProcessingNodes getCreatingProcessingNode() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.creatingProcessingNode;
    }

    private HashMap<Long, QuanResults> getQuanResults() {
        StringBuilder strB = new StringBuilder("select qr.QuanResultID").append(MyConstants.newline);
        strB.append("from ").append("SpectrumHeaders as sh, ").append("QuanResults as qr, ").append("PrecursorIonAreaSearchSpectra as link").append(MyConstants.newline);
        strB.append("where sh.SearchSpectrumID = ").append(this.getSpectrumID()).append(MyConstants.newline);
        strB.append("and link.QuanResultID = qr.QuanResultID").append(MyConstants.newline);
        strB.append("and link.SearchSpectrumID = sh.SearchSpectrumID");
        this.fillSinglePrimaryKeyGenericMap(strB.toString(), this.quanResultsMap, QuanResults.class, this.getSpectrumID(), new long[0]);
        this.bFilledQuanResultsMap = true;
        return this.quanResultsMap;
    }

    private HashMap<Long, ProcessingNodes> getProcessingNodes() {
        StringBuilder strB = new StringBuilder("select pn.ProcessingNodeNumber").append(MyConstants.newline);
        strB.append("from ").append("SpectrumHeaders as sh, ").append("ProcessingNodes as pn, ").append("ProcessingNodesSpectra as link").append(MyConstants.newline);
        strB.append("where sh.SpectrumID = ").append(this.getSpectrumID()).append(MyConstants.newline);
        strB.append("and link.SendingProcessingNodeNumber = pn.SendingProcessingNodeNumber").append(MyConstants.newline);
        strB.append("and link.SpectrumID = sh.SpectrumID");
        this.fillSinglePrimaryKeyGenericMap(strB.toString(), this.sendingProcessingNodesMap, ProcessingNodes.class, this.getSpectrumID(), new long[0]);
        this.bFilledSendingProcessingNodesMap = true;
        return this.sendingProcessingNodesMap;
    }

    private HashMap<Long, ProcessingNodes> getReporterIonQuanResultsProcessingNodes() {
        StringBuilder strB = new StringBuilder("select pn.ProcessingNodeNumber").append(MyConstants.newline);
        strB.append("from ").append("SpectrumHeaders as sh, ").append("ProcessingNodes as pn, ").append("ReporterIonQuanResultsSearchSpectra as link").append(MyConstants.newline);
        strB.append("where sh.SpectrumID = ").append(this.getSpectrumID()).append(MyConstants.newline);
        strB.append("and link.ProcessingNodeNumber = pn.ProcessingNodeNumber").append(MyConstants.newline);
        strB.append("and link.SpectrumID = sh.SpectrumID");
        this.fillSinglePrimaryKeyGenericMap(strB.toString(), this.reporterIonQuanResultsProcessingNodesMap, ProcessingNodes.class, this.getSpectrumID(), new long[0]);
        this.bFilledReporterIonQuanResultsProcessingNodesMap = true;
        return this.reporterIonQuanResultsProcessingNodesMap;
    }

    private HashMap<Long, CustomDataFields> getCustomDataFields() {
        StringBuilder strB = new StringBuilder("select cdf.FieldID").append(MyConstants.newline);
        strB.append("from ").append("SpectrumHeaders as spect, ").append("CustomDataFields as cdf, ").append("CustomDataSpectra as link").append(MyConstants.newline);
        strB.append("where spect.SpectrumID = ").append(this.getSpectrumID()).append(MyConstants.newline);
        strB.append("and link.FieldID = cdf.FieldID").append(MyConstants.newline);
        strB.append("and link.SpectrumID = spect.SpectrumID");
        this.fillSinglePrimaryKeyGenericMap(strB.toString(), this.customDataMap, CustomDataFields.class, this.getSpectrumID(), new long[0]);
        this.bFilledCustomDataMap = true;
        return this.customDataMap;
    }

    public QuanResults getQuanResult(long ID) {
        if (!this.bFilledQuanResultsMap) {
            this.getQuanResults();
        }
        if (this.quanResultsMap.containsKey(ID)) {
            return this.quanResultsMap.get(ID);
        }
        return null;
    }

    public int getNoOfQuanResults() {
        if (!this.bFilledQuanResultsMap) {
            this.getQuanResults();
        }
        return this.quanResultsMap.size();
    }

    public boolean hasQuanResultsLinks() {
        if (!this.bFilledQuanResultsMap) {
            this.getQuanResults();
        }
        return !this.quanResultsMap.isEmpty();
    }

    public ProcessingNodes getProcessingNode(long ID) {
        if (!this.bFilledSendingProcessingNodesMap) {
            this.getProcessingNodes();
        }
        if (this.sendingProcessingNodesMap.containsKey(ID)) {
            return this.sendingProcessingNodesMap.get(ID);
        }
        return null;
    }

    public int getNoOfProcessingNodes() {
        if (!this.bFilledSendingProcessingNodesMap) {
            this.getProcessingNodes();
        }
        return this.sendingProcessingNodesMap.size();
    }

    public boolean hasProcessingNodesLinks() {
        if (!this.bFilledSendingProcessingNodesMap) {
            this.getProcessingNodes();
        }
        return !this.sendingProcessingNodesMap.isEmpty();
    }

    public ProcessingNodes getReporterIonQuanResultsProcessingNode(long ID) {
        if (!this.bFilledReporterIonQuanResultsProcessingNodesMap) {
            this.getReporterIonQuanResultsProcessingNodes();
        }
        if (this.reporterIonQuanResultsProcessingNodesMap.containsKey(ID)) {
            return this.reporterIonQuanResultsProcessingNodesMap.get(ID);
        }
        return null;
    }

    public int getNoOfReporterIonQuanResultsProcessingNodes() {
        if (!this.bFilledReporterIonQuanResultsProcessingNodesMap) {
            this.getReporterIonQuanResultsProcessingNodes();
        }
        return this.reporterIonQuanResultsProcessingNodesMap.size();
    }

    public boolean hasReporterIonQuanResultsProcessingNodesLinks() {
        if (!this.bFilledReporterIonQuanResultsProcessingNodesMap) {
            this.getReporterIonQuanResultsProcessingNodes();
        }
        return !this.reporterIonQuanResultsProcessingNodesMap.isEmpty();
    }

    public CustomDataFields getCustomData(long ID) {
        if (!this.bFilledCustomDataMap) {
            this.getCustomDataFields();
        }
        if (this.customDataMap.containsKey(ID)) {
            return this.customDataMap.get(ID);
        }
        return null;
    }

    public int getNoOfCustomData() {
        if (!this.bFilledCustomDataMap) {
            this.getCustomDataFields();
        }
        return this.customDataMap.size();
    }

    public boolean hasCustomDataLinks() {
        if (!this.bFilledCustomDataMap) {
            this.getCustomDataFields();
        }
        return !this.customDataMap.isEmpty();
    }

    @Override
    public long getProcessingNodeNumber() {
        return this.creatingProcessingNodeNumber;
    }

    @Override
    public ProcessingNodes getProcessingNode() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.creatingProcessingNode;
    }

    @Override
    public String getSearchMachine() {
        return this.searchMachine;
    }

    public ArrayList<ScanEvents> getScanEventsList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.scanEventsList;
    }

    public ArrayList<ProcessingNodes> getCreatingProcessingNodesList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.creatingProcessingNodesList;
    }
}

