/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.PDBaseClassSinglePrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SchemaInfo
extends PDBaseClassSinglePrimaryKey {
    private long versionID = -1L;
    private String kind;
    private Date date = null;
    private String softwareVersion;
    private String comment;
    private boolean bSetVersion = false;

    public SchemaInfo(AProgramParameters pp, long versionID) {
        super(pp);
        this.versionID = versionID;
        this.initFromDBPrepared();
    }

    public SchemaInfo(AProgramParameters pp) {
        super(pp);
        this.initFromDB();
    }

    private void initFromDBPrepared() {
        this.sb.append("select Kind, Date, SoftwareVersion, Comment").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where Version = ?");
        this.bSetVersion = false;
        this.initAndProcessPrepared(this.versionID);
    }

    private void initFromDB() {
        this.sb.append("select Version, Kind, Date, SoftwareVersion, Comment").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.bSetVersion = true;
        this.initAndProcessPreparedPD();
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                if (this.bSetVersion) {
                    this.versionID = this.sql4javaSt.columnLong(this.colIndex++);
                }
                this.kind = this.sql4javaSt.columnString(this.colIndex++);
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                this.date = df.parse(this.sql4javaSt.columnString(this.colIndex++));
                this.softwareVersion = this.sql4javaSt.columnString(this.colIndex++);
                this.comment = this.sql4javaSt.columnString(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
            catch (ParseException pex) {
                pex.printStackTrace(System.err);
            }
        } else {
            try {
                if (this.bSetVersion) {
                    this.versionID = this.rs.getLong(this.colIndex++);
                }
                this.kind = this.rs.getString(this.colIndex++);
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                this.date = df.parse(this.rs.getString(this.colIndex++));
                this.softwareVersion = this.rs.getString(this.colIndex++);
                this.comment = this.rs.getString(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
            catch (ParseException pex) {
                pex.printStackTrace(System.err);
            }
        }
    }

    public long getVersion() {
        return this.versionID;
    }

    public String getKind() {
        return this.kind;
    }

    public Date getDate() {
        return this.date;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public String getMajorSoftwareVersion() {
        String match = "";
        Pattern pattern = Pattern.compile("(([0-9]{1,2}\\.[0-9]{1,2})(\\.[0-9]{1,2}\\.[0-9]{3,4}))");
        Matcher matcher = pattern.matcher(this.softwareVersion);
        if (matcher.find()) {
            match = matcher.group(1);
        }
        return match;
    }

    public String getMinorSoftwareVersion() {
        String match = "";
        Pattern pattern = Pattern.compile("(([0-9]{1,2}\\.[0-9]{1,2})(\\.[0-9]{1,2}\\.[0-9]{3,4}))");
        Matcher matcher = pattern.matcher(this.softwareVersion);
        if (matcher.find()) {
            match = matcher.group(2).substring(1);
        }
        return match;
    }

    public String getComment() {
        return this.comment;
    }
}

