/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.PDBaseClassSinglePrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import java.sql.SQLException;

public class ScanEvents
extends PDBaseClassSinglePrimaryKey {
    private long scanEventID = -1L;
    private MSLevel msLevel;
    private Polarity polarity;
    private ScanType scanType;
    private Ionization ionization;
    private MassAnalyzer massAnalyzer;
    private ActivationType activationType;

    public ScanEvents(AProgramParameters pp, long scanEventID) {
        super(pp);
        this.scanEventID = scanEventID;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select MSLevel, Polarity, ScanType, Ionization, MassAnalyzer, ActivationType").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where ScanEventID = ?");
        this.initAndProcessPrepared(this.scanEventID);
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.msLevel = MSLevel.fromStringValue(this.sql4javaSt.columnString(this.colIndex++));
                this.polarity = Polarity.fromStringValue(this.sql4javaSt.columnString(this.colIndex++));
                this.scanType = ScanType.fromStringValue(this.sql4javaSt.columnString(this.colIndex++));
                this.ionization = Ionization.fromStringValue(this.sql4javaSt.columnString(this.colIndex++));
                this.massAnalyzer = MassAnalyzer.fromStringValue(this.sql4javaSt.columnString(this.colIndex++));
                this.activationType = ActivationType.fromStringValue(this.sql4javaSt.columnString(this.colIndex++));
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.msLevel = MSLevel.fromStringValue(this.rs.getString(this.colIndex++));
                this.polarity = Polarity.fromStringValue(this.rs.getString(this.colIndex++));
                this.scanType = ScanType.fromStringValue(this.rs.getString(this.colIndex++));
                this.ionization = Ionization.fromStringValue(this.rs.getString(this.colIndex++));
                this.massAnalyzer = MassAnalyzer.fromStringValue(this.rs.getString(this.colIndex++));
                this.activationType = ActivationType.fromStringValue(this.rs.getString(this.colIndex++));
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public long getScanEventID() {
        return this.scanEventID;
    }

    public MSLevel getMSLevel() {
        return this.msLevel;
    }

    public Polarity getPolarity() {
        return this.polarity;
    }

    public ScanType getScanType() {
        return this.scanType;
    }

    public Ionization getIonization() {
        return this.ionization;
    }

    public MassAnalyzer getMassAnalyzer() {
        return this.massAnalyzer;
    }

    public ActivationType getActivationType() {
        return this.activationType;
    }

    public static enum ActivationType {
        UNKNOWN(0),
        CID(1),
        MPD(2),
        ECD(3),
        PQD(4),
        ETD(5),
        HCD(6);

        private final short activationType;

        private ActivationType(short activationType) {
            this.activationType = activationType;
        }

        public int getActivationTypeCode() {
            return this.activationType;
        }

        public static ActivationType fromStringValue(String valStr) {
            switch (Integer.parseInt(valStr)) {
                case 1: {
                    return CID;
                }
                case 2: {
                    return MPD;
                }
                case 3: {
                    return ECD;
                }
                case 4: {
                    return PQD;
                }
                case 5: {
                    return ETD;
                }
                case 6: {
                    return HCD;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum Ionization {
        UNKNOWN(0),
        ElectroSpray(1),
        NanoSpray(2),
        ThermoSpray(3),
        ElectronImpact(4),
        APCI(5),
        MALDI(6),
        ChemicalIonization(7),
        FAB(8),
        FieldDesorption(9),
        GlowDischarge(10);

        private final short ionization;

        private Ionization(short ionization) {
            this.ionization = ionization;
        }

        public int getIonizationCode() {
            return this.ionization;
        }

        public static Ionization fromStringValue(String valStr) {
            switch (Integer.parseInt(valStr)) {
                case 1: {
                    return ElectroSpray;
                }
                case 2: {
                    return NanoSpray;
                }
                case 3: {
                    return ThermoSpray;
                }
                case 4: {
                    return ElectronImpact;
                }
                case 5: {
                    return APCI;
                }
                case 6: {
                    return MALDI;
                }
                case 7: {
                    return ChemicalIonization;
                }
                case 8: {
                    return FAB;
                }
                case 9: {
                    return FieldDesorption;
                }
                case 10: {
                    return GlowDischarge;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum MSLevel {
        UNKNOWN(0),
        MS1(1),
        MS2(2);

        private final short msLevel;

        private MSLevel(short msLevel) {
            this.msLevel = msLevel;
        }

        public int getMSLevelCode() {
            return this.msLevel;
        }

        public static MSLevel fromStringValue(String valStr) {
            switch (Integer.parseInt(valStr)) {
                case 1: {
                    return MS1;
                }
                case 2: {
                    return MS2;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum MassAnalyzer {
        UNKNOWN(0),
        ITMS(1),
        FTMS(2),
        TOF(3),
        SQMS(4),
        TripleQuad(5),
        SectorField(6);

        private final short massAnalyzer;

        private MassAnalyzer(short massAnalyzer) {
            this.massAnalyzer = massAnalyzer;
        }

        public int getMassAnalyzerCode() {
            return this.massAnalyzer;
        }

        public static MassAnalyzer fromStringValue(String valStr) {
            switch (Integer.parseInt(valStr)) {
                case 1: {
                    return ITMS;
                }
                case 2: {
                    return FTMS;
                }
                case 3: {
                    return TOF;
                }
                case 4: {
                    return SQMS;
                }
                case 5: {
                    return TripleQuad;
                }
                case 6: {
                    return SectorField;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum Polarity {
        UNKNOWN(0),
        PositiveMode(1),
        NegativeMode(2);

        private final short polarity;

        private Polarity(short polarity) {
            this.polarity = polarity;
        }

        public int getPolarityCode() {
            return this.polarity;
        }

        public static Polarity fromStringValue(String valStr) {
            switch (Integer.parseInt(valStr)) {
                case 1: {
                    return PositiveMode;
                }
                case 2: {
                    return NegativeMode;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum ScanType {
        UNKNOWN(0),
        Full(1),
        SIM(2),
        SRM(3);

        private final short scanType;

        private ScanType(short scanType) {
            this.scanType = scanType;
        }

        public int getScanTypeCode() {
            return this.scanType;
        }

        public static ScanType fromStringValue(String valStr) {
            switch (Integer.parseInt(valStr)) {
                case 1: {
                    return Full;
                }
                case 2: {
                    return SIM;
                }
                case 3: {
                    return SRM;
                }
            }
            return UNKNOWN;
        }
    }
}

