/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.Params.AProgramParameters;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SMsFromPNN {
    private static final String STR_LIKE_SM = "LIKE '%SEQUEST%' or FriendlyName LIKE '%Mascot%' OR FriendlyName Like '%ZCore%'";
    private static final int COL_1 = 1;
    private static final int COL_2 = 2;

    public static String retrieveSearchMachineForProcessingNodeNumber(AProgramParameters pp, long processingNodeNumber) {
        String searchMachine = "";
        StringBuilder strB = new StringBuilder();
        strB.append("SELECT ProcessingNodeNumber, FriendlyName").append(MyConstants.newline);
        strB.append("FROM ProcessingNodes").append(MyConstants.newline);
        strB.append("WHERE FriendlyName ").append(STR_LIKE_SM).append(MyConstants.newline);
        strB.append("AND ProcessingNodeNumber = ").append(processingNodeNumber);
        String sqlStr = strB.toString();
        if (pp.isUsingSQLite4Java()) {
            try {
                SQLiteStatement sqlSt = pp.getSQLiteAccess().dbConn.prepare(sqlStr);
                try {
                    while (sqlSt.step()) {
                        searchMachine = sqlSt.columnString(1);
                    }
                }
                finally {
                    sqlSt.dispose();
                }
            }
            catch (SQLiteException sqliteex) {
                pp.getSQLiteAccess().handleSQLite4JavaError(sqliteex);
                sqliteex.printStackTrace(System.err);
            }
        } else if (pp.isUsingJDBC()) {
            try {
                Statement st = pp.getJDBCAccess().dbConn.createStatement();
                ResultSet rs = st.executeQuery(sqlStr);
                try {
                    while (rs.next()) {
                        searchMachine = rs.getString(2);
                    }
                }
                finally {
                    st.close();
                }
            }
            catch (SQLException sex) {
                pp.getJDBCAccess().handleJDBCError(sex);
                sex.printStackTrace(System.err);
            }
        }
        return searchMachine;
    }
}

