/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.AIonQuanResultsSearchSpectra;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.ProcessingNodes;
import de.mpc.PD.SpectrumHeaders;
import java.sql.SQLException;
import java.util.ArrayList;

public class ReporterIonQuanResultsSearchSpectra
extends AIonQuanResultsSearchSpectra {
    private long spectrumID = -1L;
    private final ArrayList<ProcessingNodes> processingNodesList = new ArrayList();
    private final ArrayList<SpectrumHeaders> spectrumHeadersList = new ArrayList();
    private final ArrayList<SpectrumHeaders> searchSpectrumHeadersList = new ArrayList();

    public ReporterIonQuanResultsSearchSpectra(AProgramParameters pp, long processingNodeNumber, long spectrumID) {
        super(pp, processingNodeNumber);
        this.processingNodeNumber = processingNodeNumber;
        this.spectrumID = spectrumID;
        this.initFromDB();
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.spectrumID = this.sql4javaSt.columnLong(this.colIndex++);
                this.searchSpectrumID = this.sql4javaSt.columnLong(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.spectrumID = this.rs.getLong(this.colIndex++);
                this.searchSpectrumID = this.rs.getLong(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    private void initFromDB() {
        this.sb.append("select SpectrumID, SearchSpectrumID").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where ProcessingNodeNumber = ? and QuanResultID = ?");
        this.initAndProcessPrepared(this.getProcessingNodeNumber(), this.spectrumID);
    }

    @Override
    protected final void loadForeignKeyObjects() {
        if (this.processingNodeNumber > -1L) {
            this.requestProcessingNodesList();
        }
        if (this.spectrumID > -1L) {
            this.requestSpectrumHeadersList();
        }
        if (this.searchSpectrumID > -1L) {
            this.requestSearchSpectrumHeadersList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private void requestProcessingNodesList() {
        for (Object obj : ProcessingNodes.getObjectIDList(this.getPP(), ProcessingNodes.class)) {
            this.processingNodesList.add(new ProcessingNodes(this.getPP(), (Long)obj));
        }
    }

    private void requestSpectrumHeadersList() {
        for (Object obj : SpectrumHeaders.getObjectIDList(this.getPP(), SpectrumHeaders.class)) {
            this.spectrumHeadersList.add(new SpectrumHeaders(this.getPP(), (Long)obj));
        }
    }

    private void requestSearchSpectrumHeadersList() {
        for (Object obj : SpectrumHeaders.getObjectIDList(this.getPP(), SpectrumHeaders.class)) {
            this.searchSpectrumHeadersList.add(new SpectrumHeaders(this.getPP(), (Long)obj));
        }
    }

    public ArrayList<ProcessingNodes> getProcessingNodesList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNodesList;
    }

    public ArrayList<SpectrumHeaders> getSpectrumHeadersList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.spectrumHeadersList;
    }

    public ArrayList<SpectrumHeaders> getSearchSpectrumHeadersList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.searchSpectrumHeadersList;
    }
}

