/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.IPNNable;
import de.mpc.PD.PDBaseClassTripledPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.ProcessingNodes;
import de.mpc.PD.SMsFromPNN;
import de.mpc.PD.SpectrumHeaders;
import java.sql.SQLException;

public class ReporterIonQuanResults
extends PDBaseClassTripledPrimaryKey
implements IPNNable {
    private long processingNodeNumber = -1L;
    private long quanChannelID = -1L;
    private long spectrumID = -1L;
    private double mass;
    private double height;
    private SpectrumHeaders spectrumHeader = null;
    private ProcessingNodes processingNode = null;
    private final String searchMachine;

    public ReporterIonQuanResults(AProgramParameters pp, long processingNodeNo, long quanChannelID, long spectrumID) {
        super(pp);
        this.processingNodeNumber = processingNodeNo;
        this.quanChannelID = quanChannelID;
        this.spectrumID = spectrumID;
        this.initFromDB();
        this.searchMachine = SMsFromPNN.retrieveSearchMachineForProcessingNodeNumber(pp, this.processingNodeNumber);
    }

    private void initFromDB() {
        this.sb.append("select Mass, Height").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where ProcessingNodeNumber = ? and QuanChannelID = ? and SpectrumID = ?");
        this.initAndProcessPrepared(this.getProcessingNodeNumber(), this.quanChannelID, this.spectrumID);
    }

    private void loadForeignKeyObjects() {
        if (this.processingNodeNumber > -1L && this.processingNode == null) {
            this.processingNode = this.requestProcessingNode(this.processingNodeNumber);
        }
        if (this.spectrumID > -1L && this.spectrumHeader == null) {
            this.spectrumHeader = this.requestSpectrumHeader(this.spectrumID);
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private SpectrumHeaders requestSpectrumHeader(long spectID) {
        return new SpectrumHeaders(this.getPP(), spectID);
    }

    private ProcessingNodes requestProcessingNode(long processingNodeNumber) {
        return new ProcessingNodes(this.getPP(), processingNodeNumber);
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.mass = this.sql4javaSt.columnDouble(this.colIndex++);
                this.height = this.sql4javaSt.columnDouble(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.mass = this.rs.getDouble(this.colIndex++);
                this.height = this.rs.getDouble(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public long getQuanChannelID() {
        return this.quanChannelID;
    }

    public long getSpectrumID() {
        return this.spectrumID;
    }

    public double getMass() {
        return this.mass;
    }

    public double getHeight() {
        return this.height;
    }

    public SpectrumHeaders getSpectrumHeader() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.spectrumHeader;
    }

    @Override
    public long getProcessingNodeNumber() {
        return this.processingNodeNumber;
    }

    @Override
    public ProcessingNodes getProcessingNode() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNode;
    }

    @Override
    public String getSearchMachine() {
        return this.searchMachine;
    }
}

