/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.Helper;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.ASpectra;
import de.mpc.PD.Params.AProgramParameters;
import java.math.BigInteger;
import java.sql.SQLException;

public class ReferenceSpectra
extends ASpectra {
    private String sequence;
    private BigInteger sequenceHashCode = null;
    private String comment;
    private BigInteger commentHashCode = null;

    public ReferenceSpectra(AProgramParameters pp, long referenceSpectrumID) {
        super(pp, referenceSpectrumID);
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select *").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where ReferenceSpectrumID = ?");
        this.initAndProcessPrepared(this.spectrumID);
    }

    @Override
    protected final void setAllMembers() {
        super.setAllMembers();
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.sequence = this.sql4javaSt.columnString(this.colIndex++);
                this.sequenceHashCode = Helper.getBigIntFromStr((String)this.sql4javaSt.columnString(this.colIndex++));
                this.colIndex += 2;
                this.comment = this.sql4javaSt.columnString(this.colIndex++);
                this.commentHashCode = Helper.getBigIntFromStr((String)this.sql4javaSt.columnString(this.colIndex++));
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.sequence = this.rs.getString(this.colIndex++);
                this.sequenceHashCode = Helper.getBigIntFromStr((String)this.rs.getString(this.colIndex++));
                this.colIndex += 2;
                this.comment = this.rs.getString(this.colIndex++);
                this.commentHashCode = Helper.getBigIntFromStr((String)this.rs.getString(this.colIndex++));
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public long getReferenceSpectrumID() {
        return this.spectrumID;
    }

    public String getSequence() {
        return this.sequence;
    }

    public BigInteger getSequenceHashCode() {
        return this.sequenceHashCode;
    }

    public String getComment() {
        return this.comment;
    }

    public BigInteger getCommentHashCode() {
        return this.commentHashCode;
    }
}

