/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.PDBaseClassPairedPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.SpectrumHeaders;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class QuanResults
extends PDBaseClassPairedPrimaryKey {
    private long quanResultID = -1L;
    private long spectrumID = -1L;
    private double height = 0.0;
    private double area = 0.0;
    private double startTime = 0.0;
    private double endTime = 0.0;
    private double startPeakTime = 0.0;
    private double startPeakIntensity = 0.0;
    private double endPeakTime = 0.0;
    private double endPeakIntensity = 0.0;
    private SpectrumHeaders spectrumHeader = null;
    private final ArrayList<SpectrumHeaders> spectrumHeadersList = new ArrayList();
    private final HashMap<Long, SpectrumHeaders> searchSpectrumsMap = new HashMap();
    private boolean bFilledSearchSpectrumsMap = false;

    public QuanResults(AProgramParameters pp, long quanResID, long spectID) {
        super(pp);
        this.quanResultID = quanResID;
        this.spectrumID = spectID;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select Height, Area, StartTime, EndTime, StartPeakTime, StartPeakIntensity, EndPeakTime, EndPeakIntensity").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where QuanResultID = ? and SpectrumID = ?");
        this.initAndProcessPrepared(this.quanResultID);
    }

    private void loadForeignKeyObjects() {
        if (this.spectrumID > -1L && this.spectrumHeader == null) {
            this.spectrumHeader = this.requestSpectrumHeader(this.spectrumID);
        }
        if (this.spectrumID > -1L) {
            this.requestSpectrumHeadersList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private SpectrumHeaders requestSpectrumHeader(long spectID) {
        return new SpectrumHeaders(this.getPP(), spectID);
    }

    private void requestSpectrumHeadersList() {
        for (Object obj : SpectrumHeaders.getObjectIDList(this.getPP(), SpectrumHeaders.class)) {
            this.spectrumHeadersList.add(new SpectrumHeaders(this.getPP(), (Long)obj));
        }
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.height = this.sql4javaSt.columnDouble(this.colIndex++);
                this.area = this.sql4javaSt.columnDouble(this.colIndex++);
                this.startTime = this.sql4javaSt.columnDouble(this.colIndex++);
                this.endTime = this.sql4javaSt.columnDouble(this.colIndex++);
                this.startPeakTime = this.sql4javaSt.columnDouble(this.colIndex++);
                this.startPeakIntensity = this.sql4javaSt.columnDouble(this.colIndex++);
                this.endPeakTime = this.sql4javaSt.columnDouble(this.colIndex++);
                this.endPeakIntensity = this.sql4javaSt.columnDouble(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.height = this.rs.getDouble(this.colIndex++);
                this.area = this.rs.getDouble(this.colIndex++);
                this.startTime = this.rs.getDouble(this.colIndex++);
                this.endTime = this.rs.getDouble(this.colIndex++);
                this.startPeakTime = this.rs.getDouble(this.colIndex++);
                this.startPeakIntensity = this.rs.getDouble(this.colIndex++);
                this.endPeakTime = this.rs.getDouble(this.colIndex++);
                this.endPeakIntensity = this.rs.getDouble(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public long getQuanResultID() {
        return this.quanResultID;
    }

    public long getSpectrumID() {
        return this.spectrumID;
    }

    public double getHeight() {
        return this.height;
    }

    public double getArea() {
        return this.area;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public double getStartPeakTime() {
        return this.startPeakTime;
    }

    public double getStartPeakIntensity() {
        return this.startPeakIntensity;
    }

    public double getEndPeakTime() {
        return this.endPeakTime;
    }

    public double getEndPeakIntensity() {
        return this.endPeakIntensity;
    }

    public SpectrumHeaders getSpectrumHeader() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.spectrumHeader;
    }

    public ArrayList<SpectrumHeaders> getSpectrumHeadersList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.spectrumHeadersList;
    }

    private HashMap<Long, SpectrumHeaders> getSearchSpectrums() {
        StringBuilder strB = new StringBuilder("select sh.SearchSpectrumID").append(MyConstants.newline);
        strB.append("from ").append("SpectrumHeaders as sh, ").append("QuanResults as qr, ").append("PrecursorIonAreaSearchSpectra as link").append(MyConstants.newline);
        strB.append("where qr.QuanResultID = ").append(this.getQuanResultID()).append(" and SpectrumID = ").append(this.getSpectrumID()).append(MyConstants.newline);
        strB.append("and link.QuanResultID = qr.QuanResultID").append(MyConstants.newline);
        strB.append("and link.SearchSpectrumID = sh.SearchSpectrumID");
        this.fillSinglePrimaryKeyGenericMap(strB.toString(), this.searchSpectrumsMap, SpectrumHeaders.class, this.getQuanResultID(), this.getSpectrumID());
        this.bFilledSearchSpectrumsMap = true;
        return this.searchSpectrumsMap;
    }

    public SpectrumHeaders getSearchSpectrum(long ID) {
        if (!this.bFilledSearchSpectrumsMap) {
            this.getSearchSpectrums();
        }
        if (this.searchSpectrumsMap.containsKey(ID)) {
            return this.searchSpectrumsMap.get(ID);
        }
        return null;
    }

    public int getNoOfSearchSpectra() {
        if (!this.bFilledSearchSpectrumsMap) {
            this.getSearchSpectrums();
        }
        return this.searchSpectrumsMap.size();
    }

    public boolean hasSearchSpectraLinks() {
        if (!this.bFilledSearchSpectrumsMap) {
            this.getSearchSpectrums();
        }
        return !this.searchSpectrumsMap.isEmpty();
    }
}

