/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.Annotations;
import de.mpc.PD.PDBaseClassTripledPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.Proteins;
import java.util.ArrayList;

public class PtmAnnotationData
extends PDBaseClassTripledPrimaryKey {
    private long proteinID = -1L;
    private long annotationID = -1L;
    private long ptmUnimodID = -1L;
    private long position = -1L;
    private long annotationType = -1L;
    private final String annotationStr = "";
    private Proteins protein = null;
    private Annotations annotation = null;
    private final ArrayList<Proteins> proteinsList = new ArrayList();

    public PtmAnnotationData(AProgramParameters pp, long proteinID, long position, long PtmUnimodID) {
        super(pp);
        this.proteinID = proteinID;
        this.ptmUnimodID = PtmUnimodID;
        this.position = position;
        if (!this.isVersion14()) {
            this.initFromDB13();
        } else {
            this.logger.error("Is PD version 1.4 in constructor for PtmAnnotationData");
        }
    }

    public PtmAnnotationData(AProgramParameters pp, long proteinID, long annotationID, long position, long annotationType) {
        super(pp);
        this.proteinID = proteinID;
        this.annotationID = annotationID;
        this.position = position;
        this.annotationType = annotationType;
        if (this.isVersion14()) {
            this.initFromDB14();
        } else {
            this.logger.error("Is not PD version 1.4 in constructor for PtmAnnotationData");
        }
    }

    private void initFromDB13() {
        this.sb.append("select *").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where ProteinId = ? and Position = ? and UnimodId = ?");
        this.initAndProcessPrepared(this.proteinID, this.position, this.ptmUnimodID);
    }

    private void initFromDB14() {
        this.sb.append("select *").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where ProteinId = ? and AnnotationID = ? and Position = ? and AnnotationType = ?");
        this.initAndProcessPrepared(this.proteinID, this.annotationID, this.position, this.annotationType);
    }

    private void loadForeignKeyObjects() {
        if (this.proteinID > -1L && this.protein == null) {
            this.protein = this.requestProtein(this.proteinID);
        }
        if (this.isVersion14() && this.annotationID > -1L && this.annotation == null) {
            this.annotation = this.requestAnnotation(this.annotationID);
        }
        if (this.proteinID > -1L) {
            this.requestProteinsList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private Proteins requestProtein(long protID) {
        return new Proteins(this.getPP(), protID, strVersion);
    }

    private Annotations requestAnnotation(long annotationID) {
        if (this.isVersion14()) {
            return new Annotations(this.getPP(), annotationID);
        }
        this.logger.error("PtmAnnotationData: Is not PD version 1.4 in requestAnnotation()");
        return null;
    }

    private void requestProteinsList() {
        for (Object obj : Proteins.getObjectIDList(this.getPP(), Proteins.class)) {
            this.proteinsList.add(new Proteins(this.getPP(), (Long)obj, strVersion));
        }
    }

    public long getProteinID() {
        return this.proteinID;
    }

    public long getAnnotationID() {
        return this.annotationID;
    }

    public long getPtmUnimodID() {
        if (!this.isVersion14()) {
            return this.ptmUnimodID;
        }
        this.logger.error("PtmAnnotationData: Is PD version 1.4 in getPtmUnimodID()");
        return -1L;
    }

    public long getPosition() {
        return this.position;
    }

    public long getAnnotationType() {
        if (this.isVersion14()) {
            return this.annotationType;
        }
        this.logger.error("PtmAnnotationData: Is not PD version 1.4 in getAnnotationType()");
        return -1L;
    }

    public String getAnnotationStr() {
        if (this.isVersion14()) {
            return "";
        }
        this.logger.error("PtmAnnotationData: Is not PD version 1.4 in getAnnotationStr()");
        return "";
    }

    public Proteins getProtein() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.protein;
    }

    public Annotations getAnnotation() {
        if (this.isVersion14()) {
            if (!this.bForeignKeyObjectsLoaded) {
                this.loadForeignKeyObjects();
            }
            return this.annotation;
        }
        this.logger.error("PtmAnnotationData: Is not PD version 1.4 in getAnnotation()");
        return null;
    }

    public ArrayList<Proteins> getProteinsList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.proteinsList;
    }
}

