/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.PDBaseClassPairedPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.ProteinIdentificationGroups;
import de.mpc.PD.Proteins;
import java.sql.SQLException;
import java.util.ArrayList;

public class ProteinsProteinGroups
extends PDBaseClassPairedPrimaryKey {
    private long proteinID = -1L;
    private long proteinGroupID = -1L;
    private final ArrayList<Proteins> proteinsList = new ArrayList();
    private final ArrayList<ProteinIdentificationGroups> proteinIdentificationGroupsList = new ArrayList();

    public ProteinsProteinGroups(AProgramParameters pp, long proteinID, long proteinGroupID) {
        super(pp);
        this.proteinID = proteinID;
        this.proteinGroupID = proteinGroupID;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select *").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where ProteinID = ? and ProteinGroupID = ?");
        this.initAndProcessPrepared(this.proteinID, this.proteinGroupID);
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.proteinID = this.sql4javaSt.columnLong(this.colIndex++);
                this.proteinGroupID = this.sql4javaSt.columnLong(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.proteinID = this.rs.getLong(this.colIndex++);
                this.proteinGroupID = this.rs.getLong(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    private void loadForeignKeyObjects() {
        if (this.proteinID > -1L) {
            this.requestProteinsList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private void requestProteinsList() {
        for (Object obj : Proteins.getObjectIDList(this.getPP(), Proteins.class)) {
            this.proteinsList.add(new Proteins(this.getPP(), (Long)obj, strVersion));
        }
    }

    public long getProteinID() {
        return this.proteinID;
    }

    public long getProteinGroupID() {
        return this.proteinGroupID;
    }

    public ArrayList<ProteinIdentificationGroups> getProteinIdentificationGroupsList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.proteinIdentificationGroupsList;
    }

    public ArrayList<Proteins> getProteinsList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.proteinsList;
    }
}

