/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import de.mpc.BaseLib.Helper;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.CustomDataFields;
import de.mpc.PD.IHashCodable;
import de.mpc.PD.PDBaseClassSinglePrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.Peptides;
import de.mpc.PD.Peptides_decoy;
import de.mpc.PD.ProteinIdentificationGroups;
import java.math.BigInteger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;

public class Proteins
extends PDBaseClassSinglePrimaryKey
implements IHashCodable {
    private long proteinID = -1L;
    private String sequence;
    private BigInteger sequenceHashCode = null;
    private boolean isMasterProtein;
    private final HashMap<Long, ProteinIdentificationGroups> proteinIdentificationGroupsMap = new HashMap();
    private boolean bFilledProteinIdentificationGroupsMap = false;
    protected final HashMap<Long, CustomDataFields> customDataMap = new HashMap();
    protected boolean bFilledCustomDataMap = false;
    protected final HashMap<Long, CustomDataFields> customDataMap_decoy = new HashMap();
    protected boolean bFilledCustomDataMap_decoy = false;
    protected final HashMap<Long, Peptides> peptidesMap = new HashMap();
    protected boolean bFilledPeptidesMap = false;
    protected final HashMap<Long, Peptides_decoy> peptidesMap_decoy = new HashMap();
    protected boolean bFilledPeptidesMap_decoy = false;

    public Proteins(AProgramParameters pp, long proteinID, String version) {
        super(pp);
        strVersion = version;
        this.proteinID = proteinID;
        this.initFromDB();
    }

    private void initFromDB() {
        if (!strVersion.equals("1.2") && !strVersion.equals("1.1")) {
            this.sb.append("select Sequence, SequenceHashCode, IsMasterProtein").append(MyConstants.newline);
        } else {
            this.sb.append("select Sequence, SequenceHashCode").append(MyConstants.newline);
        }
        this.sb.append(this.getFromLine());
        this.sb.append("where ProteinID = ?");
        this.initAndProcessPrepared(this.proteinID);
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.sequence = this.sql4javaSt.columnString(this.colIndex++);
                this.sequenceHashCode = Helper.getBigIntFromStr((String)this.sql4javaSt.columnString(this.colIndex++));
                if (!strVersion.equals("1.2") && !strVersion.equals("1.1")) {
                    this.isMasterProtein = this.sql4javaSt.columnInt(this.colIndex++) == 1;
                }
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.colIndex = 1;
                this.sequence = this.rs.getString(this.colIndex++);
                this.sequenceHashCode = Helper.getBigIntFromStr((String)this.rs.getString(this.colIndex++));
                if (!strVersion.equals("1.2") && !strVersion.equals("1.1")) {
                    this.isMasterProtein = this.rs.getInt(this.colIndex++) == 1;
                }
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    @Override
    public long getID() {
        return this.proteinID;
    }

    public long getProteinID() {
        return this.proteinID;
    }

    public String getSequence() {
        return this.sequence;
    }

    public BigInteger getSequenceHashCode() {
        return this.sequenceHashCode;
    }

    public boolean isMasterProtein() {
        return this.isMasterProtein;
    }

    @Override
    public BigInteger calculateHashCode(char[] text) {
        BigInteger bigInt = Helper.getBigIntFromStr((String)String.valueOf(Arrays.hashCode(text)));
        return bigInt;
    }

    public String getOrganismName() {
        StringBuilder strB = new StringBuilder();
        strB.append("SELECT TA.Name").append(MyConstants.newline);
        strB.append("FROM Proteins AS Prot, ProteinAnnotations AS PA, TaxonomyNames as TA").append(MyConstants.newline);
        strB.append("WHERE PROT.ProteinID = PA.ProteinID").append(MyConstants.newline);
        strB.append("AND PA.TaxonomyID = TA.TaxonomyID").append(MyConstants.newline);
        strB.append("AND PROT.ProteinID = ").append(this.proteinID);
        String sqlStr = strB.toString();
        String organismName = "";
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                SQLiteStatement sqlSt = this.getPP().getSQLiteAccess().dbConn.prepare(sqlStr);
                try {
                    while (sqlSt.step()) {
                        organismName = sqlSt.columnString(0);
                    }
                }
                finally {
                    sqlSt.dispose();
                }
            }
            catch (SQLiteException sqliteex) {
                this.getPP().getSQLiteAccess().handleSQLite4JavaError(sqliteex);
                sqliteex.printStackTrace(System.err);
            }
        } else if (this.getPP().isUsingJDBC()) {
            try {
                Statement st = this.getPP().getJDBCAccess().dbConn.createStatement();
                this.rs = st.executeQuery(sqlStr);
                try {
                    while (this.rs.next()) {
                        organismName = this.rs.getString(1);
                    }
                }
                finally {
                    st.close();
                }
            }
            catch (SQLException sex) {
                this.getPP().getJDBCAccess().handleJDBCError(sex);
                sex.printStackTrace(System.err);
            }
        }
        return organismName;
    }

    private HashMap<Long, ProteinIdentificationGroups> getProteinIdentificationGroups() {
        StringBuilder strB = new StringBuilder("select pig.ProteinGroupID").append(MyConstants.newline);
        strB.append("from ").append("Proteins as prot, ").append("ProteinIdentificationGroups as pig, ").append("ProteinsProteinGroups as link").append(MyConstants.newline);
        strB.append("where prot.ProteinID = ").append(this.getProteinID()).append(MyConstants.newline);
        strB.append("and link.ProteinID = prot.ProteinID").append(MyConstants.newline);
        strB.append("and link.ProteinGroupID = pig.ProteinGroupID");
        this.fillSinglePrimaryKeyGenericMap(strB.toString(), this.proteinIdentificationGroupsMap, ProteinIdentificationGroups.class, this.getProteinID(), new long[0]);
        this.bFilledProteinIdentificationGroupsMap = true;
        return this.proteinIdentificationGroupsMap;
    }

    private HashMap<Long, CustomDataFields> getCustomDataFields() {
        StringBuilder strB = new StringBuilder("select cdf.FieldID").append(MyConstants.newline);
        strB.append("from ").append("Proteins as prot, ").append("CustomDataFields as cdf, ").append("CustomDataProteins as link").append(MyConstants.newline);
        strB.append("where prot.ProteinID = ").append(this.getProteinID()).append(MyConstants.newline);
        strB.append("and link.FieldID = cdf.FieldID").append(MyConstants.newline);
        strB.append("and link.PeptideID = prot.ProteinID");
        this.fillSinglePrimaryKeyGenericMap(strB.toString(), this.customDataMap, CustomDataFields.class, this.getProteinID(), new long[0]);
        this.bFilledCustomDataMap = true;
        return this.customDataMap;
    }

    private HashMap<Long, CustomDataFields> getCustomDataFields_decoy() {
        StringBuilder strB = new StringBuilder("select cdf.FieldID").append(MyConstants.newline);
        strB.append("from ").append("Proteins as prot, ").append("CustomDataFields as cdf, ").append("CustomDataProteins_decoy as link").append(MyConstants.newline);
        strB.append("where prot.ProteinID = ").append(this.getProteinID()).append(MyConstants.newline);
        strB.append("and link.FieldID = cdf.FieldID").append(MyConstants.newline);
        strB.append("and link.ProteinID = prot.ProteinID");
        this.fillSinglePrimaryKeyGenericMap(strB.toString(), this.customDataMap_decoy, CustomDataFields.class, this.getProteinID(), new long[0]);
        this.bFilledCustomDataMap_decoy = true;
        return this.customDataMap_decoy;
    }

    private HashMap<Long, Peptides> getPeptides(long pnn) {
        StringBuilder strB = new StringBuilder("select pept.PeptideID").append(MyConstants.newline);
        strB.append("from ").append("Proteins as prot, ").append("Peptides as pept, ").append("PeptidesProteins as link").append(MyConstants.newline);
        strB.append("where prot.ProteinID = ").append(this.getProteinID()).append(MyConstants.newline);
        strB.append("and pept.ProcessingNodeNumber = ").append(pnn).append(MyConstants.newline);
        strB.append("and link.PeptideID = cdf.PeptideID").append(MyConstants.newline);
        strB.append("and link.ProcessingNodeNumber = pept.ProcessingNodeNumber").append(MyConstants.newline);
        strB.append("and link.ProteinID = prot.ProteinID");
        this.fillSinglePrimaryKeyGenericMap(strB.toString(), this.peptidesMap, Peptides.class, this.getProteinID(), new long[0]);
        this.bFilledPeptidesMap = true;
        return this.peptidesMap;
    }

    private HashMap<Long, Peptides_decoy> getPeptides_decoy(long pnn) {
        StringBuilder strB = new StringBuilder("select pept.PeptideID").append(MyConstants.newline);
        strB.append("from ").append("Proteins as prot, ").append("Peptides_decoy as pept, ").append("PeptidesProteins_decoy as link").append(MyConstants.newline);
        strB.append("where prot.ProteinID = ").append(this.getProteinID()).append(MyConstants.newline);
        strB.append("and pept.ProcessingNodeNumber = ").append(pnn).append(MyConstants.newline);
        strB.append("and link.PeptideID = cdf.PeptideID").append(MyConstants.newline);
        strB.append("and link.ProcessingNodeNumber = pept.ProcessingNodeNumber").append(MyConstants.newline);
        strB.append("and link.ProteinID = prot.ProteinID");
        this.fillSinglePrimaryKeyGenericMap(strB.toString(), this.peptidesMap_decoy, Peptides_decoy.class, this.getProteinID(), new long[0]);
        this.bFilledPeptidesMap_decoy = true;
        return this.peptidesMap_decoy;
    }

    public ProteinIdentificationGroups getProteinIdentificationGroup(long ID) {
        if (!this.bFilledProteinIdentificationGroupsMap) {
            this.getProteinIdentificationGroups();
        }
        if (this.proteinIdentificationGroupsMap.containsKey(ID)) {
            return this.proteinIdentificationGroupsMap.get(ID);
        }
        return null;
    }

    public int getNoOfProteinIdentificationGroups() {
        if (!this.bFilledProteinIdentificationGroupsMap) {
            this.getProteinIdentificationGroups();
        }
        return this.proteinIdentificationGroupsMap.size();
    }

    public boolean hasProteinIdentificationGroupLinks() {
        if (!this.bFilledProteinIdentificationGroupsMap) {
            this.getProteinIdentificationGroups();
        }
        return !this.proteinIdentificationGroupsMap.isEmpty();
    }

    public CustomDataFields getCustomData(long ID) {
        if (!this.bFilledCustomDataMap) {
            this.getCustomDataFields();
        }
        if (this.customDataMap.containsKey(ID)) {
            return this.customDataMap.get(ID);
        }
        return null;
    }

    public int getNoOfCustomData() {
        if (!this.bFilledCustomDataMap) {
            this.getCustomDataFields();
        }
        return this.customDataMap.size();
    }

    public boolean hasCustomDataLinks() {
        if (!this.bFilledCustomDataMap) {
            this.getCustomDataFields();
        }
        return !this.customDataMap.isEmpty();
    }

    public CustomDataFields getCustomData_decoy(long ID) {
        if (!this.bFilledCustomDataMap_decoy) {
            this.getCustomDataFields_decoy();
        }
        if (this.customDataMap_decoy.containsKey(ID)) {
            return this.customDataMap_decoy.get(ID);
        }
        return null;
    }

    public int getNoOfCustomData_decoy() {
        if (!this.bFilledCustomDataMap_decoy) {
            this.getCustomDataFields_decoy();
        }
        return this.customDataMap_decoy.size();
    }

    public boolean hasCustomDataDecoyLinks() {
        if (!this.bFilledCustomDataMap_decoy) {
            this.getCustomDataFields_decoy();
        }
        return !this.customDataMap_decoy.isEmpty();
    }

    public Peptides getPeptide(long ID, long pnn) {
        if (!this.bFilledPeptidesMap) {
            this.getPeptides(pnn);
        }
        if (this.peptidesMap.containsKey(ID)) {
            return this.peptidesMap.get(ID);
        }
        return null;
    }

    public int getNoOfPeptides(long pnn) {
        if (!this.bFilledPeptidesMap) {
            this.getPeptides(pnn);
        }
        return this.peptidesMap.size();
    }

    public boolean hasPeptideLinks(long pnn) {
        if (!this.bFilledPeptidesMap) {
            this.getPeptides(pnn);
        }
        return !this.peptidesMap.isEmpty();
    }

    public Peptides_decoy getPeptide_decoy(long ID, long pnn) {
        if (!this.bFilledPeptidesMap_decoy) {
            this.getPeptides_decoy(pnn);
        }
        if (this.peptidesMap_decoy.containsKey(ID)) {
            return this.peptidesMap_decoy.get(ID);
        }
        return null;
    }

    public int getNoOfPeptides_decoy(long pnn) {
        if (!this.bFilledPeptidesMap_decoy) {
            this.getPeptides_decoy(pnn);
        }
        return this.peptidesMap_decoy.size();
    }

    public boolean hasPeptide_decoyLinks(long pnn) {
        if (!this.bFilledPeptidesMap_decoy) {
            this.getPeptides_decoy(pnn);
        }
        return !this.peptidesMap_decoy.isEmpty();
    }
}

