/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import de.mpc.PD.IPNNListable;
import de.mpc.PD.PDBaseClassPairedPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.ProcessingNodes;
import de.mpc.PD.SMsFromPNN;
import java.util.ArrayList;

public class ProteinIdentificationGroups
extends PDBaseClassPairedPrimaryKey
implements IPNNListable {
    private long proteinIdentificationGroupID = -1L;
    private long processingNodeNumber = -1L;
    private final ArrayList<ProcessingNodes> processingNodesList = new ArrayList();
    private final String searchMachine;

    public ProteinIdentificationGroups(AProgramParameters pp, long proteinIdentificationGroupID, long processingNodeNo) {
        super(pp);
        this.proteinIdentificationGroupID = proteinIdentificationGroupID;
        this.processingNodeNumber = processingNodeNo;
        this.searchMachine = SMsFromPNN.retrieveSearchMachineForProcessingNodeNumber(pp, this.processingNodeNumber);
    }

    private void loadForeignKeyObjects() {
        if (this.processingNodeNumber > -1L) {
            this.requestProcessingNodesList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private void requestProcessingNodesList() {
        for (Object obj : ProcessingNodes.getObjectIDList(this.getPP(), ProcessingNodes.class)) {
            this.processingNodesList.add(new ProcessingNodes(this.getPP(), (Long)obj));
        }
    }

    @Override
    protected final void setAllMembers() {
    }

    @Override
    public long getFirstID() {
        return this.proteinIdentificationGroupID;
    }

    @Override
    public long getSecondID() {
        return this.processingNodeNumber;
    }

    public long getProteinIdentificationGroupID() {
        return this.proteinIdentificationGroupID;
    }

    @Override
    public long getProcessingNodeNumber() {
        return this.processingNodeNumber;
    }

    @Override
    public ArrayList<ProcessingNodes> getProcessingNodesList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNodesList;
    }

    @Override
    public String getSearchMachine() {
        return this.searchMachine;
    }
}

