/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.Helper;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.FastaFiles;
import de.mpc.PD.IHashCodable;
import de.mpc.PD.PDBaseClassSinglePrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.Proteins;
import de.mpc.PD.TaxonomyNames;
import de.mpc.PD.TaxonomyNodes;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;

public class ProteinAnnotations
extends PDBaseClassSinglePrimaryKey
implements IHashCodable {
    private long proteinAnnotationID = -1L;
    private long proteinID;
    private BigInteger descriptionHashCode = null;
    private String description;
    private long taxonomyID;
    private Proteins protein = null;
    private TaxonomyNodes taxonomyNode = null;
    private final TaxonomyNames taxonomyName = null;
    private final HashMap<Long, FastaFiles> fastaFilesMap = new HashMap();
    private boolean bFilledFastaFilesMap = false;

    public ProteinAnnotations(AProgramParameters pp, long proteinAnnotationID) {
        super(pp);
        this.proteinAnnotationID = proteinAnnotationID;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select ProteinID, DescriptionHashCode, Description, TaxonomyID").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where ProteinAnnotationID = ?");
        this.initAndProcessPrepared(this.proteinAnnotationID);
    }

    private void loadForeignKeyObjects() {
        if (this.proteinID > -1L && this.protein == null) {
            this.protein = this.requestProtein(this.proteinID);
        }
        if (this.taxonomyID > -1L && this.taxonomyNode == null) {
            this.taxonomyNode = this.requestTaxonomyNode(this.taxonomyID);
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private Proteins requestProtein(long protID) {
        return new Proteins(this.getPP(), protID, strVersion);
    }

    private TaxonomyNodes requestTaxonomyNode(long taxID) {
        return new TaxonomyNodes(this.getPP(), taxID);
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.proteinID = this.sql4javaSt.columnLong(this.colIndex++);
                this.descriptionHashCode = Helper.getBigIntFromStr((String)this.sql4javaSt.columnString(this.colIndex++));
                this.description = this.sql4javaSt.columnString(this.colIndex++);
                this.taxonomyID = this.sql4javaSt.columnLong(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.proteinID = this.rs.getLong(this.colIndex++);
                this.descriptionHashCode = Helper.getBigIntFromStr((String)this.rs.getString(this.colIndex++));
                this.description = this.rs.getString(this.colIndex++);
                this.taxonomyID = this.rs.getLong(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    @Override
    public long getID() {
        return this.proteinAnnotationID;
    }

    public long getProteinAnnotationID() {
        return this.proteinAnnotationID;
    }

    public long getProteinID() {
        return this.proteinID;
    }

    public BigInteger getDescriptionHashCode() {
        return this.descriptionHashCode;
    }

    public String getDescription() {
        return this.description;
    }

    public long getTaxonomyID() {
        return this.taxonomyID;
    }

    @Override
    public BigInteger calculateHashCode(char[] text) {
        BigInteger bigInt = new BigInteger(String.valueOf(Arrays.hashCode(text)));
        return bigInt;
    }

    public Proteins getProtein() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.protein;
    }

    public TaxonomyNodes getTaxonomyNode() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.taxonomyNode;
    }

    public TaxonomyNames getTaxonomyName() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.taxonomyName;
    }

    private HashMap<Long, FastaFiles> getFastaFiles() {
        StringBuilder strB = new StringBuilder("select ff.FastaFileID").append(MyConstants.newline);
        strB.append("from ").append("FastaFiles as ff, ").append("ProteinAnnotations as pa, ").append("FastaFilesProteinAnnotations as link").append(MyConstants.newline);
        strB.append("where pa.ProteinAnnotationID = ").append(this.getProteinAnnotationID()).append(MyConstants.newline);
        strB.append("and link.FastaFileID = ff.FastaFileID").append(MyConstants.newline);
        strB.append("and link.ProteinAnnotationID = pa.ProteinAnnotationID");
        this.fillSinglePrimaryKeyGenericMap(strB.toString(), this.fastaFilesMap, FastaFiles.class, this.getProteinAnnotationID(), new long[0]);
        this.bFilledFastaFilesMap = true;
        return this.fastaFilesMap;
    }

    public FastaFiles getFastaFile(long ID) {
        if (!this.bFilledFastaFilesMap) {
            this.getFastaFiles();
        }
        if (this.fastaFilesMap.containsKey(ID)) {
            return this.fastaFilesMap.get(ID);
        }
        return null;
    }

    public int getNoOfFastaFiles() {
        if (!this.bFilledFastaFilesMap) {
            this.getFastaFiles();
        }
        return this.fastaFilesMap.size();
    }

    public boolean hasFastaFilesLinks() {
        if (!this.bFilledFastaFilesMap) {
            this.getFastaFiles();
        }
        return !this.fastaFilesMap.isEmpty();
    }
}

