/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import de.mpc.PD.IPNNListable;
import de.mpc.PD.PDBaseClassPairedPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.ProcessingNodes;
import de.mpc.PD.SMsFromPNN;
import de.mpc.PD.SpectrumHeaders;
import java.util.ArrayList;

public class ProcessingNodesSpectra
extends PDBaseClassPairedPrimaryKey
implements IPNNListable {
    private long sendingProcessingNodeNumber = -1L;
    private long spectrumID = -1L;
    private final ArrayList<ProcessingNodes> sendingProcessingNodesList = new ArrayList();
    private final ArrayList<SpectrumHeaders> spectrumHeadersList = new ArrayList();
    private final String searchMachine;

    public ProcessingNodesSpectra(AProgramParameters pp, long sendingProcessingNodeNumber, long spectrumID) {
        super(pp);
        this.sendingProcessingNodeNumber = sendingProcessingNodeNumber;
        this.spectrumID = spectrumID;
        this.searchMachine = SMsFromPNN.retrieveSearchMachineForProcessingNodeNumber(pp, this.sendingProcessingNodeNumber);
    }

    private void loadForeignKeyObjects() {
        if (this.sendingProcessingNodeNumber > -1L) {
            this.requestSendingProcessingNodesList();
        }
        if (this.spectrumID > -1L) {
            this.requestSpectrumHeadersList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private void requestSendingProcessingNodesList() {
        for (Object obj : ProcessingNodes.getObjectIDList(this.getPP(), ProcessingNodes.class)) {
            this.sendingProcessingNodesList.add(new ProcessingNodes(this.getPP(), (Long)obj));
        }
    }

    private void requestSpectrumHeadersList() {
        for (Object obj : SpectrumHeaders.getObjectIDList(this.getPP(), SpectrumHeaders.class)) {
            this.spectrumHeadersList.add(new SpectrumHeaders(this.getPP(), (Long)obj));
        }
    }

    @Override
    protected final void setAllMembers() {
    }

    public long getSendingProcessingNodeNumber() {
        return this.getProcessingNodeNumber();
    }

    public long getSpectrumID() {
        return this.spectrumID;
    }

    @Override
    public long getProcessingNodeNumber() {
        return this.sendingProcessingNodeNumber;
    }

    @Override
    public ArrayList<ProcessingNodes> getProcessingNodesList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.sendingProcessingNodesList;
    }

    public ArrayList<SpectrumHeaders> getSpectrumHeadersList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.spectrumHeadersList;
    }

    @Override
    public String getSearchMachine() {
        return this.searchMachine;
    }
}

