/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.CustomDataFields;
import de.mpc.PD.IVersionable;
import de.mpc.PD.PDBaseClassSinglePrimaryKey;
import de.mpc.PD.PD_GUID;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.SMsFromPNN;
import de.mpc.PD.SpectrumHeaders;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ProcessingNodes
extends PDBaseClassSinglePrimaryKey
implements IVersionable {
    private long processingNodeNumber = -1L;
    private int processingNodeID;
    private String parentProcessingNodeNumber;
    private String nodeName;
    private String friendlyName;
    private int majorVersion;
    private int minorVersion;
    private String nodeComment;
    private PD_GUID nodeGUID = null;
    private int processingNodeState;
    private final HashMap<Long, SpectrumHeaders> processingNodesSpectraMap = new HashMap();
    private boolean bFilledProcessingNodesSpectraMap = false;
    private final HashMap<Long, SpectrumHeaders> reporterIonQuanResultsSpectraMap = new HashMap();
    private boolean bFilledReporterIonQuanResultsSpectra = false;
    private final HashMap<Long, SpectrumHeaders> reporterIonQuanResultsSearchSpectraMap = new HashMap();
    private boolean bFilledReporterIonQuanResultsSearchSpectra = false;
    private final HashMap<Long, CustomDataFields> customDataMap = new HashMap();
    private boolean bFilledCustomDataMap = false;
    private ProcessingNodes parentProcessingNode = null;
    private final String searchMachine;

    public ProcessingNodes(AProgramParameters pp, long processingNodeNo) {
        super(pp);
        this.processingNodeNumber = processingNodeNo;
        this.initFromDB();
        this.searchMachine = SMsFromPNN.retrieveSearchMachineForProcessingNodeNumber(pp, this.processingNodeNumber);
    }

    private void initFromDB() {
        this.sb.append("select ProcessingNodeID, ProcessingNodeParentNumber, NodeName, FriendlyName, MajorVersion, MinorVersion, NodeComment, NodeGUID, ProcessingNodeState").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where ProcessingNodeNumber = ?");
        this.initAndProcessPrepared(this.getProcessingNodeNumber());
    }

    private void loadGUIDObjects() {
        if (this.nodeGUID != null) assert (this.isNotNull((Object)this.nodeGUID));
        this.bGUIDObjectsLoaded = true;
    }

    private void loadForeignKeyObjects() {
        if (this.processingNodeNumber > -1L && this.parentProcessingNode == null) {
            this.parentProcessingNode = this.requestParentProcessingNode(this.processingNodeNumber);
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private ProcessingNodes requestParentProcessingNode(long processingNodeNumber) {
        return new ProcessingNodes(this.getPP(), processingNodeNumber);
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.processingNodeID = this.sql4javaSt.columnInt(this.colIndex++);
                this.parentProcessingNodeNumber = this.sql4javaSt.columnString(this.colIndex++);
                this.nodeName = this.sql4javaSt.columnString(this.colIndex++);
                this.friendlyName = this.sql4javaSt.columnString(this.colIndex++);
                this.majorVersion = this.sql4javaSt.columnInt(this.colIndex++);
                this.minorVersion = this.sql4javaSt.columnInt(this.colIndex++);
                this.nodeComment = this.sql4javaSt.columnString(this.colIndex++);
                this.nodeGUID = new PD_GUID(this.sql4javaSt.columnString(this.colIndex++));
                this.processingNodeState = this.sql4javaSt.columnInt(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.processingNodeID = this.rs.getInt(this.colIndex++);
                this.parentProcessingNodeNumber = this.rs.getString(this.colIndex++);
                this.nodeName = this.rs.getString(this.colIndex++);
                this.friendlyName = this.rs.getString(this.colIndex++);
                this.majorVersion = this.rs.getInt(this.colIndex++);
                this.minorVersion = this.rs.getInt(this.colIndex++);
                this.nodeComment = this.rs.getString(this.colIndex++);
                this.nodeGUID = new PD_GUID(this.rs.getString(this.colIndex++));
                this.processingNodeState = this.rs.getInt(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    @Override
    public long getID() {
        return this.processingNodeNumber;
    }

    public int getProcessingNodeID() {
        return this.processingNodeID;
    }

    public String getParentProcessingNodeNumber() {
        return this.parentProcessingNodeNumber;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String getNodeComment() {
        return this.nodeComment;
    }

    public PD_GUID getNodeGUID() {
        return this.nodeGUID;
    }

    public int getProcessingNodeState() {
        return this.processingNodeState;
    }

    public boolean isRootNode() {
        return this.getParentNodeNumberStrs().isEmpty();
    }

    public ArrayList<Integer> getParentNodeNumbers() {
        ArrayList<String> parentNodeNumberStrs = this.getParentNodeNumberStrs();
        ArrayList<Integer> parentNodeNumbers = new ArrayList<Integer>();
        for (String noStr : parentNodeNumberStrs) {
            parentNodeNumbers.add(Integer.parseInt(noStr));
        }
        return parentNodeNumbers;
    }

    private ArrayList<String> getParentNodeNumberStrs() {
        ArrayList<String> parentNodeNumbers = new ArrayList<String>();
        String sqlStr = "SELECT ProcessingNodeParentNumber FROM ProcessingNodes";
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                SQLiteStatement sqlSt = this.getPP().getSQLiteAccess().dbConn.prepare(sqlStr);
                try {
                    while (sqlSt.step()) {
                        String parentNodeNos = sqlSt.columnString(0);
                        String[] strArr = parentNodeNos.split(MyConstants.STR_SEMICOLON);
                        parentNodeNumbers.addAll(Arrays.asList(strArr));
                    }
                }
                finally {
                    sqlSt.dispose();
                }
            }
            catch (SQLiteException sqliteex) {
                this.getPP().getSQLiteAccess().handleSQLite4JavaError(sqliteex);
                sqliteex.printStackTrace(System.err);
            }
        } else if (this.getPP().isUsingJDBC()) {
            try {
                Statement st = this.getPP().getJDBCAccess().dbConn.createStatement();
                this.rs = st.executeQuery(sqlStr);
                try {
                    while (this.rs.next()) {
                        String parentNodeNos = this.rs.getString(1);
                        String[] strArr = parentNodeNos.split(MyConstants.STR_SEMICOLON);
                        parentNodeNumbers.addAll(Arrays.asList(strArr));
                    }
                }
                finally {
                    st.close();
                }
            }
            catch (SQLException sex) {
                this.getPP().getJDBCAccess().handleJDBCError(sex);
                sex.printStackTrace(System.err);
            }
        }
        return parentNodeNumbers;
    }

    public boolean isSearchMachineNode() {
        return this.isMascotNode() | this.isSEQUESTNode() | this.isZCoreNode();
    }

    public boolean isMascotNode() {
        return this.friendlyName.contains("Mascot");
    }

    public boolean isSEQUESTNode() {
        return this.friendlyName.contains("SEQUEST");
    }

    public boolean isZCoreNode() {
        return this.friendlyName.contains("ZCore");
    }

    @Override
    public String getVersion() {
        StringBuilder strB = new StringBuilder(this.majorVersion);
        strB.append('.');
        strB.append(this.minorVersion);
        return strB.toString();
    }

    private HashMap<Long, SpectrumHeaders> getProcessingNodesSpectra() {
        StringBuilder strB = new StringBuilder("select sh.SpectrumID").append(MyConstants.newline);
        strB.append("from ").append("SpectrumHeaders as sh, ").append("ProcessingNodes as pn, ").append("ProcessingNodesSpectra as link").append(MyConstants.newline);
        strB.append("where pn.ProcessingNodeNumber = ").append(this.getProcessingNodeNumber()).append(MyConstants.newline);
        strB.append("and link.SendingProcessingNodeNumber = pn.ProcessingNodeNumber").append(MyConstants.newline);
        strB.append("and link.SpectrumID = sh.SpectrumID");
        this.fillSinglePrimaryKeyGenericMap(strB.toString(), this.processingNodesSpectraMap, SpectrumHeaders.class, this.getProcessingNodeNumber(), new long[0]);
        this.bFilledProcessingNodesSpectraMap = true;
        return this.processingNodesSpectraMap;
    }

    private HashMap<Long, SpectrumHeaders> getReporterIonQuanResultsSpectra() {
        StringBuilder strB = new StringBuilder("select sh.SpectrumID").append(MyConstants.newline);
        strB.append("from ").append("SpectrumHeaders as sh, ").append("ProcessingNodes as pn, ").append("ReporterIonQuanSearchResultsSearchSpectra as link").append(MyConstants.newline);
        strB.append("where pn.ProcessingNodeNumber = ").append(this.getProcessingNodeNumber()).append(MyConstants.newline);
        strB.append("and link.SearchSpectrumID = sh.SearchSpectrumID").append(MyConstants.newline);
        strB.append("and link.SpectrumID = sh.SpectrumID");
        this.fillSinglePrimaryKeyGenericMap(strB.toString(), this.reporterIonQuanResultsSpectraMap, SpectrumHeaders.class, this.getProcessingNodeNumber(), new long[0]);
        this.bFilledReporterIonQuanResultsSpectra = true;
        return this.reporterIonQuanResultsSpectraMap;
    }

    private HashMap<Long, SpectrumHeaders> getReporterIonQuanResultsSearchSpectra() {
        StringBuilder strB = new StringBuilder("select sh.SearchSpectrumID").append(MyConstants.newline);
        strB.append("from ").append("SpectrumHeaders as sh, ").append("ProcessingNodes as pn, ").append("ReporterIonQuanSearchResultsSearchSpectra as link").append(MyConstants.newline);
        strB.append("where pn.ProcessingNodeNumber = ").append(this.getProcessingNodeNumber()).append(MyConstants.newline);
        strB.append("and link.SearchSpectrumID = sh.SearchSpectrumID").append(MyConstants.newline);
        strB.append("and link.SpectrumID = sh.SpectrumID");
        this.fillSinglePrimaryKeyGenericMap(strB.toString(), this.reporterIonQuanResultsSearchSpectraMap, SpectrumHeaders.class, this.getProcessingNodeNumber(), new long[0]);
        this.bFilledReporterIonQuanResultsSearchSpectra = true;
        return this.reporterIonQuanResultsSearchSpectraMap;
    }

    private HashMap<Long, CustomDataFields> getCustomDataFields() {
        StringBuilder strB = new StringBuilder("select cdf.FieldID").append(MyConstants.newline);
        strB.append("from ").append("ProcessingNodes as pn, ").append("CustomDataFields as cdf, ").append("CustomDataProcessingNodes as link").append(MyConstants.newline);
        strB.append("where pn.ProcessingNodeNumber = ").append(this.getProcessingNodeNumber()).append(MyConstants.newline);
        strB.append("and link.FieldID = cdf.FieldID").append(MyConstants.newline);
        strB.append("and link.ProcessingNodeNumber = pn.ProcessingNodeNumber");
        this.fillSinglePrimaryKeyGenericMap(strB.toString(), this.customDataMap, CustomDataFields.class, this.getProcessingNodeNumber(), new long[0]);
        this.bFilledCustomDataMap = true;
        return this.customDataMap;
    }

    public SpectrumHeaders getProcessingNodesSpectrum(long ID) {
        if (!this.bFilledProcessingNodesSpectraMap) {
            this.getProcessingNodesSpectra();
        }
        if (this.processingNodesSpectraMap.containsKey(ID)) {
            return this.processingNodesSpectraMap.get(ID);
        }
        return null;
    }

    public int getNoOfProcessingNodesSpectra() {
        if (!this.bFilledProcessingNodesSpectraMap) {
            this.getProcessingNodesSpectra();
        }
        return this.processingNodesSpectraMap.size();
    }

    public boolean hasProcessingNodesSpectraLinks() {
        if (!this.bFilledProcessingNodesSpectraMap) {
            this.getProcessingNodesSpectra();
        }
        return !this.processingNodesSpectraMap.isEmpty();
    }

    public SpectrumHeaders getReporterIonQuanResultsSpectrum(long ID) {
        if (!this.bFilledReporterIonQuanResultsSpectra) {
            this.getReporterIonQuanResultsSpectra();
        }
        if (this.reporterIonQuanResultsSpectraMap.containsKey(ID)) {
            return this.reporterIonQuanResultsSpectraMap.get(ID);
        }
        return null;
    }

    public int getNoOfReporterIonQuanResultsSpectra() {
        if (!this.bFilledReporterIonQuanResultsSpectra) {
            this.getReporterIonQuanResultsSpectra();
        }
        return this.reporterIonQuanResultsSpectraMap.size();
    }

    public boolean hasReporterIonQuanResultsSpectraLinks() {
        if (!this.bFilledReporterIonQuanResultsSpectra) {
            this.getReporterIonQuanResultsSpectra();
        }
        return !this.reporterIonQuanResultsSpectraMap.isEmpty();
    }

    public SpectrumHeaders getReporterIonQuanResultsSearchSpectrum(long ID) {
        if (!this.bFilledReporterIonQuanResultsSearchSpectra) {
            this.getReporterIonQuanResultsSearchSpectra();
        }
        if (this.reporterIonQuanResultsSearchSpectraMap.containsKey(ID)) {
            return this.reporterIonQuanResultsSearchSpectraMap.get(ID);
        }
        return null;
    }

    public int getNoOfReporterIonQuanResultsSearchSpectra() {
        if (!this.bFilledReporterIonQuanResultsSearchSpectra) {
            this.getReporterIonQuanResultsSearchSpectra();
        }
        return this.reporterIonQuanResultsSearchSpectraMap.size();
    }

    public boolean hasReporterIonQuanResultsSearchSpectraLinks() {
        if (!this.bFilledReporterIonQuanResultsSearchSpectra) {
            this.getReporterIonQuanResultsSearchSpectra();
        }
        return !this.reporterIonQuanResultsSearchSpectraMap.isEmpty();
    }

    public CustomDataFields getCustomData(long ID) {
        if (!this.bFilledCustomDataMap) {
            this.getCustomDataFields();
        }
        if (this.customDataMap.containsKey(ID)) {
            return this.customDataMap.get(ID);
        }
        return null;
    }

    public int getNoOfCustomData() {
        if (!this.bFilledCustomDataMap) {
            this.getCustomDataFields();
        }
        return this.customDataMap.size();
    }

    public boolean hasCustomDataLinks() {
        if (!this.bFilledCustomDataMap) {
            this.getCustomDataFields();
        }
        return !this.customDataMap.isEmpty();
    }

    public List<String> getProcessingNodeParameterNames() {
        StringBuilder sqlSB = new StringBuilder("SELECT ParameterName").append(MyConstants.newline);
        sqlSB.append("from ").append("ProcessingNodeParameters").append(MyConstants.newline);
        sqlSB.append("WHERE ProcessingNodeNumber = ?");
        ArrayList<String> paramNames = new ArrayList<String>();
        if (this.getPP().isUsingSQLite4Java()) {
            SQLiteStatement sqlSt = this.initPreparedSQLiteStatement(sqlSB.toString(), this.getProcessingNodeNumber());
            if (sqlSt != null) {
                try {
                    try {
                        while (sqlSt.step()) {
                            paramNames.add(sqlSt.columnString(0));
                        }
                    }
                    catch (SQLiteException sqliteex) {
                        this.handleSQLiteException(sqliteex);
                        sqlSt.dispose();
                    }
                }
                finally {
                    sqlSt.dispose();
                }
            } else {
                this.showError(this.getErrorMessage(), sqlSB.toString());
                System.exit(-1);
            }
        } else if (this.getPP().isUsingJDBC()) {
            PreparedStatement st = this.initPreparedJDBCStatement(sqlSB.toString(), this.getProcessingNodeNumber());
            if (st != null) {
                try {
                    this.rs = st.executeQuery();
                    while (this.rs.next()) {
                        paramNames.add(this.rs.getString(1));
                    }
                    st.close();
                }
                catch (SQLException sqlex) {
                    this.handleSQLException(sqlex);
                }
            } else {
                this.showError(this.getErrorMessage(), sqlSB.toString());
                System.exit(-1);
            }
        }
        return paramNames;
    }

    public long getProcessingNodeNumber() {
        return this.processingNodeNumber;
    }

    public ProcessingNodes getParentProcessingNode() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.parentProcessingNode;
    }

    public String getSearchMachine() {
        return this.searchMachine;
    }
}

